import { resolveElements } from '../../utils/resolve-elements.mjs';

function createSelectorEffect(subjectEffect) {
    return (subject, values) => {
        const elements = resolveElements(subject);
        const subscriptions = [];
        for (const element of elements) {
            const remove = subjectEffect(element, values);
            subscriptions.push(remove);
        }
        return () => {
            for (const remove of subscriptions)
                remove();
        };
    };
}

export { createSelectorEffect };
//# sourceMappingURL=create-dom-effect.mjs.map
