globalThis.__nitro_main__ = import.meta.url;
import nodeHTTP from "node:http";
import { Readable } from "node:stream";
import nodeHTTPS from "node:https";
import nodeHTTP2 from "node:http2";
import bcrypt from "bcryptjs";
import { eq, sql, desc, asc, and, or } from "drizzle-orm";
import { drizzle } from "drizzle-orm/mysql2";
import { mysqlTable, varchar, int, datetime, tinyint, json, text } from "drizzle-orm/mysql-core";
import mysql from "mysql2/promise";
import { createHmac, randomInt, createHash, timingSafeEqual } from "node:crypto";
import nodemailer from "nodemailer";
import { mkdir, writeFile, unlink, readFile } from "node:fs/promises";
import { join, dirname, resolve } from "node:path";
import { promises } from "node:fs";
import { fileURLToPath } from "node:url";
function lazyService(loader) {
  let promise, mod;
  return {
    fetch(req) {
      if (mod) {
        return mod.fetch(req);
      }
      if (!promise) {
        promise = loader().then((_mod) => mod = _mod.default || _mod);
      }
      return promise.then((mod2) => mod2.fetch(req));
    }
  };
}
const services = {
  ["ssr"]: lazyService(() => import("./chunks/_/server.mjs"))
};
globalThis.__nitro_vite_envs__ = services;
function lazyInherit(target, source, sourceKey) {
  for (const key2 of [...Object.getOwnPropertyNames(source), ...Object.getOwnPropertySymbols(source)]) {
    if (key2 === "constructor") continue;
    const targetDesc = Object.getOwnPropertyDescriptor(target, key2);
    const desc2 = Object.getOwnPropertyDescriptor(source, key2);
    let modified = false;
    if (desc2.get) {
      modified = true;
      desc2.get = targetDesc?.get || function() {
        return this[sourceKey][key2];
      };
    }
    if (desc2.set) {
      modified = true;
      desc2.set = targetDesc?.set || function(value) {
        this[sourceKey][key2] = value;
      };
    }
    if (!targetDesc?.value && typeof desc2.value === "function") {
      modified = true;
      desc2.value = function(...args) {
        return this[sourceKey][key2](...args);
      };
    }
    if (modified) Object.defineProperty(target, key2, desc2);
  }
}
const FastURL = /* @__PURE__ */ (() => {
  const NativeURL = globalThis.URL;
  const FastURL$1 = class URL {
    #url;
    #href;
    #protocol;
    #host;
    #pathname;
    #search;
    #searchParams;
    #pos;
    constructor(url) {
      if (typeof url === "string") this.#href = url;
      else {
        this.#protocol = url.protocol;
        this.#host = url.host;
        this.#pathname = url.pathname;
        this.#search = url.search;
      }
    }
    static [Symbol.hasInstance](val) {
      return val instanceof NativeURL;
    }
    get _url() {
      if (this.#url) return this.#url;
      this.#url = new NativeURL(this.href);
      this.#href = void 0;
      this.#protocol = void 0;
      this.#host = void 0;
      this.#pathname = void 0;
      this.#search = void 0;
      this.#searchParams = void 0;
      this.#pos = void 0;
      return this.#url;
    }
    get href() {
      if (this.#url) return this.#url.href;
      if (!this.#href) this.#href = `${this.#protocol || "http:"}//${this.#host || "localhost"}${this.#pathname || "/"}${this.#search || ""}`;
      return this.#href;
    }
    #getPos() {
      if (!this.#pos) {
        const url = this.href;
        const protoIndex = url.indexOf("://");
        const pathnameIndex = protoIndex === -1 ? -1 : url.indexOf("/", protoIndex + 4);
        this.#pos = [
          protoIndex,
          pathnameIndex,
          pathnameIndex === -1 ? -1 : url.indexOf("?", pathnameIndex)
        ];
      }
      return this.#pos;
    }
    get pathname() {
      if (this.#url) return this.#url.pathname;
      if (this.#pathname === void 0) {
        const [, pathnameIndex, queryIndex] = this.#getPos();
        if (pathnameIndex === -1) return this._url.pathname;
        this.#pathname = this.href.slice(pathnameIndex, queryIndex === -1 ? void 0 : queryIndex);
      }
      return this.#pathname;
    }
    get search() {
      if (this.#url) return this.#url.search;
      if (this.#search === void 0) {
        const [, pathnameIndex, queryIndex] = this.#getPos();
        if (pathnameIndex === -1) return this._url.search;
        const url = this.href;
        this.#search = queryIndex === -1 || queryIndex === url.length - 1 ? "" : url.slice(queryIndex);
      }
      return this.#search;
    }
    get searchParams() {
      if (this.#url) return this.#url.searchParams;
      if (!this.#searchParams) this.#searchParams = new URLSearchParams(this.search);
      return this.#searchParams;
    }
    get protocol() {
      if (this.#url) return this.#url.protocol;
      if (this.#protocol === void 0) {
        const [protocolIndex] = this.#getPos();
        if (protocolIndex === -1) return this._url.protocol;
        this.#protocol = this.href.slice(0, protocolIndex + 1);
      }
      return this.#protocol;
    }
    toString() {
      return this.href;
    }
    toJSON() {
      return this.href;
    }
  };
  lazyInherit(FastURL$1.prototype, NativeURL.prototype, "_url");
  Object.setPrototypeOf(FastURL$1.prototype, NativeURL.prototype);
  Object.setPrototypeOf(FastURL$1, NativeURL);
  return FastURL$1;
})();
function resolvePortAndHost(opts) {
  const _port = opts.port ?? globalThis.process?.env.PORT ?? 3e3;
  const port2 = typeof _port === "number" ? _port : Number.parseInt(_port, 10);
  if (port2 < 0 || port2 > 65535) throw new RangeError(`Port must be between 0 and 65535 (got "${port2}").`);
  return {
    port: port2,
    hostname: opts.hostname ?? globalThis.process?.env.HOST
  };
}
function fmtURL(host2, port2, secure) {
  if (!host2 || !port2) return;
  if (host2.includes(":")) host2 = `[${host2}]`;
  return `http${secure ? "s" : ""}://${host2}:${port2}/`;
}
function printListening(opts, url) {
  if (!url || (opts.silent ?? globalThis.process?.env?.TEST)) return;
  const _url = new URL(url);
  const allInterfaces = _url.hostname === "[::]" || _url.hostname === "0.0.0.0";
  if (allInterfaces) {
    _url.hostname = "localhost";
    url = _url.href;
  }
  let listeningOn = `➜ Listening on:`;
  let additionalInfo = allInterfaces ? " (all interfaces)" : "";
  if (globalThis.process.stdout?.isTTY) {
    listeningOn = `\x1B[32m${listeningOn}\x1B[0m`;
    url = `\x1B[36m${url}\x1B[0m`;
    additionalInfo = `\x1B[2m${additionalInfo}\x1B[0m`;
  }
  console.log(`${listeningOn} ${url}${additionalInfo}`);
}
function resolveTLSOptions(opts) {
  if (!opts.tls || opts.protocol === "http") return;
  const cert2 = resolveCertOrKey(opts.tls.cert);
  const key2 = resolveCertOrKey(opts.tls.key);
  if (!cert2 && !key2) {
    if (opts.protocol === "https") throw new TypeError("TLS `cert` and `key` must be provided for `https` protocol.");
    return;
  }
  if (!cert2 || !key2) throw new TypeError("TLS `cert` and `key` must be provided together.");
  return {
    cert: cert2,
    key: key2,
    passphrase: opts.tls.passphrase
  };
}
function resolveCertOrKey(value) {
  if (!value) return;
  if (typeof value !== "string") throw new TypeError("TLS certificate and key must be strings in PEM format or file paths.");
  if (value.startsWith("-----BEGIN ")) return value;
  const { readFileSync } = process.getBuiltinModule("node:fs");
  return readFileSync(value, "utf8");
}
function createWaitUntil() {
  const promises2 = /* @__PURE__ */ new Set();
  return {
    waitUntil: (promise) => {
      if (typeof promise?.then !== "function") return;
      promises2.add(Promise.resolve(promise).catch(console.error).finally(() => {
        promises2.delete(promise);
      }));
    },
    wait: () => {
      return Promise.all(promises2);
    }
  };
}
const noColor = /* @__PURE__ */ (() => {
  const env = globalThis.process?.env ?? {};
  return env.NO_COLOR === "1" || env.TERM === "dumb";
})();
const _c = (c, r = 39) => (t) => noColor ? t : `\x1B[${c}m${t}\x1B[${r}m`;
const red = /* @__PURE__ */ _c(31);
const gray = /* @__PURE__ */ _c(90);
function wrapFetch(server) {
  const fetchHandler = server.options.fetch;
  const middleware = server.options.middleware || [];
  return middleware.length === 0 ? fetchHandler : (request) => callMiddleware$1(request, fetchHandler, middleware, 0);
}
function callMiddleware$1(request, fetchHandler, middleware, index) {
  if (index === middleware.length) return fetchHandler(request);
  return middleware[index](request, () => callMiddleware$1(request, fetchHandler, middleware, index + 1));
}
const errorPlugin = (server) => {
  const errorHandler2 = server.options.error;
  if (!errorHandler2) return;
  server.options.middleware.unshift((_req, next) => {
    try {
      const res = next();
      return res instanceof Promise ? res.catch((error) => errorHandler2(error)) : res;
    } catch (error) {
      return errorHandler2(error);
    }
  });
};
const gracefulShutdownPlugin = (server) => {
  const config = server.options?.gracefulShutdown;
  if (!globalThis.process?.on || config === false || config === void 0 && (process.env.CI || process.env.TEST)) return;
  const gracefulShutdown = config === true || !config?.gracefulTimeout ? Number.parseInt(process.env.SERVER_SHUTDOWN_TIMEOUT || "") || 3 : config.gracefulTimeout;
  const forceShutdown = config === true || !config?.forceTimeout ? Number.parseInt(process.env.SERVER_FORCE_SHUTDOWN_TIMEOUT || "") || 5 : config.forceTimeout;
  let isShuttingDown = false;
  const shutdown = async () => {
    if (isShuttingDown) return;
    isShuttingDown = true;
    const w = process.stderr.write.bind(process.stderr);
    w(gray(`
Shutting down server in ${gracefulShutdown}s...`));
    let timeout;
    await Promise.race([server.close().finally(() => {
      clearTimeout(timeout);
      w(gray(" Server closed.\n"));
    }), new Promise((resolve2) => {
      timeout = setTimeout(() => {
        w(gray(`
Force closing connections in ${forceShutdown}s...`));
        timeout = setTimeout(() => {
          w(red("\nCould not close connections in time, force exiting."));
          resolve2();
        }, forceShutdown * 1e3);
        return server.close(true);
      }, gracefulShutdown * 1e3);
    })]);
    globalThis.process.exit(0);
  };
  for (const sig of ["SIGINT", "SIGTERM"]) globalThis.process.on(sig, shutdown);
};
const NodeResponse = /* @__PURE__ */ (() => {
  const NativeResponse = globalThis.Response;
  const STATUS_CODES = globalThis.process?.getBuiltinModule?.("node:http")?.STATUS_CODES || {};
  class NodeResponse$1 {
    #body;
    #init;
    #headers;
    #response;
    constructor(body, init) {
      this.#body = body;
      this.#init = init;
    }
    static [Symbol.hasInstance](val) {
      return val instanceof NativeResponse;
    }
    get status() {
      return this.#response?.status || this.#init?.status || 200;
    }
    get statusText() {
      return this.#response?.statusText || this.#init?.statusText || STATUS_CODES[this.status] || "";
    }
    get headers() {
      if (this.#response) return this.#response.headers;
      if (this.#headers) return this.#headers;
      const initHeaders = this.#init?.headers;
      return this.#headers = initHeaders instanceof Headers ? initHeaders : new Headers(initHeaders);
    }
    get ok() {
      if (this.#response) return this.#response.ok;
      const status = this.status;
      return status >= 200 && status < 300;
    }
    get _response() {
      if (this.#response) return this.#response;
      this.#response = new NativeResponse(this.#body, this.#headers ? {
        ...this.#init,
        headers: this.#headers
      } : this.#init);
      this.#init = void 0;
      this.#headers = void 0;
      this.#body = void 0;
      return this.#response;
    }
    _toNodeResponse() {
      const status = this.status;
      const statusText = this.statusText;
      let body;
      let contentType;
      let contentLength;
      if (this.#response) body = this.#response.body;
      else if (this.#body) if (this.#body instanceof ReadableStream) body = this.#body;
      else if (typeof this.#body === "string") {
        body = this.#body;
        contentType = "text/plain; charset=UTF-8";
        contentLength = Buffer.byteLength(this.#body);
      } else if (this.#body instanceof ArrayBuffer) {
        body = Buffer.from(this.#body);
        contentLength = this.#body.byteLength;
      } else if (this.#body instanceof Uint8Array) {
        body = this.#body;
        contentLength = this.#body.byteLength;
      } else if (this.#body instanceof DataView) {
        body = Buffer.from(this.#body.buffer);
        contentLength = this.#body.byteLength;
      } else if (this.#body instanceof Blob) {
        body = this.#body.stream();
        contentType = this.#body.type;
        contentLength = this.#body.size;
      } else if (typeof this.#body.pipe === "function") body = this.#body;
      else body = this._response.body;
      const headers2 = [];
      const initHeaders = this.#init?.headers;
      const headerEntries = this.#response?.headers || this.#headers || (initHeaders ? Array.isArray(initHeaders) ? initHeaders : initHeaders?.entries ? initHeaders.entries() : Object.entries(initHeaders).map(([k, v]) => [k.toLowerCase(), v]) : void 0);
      let hasContentTypeHeader;
      let hasContentLength;
      if (headerEntries) for (const [key2, value] of headerEntries) {
        if (Array.isArray(value)) for (const v of value) headers2.push([key2, v]);
        else headers2.push([key2, value]);
        if (key2 === "content-type") hasContentTypeHeader = true;
        else if (key2 === "content-length") hasContentLength = true;
      }
      if (contentType && !hasContentTypeHeader) headers2.push(["content-type", contentType]);
      if (contentLength && !hasContentLength) headers2.push(["content-length", String(contentLength)]);
      this.#init = void 0;
      this.#headers = void 0;
      this.#response = void 0;
      this.#body = void 0;
      return {
        status,
        statusText,
        headers: headers2,
        body
      };
    }
  }
  lazyInherit(NodeResponse$1.prototype, NativeResponse.prototype, "_response");
  Object.setPrototypeOf(NodeResponse$1, NativeResponse);
  Object.setPrototypeOf(NodeResponse$1.prototype, NativeResponse.prototype);
  return NodeResponse$1;
})();
async function sendNodeResponse(nodeRes, webRes) {
  if (!webRes) {
    nodeRes.statusCode = 500;
    return endNodeResponse(nodeRes);
  }
  if (webRes._toNodeResponse) {
    const res = webRes._toNodeResponse();
    writeHead(nodeRes, res.status, res.statusText, res.headers);
    if (res.body) {
      if (res.body instanceof ReadableStream) return streamBody(res.body, nodeRes);
      else if (typeof res.body?.pipe === "function") {
        res.body.pipe(nodeRes);
        return new Promise((resolve2) => nodeRes.on("close", resolve2));
      }
      nodeRes.write(res.body);
    }
    return endNodeResponse(nodeRes);
  }
  const rawHeaders = [...webRes.headers];
  writeHead(nodeRes, webRes.status, webRes.statusText, rawHeaders);
  return webRes.body ? streamBody(webRes.body, nodeRes) : endNodeResponse(nodeRes);
}
function writeHead(nodeRes, status, statusText, rawHeaders) {
  const writeHeaders = globalThis.Deno ? rawHeaders : rawHeaders.flat();
  if (!nodeRes.headersSent) if (nodeRes.req?.httpVersion === "2.0") nodeRes.writeHead(status, writeHeaders);
  else nodeRes.writeHead(status, statusText, writeHeaders);
}
function endNodeResponse(nodeRes) {
  return new Promise((resolve2) => nodeRes.end(resolve2));
}
function streamBody(stream, nodeRes) {
  if (nodeRes.destroyed) {
    stream.cancel();
    return;
  }
  const reader = stream.getReader();
  function streamCancel(error) {
    reader.cancel(error).catch(() => {
    });
    if (error) nodeRes.destroy(error);
  }
  function streamHandle({ done, value }) {
    try {
      if (done) nodeRes.end();
      else if (nodeRes.write(value)) reader.read().then(streamHandle, streamCancel);
      else nodeRes.once("drain", () => reader.read().then(streamHandle, streamCancel));
    } catch (error) {
      streamCancel(error instanceof Error ? error : void 0);
    }
  }
  nodeRes.on("close", streamCancel);
  nodeRes.on("error", streamCancel);
  reader.read().then(streamHandle, streamCancel);
  return reader.closed.catch(streamCancel).finally(() => {
    nodeRes.off("close", streamCancel);
    nodeRes.off("error", streamCancel);
  });
}
var NodeRequestURL = class extends FastURL {
  #req;
  constructor({ req }) {
    const path = req.url || "/";
    if (path[0] === "/") {
      const qIndex = path.indexOf("?");
      const pathname = qIndex === -1 ? path : path?.slice(0, qIndex) || "/";
      const search = qIndex === -1 ? "" : path?.slice(qIndex) || "";
      const host2 = req.headers.host || req.headers[":authority"] || `${req.socket.localFamily === "IPv6" ? "[" + req.socket.localAddress + "]" : req.socket.localAddress}:${req.socket?.localPort || "80"}`;
      const protocol = req.socket?.encrypted || req.headers["x-forwarded-proto"] === "https" || req.headers[":scheme"] === "https" ? "https:" : "http:";
      super({
        protocol,
        host: host2,
        pathname,
        search
      });
    } else super(path);
    this.#req = req;
  }
  get pathname() {
    return super.pathname;
  }
  set pathname(value) {
    this._url.pathname = value;
    this.#req.url = this._url.pathname + this._url.search;
  }
};
const NodeRequestHeaders = /* @__PURE__ */ (() => {
  const NativeHeaders = globalThis.Headers;
  class Headers2 {
    #req;
    #headers;
    constructor(req) {
      this.#req = req;
    }
    static [Symbol.hasInstance](val) {
      return val instanceof NativeHeaders;
    }
    get _headers() {
      if (!this.#headers) {
        const headers2 = new NativeHeaders();
        const rawHeaders = this.#req.rawHeaders;
        const len = rawHeaders.length;
        for (let i = 0; i < len; i += 2) {
          const key2 = rawHeaders[i];
          if (key2.charCodeAt(0) === 58) continue;
          const value = rawHeaders[i + 1];
          headers2.append(key2, value);
        }
        this.#headers = headers2;
      }
      return this.#headers;
    }
    get(name) {
      if (this.#headers) return this.#headers.get(name);
      const value = this.#req.headers[name.toLowerCase()];
      return Array.isArray(value) ? value.join(", ") : value || null;
    }
    has(name) {
      if (this.#headers) return this.#headers.has(name);
      return name.toLowerCase() in this.#req.headers;
    }
    getSetCookie() {
      if (this.#headers) return this.#headers.getSetCookie();
      const value = this.#req.headers["set-cookie"];
      return Array.isArray(value) ? value : value ? [value] : [];
    }
    *_entries() {
      const rawHeaders = this.#req.rawHeaders;
      const len = rawHeaders.length;
      for (let i = 0; i < len; i += 2) {
        const key2 = rawHeaders[i];
        if (key2.charCodeAt(0) === 58) continue;
        yield [key2.toLowerCase(), rawHeaders[i + 1]];
      }
    }
    entries() {
      return this.#headers ? this.#headers.entries() : this._entries();
    }
    [Symbol.iterator]() {
      return this.entries();
    }
  }
  lazyInherit(Headers2.prototype, NativeHeaders.prototype, "_headers");
  Object.setPrototypeOf(Headers2, NativeHeaders);
  Object.setPrototypeOf(Headers2.prototype, NativeHeaders.prototype);
  return Headers2;
})();
const NodeRequest = /* @__PURE__ */ (() => {
  const NativeRequest = globalThis[/* @__PURE__ */ Symbol.for("srvx.nativeRequest")] ??= globalThis.Request;
  const PatchedRequest = class Request$1 extends NativeRequest {
    static _srvx = true;
    static [Symbol.hasInstance](instance) {
      if (this === PatchedRequest) return instance instanceof NativeRequest;
      else return Object.prototype.isPrototypeOf.call(this.prototype, instance);
    }
    constructor(input, options) {
      if (typeof input === "object" && "_request" in input) input = input._request;
      if (options?.body?.getReader !== void 0) options.duplex ??= "half";
      super(input, options);
    }
  };
  if (!globalThis.Request._srvx) globalThis.Request = PatchedRequest;
  class Request2 {
    runtime;
    #req;
    #url;
    #bodyStream;
    #request;
    #headers;
    #abortController;
    constructor(ctx) {
      this.#req = ctx.req;
      this.runtime = {
        name: "node",
        node: ctx
      };
    }
    static [Symbol.hasInstance](val) {
      return val instanceof NativeRequest;
    }
    get ip() {
      return this.#req.socket?.remoteAddress;
    }
    get method() {
      if (this.#request) return this.#request.method;
      return this.#req.method || "GET";
    }
    get _url() {
      return this.#url ||= new NodeRequestURL({ req: this.#req });
    }
    set _url(url) {
      this.#url = url;
    }
    get url() {
      if (this.#request) return this.#request.url;
      return this._url.href;
    }
    get headers() {
      if (this.#request) return this.#request.headers;
      return this.#headers ||= new NodeRequestHeaders(this.#req);
    }
    get _abortController() {
      if (!this.#abortController) {
        this.#abortController = new AbortController();
        const { req, res } = this.runtime.node;
        const abortController = this.#abortController;
        const abort = (err) => abortController.abort?.(err);
        req.once("error", abort);
        if (res) res.once("close", () => {
          const reqError = req.errored;
          if (reqError) abort(reqError);
          else if (!res.writableEnded) abort();
        });
        else req.once("close", () => {
          if (!req.complete) abort();
        });
      }
      return this.#abortController;
    }
    get signal() {
      return this.#request ? this.#request.signal : this._abortController.signal;
    }
    get body() {
      if (this.#request) return this.#request.body;
      if (this.#bodyStream === void 0) {
        const method = this.method;
        this.#bodyStream = !(method === "GET" || method === "HEAD") ? Readable.toWeb(this.#req) : null;
      }
      return this.#bodyStream;
    }
    text() {
      if (this.#request) return this.#request.text();
      if (this.#bodyStream !== void 0) return this.#bodyStream ? new Response(this.#bodyStream).text() : Promise.resolve("");
      return readBody$1(this.#req).then((buf) => buf.toString());
    }
    json() {
      if (this.#request) return this.#request.json();
      return this.text().then((text2) => JSON.parse(text2));
    }
    get _request() {
      if (!this.#request) {
        this.#request = new PatchedRequest(this.url, {
          method: this.method,
          headers: this.headers,
          body: this.body,
          signal: this._abortController.signal
        });
        this.#headers = void 0;
        this.#bodyStream = void 0;
      }
      return this.#request;
    }
  }
  lazyInherit(Request2.prototype, NativeRequest.prototype, "_request");
  Object.setPrototypeOf(Request2.prototype, NativeRequest.prototype);
  return Request2;
})();
function readBody$1(req) {
  return new Promise((resolve2, reject) => {
    const chunks = [];
    const onData = (chunk) => {
      chunks.push(chunk);
    };
    const onError = (err) => {
      reject(err);
    };
    const onEnd = () => {
      req.off("error", onError);
      req.off("data", onData);
      resolve2(Buffer.concat(chunks));
    };
    req.on("data", onData).once("end", onEnd).once("error", onError);
  });
}
function serve(options) {
  return new NodeServer(options);
}
var NodeServer = class {
  runtime = "node";
  options;
  node;
  serveOptions;
  fetch;
  #isSecure;
  #listeningPromise;
  #wait;
  constructor(options) {
    this.options = {
      ...options,
      middleware: [...options.middleware || []]
    };
    for (const plugin of options.plugins || []) plugin(this);
    errorPlugin(this);
    gracefulShutdownPlugin(this);
    const fetchHandler = this.fetch = wrapFetch(this);
    this.#wait = createWaitUntil();
    const handler = (nodeReq, nodeRes) => {
      const request = new NodeRequest({
        req: nodeReq,
        res: nodeRes
      });
      request.waitUntil = this.#wait.waitUntil;
      const res = fetchHandler(request);
      return res instanceof Promise ? res.then((resolvedRes) => sendNodeResponse(nodeRes, resolvedRes)) : sendNodeResponse(nodeRes, res);
    };
    const tls = resolveTLSOptions(this.options);
    const socketPath = this.options.path || (globalThis.process?.env?.APP_SOCKET_PATH || globalThis.process?.env?.SOCKET_PATH || "").trim();
    const resolved = socketPath ? { path: socketPath } : resolvePortAndHost(this.options);
    this.serveOptions = {
      ...(socketPath ? { path: socketPath } : { port: resolved.port, host: resolved.hostname }),
      exclusive: !this.options.reusePort,
      ...tls ? {
        cert: tls.cert,
        key: tls.key,
        passphrase: tls.passphrase
      } : {},
      ...this.options.node
    };
    let server;
    this.#isSecure = !!this.serveOptions.cert && this.options.protocol !== "http";
    if (this.options.node?.http2 ?? this.#isSecure) if (this.#isSecure) server = nodeHTTP2.createSecureServer({
      allowHTTP1: true,
      ...this.serveOptions
    }, handler);
    else throw new Error("node.http2 option requires tls certificate!");
    else if (this.#isSecure) server = nodeHTTPS.createServer(this.serveOptions, handler);
    else server = nodeHTTP.createServer(this.serveOptions, handler);
    this.node = {
      server,
      handler
    };
    if (!options.manual) this.serve();
  }
  serve() {
    if (this.#listeningPromise) return Promise.resolve(this.#listeningPromise).then(() => this);
    this.#listeningPromise = new Promise((resolve2) => {
      this.node.server.listen(this.serveOptions, () => {
        const __listenUrl = this.url;
        if (typeof __listenUrl === "string" && /^https?:\/\//.test(__listenUrl)) {
          printListening(this.options, __listenUrl);
        }
        resolve2();
      });
    });
  }
  get url() {
    const addr = this.node?.server?.address();
    if (!addr) return;
    return typeof addr === "string" ? addr : fmtURL(addr.address, addr.port, this.#isSecure);
  }
  ready() {
    return Promise.resolve(this.#listeningPromise).then(() => this);
  }
  async close(closeAll) {
    await Promise.all([this.#wait.wait(), new Promise((resolve2, reject) => {
      const server = this.node?.server;
      if (!server) return resolve2();
      if (closeAll && "closeAllConnections" in server) server.closeAllConnections();
      server.close((error) => error ? reject(error) : resolve2());
    })]);
  }
};
const NullProtoObj = /* @__PURE__ */ (() => {
  const e = function() {
  };
  return e.prototype = /* @__PURE__ */ Object.create(null), Object.freeze(e.prototype), e;
})();
const kEventNS = "h3.internal.event.";
const kEventRes = /* @__PURE__ */ Symbol.for(`${kEventNS}res`);
const kEventResHeaders = /* @__PURE__ */ Symbol.for(`${kEventNS}res.headers`);
var H3Event = class {
  app;
  req;
  url;
  context;
  static __is_event__ = true;
  constructor(req, context, app) {
    this.context = context || req.context || new NullProtoObj();
    this.req = req;
    this.app = app;
    const _url = req._url;
    this.url = _url && _url instanceof URL ? _url : new FastURL(req.url);
  }
  get res() {
    return this[kEventRes] ||= new H3EventResponse();
  }
  get runtime() {
    return this.req.runtime;
  }
  waitUntil(promise) {
    this.req.waitUntil?.(promise);
  }
  toString() {
    return `[${this.req.method}] ${this.req.url}`;
  }
  toJSON() {
    return this.toString();
  }
  get node() {
    return this.req.runtime?.node;
  }
  get headers() {
    return this.req.headers;
  }
  get path() {
    return this.url.pathname + this.url.search;
  }
  get method() {
    return this.req.method;
  }
};
var H3EventResponse = class {
  status;
  statusText;
  get headers() {
    return this[kEventResHeaders] ||= new Headers();
  }
};
const DISALLOWED_STATUS_CHARS = /[^\u0009\u0020-\u007E]/g;
function sanitizeStatusMessage(statusMessage = "") {
  return statusMessage.replace(DISALLOWED_STATUS_CHARS, "");
}
function sanitizeStatusCode(statusCode, defaultStatusCode = 200) {
  if (!statusCode) return defaultStatusCode;
  if (typeof statusCode === "string") statusCode = +statusCode;
  if (statusCode < 100 || statusCode > 599) return defaultStatusCode;
  return statusCode;
}
var HTTPError = class HTTPError2 extends Error {
  get name() {
    return "HTTPError";
  }
  status;
  statusText;
  headers;
  cause;
  data;
  body;
  unhandled;
  static isError(input) {
    return input instanceof Error && input?.name === "HTTPError";
  }
  static status(status, statusText, details) {
    return new HTTPError2({
      ...details,
      statusText,
      status
    });
  }
  constructor(arg1, arg2) {
    let messageInput;
    let details;
    if (typeof arg1 === "string") {
      messageInput = arg1;
      details = arg2;
    } else details = arg1;
    const status = sanitizeStatusCode(details?.status || details?.cause?.status || details?.status || details?.statusCode, 500);
    const statusText = sanitizeStatusMessage(details?.statusText || details?.cause?.statusText || details?.statusText || details?.statusMessage);
    const message = messageInput || details?.message || details?.cause?.message || details?.statusText || details?.statusMessage || [
      "HTTPError",
      status,
      statusText
    ].filter(Boolean).join(" ");
    super(message, { cause: details });
    this.cause = details;
    Error.captureStackTrace?.(this, this.constructor);
    this.status = status;
    this.statusText = statusText || void 0;
    const rawHeaders = details?.headers || details?.cause?.headers;
    this.headers = rawHeaders ? new Headers(rawHeaders) : void 0;
    this.unhandled = details?.unhandled ?? details?.cause?.unhandled ?? void 0;
    this.data = details?.data;
    this.body = details?.body;
  }
  get statusCode() {
    return this.status;
  }
  get statusMessage() {
    return this.statusText;
  }
  toJSON() {
    const unhandled = this.unhandled;
    return {
      status: this.status,
      statusText: this.statusText,
      unhandled,
      message: unhandled ? "HTTPError" : this.message,
      data: unhandled ? void 0 : this.data,
      ...unhandled ? void 0 : this.body
    };
  }
};
function hasProp(obj, prop) {
  try {
    return prop in obj;
  } catch {
    return false;
  }
}
function isJSONSerializable(value, _type) {
  if (value === null || value === void 0) return true;
  if (_type !== "object") return _type === "boolean" || _type === "number" || _type === "string";
  if (typeof value.toJSON === "function") return true;
  if (Array.isArray(value)) return true;
  if (typeof value.pipe === "function" || typeof value.pipeTo === "function") return false;
  if (value instanceof NullProtoObj) return true;
  const proto = Object.getPrototypeOf(value);
  return proto === Object.prototype || proto === null;
}
const kNotFound = /* @__PURE__ */ Symbol.for("h3.notFound");
const kHandled = /* @__PURE__ */ Symbol.for("h3.handled");
function toResponse(val, event, config = {}) {
  if (typeof val?.then === "function") return (val.catch?.((error) => error) || Promise.resolve(val)).then((resolvedVal) => toResponse(resolvedVal, event, config));
  const response = prepareResponse(val, event, config);
  if (typeof response?.then === "function") return toResponse(response, event, config);
  const { onResponse: onResponse$1 } = config;
  return onResponse$1 ? Promise.resolve(onResponse$1(response, event)).then(() => response) : response;
}
var HTTPResponse = class {
  #headers;
  #init;
  body;
  constructor(body, init) {
    this.body = body;
    this.#init = init;
  }
  get status() {
    return this.#init?.status || 200;
  }
  get statusText() {
    return this.#init?.statusText || "OK";
  }
  get headers() {
    return this.#headers ||= new Headers(this.#init?.headers);
  }
};
function prepareResponse(val, event, config, nested) {
  if (val === kHandled) return new NodeResponse(null);
  if (val === kNotFound) val = new HTTPError({
    status: 404,
    message: `Cannot find any route matching [${event.req.method}] ${event.url}`
  });
  if (val && val instanceof Error) {
    const isHTTPError = HTTPError.isError(val);
    const error = isHTTPError ? val : new HTTPError(val);
    if (!isHTTPError) {
      error.unhandled = true;
      if (val?.stack) error.stack = val.stack;
    }
    if (error.unhandled && !config.silent) console.error(error);
    const { onError: onError$1 } = config;
    return onError$1 && !nested ? Promise.resolve(onError$1(error, event)).catch((error$1) => error$1).then((newVal) => prepareResponse(newVal ?? val, event, config, true)) : errorResponse(error, config.debug);
  }
  const preparedRes = event[kEventRes];
  const preparedHeaders = preparedRes?.[kEventResHeaders];
  if (!(val instanceof Response)) {
    const res = prepareResponseBody(val, event, config);
    const status = res.status || preparedRes?.status;
    return new NodeResponse(nullBody(event.req.method, status) ? null : res.body, {
      status,
      statusText: res.statusText || preparedRes?.statusText,
      headers: res.headers && preparedHeaders ? mergeHeaders$1(res.headers, preparedHeaders) : res.headers || preparedHeaders
    });
  }
  if (!preparedHeaders || nested || !val.ok) return val;
  try {
    mergeHeaders$1(val.headers, preparedHeaders, val.headers);
    return val;
  } catch {
    return new NodeResponse(nullBody(event.req.method, val.status) ? null : val.body, {
      status: val.status,
      statusText: val.statusText,
      headers: mergeHeaders$1(val.headers, preparedHeaders)
    });
  }
}
function mergeHeaders$1(base, overrides, target = new Headers(base)) {
  for (const [name, value] of overrides) if (name === "set-cookie") target.append(name, value);
  else target.set(name, value);
  return target;
}
const frozenHeaders = () => {
  throw new Error("Headers are frozen");
};
var FrozenHeaders = class extends Headers {
  constructor(init) {
    super(init);
    this.set = this.append = this.delete = frozenHeaders;
  }
};
const emptyHeaders = /* @__PURE__ */ new FrozenHeaders({ "content-length": "0" });
const jsonHeaders = /* @__PURE__ */ new FrozenHeaders({ "content-type": "application/json;charset=UTF-8" });
function prepareResponseBody(val, event, config) {
  if (val === null || val === void 0) return {
    body: "",
    headers: emptyHeaders
  };
  const valType = typeof val;
  if (valType === "string") return { body: val };
  if (val instanceof Uint8Array) {
    event.res.headers.set("content-length", val.byteLength.toString());
    return { body: val };
  }
  if (val instanceof HTTPResponse || val?.constructor?.name === "HTTPResponse") return val;
  if (isJSONSerializable(val, valType)) return {
    body: JSON.stringify(val, void 0, config.debug ? 2 : void 0),
    headers: jsonHeaders
  };
  if (valType === "bigint") return {
    body: val.toString(),
    headers: jsonHeaders
  };
  if (val instanceof Blob) {
    const headers2 = new Headers({
      "content-type": val.type,
      "content-length": val.size.toString()
    });
    let filename = val.name;
    if (filename) {
      filename = encodeURIComponent(filename);
      headers2.set("content-disposition", `filename="${filename}"; filename*=UTF-8''${filename}`);
    }
    return {
      body: val.stream(),
      headers: headers2
    };
  }
  if (valType === "symbol") return { body: val.toString() };
  if (valType === "function") return { body: `${val.name}()` };
  return { body: val };
}
function nullBody(method, status) {
  return method === "HEAD" || status === 100 || status === 101 || status === 102 || status === 204 || status === 205 || status === 304;
}
function errorResponse(error, debug) {
  return new NodeResponse(JSON.stringify({
    ...error.toJSON(),
    stack: debug && error.stack ? error.stack.split("\n").map((l) => l.trim()) : void 0
  }, void 0, debug ? 2 : void 0), {
    status: error.status,
    statusText: error.statusText,
    headers: error.headers ? mergeHeaders$1(jsonHeaders, error.headers) : new Headers(jsonHeaders)
  });
}
function callMiddleware(event, middleware, handler, index = 0) {
  if (index === middleware.length) return handler(event);
  const fn = middleware[index];
  let nextCalled;
  let nextResult;
  const next = () => {
    if (nextCalled) return nextResult;
    nextCalled = true;
    nextResult = callMiddleware(event, middleware, handler, index + 1);
    return nextResult;
  };
  const ret = fn(event, next);
  return isUnhandledResponse(ret) ? next() : typeof ret?.then === "function" ? ret.then((resolved) => isUnhandledResponse(resolved) ? next() : resolved) : ret;
}
function isUnhandledResponse(val) {
  return val === void 0 || val === kNotFound;
}
const plusRegex = /\+/g;
function parseQuery(input) {
  const params = new NullProtoObj();
  if (!input || input === "?") return params;
  const inputLength = input.length;
  let key2 = "";
  let value = "";
  let startingIndex = -1;
  let equalityIndex = -1;
  let shouldDecodeKey = false;
  let shouldDecodeValue = false;
  let keyHasPlus = false;
  let valueHasPlus = false;
  let hasBothKeyValuePair = false;
  let c = 0;
  for (let i = 0; i < inputLength + 1; i++) {
    c = i === inputLength ? 38 : input.charCodeAt(i);
    switch (c) {
      case 38:
        hasBothKeyValuePair = equalityIndex > startingIndex;
        if (!hasBothKeyValuePair) equalityIndex = i;
        key2 = input.slice(startingIndex + 1, equalityIndex);
        if (hasBothKeyValuePair || key2.length > 0) {
          if (keyHasPlus) key2 = key2.replace(plusRegex, " ");
          if (shouldDecodeKey) try {
            key2 = decodeURIComponent(key2);
          } catch {
          }
          if (hasBothKeyValuePair) {
            value = input.slice(equalityIndex + 1, i);
            if (valueHasPlus) value = value.replace(plusRegex, " ");
            if (shouldDecodeValue) try {
              value = decodeURIComponent(value);
            } catch {
            }
          }
          const currentValue = params[key2];
          if (currentValue === void 0) params[key2] = value;
          else if (Array.isArray(currentValue)) currentValue.push(value);
          else params[key2] = [currentValue, value];
        }
        value = "";
        startingIndex = i;
        equalityIndex = i;
        shouldDecodeKey = false;
        shouldDecodeValue = false;
        keyHasPlus = false;
        valueHasPlus = false;
        break;
      case 61:
        if (equalityIndex <= startingIndex) equalityIndex = i;
        else shouldDecodeValue = true;
        break;
      case 43:
        if (equalityIndex > startingIndex) valueHasPlus = true;
        else keyHasPlus = true;
        break;
      case 37:
        if (equalityIndex > startingIndex) shouldDecodeValue = true;
        else shouldDecodeKey = true;
        break;
    }
  }
  return params;
}
function toRequest(input, options) {
  if (typeof input === "string") {
    let url = input;
    if (url[0] === "/") {
      const host2 = "localhost";
      url = `${"http"}://${host2}${url}`;
    }
    return new Request(url, options);
  } else if (input instanceof URL) return new Request(input, options);
  return input;
}
function getQuery(event) {
  return parseQuery((event.url || new URL(event.req.url)).search.slice(1));
}
function defineHandler(input) {
  if (typeof input === "function") return handlerWithFetch(input);
  const handler = input.handler || (input.fetch ? function _fetchHandler(event) {
    return input.fetch(event.req);
  } : NoHandler);
  return Object.assign(handlerWithFetch(input.middleware?.length ? function _handlerMiddleware(event) {
    return callMiddleware(event, input.middleware, handler);
  } : handler), input);
}
function handlerWithFetch(handler) {
  if ("fetch" in handler) return handler;
  return Object.assign(handler, { fetch: (req) => {
    if (typeof req === "string") req = new URL(req, "http://_");
    if (req instanceof URL) req = new Request(req);
    const event = new H3Event(req);
    try {
      return Promise.resolve(toResponse(handler(event), event));
    } catch (error) {
      return Promise.resolve(toResponse(error, event));
    }
  } });
}
function defineLazyEventHandler(loader) {
  let handler;
  let promise;
  const resolveLazyHandler = () => {
    if (handler) return Promise.resolve(handler);
    return promise ??= Promise.resolve(loader()).then((r) => {
      handler = toEventHandler(r) || toEventHandler(r.default);
      if (typeof handler !== "function") throw new TypeError("Invalid lazy handler", { cause: { resolved: r } });
      return handler;
    });
  };
  return defineHandler(function lazyHandler(event) {
    return handler ? handler(event) : resolveLazyHandler().then((r) => r(event));
  });
}
function toEventHandler(handler) {
  if (typeof handler === "function") return handler;
  if (typeof handler?.handler === "function") return handler.handler;
  if (typeof handler?.fetch === "function") return function _fetchHandler(event) {
    return handler.fetch(event.req);
  };
}
const NoHandler = () => kNotFound;
var H3Core = class {
  config;
  "~middleware";
  "~routes" = [];
  constructor(config = {}) {
    this["~middleware"] = [];
    this.config = config;
    this.fetch = this.fetch.bind(this);
    this.handler = this.handler.bind(this);
  }
  fetch(request) {
    return this["~request"](request);
  }
  handler(event) {
    const route = this["~findRoute"](event);
    if (route) {
      event.context.params = route.params;
      event.context.matchedRoute = route.data;
    }
    const routeHandler = route?.data.handler || NoHandler;
    const middleware = this["~getMiddleware"](event, route);
    return middleware.length > 0 ? callMiddleware(event, middleware, routeHandler) : routeHandler(event);
  }
  "~request"(request, context) {
    const event = new H3Event(request, context, this);
    let handlerRes;
    try {
      if (this.config.onRequest) {
        const hookRes = this.config.onRequest(event);
        handlerRes = typeof hookRes?.then === "function" ? hookRes.then(() => this.handler(event)) : this.handler(event);
      } else handlerRes = this.handler(event);
    } catch (error) {
      handlerRes = Promise.reject(error);
    }
    return toResponse(handlerRes, event, this.config);
  }
  "~findRoute"(_event) {
  }
  "~addRoute"(_route) {
    this["~routes"].push(_route);
  }
  "~getMiddleware"(_event, route) {
    const routeMiddleware = route?.data.middleware;
    const globalMiddleware2 = this["~middleware"];
    return routeMiddleware ? [...globalMiddleware2, ...routeMiddleware] : globalMiddleware2;
  }
};
function parseURLEncodedBody(body) {
  const form = new URLSearchParams(body);
  const parsedForm = new NullProtoObj();
  for (const [key2, value] of form.entries()) if (hasProp(parsedForm, key2)) {
    if (!Array.isArray(parsedForm[key2])) parsedForm[key2] = [parsedForm[key2]];
    parsedForm[key2].push(value);
  } else parsedForm[key2] = value;
  return parsedForm;
}
async function readBody(event) {
  const text2 = await event.req.text();
  if (!text2) return;
  if ((event.req.headers.get("content-type") || "").startsWith("application/x-www-form-urlencoded")) return parseURLEncodedBody(text2);
  try {
    return JSON.parse(text2);
  } catch {
    throw new HTTPError({
      status: 400,
      statusText: "Bad Request",
      message: "Invalid JSON body"
    });
  }
}
function getRequestHeader(event, name) {
  return event.req.headers.get(name) || void 0;
}
const getHeader = getRequestHeader;
async function readMultipartFormData(event) {
  const formData = await event.req.formData();
  return Promise.all([...formData.entries()].map(async ([key2, value]) => {
    return value instanceof Blob ? {
      name: key2,
      type: value.type,
      filename: value.name,
      data: await value.bytes()
    } : {
      name: key2,
      data: new TextEncoder().encode(value)
    };
  }));
}
function setResponseHeader(event, name, value) {
  if (Array.isArray(value)) {
    event.res.headers.delete(name);
    for (const valueItem of value) event.res.headers.append(name, valueItem);
  } else event.res.headers.set(name, value);
}
const setHeader = setResponseHeader;
function setResponseStatus(event, code, text2) {
  if (code) event.res.status = sanitizeStatusCode(code, event.res.status);
}
const defineEventHandler = defineHandler;
function callHooks(hooks, args, startIndex, task) {
  for (let i = startIndex; i < hooks.length; i += 1) try {
    const result = task ? task.run(() => hooks[i](...args)) : hooks[i](...args);
    if (result instanceof Promise) return result.then(() => callHooks(hooks, args, i + 1, task));
  } catch (error) {
    return Promise.reject(error);
  }
}
var HookableCore = class {
  _hooks;
  constructor() {
    this._hooks = {};
  }
  hook(name, fn) {
    if (!name || typeof fn !== "function") return () => {
    };
    this._hooks[name] = this._hooks[name] || [];
    this._hooks[name].push(fn);
    return () => {
      if (fn) {
        this.removeHook(name, fn);
        fn = void 0;
      }
    };
  }
  removeHook(name, function_) {
    const hooks = this._hooks[name];
    if (hooks) {
      const index = hooks.indexOf(function_);
      if (index !== -1) hooks.splice(index, 1);
      if (hooks.length === 0) this._hooks[name] = void 0;
    }
  }
  callHook(name, ...args) {
    const hooks = this._hooks[name];
    if (!hooks || hooks.length === 0) return;
    return callHooks(hooks, args, 0);
  }
};
const errorHandler$1 = (error, event) => {
  const res = defaultHandler(error, event);
  return new NodeResponse(typeof res.body === "string" ? res.body : JSON.stringify(res.body, null, 2), res);
};
function defaultHandler(error, event, opts) {
  const isSensitive = error.unhandled;
  const status = error.status || 500;
  const url = event.url || new URL(event.req.url);
  if (status === 404) {
    const baseURL = "/investigacionv2/";
    if (/^\/[^/]/.test(baseURL) && !url.pathname.startsWith(baseURL)) {
      const redirectTo = `${baseURL}${url.pathname.slice(1)}${url.search}`;
      return {
        status: 302,
        statusText: "Found",
        headers: { location: redirectTo },
        body: `Redirecting...`
      };
    }
  }
  if (isSensitive && !opts?.silent) {
    const tags = [error.unhandled && "[unhandled]"].filter(Boolean).join(" ");
    console.error(`[request error] ${tags} [${event.req.method}] ${url}
`, error);
  }
  const headers2 = {
    "content-type": "application/json",
    "x-content-type-options": "nosniff",
    "x-frame-options": "DENY",
    "referrer-policy": "no-referrer",
    "content-security-policy": "script-src 'none'; frame-ancestors 'none';"
  };
  if (status === 404 || !event.res.headers.has("cache-control")) {
    headers2["cache-control"] = "no-cache";
  }
  const body = {
    error: true,
    url: url.href,
    status,
    statusText: error.statusText,
    message: isSensitive ? "Server Error" : error.message,
    data: isSensitive ? void 0 : error.data
  };
  return {
    status,
    statusText: error.statusText,
    headers: headers2,
    body
  };
}
const errorHandlers = [errorHandler$1];
async function errorHandler(error, event) {
  for (const handler of errorHandlers) {
    try {
      const response = await handler(error, event, { defaultHandler });
      if (response) {
        return response;
      }
    } catch (error2) {
      console.error(error2);
    }
  }
}
const BASE = "/investigacionv2";
const _KEFh44dOsQa0yPARPlbypqZ3Zb3Z2CrEhU0JJCIlGVE = (nitroApp2) => {
  nitroApp2.hooks.hook("request", (event) => {
    if (process.env.NODE_ENV !== "production") return;
    const url = event.node?.req?.url;
    if (!url || typeof url !== "string") return;
    if (url.startsWith(BASE)) return;
    if (url.startsWith("/api/") || url.startsWith("/assets/") || url === "/" || url.startsWith("/?")) {
      event.node.req.url = BASE + (url === "/" ? "/" : url);
    }
  });
};
const plugins = [
  _KEFh44dOsQa0yPARPlbypqZ3Zb3Z2CrEhU0JJCIlGVE
];
const ENC_SLASH_RE = /%2f/gi;
function decode(text2 = "") {
  try {
    return decodeURIComponent("" + text2);
  } catch {
    return "" + text2;
  }
}
function decodePath(text2) {
  return decode(text2.replace(ENC_SLASH_RE, "%252F"));
}
const JOIN_LEADING_SLASH_RE = /^\.?\//;
function hasTrailingSlash(input = "", respectQueryAndFragment) {
  {
    return input.endsWith("/");
  }
}
function withoutTrailingSlash(input = "", respectQueryAndFragment) {
  {
    return (hasTrailingSlash(input) ? input.slice(0, -1) : input) || "/";
  }
}
function withTrailingSlash(input = "", respectQueryAndFragment) {
  {
    return input.endsWith("/") ? input : input + "/";
  }
}
function hasLeadingSlash(input = "") {
  return input.startsWith("/");
}
function withLeadingSlash(input = "") {
  return hasLeadingSlash(input) ? input : "/" + input;
}
function isNonEmptyURL(url) {
  return url && url !== "/";
}
function joinURL(base, ...input) {
  let url = base || "";
  for (const segment of input.filter((url2) => isNonEmptyURL(url2))) {
    if (url) {
      const _segment = segment.replace(JOIN_LEADING_SLASH_RE, "");
      url = withTrailingSlash(url) + _segment;
    } else {
      url = segment;
    }
  }
  return url;
}
const headers = ((m) => function headersRouteRule(event) {
  for (const [key2, value] of Object.entries(m.options || {})) {
    event.res.headers.set(key2, value);
  }
});
const _lDk5s1 = defineEventHandler(() => {
  const version = process.env.APP_VERSION ?? "0.0.0";
  return { version };
});
const version_get = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _lDk5s1
});
const _knK2Yo = defineEventHandler(async (event) => {
  const query = getQuery(event);
  const curp2 = query.curp;
  if (!curp2 || curp2.length !== 18) {
    return {
      success: false,
      error: "CURP inválido o no proporcionado"
    };
  }
  try {
    const apiUrl = process.env.CURP_API_URL || "http://187.217.150.103/CURPHJM/Leercurp.php";
    const url = `${apiUrl}?curp=${curp2}`;
    const controller = new AbortController();
    const timeoutId = setTimeout(() => controller.abort(), 1e4);
    const response = await fetch(url, {
      method: "GET",
      headers: {
        "User-Agent": "Mozilla/5.0 (compatible; HJM-RPI/1.0)",
        "Connection": "keep-alive"
      },
      signal: controller.signal
    });
    clearTimeout(timeoutId);
    if (!response.ok) {
      throw new Error(`Error ${response.status}: ${response.statusText}`);
    }
    const responseText = await response.text();
    const parts = responseText.split("_");
    if (parts[0] === "1" || parts.length < 7) {
      throw new Error("CURP no encontrado");
    }
    const sexoRaw = parts[4];
    let sexo = "";
    if (sexoRaw === "HOMBRE" || sexoRaw === "H") sexo = "H";
    else if (sexoRaw === "MUJER" || sexoRaw === "M") sexo = "M";
    else sexo = sexoRaw;
    return {
      success: true,
      data: {
        nombre: parts[1],
        apellidoPaterno: parts[2],
        apellidoMaterno: parts[3],
        sexo,
        fechaNacimiento: parts[5],
        edad: parseInt(parts[6], 10),
        nacionalidad: parts[7] || ""
      }
    };
  } catch (error) {
    if (error instanceof Error && error.name === "AbortError") {
      return {
        success: false,
        error: "Tiempo de espera agotado"
      };
    }
    return {
      success: false,
      error: error instanceof Error ? error.message : "Error desconocido"
    };
  }
});
const curp = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _knK2Yo
});
const socketPath = process.env.DB_SOCKET?.trim() || void 0;
const pool = mysql.createPool(
  socketPath ? {
    socketPath,
    user: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_NAME,
    waitForConnections: true,
    connectionLimit: 10,
    queueLimit: 0
  } : {
    host: process.env.DB_HOST || "localhost",
    user: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_NAME,
    waitForConnections: true,
    connectionLimit: 10,
    queueLimit: 0
  }
);
const usuarios = mysqlTable("usuarios", {
  id: int("id").primaryKey().autoincrement(),
  nacionalidad: varchar("nacionalidad", { length: 20 }),
  curp: varchar("curp", { length: 18 }),
  identificacion: varchar("identificacion", { length: 64 }),
  nombre: varchar("nombre", { length: 120 }),
  apellidos: varchar("apellidos", { length: 160 }),
  edad: int("edad"),
  genero: varchar("genero", { length: 20 }),
  correo: varchar("correo", { length: 255 }),
  lugarResidencia: varchar("lugar_residencia", { length: 255 }),
  formacionAcademica: varchar("formacion_academica", { length: 255 }),
  institucionProcedencia: varchar("institucion_procedencia", { length: 255 }),
  telefono: varchar("telefono", { length: 20 }),
  contrasena: varchar("contrasena", { length: 255 }),
  correoVerificado: tinyint("correo_verificado"),
  codigoVerificacionHash: varchar("codigo_verificacion_hash", { length: 255 }),
  codigoVerificacionExpira: datetime("codigo_verificacion_expira"),
  codigoVerificacionIntentos: int("codigo_verificacion_intentos"),
  codigoVerificacionUltimoEnvio: datetime("codigo_verificacion_ultimo_envio"),
  codigoRecuperacionHash: varchar("codigo_recuperacion_hash", { length: 255 }),
  codigoRecuperacionExpira: datetime("codigo_recuperacion_expira"),
  codigoRecuperacionIntentos: int("codigo_recuperacion_intentos"),
  codigoRecuperacionUltimoEnvio: datetime("codigo_recuperacion_ultimo_envio"),
  rolId: int("rol_id")
});
const roles = mysqlTable("roles", {
  id: int("id").primaryKey().autoincrement(),
  nombre: varchar("nombre", { length: 100 })
});
const proyectos = mysqlTable("proyectos", {
  id: int("id").primaryKey().autoincrement(),
  usuarioId: int("usuario_id"),
  estado: varchar("estado", { length: 20 }),
  pasoActual: tinyint("paso_actual"),
  fechaCreacion: datetime("fecha_creacion"),
  fechaActualizacion: datetime("fecha_actualizacion")
});
const datosProyecto = mysqlTable("datos_proyecto", {
  id: int("id").primaryKey().autoincrement(),
  proyectoId: int("proyecto_id"),
  paso: tinyint("paso"),
  datos: json("datos")
});
const archivosProyecto = mysqlTable("archivos_proyecto", {
  id: int("id").primaryKey().autoincrement(),
  proyectoId: int("proyecto_id"),
  tipoArchivo: varchar("tipo_archivo", { length: 50 }),
  rutaServidor: varchar("ruta_servidor", { length: 500 }),
  nombreOriginal: varchar("nombre_original", { length: 255 }),
  tamano: int("tamano"),
  contentType: varchar("content_type", { length: 100 }),
  fechaSubida: datetime("fecha_subida")
});
const revisionComentarios = mysqlTable("revision_comentarios", {
  id: int("id").primaryKey().autoincrement(),
  proyectoId: int("proyecto_id"),
  comite: tinyint("comite"),
  paso: tinyint("paso"),
  comentario: text("comentario"),
  usuarioId: int("usuario_id"),
  fechaComentario: datetime("fecha_comentario")
});
const revisionAprobaciones = mysqlTable("revision_aprobaciones", {
  id: int("id").primaryKey().autoincrement(),
  proyectoId: int("proyecto_id"),
  comite: tinyint("comite"),
  aprobado: tinyint("aprobado"),
  usuarioId: int("usuario_id"),
  fechaAprobacion: datetime("fecha_aprobacion")
});
const db = drizzle(pool);
async function listarUsuariosConDrizzle() {
  return db.select({
    id: usuarios.id,
    nacionalidad: usuarios.nacionalidad,
    curp: usuarios.curp,
    identificacion: usuarios.identificacion,
    nombre: usuarios.nombre,
    apellidos: usuarios.apellidos,
    edad: usuarios.edad,
    genero: usuarios.genero,
    correo: usuarios.correo,
    lugar_residencia: usuarios.lugarResidencia,
    formacion_academica: usuarios.formacionAcademica,
    institucion_procedencia: usuarios.institucionProcedencia,
    telefono: usuarios.telefono,
    correo_verificado: usuarios.correoVerificado,
    codigo_verificacion_hash: usuarios.codigoVerificacionHash,
    codigo_verificacion_expira: usuarios.codigoVerificacionExpira,
    codigo_verificacion_intentos: usuarios.codigoVerificacionIntentos,
    codigo_verificacion_ultimo_envio: usuarios.codigoVerificacionUltimoEnvio,
    codigo_recuperacion_hash: usuarios.codigoRecuperacionHash,
    codigo_recuperacion_expira: usuarios.codigoRecuperacionExpira,
    codigo_recuperacion_intentos: usuarios.codigoRecuperacionIntentos,
    codigo_recuperacion_ultimo_envio: usuarios.codigoRecuperacionUltimoEnvio,
    rol_id: usuarios.rolId,
    rol_nombre: roles.nombre
  }).from(usuarios).leftJoin(roles, eq(usuarios.rolId, roles.id)).orderBy(usuarios.apellidos, usuarios.nombre);
}
async function listarUsuariosAdminDrizzle() {
  return db.select({
    id: usuarios.id,
    nombre: usuarios.nombre,
    apellidos: usuarios.apellidos,
    correo: usuarios.correo,
    curp: usuarios.curp,
    identificacion: usuarios.identificacion,
    rol_id: usuarios.rolId,
    rol_nombre: roles.nombre
  }).from(usuarios).leftJoin(roles, eq(usuarios.rolId, roles.id)).orderBy(usuarios.apellidos, usuarios.nombre);
}
async function existeUsuarioPorCurpDrizzle(curp2) {
  const rows = await db.select({ id: usuarios.id }).from(usuarios).where(eq(usuarios.curp, curp2)).limit(1);
  return rows.length > 0;
}
async function obtenerNombreUsuarioPorCurpDrizzle(curp2) {
  const rows = await db.select({
    nombre: usuarios.nombre,
    apellidos: usuarios.apellidos
  }).from(usuarios).where(eq(usuarios.curp, curp2)).limit(1);
  if (!rows.length || !rows[0]) return null;
  return {
    nombre: rows[0].nombre ?? "",
    apellidos: rows[0].apellidos ?? ""
  };
}
async function listarProyectosPorUsuarioDrizzle(usuarioId) {
  const rows = await db.select({
    id: proyectos.id,
    estado: proyectos.estado,
    paso_actual: proyectos.pasoActual,
    fecha_creacion: proyectos.fechaCreacion,
    fecha_actualizacion: proyectos.fechaActualizacion
  }).from(proyectos).where(eq(proyectos.usuarioId, usuarioId)).orderBy(desc(proyectos.fechaActualizacion));
  return rows.map((row) => ({
    id: row.id,
    estado: row.estado ?? "borrador",
    paso_actual: row.paso_actual ?? 0,
    fecha_creacion: row.fecha_creacion ?? /* @__PURE__ */ new Date(0),
    fecha_actualizacion: row.fecha_actualizacion ?? /* @__PURE__ */ new Date(0)
  }));
}
async function obtenerProyectoDetalleDrizzle(proyectoId) {
  const rowsProyecto = await db.select({
    id: proyectos.id,
    usuario_id: proyectos.usuarioId,
    estado: proyectos.estado,
    paso_actual: proyectos.pasoActual,
    fecha_creacion: proyectos.fechaCreacion,
    fecha_actualizacion: proyectos.fechaActualizacion
  }).from(proyectos).where(eq(proyectos.id, proyectoId)).limit(1);
  if (rowsProyecto.length < 1) return null;
  const rowProyecto = rowsProyecto[0];
  const [rowsDatos, rowsArchivos] = await Promise.all([
    db.select({
      paso: datosProyecto.paso,
      datos: datosProyecto.datos
    }).from(datosProyecto).where(eq(datosProyecto.proyectoId, proyectoId)).orderBy(asc(datosProyecto.paso)),
    db.select({
      id: archivosProyecto.id,
      tipo_archivo: archivosProyecto.tipoArchivo,
      ruta_servidor: archivosProyecto.rutaServidor,
      nombre_original: archivosProyecto.nombreOriginal,
      tamano: archivosProyecto.tamano,
      content_type: archivosProyecto.contentType,
      fecha_subida: archivosProyecto.fechaSubida
    }).from(archivosProyecto).where(eq(archivosProyecto.proyectoId, proyectoId))
  ]);
  const datosPorPaso = {};
  for (const row of rowsDatos) {
    if (row.paso == null) continue;
    datosPorPaso[row.paso] = row.datos ?? null;
  }
  const archivos = rowsArchivos.map((row) => ({
    id: row.id,
    tipo_archivo: row.tipo_archivo,
    ruta_servidor: row.ruta_servidor,
    nombre_original: row.nombre_original,
    tamano: row.tamano,
    content_type: row.content_type,
    fecha_subida: row.fecha_subida
  }));
  return {
    proyecto: {
      id: rowProyecto.id,
      usuario_id: rowProyecto.usuario_id ?? 0,
      estado: rowProyecto.estado ?? "borrador",
      paso_actual: rowProyecto.paso_actual ?? 0,
      fecha_creacion: rowProyecto.fecha_creacion ?? /* @__PURE__ */ new Date(0),
      fecha_actualizacion: rowProyecto.fecha_actualizacion ?? /* @__PURE__ */ new Date(0)
    },
    datosPorPaso,
    archivos: archivos.map((row) => ({
      id: row.id,
      tipo_archivo: row.tipo_archivo ?? "",
      ruta_servidor: row.ruta_servidor ?? "",
      nombre_original: row.nombre_original ?? "",
      tamano: row.tamano ?? 0,
      content_type: row.content_type ?? "application/pdf",
      fecha_subida: row.fecha_subida ?? /* @__PURE__ */ new Date(0)
    }))
  };
}
async function crearProyectoDrizzle(usuarioId) {
  const result = await db.insert(proyectos).values({
    usuarioId,
    estado: "borrador",
    pasoActual: 0
  }).$returningId();
  return result[0].id;
}
async function obtenerProyectoOwnerDrizzle(proyectoId) {
  const rows = await db.select({
    id: proyectos.id,
    usuario_id: proyectos.usuarioId,
    estado: proyectos.estado
  }).from(proyectos).where(eq(proyectos.id, proyectoId)).limit(1);
  if (rows.length < 1 || rows[0].usuario_id == null) return null;
  return {
    id: rows[0].id,
    usuario_id: rows[0].usuario_id,
    estado: rows[0].estado ?? "borrador"
  };
}
async function upsertDatosPasoProyectoDrizzle(proyectoId, paso, datos) {
  await db.insert(datosProyecto).values({
    proyectoId,
    paso,
    datos: datos ?? {}
  }).onDuplicateKeyUpdate({
    set: {
      datos: sql`VALUES(datos)`
    }
  });
}
async function actualizarProyectoCamposDrizzle(proyectoId, values) {
  const nextValues = {
    fechaActualizacion: sql`CURRENT_TIMESTAMP`
  };
  if (values.estado != null) nextValues.estado = values.estado;
  if (values.pasoActual != null) nextValues.pasoActual = values.pasoActual;
  await db.update(proyectos).set(nextValues).where(eq(proyectos.id, proyectoId));
}
async function obtenerArchivoProyectoPorTipoDrizzle(proyectoId, tipoArchivo) {
  const rows = await db.select({
    id: archivosProyecto.id,
    ruta_servidor: archivosProyecto.rutaServidor,
    nombre_original: archivosProyecto.nombreOriginal
  }).from(archivosProyecto).where(and(eq(archivosProyecto.proyectoId, proyectoId), eq(archivosProyecto.tipoArchivo, tipoArchivo))).limit(1);
  if (rows.length < 1 || rows[0].ruta_servidor == null || rows[0].nombre_original == null) return null;
  return {
    id: rows[0].id,
    ruta_servidor: rows[0].ruta_servidor,
    nombre_original: rows[0].nombre_original
  };
}
async function guardarArchivoProyectoDrizzle(input) {
  await db.insert(archivosProyecto).values({
    proyectoId: input.proyectoId,
    tipoArchivo: input.tipoArchivo,
    rutaServidor: input.rutaServidor,
    nombreOriginal: input.nombreOriginal,
    tamano: input.tamano,
    contentType: input.contentType
  }).onDuplicateKeyUpdate({
    set: {
      rutaServidor: input.rutaServidor,
      nombreOriginal: input.nombreOriginal,
      tamano: input.tamano,
      contentType: input.contentType,
      fechaSubida: sql`CURRENT_TIMESTAMP`
    }
  });
}
async function obtenerUsuarioRolPorIdDrizzle(usuarioId) {
  const rows = await db.select({
    id: usuarios.id,
    nombre: usuarios.nombre,
    apellidos: usuarios.apellidos,
    rol_id: usuarios.rolId,
    rol_nombre: roles.nombre
  }).from(usuarios).leftJoin(roles, eq(usuarios.rolId, roles.id)).where(eq(usuarios.id, usuarioId)).limit(1);
  if (rows.length < 1) return null;
  return {
    id: rows[0].id,
    nombre: rows[0].nombre,
    apellidos: rows[0].apellidos,
    rol_id: rows[0].rol_id,
    rol_nombre: rows[0].rol_nombre
  };
}
async function listarProyectosEnviadosRevisionDrizzle() {
  const rows = await db.select({
    id: proyectos.id,
    usuario_id: proyectos.usuarioId,
    proponente_nombre: sql`TRIM(CONCAT(COALESCE(${usuarios.nombre}, ''), ' ', COALESCE(${usuarios.apellidos}, '')))`,
    estado: proyectos.estado,
    paso_actual: proyectos.pasoActual,
    fecha_actualizacion: proyectos.fechaActualizacion
  }).from(proyectos).leftJoin(usuarios, eq(proyectos.usuarioId, usuarios.id)).where(or(eq(proyectos.estado, "enviado"), eq(proyectos.estado, "aprobado"))).orderBy(desc(proyectos.fechaActualizacion));
  return rows.map((row) => ({
    id: row.id,
    usuario_id: row.usuario_id ?? 0,
    proponente_nombre: row.proponente_nombre || "Sin nombre",
    estado: row.estado ?? "borrador",
    paso_actual: row.paso_actual ?? 0,
    fecha_actualizacion: row.fecha_actualizacion ?? /* @__PURE__ */ new Date(0)
  }));
}
async function listarAprobacionesRevisionDrizzle(proyectoId) {
  const rows = await db.select({
    id: revisionAprobaciones.id,
    proyecto_id: revisionAprobaciones.proyectoId,
    comite: revisionAprobaciones.comite,
    aprobado: revisionAprobaciones.aprobado,
    usuario_id: revisionAprobaciones.usuarioId,
    autor_nombre: sql`TRIM(CONCAT(COALESCE(${usuarios.nombre}, ''), ' ', COALESCE(${usuarios.apellidos}, '')))`,
    fecha_aprobacion: revisionAprobaciones.fechaAprobacion
  }).from(revisionAprobaciones).leftJoin(usuarios, eq(revisionAprobaciones.usuarioId, usuarios.id)).where(eq(revisionAprobaciones.proyectoId, proyectoId)).orderBy(asc(revisionAprobaciones.comite));
  return rows.map((row) => ({
    id: row.id,
    proyecto_id: row.proyecto_id ?? 0,
    comite: row.comite ?? 0,
    aprobado: row.aprobado ?? 0,
    usuario_id: row.usuario_id ?? 0,
    autor_nombre: row.autor_nombre || "Comité",
    fecha_aprobacion: row.fecha_aprobacion ?? /* @__PURE__ */ new Date(0)
  }));
}
async function upsertAprobacionRevisionDrizzle(input) {
  await db.insert(revisionAprobaciones).values({
    proyectoId: input.proyectoId,
    comite: input.comite,
    aprobado: input.aprobado,
    usuarioId: input.usuarioId,
    fechaAprobacion: sql`CURRENT_TIMESTAMP`
  }).onDuplicateKeyUpdate({
    set: {
      aprobado: sql`VALUES(aprobado)`,
      usuarioId: sql`VALUES(usuario_id)`,
      fechaAprobacion: sql`CURRENT_TIMESTAMP`
    }
  });
}
async function listarComentariosRevisionDrizzle(proyectoId, comite) {
  const rows = await db.select({
    id: revisionComentarios.id,
    proyecto_id: revisionComentarios.proyectoId,
    comite: revisionComentarios.comite,
    paso: revisionComentarios.paso,
    comentario: revisionComentarios.comentario,
    usuario_id: revisionComentarios.usuarioId,
    autor_nombre: sql`TRIM(CONCAT(COALESCE(${usuarios.nombre}, ''), ' ', COALESCE(${usuarios.apellidos}, '')))`,
    fecha_comentario: revisionComentarios.fechaComentario
  }).from(revisionComentarios).leftJoin(usuarios, eq(revisionComentarios.usuarioId, usuarios.id)).where(and(eq(revisionComentarios.proyectoId, proyectoId), eq(revisionComentarios.comite, comite))).orderBy(asc(revisionComentarios.paso), asc(revisionComentarios.fechaComentario));
  return rows.map((row) => ({
    id: row.id,
    proyecto_id: row.proyecto_id ?? 0,
    comite: row.comite ?? 0,
    paso: row.paso ?? 0,
    comentario: row.comentario ?? "",
    usuario_id: row.usuario_id ?? 0,
    autor_nombre: row.autor_nombre || "Comité",
    fecha_comentario: row.fecha_comentario ?? /* @__PURE__ */ new Date(0)
  }));
}
async function listarComentariosRevisionProyectoDrizzle(proyectoId) {
  const rows = await db.select({
    id: revisionComentarios.id,
    proyecto_id: revisionComentarios.proyectoId,
    comite: revisionComentarios.comite,
    paso: revisionComentarios.paso,
    comentario: revisionComentarios.comentario,
    usuario_id: revisionComentarios.usuarioId,
    autor_nombre: sql`TRIM(CONCAT(COALESCE(${usuarios.nombre}, ''), ' ', COALESCE(${usuarios.apellidos}, '')))`,
    fecha_comentario: revisionComentarios.fechaComentario
  }).from(revisionComentarios).leftJoin(usuarios, eq(revisionComentarios.usuarioId, usuarios.id)).where(eq(revisionComentarios.proyectoId, proyectoId)).orderBy(asc(revisionComentarios.paso), asc(revisionComentarios.comite), asc(revisionComentarios.fechaComentario));
  return rows.map((row) => ({
    id: row.id,
    proyecto_id: row.proyecto_id ?? 0,
    comite: row.comite ?? 0,
    paso: row.paso ?? 0,
    comentario: row.comentario ?? "",
    usuario_id: row.usuario_id ?? 0,
    autor_nombre: row.autor_nombre || "Comité",
    fecha_comentario: row.fecha_comentario ?? /* @__PURE__ */ new Date(0)
  }));
}
async function crearComentarioRevisionDrizzle(input) {
  const result = await db.insert(revisionComentarios).values({
    proyectoId: input.proyectoId,
    comite: input.comite,
    paso: input.paso,
    comentario: input.comentario,
    usuarioId: input.usuarioId,
    fechaComentario: sql`CURRENT_TIMESTAMP`
  }).$returningId();
  return result[0].id;
}
async function obtenerUsuarioLoginDrizzle(usuarioInput, esCurp) {
  const rows = await db.select({
    id: usuarios.id,
    nacionalidad: usuarios.nacionalidad,
    curp: usuarios.curp,
    identificacion: usuarios.identificacion,
    contrasena: usuarios.contrasena,
    nombre: usuarios.nombre,
    apellidos: usuarios.apellidos,
    correo: usuarios.correo,
    telefono: usuarios.telefono,
    formacion_academica: usuarios.formacionAcademica,
    correo_verificado: usuarios.correoVerificado,
    rol_id: usuarios.rolId,
    rol_nombre: roles.nombre
  }).from(usuarios).leftJoin(roles, eq(usuarios.rolId, roles.id)).where(esCurp ? eq(usuarios.curp, usuarioInput) : eq(usuarios.identificacion, usuarioInput)).limit(1);
  if (rows.length < 1 || !rows[0] || rows[0].contrasena == null || rows[0].rol_id == null) return null;
  const row = rows[0];
  return {
    id: row.id,
    nacionalidad: row.nacionalidad,
    curp: row.curp,
    identificacion: row.identificacion,
    contrasena: row.contrasena ?? "",
    nombre: row.nombre,
    apellidos: row.apellidos,
    correo: row.correo,
    telefono: row.telefono,
    formacion_academica: row.formacion_academica,
    correo_verificado: row.correo_verificado,
    rol_id: row.rol_id ?? 0,
    rol_nombre: row.rol_nombre
  };
}
async function existeUsuarioPorIdentificacionDrizzle(identificacion) {
  const rows = await db.select({ id: usuarios.id }).from(usuarios).where(eq(usuarios.identificacion, identificacion)).limit(1);
  return rows.length > 0;
}
async function crearUsuarioRegistroDrizzle(input) {
  const result = await db.insert(usuarios).values({
    nacionalidad: input.nacionalidad,
    curp: input.curp,
    identificacion: input.identificacion,
    nombre: input.nombre,
    apellidos: input.apellidos,
    edad: input.edad,
    genero: input.genero,
    correo: input.correo,
    lugarResidencia: input.lugarResidencia,
    formacionAcademica: input.formacionAcademica,
    institucionProcedencia: input.institucionProcedencia,
    telefono: input.telefono,
    contrasena: input.contrasenaHash,
    correoVerificado: 0,
    codigoVerificacionHash: input.codigoVerificacionHash,
    codigoVerificacionExpira: input.codigoVerificacionExpira,
    codigoVerificacionIntentos: 0,
    codigoVerificacionUltimoEnvio: sql`NOW()`
  }).$returningId();
  return result[0].id;
}
async function eliminarUsuarioPorIdDrizzle(id) {
  await db.delete(usuarios).where(eq(usuarios.id, id)).limit(1);
}
async function listarRolesDrizzle() {
  const rows = await db.select({
    id: roles.id,
    nombre: roles.nombre
  }).from(roles).orderBy(asc(roles.id));
  return rows.map((row) => ({
    id: row.id,
    nombre: row.nombre ?? ""
  }));
}
async function existeRolDrizzle(id) {
  const rows = await db.select({ id: roles.id }).from(roles).where(eq(roles.id, id)).limit(1);
  return rows.length > 0;
}
async function actualizarRolUsuarioDrizzle(usuarioId, rolId) {
  await db.update(usuarios).set({ rolId }).where(eq(usuarios.id, usuarioId));
}
async function obtenerUsuarioVerificacionPorIdentificadorCorreoDrizzle(input) {
  const rows = await db.select({
    id: usuarios.id,
    nacionalidad: usuarios.nacionalidad,
    curp: usuarios.curp,
    identificacion: usuarios.identificacion,
    nombre: usuarios.nombre,
    apellidos: usuarios.apellidos,
    correo: usuarios.correo,
    correo_verificado: usuarios.correoVerificado,
    codigo_verificacion_hash: usuarios.codigoVerificacionHash,
    codigo_verificacion_expira: usuarios.codigoVerificacionExpira,
    codigo_verificacion_intentos: usuarios.codigoVerificacionIntentos,
    codigo_verificacion_ultimo_envio: usuarios.codigoVerificacionUltimoEnvio
  }).from(usuarios).where(
    and(
      input.usaCurp ? eq(usuarios.curp, input.identificador) : eq(usuarios.identificacion, input.identificador),
      eq(usuarios.correo, input.correo)
    )
  ).limit(1);
  if (rows.length < 1) return null;
  return rows[0];
}
async function incrementarIntentosCodigoVerificacionDrizzle(id) {
  await db.update(usuarios).set({
    codigoVerificacionIntentos: sql`${usuarios.codigoVerificacionIntentos} + 1`
  }).where(eq(usuarios.id, id));
}
async function confirmarCorreoVerificadoDrizzle(id) {
  await db.update(usuarios).set({
    correoVerificado: 1,
    codigoVerificacionHash: null,
    codigoVerificacionExpira: null,
    codigoVerificacionIntentos: 0,
    codigoVerificacionUltimoEnvio: null
  }).where(eq(usuarios.id, id));
}
async function actualizarCodigoVerificacionUsuarioDrizzle(input) {
  await db.update(usuarios).set({
    codigoVerificacionHash: input.codigoHash,
    codigoVerificacionExpira: input.codigoExpira,
    codigoVerificacionIntentos: 0,
    codigoVerificacionUltimoEnvio: sql`NOW()`
  }).where(eq(usuarios.id, input.id));
}
async function obtenerContactoUsuarioPorCurpDrizzle(curp2) {
  const rows = await db.select({
    telefono: usuarios.telefono,
    correo: usuarios.correo
  }).from(usuarios).where(eq(usuarios.curp, curp2)).limit(1);
  if (rows.length < 1) return null;
  return rows[0];
}
async function obtenerUsuarioRecuperacionPorCurpDrizzle(curp2) {
  const rows = await db.select({
    id: usuarios.id,
    nombre: usuarios.nombre,
    apellidos: usuarios.apellidos,
    correo: usuarios.correo,
    codigo_recuperacion_hash: usuarios.codigoRecuperacionHash,
    codigo_recuperacion_expira: usuarios.codigoRecuperacionExpira,
    codigo_recuperacion_intentos: usuarios.codigoRecuperacionIntentos,
    codigo_recuperacion_ultimo_envio: usuarios.codigoRecuperacionUltimoEnvio
  }).from(usuarios).where(eq(usuarios.curp, curp2)).limit(1);
  if (rows.length < 1) return null;
  return rows[0];
}
async function actualizarCodigoRecuperacionUsuarioDrizzle(input) {
  await db.update(usuarios).set({
    codigoRecuperacionHash: input.codigoHash,
    codigoRecuperacionExpira: input.codigoExpira,
    codigoRecuperacionIntentos: 0,
    codigoRecuperacionUltimoEnvio: sql`NOW()`
  }).where(eq(usuarios.id, input.id));
}
async function incrementarIntentosRecuperacionDrizzle(id) {
  await db.update(usuarios).set({
    codigoRecuperacionIntentos: sql`${usuarios.codigoRecuperacionIntentos} + 1`
  }).where(eq(usuarios.id, id));
}
async function actualizarContrasenaRecuperacionPorCurpDrizzle(curp2, contrasenaHash) {
  await db.update(usuarios).set({
    contrasena: contrasenaHash,
    codigoRecuperacionHash: null,
    codigoRecuperacionExpira: null,
    codigoRecuperacionIntentos: 0,
    codigoRecuperacionUltimoEnvio: null
  }).where(eq(usuarios.curp, curp2));
}
const COOKIE_NAME = "rpi_sesion";
const SECRET = process.env.COOKIE_SECRET || "rpi-dev-secret";
const MAX_AGE_DAYS = 1;
function sign(payload) {
  return createHmac("sha256", SECRET).update(payload).digest("base64url");
}
function base64urlEncode(obj) {
  return Buffer.from(JSON.stringify(obj), "utf8").toString("base64url");
}
function base64urlDecode(str) {
  try {
    const json2 = Buffer.from(str, "base64url").toString("utf8");
    const parsed = JSON.parse(json2);
    if (typeof parsed?.id !== "number") return null;
    return { id: parsed.id };
  } catch {
    return null;
  }
}
function setSesionCookie(event, usuarioId) {
  const payload = base64urlEncode({ id: usuarioId });
  const signature = sign(payload);
  const value = `${payload}.${signature}`;
  const maxAge = MAX_AGE_DAYS * 24 * 60 * 60;
  setHeader(event, "Set-Cookie", `${COOKIE_NAME}=${value}; Path=/; Max-Age=${maxAge}; HttpOnly; SameSite=Lax`);
}
function getUsuarioIdDesdeSesion(event) {
  const cookies = getHeader(event, "cookie") || "";
  const match = cookies.match(new RegExp(`(?:^|;)\\s*${COOKIE_NAME}=([^;]+)`));
  if (!match) return null;
  const parts = match[1].trim().split(".");
  if (parts.length !== 2) return null;
  const [payload, sig] = parts;
  if (sign(payload) !== sig) return null;
  return base64urlDecode(payload)?.id ?? null;
}
const _FDPqez = defineEventHandler(async (event) => {
  const body = await readBody(event).catch(() => null);
  if (!body || typeof body !== "object") {
    return { success: false, error: "CURP o identificación y contraseña requeridos" };
  }
  const payload = body;
  const usuarioInput = String(payload.curp || "").trim().toUpperCase();
  const password = payload.password;
  if (!usuarioInput) {
    return { success: false, error: "CURP o identificación requeridos" };
  }
  if (!password || typeof password !== "string") {
    return { success: false, error: "Contraseña requerida" };
  }
  try {
    const esCurp = usuarioInput.length === 18 && /^[A-Z0-9]{18}$/.test(usuarioInput);
    const usuario = await obtenerUsuarioLoginDrizzle(usuarioInput, esCurp);
    if (!usuario) {
      return { success: false, error: "Credenciales incorrectas" };
    }
    const coincide = await bcrypt.compare(password, usuario.contrasena);
    if (!coincide) {
      return { success: false, error: "Credenciales incorrectas" };
    }
    if (usuario.correo_verificado === 0) {
      return {
        success: false,
        error: "Debe verificar su correo electrónico antes de iniciar sesión",
        requiereVerificacionCorreo: true,
        verificacion: {
          nacionalidad: usuario.nacionalidad ?? void 0,
          curp: usuario.curp ?? void 0,
          identificacion: usuario.identificacion ?? void 0,
          correo: usuario.correo ?? void 0
        }
      };
    }
    setSesionCookie(event, usuario.id);
    return {
      success: true,
      usuario: {
        id: usuario.id,
        curp: usuario.curp ?? void 0,
        identificacion: usuario.identificacion ?? void 0,
        nombre: usuario.nombre ?? void 0,
        apellidos: usuario.apellidos ?? void 0,
        correo: usuario.correo ?? void 0,
        telefono: usuario.telefono ?? void 0,
        formacion_academica: usuario.formacion_academica ?? void 0,
        rol_id: usuario.rol_id,
        rol_nombre: usuario.rol_nombre ?? void 0
      }
    };
  } catch (err) {
    return {
      success: false,
      error: "Error al verificar credenciales"
    };
  }
});
const login_post = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _FDPqez
});
const CODE_LENGTH = 6;
const CODE_EXPIRATION_MINUTES = 10;
function getPepper() {
  return String(process.env.EMAIL_VERIFICATION_PEPPER || "");
}
function generarCodigoVerificacion() {
  return randomInt(0, 1e6).toString().padStart(CODE_LENGTH, "0");
}
function generarHashCodigoVerificacion(codigo, correo) {
  return createHash("sha256").update(`${codigo.trim()}:${correo.trim().toLowerCase()}:${getPepper()}`).digest("hex");
}
function codigoVerificacionExpiraEn() {
  const ahora = /* @__PURE__ */ new Date();
  ahora.setMinutes(ahora.getMinutes() + CODE_EXPIRATION_MINUTES);
  return ahora;
}
function validarCodigoVerificacion(codigo) {
  return /^\d{6}$/.test(codigo.trim());
}
function compararHashCodigoVerificacion(codigo, correo, hashEsperado) {
  const hashCalculado = generarHashCodigoVerificacion(codigo, correo);
  const esperado = Buffer.from(hashEsperado);
  const calculado = Buffer.from(hashCalculado);
  if (esperado.length !== calculado.length) {
    return false;
  }
  return timingSafeEqual(esperado, calculado);
}
function segundosParaReenvioPermitido(ultimoEnvio) {
  if (!ultimoEnvio) {
    return 0;
  }
  const fechaUltimoEnvio = new Date(ultimoEnvio);
  const proximoEnvio = fechaUltimoEnvio.getTime() + 60 * 1e3;
  const restanteMs = proximoEnvio - Date.now();
  if (restanteMs <= 0) {
    return 0;
  }
  return Math.ceil(restanteMs / 1e3);
}
let transporter = null;
function getSmtpEnv() {
  const host2 = String(process.env.SMTP_HOST || "").trim();
  const port2 = Number(process.env.SMTP_PORT || 0);
  const secureRaw = String(process.env.SMTP_SECURE || "").trim().toLowerCase();
  const user = String(process.env.SMTP_USER || "").trim();
  const pass = String(process.env.SMTP_PASS || "").trim();
  const from = String(process.env.SMTP_FROM || "").trim();
  if (!host2 || !port2 || !user || !pass || !from) {
    throw new Error("Configuración SMTP incompleta");
  }
  const secure = secureRaw === "true" || port2 === 465;
  return { host: host2, port: port2, secure, user, pass, from };
}
function getTransporter() {
  if (transporter) {
    return transporter;
  }
  const smtp = getSmtpEnv();
  transporter = nodemailer.createTransport({
    host: smtp.host,
    port: smtp.port,
    secure: smtp.secure,
    auth: {
      user: smtp.user,
      pass: smtp.pass
    }
  });
  return transporter;
}
function getBasePublicUrl() {
  const appPublicUrl = String(process.env.APP_PUBLIC_URL || "").trim();
  if (appPublicUrl) {
    return appPublicUrl.replace(/\/$/, "");
  }
  const viteProductionUrl = String(process.env.VITE_PRODUCTION_URL || "").trim();
  if (viteProductionUrl) {
    return viteProductionUrl.replace(/\/$/, "");
  }
  return "https://hospitaljuarezmexico.gob.mx/investigacionv2";
}
function getSaludo(nombreCompleto) {
  return nombreCompleto?.trim() ? `Estimado(a) ${nombreCompleto.trim()},` : "Estimado(a) usuario(a),";
}
async function enviarCodigoVerificacionRegistro(correo, codigo, nombreCompleto) {
  const smtp = getSmtpEnv();
  const tx = getTransporter();
  const logoUrl = `${getBasePublicUrl()}/LogoHJM-dark.svg`;
  const saludo = getSaludo(nombreCompleto);
  await tx.sendMail({
    from: smtp.from,
    to: correo,
    subject: "Código de verificación de registro",
    text: [
      "División de Investigación - Hospital Juárez de México",
      "",
      saludo,
      "Recibimos una solicitud de registro en el sistema de investigación.",
      `Su código de verificación es: ${codigo}`,
      "Este código expira en 10 minutos.",
      "Si usted no realizó esta solicitud, puede ignorar este mensaje."
    ].join("\n"),
    html: `
      <div style="margin:0;padding:24px;background:#f6f2f3;font-family:Arial,sans-serif;color:#2f1b20;">
        <table role="presentation" cellpadding="0" cellspacing="0" border="0" width="100%" style="max-width:640px;margin:0 auto;background:#ffffff;border:1px solid #e7d7db;border-radius:14px;overflow:hidden;">
          <tr>
            <td style="padding:20px 24px;background:linear-gradient(135deg,#6f2736,#8a3143);color:#ffffff;">
              <table role="presentation" cellpadding="0" cellspacing="0" border="0" width="100%">
                <tr>
                  <td style="width:86px;vertical-align:middle;">
                    <img src="${logoUrl}" alt="Hospital Juárez de México" style="display:block;width:72px;height:auto;" />
                  </td>
                  <td style="vertical-align:middle;">
                    <p style="margin:0;font-size:12px;opacity:.9;letter-spacing:.5px;color:#ffffff;">HOSPITAL JUÁREZ DE MÉXICO</p>
                    <p style="margin:4px 0 0;font-size:20px;font-weight:700;color:#ffffff;">División de Investigación</p>
                    <p style="margin:6px 0 0;font-size:13px;opacity:.95;color:#ffffff;">Código de verificación de registro</p>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr>
            <td style="padding:24px;">
              <p style="margin:0 0 12px;font-size:15px;">${saludo}</p>
              <p style="margin:0 0 16px;font-size:15px;line-height:1.6;">
                Recibimos una solicitud de registro en el sistema de investigación.
              </p>
              <p style="margin:0 0 8px;font-size:14px;color:#6f2736;font-weight:700;">Su código de verificación es:</p>
              <div style="display:inline-block;padding:12px 18px;border:1px solid #d8b8bf;background:#fbf4f6;border-radius:10px;">
                <span style="font-size:34px;line-height:1;font-weight:700;letter-spacing:8px;color:#6f2736;">${codigo}</span>
              </div>
              <p style="margin:16px 0 0;font-size:14px;line-height:1.6;">
                Este código expira en <strong>10 minutos</strong>.
              </p>
              <p style="margin:8px 0 0;font-size:14px;line-height:1.6;color:#5a3a41;">
                Si usted no realizó esta solicitud, puede ignorar este mensaje.
              </p>
            </td>
          </tr>
          <tr>
            <td style="padding:14px 24px;background:#f7ecef;border-top:1px solid #ead4da;">
              <p style="margin:0;font-size:12px;color:#7c5961;">
                Mensaje automático del sistema de Registro de Proyectos de Investigación.
              </p>
            </td>
          </tr>
        </table>
      </div>
    `
  });
}
async function enviarConfirmacionRegistroCompletado({
  correo,
  nacionalidad,
  curp: curp2,
  identificacion,
  nombreCompleto
}) {
  const smtp = getSmtpEnv();
  const tx = getTransporter();
  const baseUrl = getBasePublicUrl();
  const logoUrl = `${baseUrl}/LogoHJM-dark.svg`;
  const loginUrl = `${baseUrl}/login`;
  const usaCurp = nacionalidad === "mexicana";
  const accesoLabel = usaCurp ? "CURP" : "Identificación";
  const accesoValor = usaCurp ? curp2 || "N/D" : identificacion || "N/D";
  const saludo = getSaludo(nombreCompleto);
  await tx.sendMail({
    from: smtp.from,
    to: correo,
    subject: "Registro confirmado en el sistema de investigación",
    text: [
      "División de Investigación - Hospital Juárez de México",
      "",
      saludo,
      "Su registro fue confirmado correctamente.",
      "",
      "Instrucciones de acceso:",
      `- Usuario: ${accesoLabel} (${accesoValor})`,
      "- Contraseña: la que definió durante su registro",
      "",
      `URL de acceso: ${loginUrl}`,
      "",
      "Puede iniciar sesión en el sistema."
    ].join("\n"),
    html: `
      <div style="margin:0;padding:24px;background:#f6f2f3;font-family:Arial,sans-serif;color:#2f1b20;">
        <table role="presentation" cellpadding="0" cellspacing="0" border="0" width="100%" style="max-width:640px;margin:0 auto;background:#ffffff;border:1px solid #e7d7db;border-radius:14px;overflow:hidden;">
          <tr>
            <td style="padding:20px 24px;background:linear-gradient(135deg,#6f2736,#8a3143);color:#ffffff;">
              <table role="presentation" cellpadding="0" cellspacing="0" border="0" width="100%">
                <tr>
                  <td style="width:86px;vertical-align:middle;">
                    <img src="${logoUrl}" alt="Hospital Juárez de México" style="display:block;width:72px;height:auto;" />
                  </td>
                  <td style="vertical-align:middle;">
                    <p style="margin:0;font-size:12px;opacity:.9;letter-spacing:.5px;color:#ffffff;">HOSPITAL JUÁREZ DE MÉXICO</p>
                    <p style="margin:4px 0 0;font-size:20px;font-weight:700;color:#ffffff;">División de Investigación</p>
                    <p style="margin:6px 0 0;font-size:13px;opacity:.95;color:#ffffff;">Confirmación de registro</p>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr>
            <td style="padding:24px;">
              <p style="margin:0 0 12px;font-size:15px;">${saludo}</p>
              <p style="margin:0 0 16px;font-size:15px;line-height:1.6;">
                Su registro fue confirmado correctamente en el sistema de investigación.
              </p>
              <p style="margin:0 0 10px;font-size:14px;color:#6f2736;font-weight:700;">Instrucciones para ingresar:</p>
              <ul style="margin:0 0 14px 18px;padding:0;font-size:14px;line-height:1.7;color:#2f1b20;">
                <li>Usuario: <strong>${accesoLabel}</strong> (${accesoValor})</li>
                <li>Contraseña: la que definió durante el registro</li>
              </ul>
              <p style="margin:0 0 14px;font-size:14px;line-height:1.6;color:#2f1b20;">
                URL de acceso:
                <a href="${loginUrl}" style="color:#6f2736;text-decoration:underline;">${loginUrl}</a>
              </p>
              <p style="margin:0;font-size:14px;line-height:1.6;color:#5a3a41;">
                Si usted no reconoce esta actividad, comuníquese con la División de Investigación.
              </p>
            </td>
          </tr>
          <tr>
            <td style="padding:14px 24px;background:#f7ecef;border-top:1px solid #ead4da;">
              <p style="margin:0;font-size:12px;color:#7c5961;">
                Mensaje automático del sistema de Registro de Proyectos de Investigación.
              </p>
            </td>
          </tr>
        </table>
      </div>
    `
  });
}
async function enviarCodigoRecuperacionContrasena(correo, codigo, nombreCompleto) {
  const smtp = getSmtpEnv();
  const tx = getTransporter();
  const logoUrl = `${getBasePublicUrl()}/LogoHJM-dark.svg`;
  const saludo = getSaludo(nombreCompleto);
  await tx.sendMail({
    from: smtp.from,
    to: correo,
    subject: "Código para recuperación de contraseña",
    text: [
      "División de Investigación - Hospital Juárez de México",
      "",
      saludo,
      "Recibimos una solicitud para cambiar su contraseña.",
      `Su código de recuperación es: ${codigo}`,
      "Este código expira en 10 minutos.",
      "Si usted no realizó esta solicitud, puede ignorar este mensaje."
    ].join("\n"),
    html: `
      <div style="margin:0;padding:24px;background:#f6f2f3;font-family:Arial,sans-serif;color:#2f1b20;">
        <table role="presentation" cellpadding="0" cellspacing="0" border="0" width="100%" style="max-width:640px;margin:0 auto;background:#ffffff;border:1px solid #e7d7db;border-radius:14px;overflow:hidden;">
          <tr>
            <td style="padding:20px 24px;background:linear-gradient(135deg,#6f2736,#8a3143);color:#ffffff;">
              <table role="presentation" cellpadding="0" cellspacing="0" border="0" width="100%">
                <tr>
                  <td style="width:86px;vertical-align:middle;">
                    <img src="${logoUrl}" alt="Hospital Juárez de México" style="display:block;width:72px;height:auto;" />
                  </td>
                  <td style="vertical-align:middle;">
                    <p style="margin:0;font-size:12px;opacity:.9;letter-spacing:.5px;color:#ffffff;">HOSPITAL JUÁREZ DE MÉXICO</p>
                    <p style="margin:4px 0 0;font-size:20px;font-weight:700;color:#ffffff;">División de Investigación</p>
                    <p style="margin:6px 0 0;font-size:13px;opacity:.95;color:#ffffff;">Código para recuperación de contraseña</p>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr>
            <td style="padding:24px;">
              <p style="margin:0 0 12px;font-size:15px;">${saludo}</p>
              <p style="margin:0 0 16px;font-size:15px;line-height:1.6;">
                Recibimos una solicitud para cambiar su contraseña en el sistema de investigación.
              </p>
              <p style="margin:0 0 8px;font-size:14px;color:#6f2736;font-weight:700;">Su código de recuperación es:</p>
              <div style="display:inline-block;padding:12px 18px;border:1px solid #d8b8bf;background:#fbf4f6;border-radius:10px;">
                <span style="font-size:34px;line-height:1;font-weight:700;letter-spacing:8px;color:#6f2736;">${codigo}</span>
              </div>
              <p style="margin:16px 0 0;font-size:14px;line-height:1.6;">
                Este código expira en <strong>10 minutos</strong>.
              </p>
              <p style="margin:8px 0 0;font-size:14px;line-height:1.6;color:#5a3a41;">
                Si usted no realizó esta solicitud, puede ignorar este mensaje.
              </p>
            </td>
          </tr>
          <tr>
            <td style="padding:14px 24px;background:#f7ecef;border-top:1px solid #ead4da;">
              <p style="margin:0;font-size:12px;color:#7c5961;">
                Mensaje automático del sistema de Registro de Proyectos de Investigación.
              </p>
            </td>
          </tr>
        </table>
      </div>
    `
  });
}
async function enviarConfirmacionCambioContrasena(correo, nombreCompleto) {
  const smtp = getSmtpEnv();
  const tx = getTransporter();
  const baseUrl = getBasePublicUrl();
  const logoUrl = `${baseUrl}/LogoHJM-dark.svg`;
  const loginUrl = `${baseUrl}/login`;
  const saludo = getSaludo(nombreCompleto);
  await tx.sendMail({
    from: smtp.from,
    to: correo,
    subject: "Confirmación de cambio de contraseña",
    text: [
      "División de Investigación - Hospital Juárez de México",
      "",
      saludo,
      "Su contraseña fue actualizada correctamente.",
      "",
      `URL de acceso: ${loginUrl}`,
      "",
      "Si usted no realizó este cambio, comuníquese de inmediato con la División de Investigación."
    ].join("\n"),
    html: `
      <div style="margin:0;padding:24px;background:#f6f2f3;font-family:Arial,sans-serif;color:#2f1b20;">
        <table role="presentation" cellpadding="0" cellspacing="0" border="0" width="100%" style="max-width:640px;margin:0 auto;background:#ffffff;border:1px solid #e7d7db;border-radius:14px;overflow:hidden;">
          <tr>
            <td style="padding:20px 24px;background:linear-gradient(135deg,#6f2736,#8a3143);color:#ffffff;">
              <table role="presentation" cellpadding="0" cellspacing="0" border="0" width="100%">
                <tr>
                  <td style="width:86px;vertical-align:middle;">
                    <img src="${logoUrl}" alt="Hospital Juárez de México" style="display:block;width:72px;height:auto;" />
                  </td>
                  <td style="vertical-align:middle;">
                    <p style="margin:0;font-size:12px;opacity:.9;letter-spacing:.5px;color:#ffffff;">HOSPITAL JUÁREZ DE MÉXICO</p>
                    <p style="margin:4px 0 0;font-size:20px;font-weight:700;color:#ffffff;">División de Investigación</p>
                    <p style="margin:6px 0 0;font-size:13px;opacity:.95;color:#ffffff;">Confirmación de cambio de contraseña</p>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr>
            <td style="padding:24px;">
              <p style="margin:0 0 12px;font-size:15px;">${saludo}</p>
              <p style="margin:0 0 16px;font-size:15px;line-height:1.6;">
                Su contraseña fue actualizada correctamente.
              </p>
              <p style="margin:0 0 14px;font-size:14px;line-height:1.6;color:#2f1b20;">
                URL de acceso:
                <a href="${loginUrl}" style="color:#6f2736;text-decoration:underline;">${loginUrl}</a>
              </p>
              <p style="margin:0;font-size:14px;line-height:1.6;color:#5a3a41;">
                Si usted no realizó este cambio, comuníquese de inmediato con la División de Investigación.
              </p>
            </td>
          </tr>
          <tr>
            <td style="padding:14px 24px;background:#f7ecef;border-top:1px solid #ead4da;">
              <p style="margin:0;font-size:12px;color:#7c5961;">
                Mensaje automático del sistema de Registro de Proyectos de Investigación.
              </p>
            </td>
          </tr>
        </table>
      </div>
    `
  });
}
const _Yuh7Jb = defineEventHandler(async (event) => {
  const body = await readBody(event).catch(() => null);
  if (!body || typeof body !== "object") {
    return { success: false, error: "Datos requeridos" };
  }
  const payload = body;
  const nacionalidad = String(payload.nacionalidad || "").trim();
  const curp2 = nacionalidad === "mexicana" ? String(payload.curp || "").trim().toUpperCase() : null;
  const identificacion = nacionalidad === "extranjera" ? String(payload.identificacion || "").trim() : null;
  const nombre = String(payload.nombre || "").trim();
  const apellidos = String(payload.apellidos || "").trim();
  const edad = payload.edad ? parseInt(String(payload.edad), 10) : null;
  const genero = String(payload.genero || "").trim();
  const emailParte = String(payload.emailParte || "").trim();
  const emailDominio = String(payload.emailDominio || "").trim();
  const correo = emailParte && emailDominio ? `${emailParte}@${emailDominio}`.toLowerCase() : "";
  const lugarResidencia = String(payload.lugarResidencia || "").trim();
  const formacionAcademica = String(payload.formacionAcademica || "").trim();
  const institucionProcedencia = String(payload.institucionProcedencia || "").trim();
  const telefono = String(payload.telefono || "").trim().replace(/\D/g, "").slice(0, 10);
  const password = payload.password;
  if (!nacionalidad || nacionalidad !== "mexicana" && nacionalidad !== "extranjera") {
    return { success: false, error: "Nacionalidad no válida" };
  }
  if (nacionalidad === "mexicana" && (!curp2 || curp2.length !== 18)) {
    return { success: false, error: "CURP inválido" };
  }
  if (nacionalidad === "extranjera" && !identificacion) {
    return { success: false, error: "Identificación requerida" };
  }
  if (!nombre) {
    return { success: false, error: "Nombre requerido" };
  }
  if (!correo) {
    return { success: false, error: "Correo requerido" };
  }
  if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(correo)) {
    return { success: false, error: "Correo inválido" };
  }
  if (!password || typeof password !== "string" || password.length < 8) {
    return { success: false, error: "Contraseña debe tener al menos 8 caracteres" };
  }
  try {
    const contrasenaHash = await bcrypt.hash(password, 10);
    const codigoVerificacion = generarCodigoVerificacion();
    const codigoVerificacionHash = generarHashCodigoVerificacion(codigoVerificacion, correo);
    const codigoVerificacionExpira = codigoVerificacionExpiraEn();
    let usuarioIdCreado = 0;
    if (nacionalidad === "mexicana") {
      const yaExiste = await existeUsuarioPorCurpDrizzle(curp2);
      if (yaExiste) {
        return { success: false, error: "Ya existe un registro con ese CURP" };
      }
      usuarioIdCreado = await crearUsuarioRegistroDrizzle({
        nacionalidad,
        curp: curp2,
        identificacion: null,
        nombre,
        apellidos,
        edad,
        genero,
        correo,
        lugarResidencia,
        formacionAcademica,
        institucionProcedencia,
        telefono,
        contrasenaHash,
        codigoVerificacionHash,
        codigoVerificacionExpira
      });
    } else {
      const yaExiste = await existeUsuarioPorIdentificacionDrizzle(identificacion);
      if (yaExiste) {
        return { success: false, error: "Ya existe un registro con esa identificación" };
      }
      usuarioIdCreado = await crearUsuarioRegistroDrizzle({
        nacionalidad,
        curp: null,
        identificacion,
        nombre,
        apellidos,
        edad,
        genero,
        correo,
        lugarResidencia,
        formacionAcademica,
        institucionProcedencia,
        telefono,
        contrasenaHash,
        codigoVerificacionHash,
        codigoVerificacionExpira
      });
    }
    try {
      await enviarCodigoVerificacionRegistro(
        correo,
        codigoVerificacion,
        `${nombre} ${apellidos}`.trim()
      );
    } catch (error) {
      console.error("Error enviando código de verificación en registro:", error);
      if (usuarioIdCreado) {
        await eliminarUsuarioPorIdDrizzle(usuarioIdCreado);
      }
      return {
        success: false,
        error: "No se pudo enviar el código de verificación al correo"
      };
    }
    return {
      success: true,
      requiereVerificacionCorreo: true,
      correo,
      curp: curp2 ?? void 0,
      identificacion: identificacion ?? void 0
    };
  } catch (err) {
    return {
      success: false,
      error: "Error al guardar el registro"
    };
  }
});
const registro_post = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _Yuh7Jb
});
const _3EduuS = defineEventHandler(async (event) => {
  const { curp: curp2 } = getQuery(event);
  const curpStr = String(curp2 || "").trim().toUpperCase();
  if (curpStr.length !== 18 || !/^[A-Z0-9]{18}$/.test(curpStr)) {
    return { disponible: false, error: "CURP inválido" };
  }
  try {
    const yaRegistrado = await existeUsuarioPorCurpDrizzle(curpStr);
    return { disponible: !yaRegistrado };
  } catch {
    return { disponible: false, error: "Error al verificar" };
  }
});
const curpDisponible_get = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _3EduuS
});
const _JrCAsr = defineEventHandler(async (event) => {
  const { curp: curp2 } = getQuery(event);
  const curpStr = String(curp2 || "").trim().toUpperCase();
  if (!curpStr) {
    return { success: false, error: "CURP requerido" };
  }
  if (curpStr.length !== 18 || !/^[A-Z0-9]{18}$/.test(curpStr)) {
    return { success: false, error: "CURP inválido" };
  }
  try {
    const usuario = await obtenerNombreUsuarioPorCurpDrizzle(curpStr);
    if (!usuario) {
      return { success: false, error: "No existe un usuario registrado con ese CURP" };
    }
    return {
      success: true,
      usuario: {
        nombre: usuario.nombre,
        apellidos: usuario.apellidos
      }
    };
  } catch {
    return { success: false, error: "Error al consultar" };
  }
});
const usuarioPorCurp_get = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _JrCAsr
});
const _DgBOV4 = defineEventHandler(async (event) => {
  const body = await readBody(event).catch(() => null);
  if (!body || typeof body !== "object") {
    return { success: false, error: "Datos requeridos" };
  }
  const payload = body;
  const curp2 = String(payload.curp || "").trim().toUpperCase();
  const telefono = String(payload.telefono || "").replace(/\D/g, "").slice(0, 10);
  const correo = String(payload.correo || "").trim().toLowerCase();
  if (curp2.length !== 18 || !/^[A-Z0-9]{18}$/.test(curp2)) {
    return { success: false, error: "CURP inválido" };
  }
  if (!telefono || telefono.length !== 10) {
    return { success: false, error: "Teléfono inválido" };
  }
  if (!correo || !correo.includes("@")) {
    return { success: false, error: "Correo inválido" };
  }
  try {
    const u = await obtenerContactoUsuarioPorCurpDrizzle(curp2);
    if (!u) {
      return { success: false, error: "Usuario no encontrado" };
    }
    const telefonoRegistrado = (u.telefono ?? "").replace(/\D/g, "").slice(0, 10);
    const correoRegistrado = (u.correo ?? "").trim().toLowerCase();
    const telefonoCoincide = telefono === telefonoRegistrado;
    const correoCoincide = correo === correoRegistrado;
    if (!telefonoCoincide || !correoCoincide) {
      return { success: false, error: "El teléfono o el correo no coinciden con los registrados" };
    }
    return { success: true };
  } catch {
    return { success: false, error: "Error al verificar" };
  }
});
const verificarDatosRecuperacion_post = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _DgBOV4
});
const _zup2AC = defineEventHandler(async (event) => {
  const body = await readBody(event).catch(() => null);
  if (!body || typeof body !== "object") {
    return { success: false, error: "Datos requeridos" };
  }
  const payload = body;
  const curp2 = String(payload.curp || "").trim().toUpperCase();
  const codigo = String(payload.codigo || "").trim();
  const nuevaContrasena = payload.nuevaContrasena;
  if (curp2.length !== 18 || !/^[A-Z0-9]{18}$/.test(curp2)) {
    return { success: false, error: "CURP inválido" };
  }
  if (!validarCodigoVerificacion(codigo)) {
    return { success: false, error: "Código inválido" };
  }
  if (!nuevaContrasena || typeof nuevaContrasena !== "string" || nuevaContrasena.length < 8) {
    return { success: false, error: "La contraseña debe tener al menos 8 caracteres" };
  }
  try {
    const u = await obtenerUsuarioRecuperacionPorCurpDrizzle(curp2);
    if (!u) {
      return { success: false, error: "Usuario no encontrado" };
    }
    const correoRegistrado = String(u.correo || "").trim().toLowerCase();
    const hash = String(u.codigo_recuperacion_hash || "").trim();
    const expiraRaw = u.codigo_recuperacion_expira;
    const intentos = Number(u.codigo_recuperacion_intentos || 0);
    if (intentos >= 5) {
      return {
        success: false,
        error: "Se alcanzó el límite de intentos. Solicite un nuevo código."
      };
    }
    if (!correoRegistrado || !hash || !expiraRaw) {
      return { success: false, error: "No hay código activo. Solicite uno nuevo." };
    }
    const expiraFecha = new Date(expiraRaw);
    if (Number.isNaN(expiraFecha.getTime()) || expiraFecha.getTime() < Date.now()) {
      return { success: false, error: "El código expiró. Solicite uno nuevo." };
    }
    const coincide = compararHashCodigoVerificacion(codigo, correoRegistrado, hash);
    if (!coincide) {
      await incrementarIntentosRecuperacionDrizzle(u.id);
      return { success: false, error: "Código incorrecto" };
    }
    const contrasenaHash = await bcrypt.hash(nuevaContrasena, 10);
    await actualizarContrasenaRecuperacionPorCurpDrizzle(curp2, contrasenaHash);
    try {
      await enviarConfirmacionCambioContrasena(
        correoRegistrado,
        `${String(u.nombre || "").trim()} ${String(u.apellidos || "").trim()}`.trim()
      );
    } catch (error) {
      console.error("Error enviando confirmación de cambio de contraseña:", error);
    }
    return { success: true };
  } catch {
    return { success: false, error: "Error al actualizar la contraseña" };
  }
});
const cambiarPasswordRecuperacion_post = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _zup2AC
});
const _S88Gcv = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return { success: false, error: "No autorizado" };
  }
  try {
    const insertId = await crearProyectoDrizzle(usuarioId);
    if (!insertId) {
      return { success: false, error: "Error al crear proyecto" };
    }
    return { success: true, id: insertId };
  } catch (err) {
    return { success: false, error: "Error al crear proyecto" };
  }
});
const proyectos_post = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _S88Gcv
});
const _Ix5ZLP = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return { success: false, error: "No autorizado", proyectos: [] };
  }
  try {
    const lista = await listarProyectosPorUsuarioDrizzle(usuarioId);
    return { success: true, proyectos: lista };
  } catch (err) {
    return { success: false, error: "Error al listar proyectos", proyectos: [] };
  }
});
const proyectos_get = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _Ix5ZLP
});
const _8ToQWv = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return { success: false, error: "No autorizado" };
  }
  const id = event.context.params?.id;
  if (!id) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID requerido" };
  }
  const proyectoId = parseInt(id, 10);
  if (Number.isNaN(proyectoId) || proyectoId < 1) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID no válido" };
  }
  try {
    const detalle = await obtenerProyectoDetalleDrizzle(proyectoId);
    if (!detalle) {
      setResponseStatus(event, 404);
      return { success: false, error: "Proyecto no encontrado" };
    }
    if (detalle.proyecto.usuario_id !== usuarioId) {
      setResponseStatus(event, 403);
      return { success: false, error: "No tiene permiso para este proyecto" };
    }
    return {
      success: true,
      proyecto: {
        id: detalle.proyecto.id,
        estado: detalle.proyecto.estado,
        paso_actual: detalle.proyecto.paso_actual,
        fecha_creacion: detalle.proyecto.fecha_creacion,
        fecha_actualizacion: detalle.proyecto.fecha_actualizacion
      },
      datosPorPaso: detalle.datosPorPaso,
      archivos: detalle.archivos
    };
  } catch (err) {
    return { success: false, error: "Error al obtener proyecto" };
  }
});
const _id__get = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _8ToQWv
});
const _WnI391 = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return { success: false, error: "No autorizado" };
  }
  const id = event.context.params?.id;
  if (!id) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID requerido" };
  }
  const proyectoId = parseInt(id, 10);
  if (Number.isNaN(proyectoId) || proyectoId < 1) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID no válido" };
  }
  const proyecto = await obtenerProyectoOwnerDrizzle(proyectoId);
  if (!proyecto || proyecto.usuario_id !== usuarioId) {
    setResponseStatus(event, 404);
    return { success: false, error: "Proyecto no encontrado" };
  }
  if (proyecto.estado === "enviado" || proyecto.estado === "aprobado") {
    setResponseStatus(event, 403);
    return { success: false, error: "El proyecto ya fue enviado y no puede editarse" };
  }
  const body = await readBody(event).catch(() => null);
  if (!body || typeof body !== "object") {
    setResponseStatus(event, 400);
    return { success: false, error: "Datos requeridos" };
  }
  const payload = body;
  const paso = payload.paso != null ? parseInt(String(payload.paso), 10) : null;
  const datos = payload.datos;
  const estado = typeof payload.estado === "string" ? payload.estado.trim() : null;
  const pasoActual = payload.paso_actual != null ? parseInt(String(payload.paso_actual), 10) : null;
  try {
    if (paso !== null && !Number.isNaN(paso) && paso >= 0 && paso <= 7) {
      await upsertDatosPasoProyectoDrizzle(proyectoId, paso, typeof datos !== "undefined" ? datos : {});
    }
    let estadoValido;
    let pasoActualValido;
    if (estado === "borrador" || estado === "enviado") {
      estadoValido = estado;
    }
    if (pasoActual !== null && !Number.isNaN(pasoActual) && pasoActual >= 0 && pasoActual <= 7) {
      pasoActualValido = pasoActual;
    }
    if (estadoValido != null || pasoActualValido != null) {
      await actualizarProyectoCamposDrizzle(proyectoId, {
        estado: estadoValido,
        pasoActual: pasoActualValido
      });
    } else if (paso !== null && !Number.isNaN(paso)) {
      await actualizarProyectoCamposDrizzle(proyectoId, {
        pasoActual: paso
      });
    }
    return { success: true };
  } catch (err) {
    return { success: false, error: "Error al actualizar proyecto" };
  }
});
const _id__patch = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _WnI391
});
const TIPOS_VALIDOS = ["carta_aprobacion", "carta_colaboracion", "marco_referencia", "recoleccion_datos", "programa_gasto", "cronograma"];
const MAX_SIZE_BYTES = 20 * 1024 * 1024;
const PDF_TYPE = "application/pdf";
function getUploadDir$1() {
  const base = process.env.UPLOAD_DIR?.trim() || join(process.cwd(), "uploads");
  return base;
}
const _z7M4ii = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return { success: false, error: "No autorizado" };
  }
  const id = event.context.params?.id;
  if (!id) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID requerido" };
  }
  const proyectoId = parseInt(id, 10);
  if (Number.isNaN(proyectoId) || proyectoId < 1) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID no válido" };
  }
  const proyecto = await obtenerProyectoOwnerDrizzle(proyectoId);
  if (!proyecto || proyecto.usuario_id !== usuarioId) {
    setResponseStatus(event, 404);
    return { success: false, error: "Proyecto no encontrado" };
  }
  if (proyecto.estado === "enviado" || proyecto.estado === "aprobado") {
    setResponseStatus(event, 403);
    return { success: false, error: "El proyecto ya fue enviado y no puede editarse" };
  }
  let tipoArchivo = null;
  let fileData = null;
  let filename = null;
  let contentType = null;
  try {
    const parts = await readMultipartFormData(event);
    if (!parts.length) {
      setResponseStatus(event, 400);
      return { success: false, error: "No se recibió archivo" };
    }
    for (const part of parts) {
      if (part.name === "tipo_archivo") {
        tipoArchivo = Buffer.from(part.data).toString("utf8").trim();
      }
      if (part.name === "archivo") {
        fileData = part.data;
        filename = part.filename ?? null;
        contentType = part.type ?? null;
      }
    }
    if (!tipoArchivo || !TIPOS_VALIDOS.includes(tipoArchivo)) {
      setResponseStatus(event, 400);
      return { success: false, error: "Tipo de archivo no válido" };
    }
    if (!fileData?.length) {
      setResponseStatus(event, 400);
      return { success: false, error: "No se recibió archivo" };
    }
    if (fileData.length > MAX_SIZE_BYTES) {
      setResponseStatus(event, 400);
      return { success: false, error: "Archivo demasiado grande" };
    }
    const isPdf = contentType === PDF_TYPE || filename && filename.toLowerCase().endsWith(".pdf");
    if (!isPdf) {
      setResponseStatus(event, 400);
      return { success: false, error: "Solo se permiten archivos PDF" };
    }
    const baseDir = getUploadDir$1();
    const projectDir = join(baseDir, "proyectos", String(proyectoId));
    await mkdir(projectDir, { recursive: true });
    const timestamp = Date.now();
    const safeName = `${tipoArchivo}_${timestamp}.pdf`;
    const rutaCompleta = join(projectDir, safeName);
    const rutaRelativa = `proyectos/${proyectoId}/${safeName}`;
    await writeFile(rutaCompleta, Buffer.from(fileData));
    const nombreOriginal = filename || safeName;
    const existente = await obtenerArchivoProyectoPorTipoDrizzle(proyectoId, tipoArchivo);
    if (existente) {
      const rutaAntigua = join(getUploadDir$1(), existente.ruta_servidor);
      await unlink(rutaAntigua).catch(() => {
      });
    }
    await guardarArchivoProyectoDrizzle({
      proyectoId,
      tipoArchivo,
      rutaServidor: rutaRelativa,
      nombreOriginal,
      tamano: fileData.length,
      contentType: PDF_TYPE
    });
    return { success: true, ruta_servidor: rutaRelativa, nombre_original: nombreOriginal };
  } catch (err) {
    return { success: false, error: "Error al subir archivo" };
  }
});
const archivos_post = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _z7M4ii
});
function getUploadDir() {
  const base = process.env.UPLOAD_DIR?.trim() || join(process.cwd(), "uploads");
  return base;
}
const _tjHDlt = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return null;
  }
  const id = event.context.params?.id;
  const tipo = event.context.params?.tipo;
  if (!id || !tipo) {
    setResponseStatus(event, 400);
    return null;
  }
  const proyectoId = parseInt(id, 10);
  if (Number.isNaN(proyectoId) || proyectoId < 1) {
    setResponseStatus(event, 400);
    return null;
  }
  const proyecto = await obtenerProyectoOwnerDrizzle(proyectoId);
  if (!proyecto || proyecto.usuario_id !== usuarioId) {
    setResponseStatus(event, 404);
    return null;
  }
  const archivo = await obtenerArchivoProyectoPorTipoDrizzle(proyectoId, tipo);
  if (!archivo) {
    setResponseStatus(event, 404);
    return null;
  }
  const rutaCompleta = join(getUploadDir(), archivo.ruta_servidor);
  try {
    const buffer = await readFile(rutaCompleta);
    const filename = archivo.nombre_original || `${tipo}.pdf`;
    setResponseHeader(event, "Content-Type", "application/pdf");
    setResponseHeader(event, "Content-Disposition", `inline; filename="${filename}"`);
    return buffer;
  } catch {
    setResponseStatus(event, 404);
    return null;
  }
});
const _tipo__get = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: _tjHDlt
});
const assets = {
  "/investigacionv2/.DS_Store": {
    "type": "text/plain; charset=utf-8",
    "etag": '"1804-xRMSDE8KQ6LPJsakEPRGcfksEPs"',
    "mtime": "2026-02-17T16:52:34.763Z",
    "size": 6148,
    "path": "../public/.DS_Store"
  },
  "/investigacionv2/.DS_Store.br": {
    "type": "text/plain; charset=utf-8",
    "encoding": "br",
    "etag": '"df-Zl1WPiKKiRuat7T8m2s0ZI4MRt0"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 223,
    "path": "../public/.DS_Store.br"
  },
  "/investigacionv2/.DS_Store.gz": {
    "type": "text/plain; charset=utf-8",
    "encoding": "gzip",
    "etag": '"115-ZfJJQpwaTT9As81frlr2o6IbR/M"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 277,
    "path": "../public/.DS_Store.gz"
  },
  "/investigacionv2/LogoHJM-dark.svg": {
    "type": "image/svg+xml",
    "etag": '"6cfff-MAEGIaQM1u79q6erzsx6kcUZ6eE"',
    "mtime": "2026-02-17T16:52:34.763Z",
    "size": 446463,
    "path": "../public/LogoHJM-dark.svg"
  },
  "/investigacionv2/LogoHJM-dark.svg.br": {
    "type": "image/svg+xml",
    "encoding": "br",
    "etag": '"14185-ddGmv/zRwzOVyM7eGazEUuUlFgo"',
    "mtime": "2026-02-17T16:52:36.312Z",
    "size": 82309,
    "path": "../public/LogoHJM-dark.svg.br"
  },
  "/investigacionv2/LogoHJM-dark.svg.gz": {
    "type": "image/svg+xml",
    "encoding": "gzip",
    "etag": '"19df7-t6hGDQB7OHPsJ2eTVs9Fd7rCaxc"',
    "mtime": "2026-02-17T16:52:36.219Z",
    "size": 105975,
    "path": "../public/LogoHJM-dark.svg.gz"
  },
  "/investigacionv2/LogoHJM.svg": {
    "type": "image/svg+xml",
    "etag": '"6cff0-B0VwGZF09xAUwsyCMkcOV4ay6tQ"',
    "mtime": "2026-02-17T16:52:34.764Z",
    "size": 446448,
    "path": "../public/LogoHJM.svg"
  },
  "/investigacionv2/LogoHJM.svg.br": {
    "type": "image/svg+xml",
    "encoding": "br",
    "etag": '"141fe-D5r3wzolFHmeNkGEwjg2g87C3Cw"',
    "mtime": "2026-02-17T16:52:36.326Z",
    "size": 82430,
    "path": "../public/LogoHJM.svg.br"
  },
  "/investigacionv2/LogoHJM.svg.gz": {
    "type": "image/svg+xml",
    "encoding": "gzip",
    "etag": '"19dee-mJwJRwXbbALhAGicjCiepxDmmc4"',
    "mtime": "2026-02-17T16:52:36.219Z",
    "size": 105966,
    "path": "../public/LogoHJM.svg.gz"
  },
  "/investigacionv2/investigacion.webp": {
    "type": "image/webp",
    "etag": '"3733a-QjtrngJM7OSxUS9EevmPXe3e0dY"',
    "mtime": "2026-02-17T16:52:34.765Z",
    "size": 226106,
    "path": "../public/investigacion.webp"
  },
  "/investigacionv2/assets/_layout-C2XO6He5.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"2999b-yoLeP24QfQGtHVeDd82gRc7VM+M"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 170395,
    "path": "../public/assets/_layout-C2XO6He5.js"
  },
  "/investigacionv2/assets/_layout-C2XO6He5.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"b84f-9RoS+ze0snFg8A+OUX2YupEK79c"',
    "mtime": "2026-02-17T16:52:36.213Z",
    "size": 47183,
    "path": "../public/assets/_layout-C2XO6He5.js.br"
  },
  "/investigacionv2/assets/_layout-C2XO6He5.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"cef0-TueJB831x+rTaPQdTpp7UkQ73WA"',
    "mtime": "2026-02-17T16:52:36.215Z",
    "size": 52976,
    "path": "../public/assets/_layout-C2XO6He5.js.gz"
  },
  "/investigacionv2/assets/_layout.admin.usuarios-Du4wSAhq.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"e1dd-VEHAmBvIxRrqXv4f5gpHuAoreZA"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 57821,
    "path": "../public/assets/_layout.admin.usuarios-Du4wSAhq.js"
  },
  "/investigacionv2/assets/_layout.admin.usuarios-Du4wSAhq.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"38d8-qgyTwRzWwM1au/PnTdQDnb9HqUk"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 14552,
    "path": "../public/assets/_layout.admin.usuarios-Du4wSAhq.js.br"
  },
  "/investigacionv2/assets/_layout.admin.usuarios-Du4wSAhq.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"3f24-E9TplmYtKMXbvomLOn77/seYMhk"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 16164,
    "path": "../public/assets/_layout.admin.usuarios-Du4wSAhq.js.gz"
  },
  "/investigacionv2/assets/_layout.documentacion--WXjn-eX.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"273-pee466owSchfeo/RPGGKBjNaNXA"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 627,
    "path": "../public/assets/_layout.documentacion--WXjn-eX.js"
  },
  "/investigacionv2/assets/_layout.inicio-CO1gqysR.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"66c-MYn4bfRveC3ntv5WWEn8trz/jG0"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 1644,
    "path": "../public/assets/_layout.inicio-CO1gqysR.js"
  },
  "/investigacionv2/assets/_layout.inicio-CO1gqysR.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"240-m2jwM+IsA5SqtWy7Lxrg/LyGIBU"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 576,
    "path": "../public/assets/_layout.inicio-CO1gqysR.js.br"
  },
  "/investigacionv2/assets/_layout.inicio-CO1gqysR.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"2b6-TuHuNdy6O0ilOvw3Xtdk+WUc1L0"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 694,
    "path": "../public/assets/_layout.inicio-CO1gqysR.js.gz"
  },
  "/investigacionv2/assets/_layout.proyectos-CHRjG-Sh.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"18ca-Rg2f8mSz8ddLokOqI+5/iFKc+mQ"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 6346,
    "path": "../public/assets/_layout.proyectos-CHRjG-Sh.js"
  },
  "/investigacionv2/assets/_layout.proyectos-CHRjG-Sh.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"7cc-eIxh3bpTNqGCnYtu06WtVYwIscQ"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 1996,
    "path": "../public/assets/_layout.proyectos-CHRjG-Sh.js.br"
  },
  "/investigacionv2/assets/_layout.proyectos-CHRjG-Sh.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"8be-+9jtaDqVWmZWMfkezNRE8h5iY5I"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 2238,
    "path": "../public/assets/_layout.proyectos-CHRjG-Sh.js.gz"
  },
  "/investigacionv2/assets/_layout.prueba-drizzle-Dj_jBFcK.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"ac7-st/H6udH7XKZfvnimik8ym3fLEA"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 2759,
    "path": "../public/assets/_layout.prueba-drizzle-Dj_jBFcK.js"
  },
  "/investigacionv2/assets/_layout.prueba-drizzle-Dj_jBFcK.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"40e-cMwM8q74N5YIVuSkGBjZSPO//RA"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 1038,
    "path": "../public/assets/_layout.prueba-drizzle-Dj_jBFcK.js.br"
  },
  "/investigacionv2/assets/_layout.prueba-drizzle-Dj_jBFcK.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"487-q2xBdAugyIJbarf9vdZ98yWxS2I"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 1159,
    "path": "../public/assets/_layout.prueba-drizzle-Dj_jBFcK.js.gz"
  },
  "/investigacionv2/assets/_layout.registro-proyecto-CzV_titc.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"2cf1e-TjUnps8ZOzLi0txtTf6aZPUxUIc"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 184094,
    "path": "../public/assets/_layout.registro-proyecto-CzV_titc.js"
  },
  "/investigacionv2/assets/_layout.registro-proyecto-CzV_titc.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"8737-0vlB8t8yeG0LGuISZCWGsLxHvtU"',
    "mtime": "2026-02-17T16:52:36.215Z",
    "size": 34615,
    "path": "../public/assets/_layout.registro-proyecto-CzV_titc.js.br"
  },
  "/investigacionv2/assets/_layout.registro-proyecto-CzV_titc.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"9d5f-2lL4r8Xnx+0BfngjA8lMkBuSy/k"',
    "mtime": "2026-02-17T16:52:36.213Z",
    "size": 40287,
    "path": "../public/assets/_layout.registro-proyecto-CzV_titc.js.gz"
  },
  "/investigacionv2/assets/_layout.revision-CUQC-TF9.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"327c-jJduAcV+uaSXEg8NzMOjlI/KlR8"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 12924,
    "path": "../public/assets/_layout.revision-CUQC-TF9.js"
  },
  "/investigacionv2/assets/_layout.revision-CUQC-TF9.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"e9a-hNqbk4J4UYoZOQsm5tfOfaEWUCY"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 3738,
    "path": "../public/assets/_layout.revision-CUQC-TF9.js.br"
  },
  "/investigacionv2/assets/_layout.revision-CUQC-TF9.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"103e-5b8ztkZPLwB5uCt6h4JTw6yMy/I"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 4158,
    "path": "../public/assets/_layout.revision-CUQC-TF9.js.gz"
  },
  "/investigacionv2/assets/alert-dialog-pOfyvsEh.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"17d0-EKTErBIhR5TMqO7mJB6f9SuqOJY"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 6096,
    "path": "../public/assets/alert-dialog-pOfyvsEh.js"
  },
  "/investigacionv2/assets/alert-dialog-pOfyvsEh.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"70c-EJ6HlHUaijJVfuKcXd1meygCxFg"',
    "mtime": "2026-02-17T16:52:36.207Z",
    "size": 1804,
    "path": "../public/assets/alert-dialog-pOfyvsEh.js.br"
  },
  "/investigacionv2/assets/alert-dialog-pOfyvsEh.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"82f-yDyo2Oaj9WLGBKxNfyygrOK8oLI"',
    "mtime": "2026-02-17T16:52:36.207Z",
    "size": 2095,
    "path": "../public/assets/alert-dialog-pOfyvsEh.js.gz"
  },
  "/investigacionv2/assets/api-proyectos-FoOFP4EO.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"e7c-APA9g+Qtks+QCT1Mtuwh8KP72W0"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 3708,
    "path": "../public/assets/api-proyectos-FoOFP4EO.js"
  },
  "/investigacionv2/assets/api-proyectos-FoOFP4EO.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"48c-igEG3LohFdxq/n5VflFi7EH+rQc"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 1164,
    "path": "../public/assets/api-proyectos-FoOFP4EO.js.br"
  },
  "/investigacionv2/assets/api-proyectos-FoOFP4EO.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"55c-BYCswTbdimMcG9Ypg6YZqF0N+J8"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 1372,
    "path": "../public/assets/api-proyectos-FoOFP4EO.js.gz"
  },
  "/investigacionv2/assets/badge-IjTmkGWq.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"6a18-1PqBfbv+TUql3MUhQDpj9j++nvk"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 27160,
    "path": "../public/assets/badge-IjTmkGWq.js"
  },
  "/investigacionv2/assets/badge-IjTmkGWq.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"1a31-Xqb55d0yzzNeIGIT32Jbr6LeXJo"',
    "mtime": "2026-02-17T16:52:36.198Z",
    "size": 6705,
    "path": "../public/assets/badge-IjTmkGWq.js.br"
  },
  "/investigacionv2/assets/badge-IjTmkGWq.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"1dbe-LOhkgynorppExhFuOKEgZDC2cx8"',
    "mtime": "2026-02-17T16:52:36.198Z",
    "size": 7614,
    "path": "../public/assets/badge-IjTmkGWq.js.gz"
  },
  "/investigacionv2/assets/button-BQBIKqp6.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"13b6-ZBo2NMzJsUy08xZ4RfrHEZLT41s"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 5046,
    "path": "../public/assets/button-BQBIKqp6.js"
  },
  "/investigacionv2/assets/button-BQBIKqp6.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"700-yXA6Czem5ma3J/YavArD10Lq1gA"',
    "mtime": "2026-02-17T16:52:36.198Z",
    "size": 1792,
    "path": "../public/assets/button-BQBIKqp6.js.br"
  },
  "/investigacionv2/assets/button-BQBIKqp6.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"7a6-/PMTeBiadguLcVeVyInzF0MWy3E"',
    "mtime": "2026-02-17T16:52:36.197Z",
    "size": 1958,
    "path": "../public/assets/button-BQBIKqp6.js.gz"
  },
  "/investigacionv2/assets/card-DHe9cN2S.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"546-tVhihtvWUf3+tVpDq71UNNpnRNs"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 1350,
    "path": "../public/assets/card-DHe9cN2S.js"
  },
  "/investigacionv2/assets/card-DHe9cN2S.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"1dc-/MWGQtEgGw9t4JsddfuQYRYUdJE"',
    "mtime": "2026-02-17T16:52:36.207Z",
    "size": 476,
    "path": "../public/assets/card-DHe9cN2S.js.br"
  },
  "/investigacionv2/assets/card-DHe9cN2S.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"218-xV9yWehyaOLlpDINsdJGS6A7uOk"',
    "mtime": "2026-02-17T16:52:36.207Z",
    "size": 536,
    "path": "../public/assets/card-DHe9cN2S.js.gz"
  },
  "/investigacionv2/assets/index-BNjX8fvG.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"6137-zFoO01rurWd3tdeEKck5zXeWc4U"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 24887,
    "path": "../public/assets/index-BNjX8fvG.js"
  },
  "/investigacionv2/assets/index-BNjX8fvG.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"1fab-IUoBLsiyIQORGaojMDS0GVYHd7g"',
    "mtime": "2026-02-17T16:52:36.207Z",
    "size": 8107,
    "path": "../public/assets/index-BNjX8fvG.js.br"
  },
  "/investigacionv2/assets/index-BNjX8fvG.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"2342-Iolx8QXaEXcDwezKYjvfxpEdxxM"',
    "mtime": "2026-02-17T16:52:36.207Z",
    "size": 9026,
    "path": "../public/assets/index-BNjX8fvG.js.gz"
  },
  "/investigacionv2/assets/index-C5j4R2CM.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"831-ei7z9CKAMjOY2zlGZer9mSGFGOM"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 2097,
    "path": "../public/assets/index-C5j4R2CM.js"
  },
  "/investigacionv2/assets/index-C5j4R2CM.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"338-zTlH8K1O81nOQKO//a/nd/p0bN4"',
    "mtime": "2026-02-17T16:52:36.207Z",
    "size": 824,
    "path": "../public/assets/index-C5j4R2CM.js.br"
  },
  "/investigacionv2/assets/index-C5j4R2CM.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"3b1-lip/Yo+RBGPDbQQ2Tv/uWCjZ2k4"',
    "mtime": "2026-02-17T16:52:36.207Z",
    "size": 945,
    "path": "../public/assets/index-C5j4R2CM.js.gz"
  },
  "/investigacionv2/assets/index-CvIH5Vqj.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"75fc-9kh3Vv15xM11AWBX4tVEmwEVXKs"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 30204,
    "path": "../public/assets/index-CvIH5Vqj.js"
  },
  "/investigacionv2/assets/index-CvIH5Vqj.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"2927-ZHaS83bFESoHWiUN1TAdSqa8OQ0"',
    "mtime": "2026-02-17T16:52:36.207Z",
    "size": 10535,
    "path": "../public/assets/index-CvIH5Vqj.js.br"
  },
  "/investigacionv2/assets/index-CvIH5Vqj.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"2d81-AvNH29Rggt9ISJ60DdMo7/5FGjw"',
    "mtime": "2026-02-17T16:52:36.207Z",
    "size": 11649,
    "path": "../public/assets/index-CvIH5Vqj.js.gz"
  },
  "/investigacionv2/assets/index-CxZi1SfK.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"71-ftvmkNH/0VapoOsr/l12HGnhkKc"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 113,
    "path": "../public/assets/index-CxZi1SfK.js"
  },
  "/investigacionv2/assets/index-Hav0qhTA.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"199b-2bRW4LIv/DzrEEn8wKJ5SkzBIeU"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 6555,
    "path": "../public/assets/index-Hav0qhTA.js"
  },
  "/investigacionv2/assets/index-Hav0qhTA.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"891-VLlSGrgr04b79t6frqY2yI6BmJY"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 2193,
    "path": "../public/assets/index-Hav0qhTA.js.br"
  },
  "/investigacionv2/assets/index-Hav0qhTA.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"9d6-fhm4T6g285MUdh3YPRyWi9lf4AU"',
    "mtime": "2026-02-17T16:52:36.207Z",
    "size": 2518,
    "path": "../public/assets/index-Hav0qhTA.js.gz"
  },
  "/investigacionv2/assets/input-BrccYRvA.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"349-2yMOaBpfBHybgJDNnvWHR4ilQzE"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 841,
    "path": "../public/assets/input-BrccYRvA.js"
  },
  "/investigacionv2/assets/input-otp-Ci0yiz4c.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"2af8-76dLEvVqE8/7XuVpuweF937r+Nc"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 11e3,
    "path": "../public/assets/input-otp-Ci0yiz4c.js"
  },
  "/investigacionv2/assets/input-otp-Ci0yiz4c.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"efe-5p06V934MGFzfw1CPyZ98jvrJeA"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 3838,
    "path": "../public/assets/input-otp-Ci0yiz4c.js.br"
  },
  "/investigacionv2/assets/input-otp-Ci0yiz4c.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"10d9-yLzbEOE2f42RO5nzpQP4vzEsRxI"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 4313,
    "path": "../public/assets/input-otp-Ci0yiz4c.js.gz"
  },
  "/investigacionv2/assets/jetbrains-mono-cyrillic-wght-normal-D73BlboJ.woff2": {
    "type": "font/woff2",
    "etag": '"2f4c-WiAGfn140d4QND3ayQWaCHF8rbE"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 12108,
    "path": "../public/assets/jetbrains-mono-cyrillic-wght-normal-D73BlboJ.woff2"
  },
  "/investigacionv2/assets/jetbrains-mono-greek-wght-normal-Bw9x6K1M.woff2": {
    "type": "font/woff2",
    "etag": '"232c-Dnz9DhH4c266e6TziU1pxRkV6FY"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 9004,
    "path": "../public/assets/jetbrains-mono-greek-wght-normal-Bw9x6K1M.woff2"
  },
  "/investigacionv2/assets/jetbrains-mono-latin-ext-wght-normal-DBQx-q_a.woff2": {
    "type": "font/woff2",
    "etag": '"3b5c-HLF7Wvs2Z1IA1cPRs6jnor8OUQ4"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 15196,
    "path": "../public/assets/jetbrains-mono-latin-ext-wght-normal-DBQx-q_a.woff2"
  },
  "/investigacionv2/assets/jetbrains-mono-latin-wght-normal-B9CIFXIH.woff2": {
    "type": "font/woff2",
    "etag": '"9dd4-5yd+cUUhzrXxdMyYebUeD0qml1M"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 40404,
    "path": "../public/assets/jetbrains-mono-latin-wght-normal-B9CIFXIH.woff2"
  },
  "/investigacionv2/assets/jetbrains-mono-vietnamese-wght-normal-Bt-aOZkq.woff2": {
    "type": "font/woff2",
    "etag": '"1d50-/Re0MyD6BV8h81wBPVijGZH5GBs"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 7504,
    "path": "../public/assets/jetbrains-mono-vietnamese-wght-normal-Bt-aOZkq.woff2"
  },
  "/investigacionv2/assets/label-70rGEvIm.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"2a5-R1MFKUnKnqvR5hem6PoQxQXOgPs"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 677,
    "path": "../public/assets/label-70rGEvIm.js"
  },
  "/investigacionv2/assets/login-CKQ03W4i.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"2bc3-3FB3nJl0YRUpy7JV/CwK+VLGoX0"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 11203,
    "path": "../public/assets/login-CKQ03W4i.js"
  },
  "/investigacionv2/assets/login-CKQ03W4i.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"d77-ddvBWoLVV4ueEiWmo+ZWhM2jd8E"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 3447,
    "path": "../public/assets/login-CKQ03W4i.js.br"
  },
  "/investigacionv2/assets/login-CKQ03W4i.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"f31-wkpaVAVFD0E/rwQoUK7le35QRaE"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 3889,
    "path": "../public/assets/login-CKQ03W4i.js.gz"
  },
  "/investigacionv2/assets/main-BPXoEWCc.css": {
    "type": "text/css; charset=utf-8",
    "etag": '"2a6c8-rOXqI8ZBmtNECqAgBVQBXnh8DLU"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 173768,
    "path": "../public/assets/main-BPXoEWCc.css"
  },
  "/investigacionv2/assets/main-BPXoEWCc.css.br": {
    "type": "text/css; charset=utf-8",
    "encoding": "br",
    "etag": '"581a-V1d1bIMne6Z/cFIvx9uwg/Tfutc"',
    "mtime": "2026-02-17T16:52:36.213Z",
    "size": 22554,
    "path": "../public/assets/main-BPXoEWCc.css.br"
  },
  "/investigacionv2/assets/main-BPXoEWCc.css.gz": {
    "type": "text/css; charset=utf-8",
    "encoding": "gzip",
    "etag": '"6dff-oxFIB7xnufb9FFg6p3+e+fdAYhY"',
    "mtime": "2026-02-17T16:52:36.209Z",
    "size": 28159,
    "path": "../public/assets/main-BPXoEWCc.css.gz"
  },
  "/investigacionv2/assets/main-CM3NUj3b.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"636d7-uTIklr0Z1KLH79lDrK1x33u8vJU"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 407255,
    "path": "../public/assets/main-CM3NUj3b.js"
  },
  "/investigacionv2/assets/main-CM3NUj3b.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"1a9aa-38UMP7hyY2vM+XQDPIfY3rCXpUk"',
    "mtime": "2026-02-17T16:52:36.480Z",
    "size": 108970,
    "path": "../public/assets/main-CM3NUj3b.js.br"
  },
  "/investigacionv2/assets/main-CM3NUj3b.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"1ede7-MT+PcD70GxNGqs68lun4mxCQslw"',
    "mtime": "2026-02-17T16:52:36.219Z",
    "size": 126439,
    "path": "../public/assets/main-CM3NUj3b.js.gz"
  },
  "/investigacionv2/assets/progress-C6rLnIBw.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"7c8-O7Kwhh31xczgioWWtO+uLzbVLWU"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 1992,
    "path": "../public/assets/progress-C6rLnIBw.js"
  },
  "/investigacionv2/assets/progress-C6rLnIBw.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"355-GEN6i0NVbuB2JLHhzmSdGDYcrg0"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 853,
    "path": "../public/assets/progress-C6rLnIBw.js.br"
  },
  "/investigacionv2/assets/progress-C6rLnIBw.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"3d3-hCkusvtUTyE0uTqlHTIN5rA+e94"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 979,
    "path": "../public/assets/progress-C6rLnIBw.js.gz"
  },
  "/investigacionv2/assets/recuperar-password-DZC2mknz.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"3175-pDczlq2ytt5etFMdrlCWSOBKB6Q"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 12661,
    "path": "../public/assets/recuperar-password-DZC2mknz.js"
  },
  "/investigacionv2/assets/recuperar-password-DZC2mknz.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"c33-pPflfTuj9QhMH5eIKMhnfi1x7Y0"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 3123,
    "path": "../public/assets/recuperar-password-DZC2mknz.js.br"
  },
  "/investigacionv2/assets/recuperar-password-DZC2mknz.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"dd8-b87tRxDnnm50Q9S0HBQ4xe3Uenc"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 3544,
    "path": "../public/assets/recuperar-password-DZC2mknz.js.gz"
  },
  "/investigacionv2/assets/registro-5VkqyFLu.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"66fb-ic4WXXcybCRr0tlzakXO/TLAq6Q"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 26363,
    "path": "../public/assets/registro-5VkqyFLu.js"
  },
  "/investigacionv2/assets/registro-5VkqyFLu.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"170c-JO1JjXji1s++OpJpUIYD3+O+YHo"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 5900,
    "path": "../public/assets/registro-5VkqyFLu.js.br"
  },
  "/investigacionv2/assets/registro-5VkqyFLu.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"1a08-3HQ91GSllX4reSyWRfEjdlssN+A"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 6664,
    "path": "../public/assets/registro-5VkqyFLu.js.gz"
  },
  "/investigacionv2/assets/select-DZ75huDV.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"5b63-bWtDk2iobXk0W6XneDNvgqWbEO8"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 23395,
    "path": "../public/assets/select-DZ75huDV.js"
  },
  "/investigacionv2/assets/select-DZ75huDV.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"1c7b-hIS4FrqG8g0CQzB8jNKbHZjgYmM"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 7291,
    "path": "../public/assets/select-DZ75huDV.js.br"
  },
  "/investigacionv2/assets/select-DZ75huDV.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"1fa2-PGcJqB+VTkztup9rYgCUKkOOyNQ"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 8098,
    "path": "../public/assets/select-DZ75huDV.js.gz"
  },
  "/investigacionv2/assets/spinner-gKoHiIj7.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"f9-J2SfMVO9BTyCfjr4RKtr+v4XbOk"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 249,
    "path": "../public/assets/spinner-gKoHiIj7.js"
  },
  "/investigacionv2/assets/table-BOiYZ43q.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"47e-HTljZRU+blDNsu4zInJumrs+XxQ"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 1150,
    "path": "../public/assets/table-BOiYZ43q.js"
  },
  "/investigacionv2/assets/table-BOiYZ43q.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"181-NV98+uPuQSFhqgOVkOHTIIaTuhA"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 385,
    "path": "../public/assets/table-BOiYZ43q.js.br"
  },
  "/investigacionv2/assets/table-BOiYZ43q.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"1d2-S4jdwXPJ6J7wZ9aIwI1GOCwvQlU"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 466,
    "path": "../public/assets/table-BOiYZ43q.js.gz"
  },
  "/investigacionv2/assets/textarea-DgPQBWsh.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"2cc-mFjBmos0PAyBU8nE/t/3cQpW/LY"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 716,
    "path": "../public/assets/textarea-DgPQBWsh.js"
  },
  "/investigacionv2/assets/theme-toggle-Dx4qU9Ja.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"2e3-GXnAhuFgNWAp9NIidh3K3K9FUKk"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 739,
    "path": "../public/assets/theme-toggle-Dx4qU9Ja.js"
  },
  "/investigacionv2/assets/use-require-auth-Wgh_rt38.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"d5-aqtf74iZCnneijTRAeHJ7mT2ai4"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 213,
    "path": "../public/assets/use-require-auth-Wgh_rt38.js"
  },
  "/investigacionv2/assets/use-version-display-C99VBdDb.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"84-Rvo5pXqvhlh1c5iqx9BCqgSKejo"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 132,
    "path": "../public/assets/use-version-display-C99VBdDb.js"
  },
  "/investigacionv2/assets/useMutation-DD43cIja.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"8a1-ryv5zwifJzCUnTFe82S86zlprKo"',
    "mtime": "2026-02-17T16:52:34.934Z",
    "size": 2209,
    "path": "../public/assets/useMutation-DD43cIja.js"
  },
  "/investigacionv2/assets/useMutation-DD43cIja.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"337-J34ZiYvdSuCGgSC0g/h79djBuJA"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 823,
    "path": "../public/assets/useMutation-DD43cIja.js.br"
  },
  "/investigacionv2/assets/useMutation-DD43cIja.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"396-311DsBCnHLYiBQHBOazwV0ZdA3I"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 918,
    "path": "../public/assets/useMutation-DD43cIja.js.gz"
  },
  "/investigacionv2/assets/useQuery-B4JHtNQ2.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"2260-57ZrSve6NDFqOVbms4Uu43miWb0"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 8800,
    "path": "../public/assets/useQuery-B4JHtNQ2.js"
  },
  "/investigacionv2/assets/useQuery-B4JHtNQ2.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"b77-U5ZTZptF2gfG6VJJqQA3qIDkHDQ"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 2935,
    "path": "../public/assets/useQuery-B4JHtNQ2.js.br"
  },
  "/investigacionv2/assets/useQuery-B4JHtNQ2.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"c8b-hOXJKN+VBx9hgcvv6sHe39Qg46k"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 3211,
    "path": "../public/assets/useQuery-B4JHtNQ2.js.gz"
  },
  "/investigacionv2/assets/utils-CDN07tui.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": '"63aa-tlIrw8ZrUIZZqhEOI0GfGybRivo"',
    "mtime": "2026-02-17T16:52:34.935Z",
    "size": 25514,
    "path": "../public/assets/utils-CDN07tui.js"
  },
  "/investigacionv2/assets/utils-CDN07tui.js.br": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "br",
    "etag": '"1bd4-fnB9U9/fVN34ta0bfjVaKyChXTA"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 7124,
    "path": "../public/assets/utils-CDN07tui.js.br"
  },
  "/investigacionv2/assets/utils-CDN07tui.js.gz": {
    "type": "text/javascript; charset=utf-8",
    "encoding": "gzip",
    "etag": '"1fb6-FxEp/wWTFwd8tLR52W2Gs7NnLWA"',
    "mtime": "2026-02-17T16:52:36.208Z",
    "size": 8118,
    "path": "../public/assets/utils-CDN07tui.js.gz"
  }
};
function readAsset(id) {
  const serverDir = dirname(fileURLToPath(globalThis.__nitro_main__));
  return promises.readFile(resolve(serverDir, assets[id].path));
}
const publicAssetBases = {};
function isPublicAssetURL(id = "") {
  if (assets[id]) {
    return true;
  }
  for (const base in publicAssetBases) {
    if (id.startsWith(base)) {
      return true;
    }
  }
  return false;
}
function getAsset(id) {
  return assets[id];
}
const METHODS = /* @__PURE__ */ new Set(["HEAD", "GET"]);
const EncodingMap = {
  gzip: ".gz",
  br: ".br"
};
const _qNHMnr = defineHandler((event) => {
  if (event.req.method && !METHODS.has(event.req.method)) {
    return;
  }
  let id = decodePath(withLeadingSlash(withoutTrailingSlash(event.url.pathname)));
  let asset;
  const encodingHeader = event.req.headers.get("accept-encoding") || "";
  const encodings = [...encodingHeader.split(",").map((e) => EncodingMap[e.trim()]).filter(Boolean).sort(), ""];
  if (encodings.length > 1) {
    event.res.headers.append("Vary", "Accept-Encoding");
  }
  for (const encoding of encodings) {
    for (const _id of [id + encoding, joinURL(id, "index.html" + encoding)]) {
      const _asset = getAsset(_id);
      if (_asset) {
        asset = _asset;
        id = _id;
        break;
      }
    }
  }
  if (!asset) {
    if (isPublicAssetURL(id)) {
      event.res.headers.delete("Cache-Control");
      throw new HTTPError({ status: 404 });
    }
    return;
  }
  const ifNotMatch = event.req.headers.get("if-none-match") === asset.etag;
  if (ifNotMatch) {
    event.res.status = 304;
    event.res.statusText = "Not Modified";
    return "";
  }
  const ifModifiedSinceH = event.req.headers.get("if-modified-since");
  const mtimeDate = new Date(asset.mtime);
  if (ifModifiedSinceH && asset.mtime && new Date(ifModifiedSinceH) >= mtimeDate) {
    event.res.status = 304;
    event.res.statusText = "Not Modified";
    return "";
  }
  if (asset.type) {
    event.res.headers.set("Content-Type", asset.type);
  }
  if (asset.etag && !event.res.headers.has("ETag")) {
    event.res.headers.set("ETag", asset.etag);
  }
  if (asset.mtime && !event.res.headers.has("Last-Modified")) {
    event.res.headers.set("Last-Modified", mtimeDate.toUTCString());
  }
  if (asset.encoding && !event.res.headers.has("Content-Encoding")) {
    event.res.headers.set("Content-Encoding", asset.encoding);
  }
  if (asset.size > 0 && !event.res.headers.has("Content-Length")) {
    event.res.headers.set("Content-Length", asset.size.toString());
  }
  return readAsset(id);
});
const findRouteRules = /* @__PURE__ */ (() => {
  const $0 = [{ name: "headers", route: "/assets/**", handler: headers, options: { "cache-control": "public, max-age=31536000, immutable" } }];
  return (m, p) => {
    let r = [];
    if (p.charCodeAt(p.length - 1) === 47) p = p.slice(0, -1) || "/";
    let s = p.split("/");
    s.length - 1;
    if (s[1] === "investigacionv2") {
      if (s[2] === "assets") {
        r.unshift({ data: $0, params: { "_": s.slice(3).join("/") } });
      }
    }
    return r;
  };
})();
const _lazy_6SEetN = defineLazyEventHandler(() => import("./chunks/routes/api/admin/roles.get.mjs"));
const _lazy_IkajIa = defineLazyEventHandler(() => import("./chunks/routes/api/admin/usuarios.get.mjs"));
const _lazy_aTti7y = defineLazyEventHandler(() => import("./chunks/routes/api/admin/usuarios/_id_.patch.mjs"));
defineLazyEventHandler(() => Promise.resolve().then(function() {
  return cambiarPasswordRecuperacion_post;
}));
defineLazyEventHandler(() => Promise.resolve().then(function() {
  return curpDisponible_get;
}));
defineLazyEventHandler(() => Promise.resolve().then(function() {
  return login_post;
}));
const _lazy_8TdSs1 = defineLazyEventHandler(() => import("./chunks/routes/api/auth/recuperacion-enviar-codigo.post.mjs"));
const _lazy_l3Mcwq = defineLazyEventHandler(() => import("./chunks/routes/api/auth/recuperacion-verificar-codigo.post.mjs"));
const _lazy_QUfXi6 = defineLazyEventHandler(() => import("./chunks/routes/api/auth/registro-reenviar-codigo.post.mjs"));
defineLazyEventHandler(() => Promise.resolve().then(function() {
  return registro_post;
}));
defineLazyEventHandler(() => Promise.resolve().then(function() {
  return usuarioPorCurp_get;
}));
const _lazy_facRpX = defineLazyEventHandler(() => import("./chunks/routes/api/auth/verificar-correo-registro.post.mjs"));
defineLazyEventHandler(() => Promise.resolve().then(function() {
  return verificarDatosRecuperacion_post;
}));
defineLazyEventHandler(() => Promise.resolve().then(function() {
  return curp;
}));
defineLazyEventHandler(() => Promise.resolve().then(function() {
  return proyectos_get;
}));
defineLazyEventHandler(() => Promise.resolve().then(function() {
  return proyectos_post;
}));
const _lazy_8ToQWv = defineLazyEventHandler(() => Promise.resolve().then(function() {
  return _id__get;
}));
const _lazy_WnI391 = defineLazyEventHandler(() => Promise.resolve().then(function() {
  return _id__patch;
}));
defineLazyEventHandler(() => Promise.resolve().then(function() {
  return archivos_post;
}));
const _lazy_tjHDlt = defineLazyEventHandler(() => Promise.resolve().then(function() {
  return _tipo__get;
}));
const _lazy_Wcz8AG = defineLazyEventHandler(() => import("./chunks/routes/api/proyectos/_id/comentarios-revision.get.mjs"));
const _lazy_0AfWbm = defineLazyEventHandler(() => import("./chunks/routes/api/revision/proyectos.get.mjs"));
const _lazy_xDFxnr = defineLazyEventHandler(() => import("./chunks/routes/api/revision/proyectos/_id_.get.mjs"));
const _lazy_CWChmh = defineLazyEventHandler(() => import("./chunks/routes/api/revision/proyectos/_id/aprobar.post.mjs"));
const _lazy_hpePuR = defineLazyEventHandler(() => import("./chunks/routes/api/revision/proyectos/_id/archivos/_tipo_.get.mjs"));
const _lazy_g4S1Cp = defineLazyEventHandler(() => import("./chunks/routes/api/revision/proyectos/_id/comentarios.post.mjs"));
const _lazy_sXaO3U = defineLazyEventHandler(() => import("./chunks/routes/api/test/drizzle-usuarios.get.mjs"));
defineLazyEventHandler(() => Promise.resolve().then(function() {
  return version_get;
}));
const _lazy_v67jep = defineLazyEventHandler(() => Promise.resolve().then(function() {
  return ssrRenderer$1;
}));
const findRoute = /* @__PURE__ */ (() => {
  const $0 = { route: "/api/version", method: "GET", handler: toEventHandler(_lDk5s1) }, $2 = { route: "/api/curp", handler: toEventHandler(_knK2Yo) }, $4 = { route: "/api/auth/login", method: "POST", handler: toEventHandler(_FDPqez) }, $6 = { route: "/api/auth/registro", method: "POST", handler: toEventHandler(_Yuh7Jb) }, $8 = { route: "/api/auth/curp-disponible", method: "GET", handler: toEventHandler(_3EduuS) }, $10 = { route: "/api/auth/usuario-por-curp", method: "GET", handler: toEventHandler(_JrCAsr) }, $12 = { route: "/api/auth/verificar-datos-recuperacion", method: "POST", handler: toEventHandler(_DgBOV4) }, $14 = { route: "/api/auth/cambiar-password-recuperacion", method: "POST", handler: toEventHandler(_zup2AC) }, $16 = { route: "/api/proyectos", method: "POST", handler: toEventHandler(_S88Gcv) }, $18 = { route: "/api/proyectos", method: "GET", handler: toEventHandler(_Ix5ZLP) }, $20 = { route: "/api/admin/roles", method: "get", handler: _lazy_6SEetN }, $21 = { route: "/api/admin/usuarios", method: "get", handler: _lazy_IkajIa }, $22 = { route: "/api/auth/recuperacion-enviar-codigo", method: "post", handler: _lazy_8TdSs1 }, $23 = { route: "/api/auth/recuperacion-verificar-codigo", method: "post", handler: _lazy_l3Mcwq }, $24 = { route: "/api/auth/registro-reenviar-codigo", method: "post", handler: _lazy_QUfXi6 }, $25 = { route: "/api/auth/verificar-correo-registro", method: "post", handler: _lazy_facRpX }, $26 = { route: "/api/revision/proyectos", method: "get", handler: _lazy_0AfWbm }, $27 = { route: "/api/test/drizzle-usuarios", method: "get", handler: _lazy_sXaO3U }, $28 = { route: "/api/proyectos/:id", method: "GET", handler: toEventHandler(_8ToQWv) }, $29 = { route: "/api/proyectos/:id", method: "get", handler: _lazy_8ToQWv }, $30 = { route: "/api/proyectos/:id", method: "PATCH", handler: toEventHandler(_WnI391) }, $31 = { route: "/api/proyectos/:id", method: "patch", handler: _lazy_WnI391 }, $32 = { route: "/api/proyectos/:id/archivos", method: "POST", handler: toEventHandler(_z7M4ii) }, $34 = { route: "/api/proyectos/:id/archivos/:tipo", method: "GET", handler: toEventHandler(_tjHDlt) }, $35 = { route: "/api/proyectos/:id/archivos/:tipo", method: "get", handler: _lazy_tjHDlt }, $36 = { route: "/api/proyectos/:id/comentarios-revision", method: "get", handler: _lazy_Wcz8AG }, $37 = { route: "/api/admin/usuarios/:id", method: "patch", handler: _lazy_aTti7y }, $38 = { route: "/api/revision/proyectos/:id", method: "get", handler: _lazy_xDFxnr }, $39 = { route: "/api/revision/proyectos/:id/aprobar", method: "post", handler: _lazy_CWChmh }, $40 = { route: "/api/revision/proyectos/:id/archivos/:tipo", method: "get", handler: _lazy_hpePuR }, $41 = { route: "/api/revision/proyectos/:id/comentarios", method: "post", handler: _lazy_g4S1Cp }, $42 = { route: "/**", handler: _lazy_v67jep };
  return (m, p) => {
    if (p.charCodeAt(p.length - 1) === 47) p = p.slice(0, -1) || "/";
    if (p === "/investigacionv2/api/version") {
      if (m === "GET") {
        return { data: $0 };
      }
    }
    if (p === "/investigacionv2/api/curp") {
      return { data: $2 };
    }
    if (p === "/investigacionv2/api/auth/login") {
      if (m === "POST") {
        return { data: $4 };
      }
    }
    if (p === "/investigacionv2/api/auth/registro") {
      if (m === "POST") {
        return { data: $6 };
      }
    }
    if (p === "/investigacionv2/api/auth/curp-disponible") {
      if (m === "GET") {
        return { data: $8 };
      }
    }
    if (p === "/investigacionv2/api/auth/usuario-por-curp") {
      if (m === "GET") {
        return { data: $10 };
      }
    }
    if (p === "/investigacionv2/api/auth/verificar-datos-recuperacion") {
      if (m === "POST") {
        return { data: $12 };
      }
    }
    if (p === "/investigacionv2/api/auth/cambiar-password-recuperacion") {
      if (m === "POST") {
        return { data: $14 };
      }
    }
    if (p === "/investigacionv2/api/proyectos") {
      if (m === "POST") {
        return { data: $16 };
      }
      if (m === "GET") {
        return { data: $18 };
      }
    }
    if (p === "/investigacionv2/api/admin/roles") {
      if (m === "GET") return { data: $20 };
    }
    if (p === "/investigacionv2/api/admin/usuarios") {
      if (m === "GET") return { data: $21 };
    }
    if (p === "/investigacionv2/api/auth/recuperacion-enviar-codigo") {
      if (m === "POST") return { data: $22 };
    }
    if (p === "/investigacionv2/api/auth/recuperacion-verificar-codigo") {
      if (m === "POST") return { data: $23 };
    }
    if (p === "/investigacionv2/api/auth/registro-reenviar-codigo") {
      if (m === "POST") return { data: $24 };
    }
    if (p === "/investigacionv2/api/auth/verificar-correo-registro") {
      if (m === "POST") return { data: $25 };
    }
    if (p === "/investigacionv2/api/revision/proyectos") {
      if (m === "GET") return { data: $26 };
    }
    if (p === "/investigacionv2/api/test/drizzle-usuarios") {
      if (m === "GET") return { data: $27 };
    }
    let s = p.split("/"), l = s.length - 1;
    if (s[1] === "investigacionv2") {
      if (s[2] === "api") {
        if (s[3] === "proyectos") {
          if (l === 4 || l === 3) {
            if (m === "GET") {
              if (l >= 4) return { data: $28, params: { "id": s[4] } };
              if (l >= 4) return { data: $29, params: { "id": s[4] } };
            }
            if (m === "PATCH") {
              if (l >= 4) return { data: $30, params: { "id": s[4] } };
              if (l >= 4) return { data: $31, params: { "id": s[4] } };
            }
          }
          if (s[5] === "archivos") {
            if (l === 5) {
              if (m === "POST") {
                return { data: $32, params: { "id": s[4] } };
              }
            }
            if (l === 6 || l === 5) {
              if (m === "GET") {
                if (l >= 6) return { data: $34, params: { "id": s[4], "tipo": s[6] } };
                if (l >= 6) return { data: $35, params: { "id": s[4], "tipo": s[6] } };
              }
            }
          }
          if (s[5] === "comentarios-revision") {
            if (l === 5) {
              if (m === "GET") return { data: $36, params: { "id": s[4] } };
            }
          }
        }
        if (s[3] === "admin") {
          if (s[4] === "usuarios") {
            if (l === 5 || l === 4) {
              if (m === "PATCH") {
                if (l >= 5) return { data: $37, params: { "id": s[5] } };
              }
            }
          }
        }
        if (s[3] === "revision") {
          if (s[4] === "proyectos") {
            if (l === 5 || l === 4) {
              if (m === "GET") {
                if (l >= 5) return { data: $38, params: { "id": s[5] } };
              }
            }
            if (s[6] === "aprobar") {
              if (l === 6) {
                if (m === "POST") return { data: $39, params: { "id": s[5] } };
              }
            }
            if (s[6] === "archivos") {
              if (l === 7 || l === 6) {
                if (m === "GET") {
                  if (l >= 7) return { data: $40, params: { "id": s[5], "tipo": s[7] } };
                }
              }
            }
            if (s[6] === "comentarios") {
              if (l === 6) {
                if (m === "POST") return { data: $41, params: { "id": s[5] } };
              }
            }
          }
        }
      }
      return { data: $42, params: { "_": s.slice(2).join("/") } };
    }
  };
})();
const globalMiddleware = [
  toEventHandler(_qNHMnr)
].filter(Boolean);
function useNitroApp() {
  return useNitroApp.__instance__ ??= initNitroApp();
}
function initNitroApp() {
  const nitroApp2 = createNitroApp();
  {
    for (const plugin of plugins) {
      try {
        plugin(nitroApp2);
      } catch (error) {
        nitroApp2.captureError?.(error, { tags: ["plugin"] });
        throw error;
      }
    }
  }
  globalThis.__nitro__ = nitroApp2;
  return nitroApp2;
}
function createNitroApp() {
  const hooks = new HookableCore();
  const captureError = (error, errorCtx) => {
    const promise = hooks.callHook("error", error, errorCtx)?.catch?.((hookError) => {
      console.error("Error while capturing another error", hookError);
    });
    if (errorCtx?.event) {
      const errors = errorCtx.event.req.context?.nitro?.errors;
      if (errors) {
        errors.push({
          error,
          context: errorCtx
        });
      }
      if (typeof errorCtx.event.req.waitUntil === "function") {
        errorCtx.event.req.waitUntil(promise);
      }
    }
  };
  const h3App = createH3App({ onError(error, event) {
    captureError(error, { event });
    return errorHandler(error, event);
  } });
  {
    h3App.config.onRequest = (event) => {
      return hooks.callHook("request", event)?.catch?.((error) => {
        captureError(error, {
          event,
          tags: ["request"]
        });
      });
    };
    h3App.config.onResponse = (res, event) => {
      return hooks.callHook("response", res, event)?.catch?.((error) => {
        captureError(error, {
          event,
          tags: ["response"]
        });
      });
    };
  }
  let appHandler = (req) => {
    req.context ||= {};
    req.context.nitro = req.context.nitro || { errors: [] };
    return h3App.fetch(req);
  };
  const app = {
    fetch: appHandler,
    h3: h3App,
    hooks,
    captureError
  };
  return app;
}
function createH3App(config) {
  const h3App = new H3Core(config);
  h3App["~findRoute"] = (event) => findRoute(event.req.method, event.url.pathname);
  h3App["~middleware"].push(...globalMiddleware);
  {
    h3App["~getMiddleware"] = (event, route) => {
      const pathname = event.url.pathname;
      const method = event.req.method;
      const middleware = [];
      {
        const routeRules = getRouteRules(method, pathname);
        event.context.routeRules = routeRules?.routeRules;
        if (routeRules?.routeRuleMiddleware.length) {
          middleware.push(...routeRules.routeRuleMiddleware);
        }
      }
      middleware.push(...h3App["~middleware"]);
      if (route?.data?.middleware?.length) {
        middleware.push(...route.data.middleware);
      }
      return middleware;
    };
  }
  return h3App;
}
function getRouteRules(method, pathname) {
  const m = findRouteRules(method, pathname);
  if (!m?.length) {
    return { routeRuleMiddleware: [] };
  }
  const routeRules = {};
  for (const layer of m) {
    for (const rule of layer.data) {
      const currentRule = routeRules[rule.name];
      if (currentRule) {
        if (rule.options === false) {
          delete routeRules[rule.name];
          continue;
        }
        if (typeof currentRule.options === "object" && typeof rule.options === "object") {
          currentRule.options = {
            ...currentRule.options,
            ...rule.options
          };
        } else {
          currentRule.options = rule.options;
        }
        currentRule.route = rule.route;
        currentRule.params = {
          ...currentRule.params,
          ...layer.params
        };
      } else if (rule.options !== false) {
        routeRules[rule.name] = {
          ...rule,
          params: layer.params
        };
      }
    }
  }
  const middleware = [];
  for (const rule of Object.values(routeRules)) {
    if (rule.options === false || !rule.handler) {
      continue;
    }
    middleware.push(rule.handler(rule));
  }
  return {
    routeRules,
    routeRuleMiddleware: middleware
  };
}
function _captureError(error, type) {
  console.error(`[${type}]`, error);
  useNitroApp().captureError?.(error, { tags: [type] });
}
function trapUnhandledErrors() {
  process.on("unhandledRejection", (error) => _captureError(error, "unhandledRejection"));
  process.on("uncaughtException", (error) => _captureError(error, "uncaughtException"));
}
const port = Number.parseInt(process.env.NITRO_PORT || process.env.PORT || "") || 3e3;
const host = process.env.NITRO_HOST || process.env.HOST;
const cert = process.env.NITRO_SSL_CERT;
const key = process.env.NITRO_SSL_KEY;
const nitroApp = useNitroApp();
serve({
  port,
  hostname: host,
  tls: cert && key ? {
    cert,
    key
  } : void 0,
  fetch: nitroApp.fetch
});
trapUnhandledErrors();
const nodeServer = {};
function fetchViteEnv(viteEnvName, input, init) {
  const envs = globalThis.__nitro_vite_envs__ || {};
  const viteEnv = envs[viteEnvName];
  if (!viteEnv) {
    throw HTTPError.status(404);
  }
  return Promise.resolve(viteEnv.fetch(toRequest(input, init)));
}
function ssrRenderer({ req }) {
  return fetchViteEnv("ssr", req);
}
const ssrRenderer$1 = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  default: ssrRenderer
});
export {
  listarAprobacionesRevisionDrizzle as A,
  obtenerUsuarioRolPorIdDrizzle as B,
  getQuery as C,
  listarProyectosEnviadosRevisionDrizzle as D,
  listarComentariosRevisionDrizzle as E,
  upsertAprobacionRevisionDrizzle as F,
  actualizarProyectoCamposDrizzle as G,
  obtenerArchivoProyectoPorTipoDrizzle as H,
  setResponseHeader as I,
  crearComentarioRevisionDrizzle as J,
  listarUsuariosConDrizzle as K,
  NullProtoObj as N,
  listarUsuariosAdminDrizzle as a,
  actualizarRolUsuarioDrizzle as b,
  generarHashCodigoVerificacion as c,
  defineEventHandler as d,
  nodeServer as default,
  existeRolDrizzle as e,
  codigoVerificacionExpiraEn as f,
  generarCodigoVerificacion as g,
  actualizarCodigoRecuperacionUsuarioDrizzle as h,
  enviarCodigoRecuperacionContrasena as i,
  compararHashCodigoVerificacion as j,
  incrementarIntentosRecuperacionDrizzle as k,
  listarRolesDrizzle as l,
  obtenerUsuarioVerificacionPorIdentificadorCorreoDrizzle as m,
  actualizarCodigoVerificacionUsuarioDrizzle as n,
  obtenerUsuarioRecuperacionPorCurpDrizzle as o,
  enviarCodigoVerificacionRegistro as p,
  incrementarIntentosCodigoVerificacionDrizzle as q,
  readBody as r,
  segundosParaReenvioPermitido as s,
  confirmarCorreoVerificadoDrizzle as t,
  enviarConfirmacionRegistroCompletado as u,
  validarCodigoVerificacion as v,
  getUsuarioIdDesdeSesion as w,
  setResponseStatus as x,
  obtenerProyectoDetalleDrizzle as y,
  listarComentariosRevisionProyectoDrizzle as z
};
