import { d as defineEventHandler, K as listarUsuariosConDrizzle } from "../../../../index.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
const drizzleUsuarios_get = defineEventHandler(async () => {
  try {
    const usuarios = await listarUsuariosConDrizzle();
    return {
      success: true,
      total: usuarios.length,
      usuarios
    };
  } catch (error) {
    console.error("Error en prueba Drizzle usuarios:", error);
    return {
      success: false,
      error: "No se pudo consultar usuarios con Drizzle",
      total: 0,
      usuarios: []
    };
  }
});
export {
  drizzleUsuarios_get as default
};
