import { d as defineEventHandler, w as getUsuarioIdDesdeSesion, x as setResponseStatus, B as obtenerUsuarioRolPorIdDrizzle, C as getQuery, y as obtenerProyectoDetalleDrizzle, E as listarComentariosRevisionDrizzle, A as listarAprobacionesRevisionDrizzle } from "../../../../../index.mjs";
import { p as parseComite, e as esAdminDesdeRolOId, o as obtenerComiteDesdeRolOId, P as PASOS_POR_COMITE, T as TIPOS_ARCHIVO_POR_PASO, N as NOMBRES_PASO } from "../../../../_/comites.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
const _id__get = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return { success: false, error: "No autorizado" };
  }
  const usuario = await obtenerUsuarioRolPorIdDrizzle(usuarioId);
  const query = getQuery(event);
  const solicitado = parseComite(query.comite);
  const admin = esAdminDesdeRolOId(usuario?.rol_nombre, usuario?.rol_id);
  const comite = admin ? solicitado ?? 1 : obtenerComiteDesdeRolOId(usuario?.rol_nombre, usuario?.rol_id);
  if (comite == null) {
    setResponseStatus(event, 403);
    return { success: false, error: "Sin permisos de comité" };
  }
  const id = event.context.params?.id;
  if (!id) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID requerido" };
  }
  const proyectoId = parseInt(id, 10);
  if (Number.isNaN(proyectoId) || proyectoId < 1) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID no válido" };
  }
  try {
    const detalle = await obtenerProyectoDetalleDrizzle(proyectoId);
    if (!detalle) {
      setResponseStatus(event, 404);
      return { success: false, error: "Proyecto no encontrado" };
    }
    if (detalle.proyecto.estado !== "enviado" && detalle.proyecto.estado !== "aprobado") {
      setResponseStatus(event, 404);
      return { success: false, error: "Solo se pueden revisar proyectos enviados o aprobados" };
    }
    const pasosPermitidos = PASOS_POR_COMITE[comite];
    const setPasosPermitidos = new Set(pasosPermitidos);
    const datosFiltrados = {};
    for (const paso of pasosPermitidos) {
      if (Object.prototype.hasOwnProperty.call(detalle.datosPorPaso, paso)) {
        datosFiltrados[paso] = detalle.datosPorPaso[paso];
      }
    }
    const tiposArchivoPermitidos = pasosPermitidos.flatMap((paso) => TIPOS_ARCHIVO_POR_PASO[paso] ?? []);
    const setTiposArchivoPermitidos = new Set(tiposArchivoPermitidos);
    const archivosFiltrados = detalle.archivos.filter((archivo) => setTiposArchivoPermitidos.has(archivo.tipo_archivo));
    const comentarios = await listarComentariosRevisionDrizzle(proyectoId, comite);
    const comentariosFiltrados = comentarios.filter((c) => setPasosPermitidos.has(c.paso));
    const aprobaciones = await listarAprobacionesRevisionDrizzle(proyectoId);
    return {
      success: true,
      comite,
      pasosPermitidos,
      nombresPaso: NOMBRES_PASO,
      proyecto: {
        id: detalle.proyecto.id,
        estado: detalle.proyecto.estado,
        paso_actual: detalle.proyecto.paso_actual,
        fecha_creacion: detalle.proyecto.fecha_creacion,
        fecha_actualizacion: detalle.proyecto.fecha_actualizacion
      },
      datosPorPaso: datosFiltrados,
      archivos: archivosFiltrados,
      comentarios: comentariosFiltrados,
      aprobaciones
    };
  } catch (err) {
    return { success: false, error: "Error al cargar detalle de revisión" };
  }
});
export {
  _id__get as default
};
