import { d as defineEventHandler, w as getUsuarioIdDesdeSesion, x as setResponseStatus, B as obtenerUsuarioRolPorIdDrizzle, C as getQuery, r as readBody, y as obtenerProyectoDetalleDrizzle, J as crearComentarioRevisionDrizzle } from "../../../../../../index.mjs";
import { p as parseComite, e as esAdminDesdeRolOId, o as obtenerComiteDesdeRolOId, P as PASOS_POR_COMITE } from "../../../../../_/comites.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
const comentarios_post = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return { success: false, error: "No autorizado" };
  }
  const usuario = await obtenerUsuarioRolPorIdDrizzle(usuarioId);
  const query = getQuery(event);
  const solicitado = parseComite(query.comite);
  const admin = esAdminDesdeRolOId(usuario?.rol_nombre, usuario?.rol_id);
  const comite = admin ? solicitado ?? 1 : obtenerComiteDesdeRolOId(usuario?.rol_nombre, usuario?.rol_id);
  if (comite == null) {
    setResponseStatus(event, 403);
    return { success: false, error: "Sin permisos de comité" };
  }
  const id = event.context.params?.id;
  if (!id) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID requerido" };
  }
  const proyectoId = parseInt(id, 10);
  if (Number.isNaN(proyectoId) || proyectoId < 1) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID no válido" };
  }
  const body = await readBody(event).catch(() => null);
  if (!body || typeof body !== "object") {
    setResponseStatus(event, 400);
    return { success: false, error: "Datos requeridos" };
  }
  const payload = body;
  const paso = payload.paso != null ? parseInt(String(payload.paso), 10) : NaN;
  const comentario = String(payload.comentario || "").trim();
  if (Number.isNaN(paso) || paso < 0 || paso > 7) {
    setResponseStatus(event, 400);
    return { success: false, error: "Paso no válido" };
  }
  if (!comentario) {
    setResponseStatus(event, 400);
    return { success: false, error: "Comentario requerido" };
  }
  const pasosPermitidos = PASOS_POR_COMITE[comite];
  if (!pasosPermitidos.includes(paso)) {
    setResponseStatus(event, 403);
    return { success: false, error: "No puede comentar este paso" };
  }
  const detalle = await obtenerProyectoDetalleDrizzle(proyectoId);
  if (!detalle || detalle.proyecto.estado !== "enviado" && detalle.proyecto.estado !== "aprobado") {
    setResponseStatus(event, 404);
    return { success: false, error: "Proyecto no disponible para revisión" };
  }
  try {
    const comentarioId = await crearComentarioRevisionDrizzle({
      proyectoId,
      comite,
      paso,
      comentario,
      usuarioId
    });
    return { success: true, id: comentarioId };
  } catch (err) {
    return { success: false, error: "No se pudo guardar el comentario" };
  }
});
export {
  comentarios_post as default
};
