import { readFile } from "node:fs/promises";
import { join } from "node:path";
import { d as defineEventHandler, w as getUsuarioIdDesdeSesion, x as setResponseStatus, B as obtenerUsuarioRolPorIdDrizzle, C as getQuery, y as obtenerProyectoDetalleDrizzle, H as obtenerArchivoProyectoPorTipoDrizzle, I as setResponseHeader } from "../../../../../../../index.mjs";
import { p as parseComite, e as esAdminDesdeRolOId, o as obtenerComiteDesdeRolOId, P as PASOS_POR_COMITE, T as TIPOS_ARCHIVO_POR_PASO } from "../../../../../../_/comites.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs";
import "node:url";
function getUploadDir() {
  const base = process.env.UPLOAD_DIR?.trim() || join(process.cwd(), "uploads");
  return base;
}
const _tipo__get = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return null;
  }
  const usuario = await obtenerUsuarioRolPorIdDrizzle(usuarioId);
  const query = getQuery(event);
  const solicitado = parseComite(query.comite);
  const admin = esAdminDesdeRolOId(usuario?.rol_nombre, usuario?.rol_id);
  const comite = admin ? solicitado ?? 1 : obtenerComiteDesdeRolOId(usuario?.rol_nombre, usuario?.rol_id);
  if (comite == null) {
    setResponseStatus(event, 403);
    return null;
  }
  const id = event.context.params?.id;
  const tipo = event.context.params?.tipo;
  if (!id || !tipo) {
    setResponseStatus(event, 400);
    return null;
  }
  const proyectoId = parseInt(id, 10);
  if (Number.isNaN(proyectoId) || proyectoId < 1) {
    setResponseStatus(event, 400);
    return null;
  }
  const detalle = await obtenerProyectoDetalleDrizzle(proyectoId);
  if (!detalle || detalle.proyecto.estado !== "enviado" && detalle.proyecto.estado !== "aprobado") {
    setResponseStatus(event, 404);
    return null;
  }
  const pasosPermitidos = PASOS_POR_COMITE[comite];
  const tiposArchivoPermitidos = new Set(
    pasosPermitidos.flatMap((paso) => TIPOS_ARCHIVO_POR_PASO[paso] ?? [])
  );
  if (!tiposArchivoPermitidos.has(tipo)) {
    setResponseStatus(event, 403);
    return null;
  }
  const archivo = await obtenerArchivoProyectoPorTipoDrizzle(proyectoId, tipo);
  if (!archivo) {
    setResponseStatus(event, 404);
    return null;
  }
  const rutaCompleta = join(getUploadDir(), archivo.ruta_servidor);
  try {
    const buffer = await readFile(rutaCompleta);
    const filename = archivo.nombre_original || `${tipo}.pdf`;
    setResponseHeader(event, "Content-Type", "application/pdf");
    setResponseHeader(event, "Content-Disposition", `inline; filename="${filename}"`);
    return buffer;
  } catch {
    setResponseStatus(event, 404);
    return null;
  }
});
export {
  _tipo__get as default
};
