import { d as defineEventHandler, w as getUsuarioIdDesdeSesion, x as setResponseStatus, B as obtenerUsuarioRolPorIdDrizzle, C as getQuery, y as obtenerProyectoDetalleDrizzle, F as upsertAprobacionRevisionDrizzle, A as listarAprobacionesRevisionDrizzle, G as actualizarProyectoCamposDrizzle } from "../../../../../../index.mjs";
import { p as parseComite, e as esAdminDesdeRolOId, o as obtenerComiteDesdeRolOId } from "../../../../../_/comites.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
const COMITES_REQUERIDOS = [1, 2, 3];
const aprobar_post = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return { success: false, error: "No autorizado" };
  }
  const usuario = await obtenerUsuarioRolPorIdDrizzle(usuarioId);
  const query = getQuery(event);
  const solicitado = parseComite(query.comite);
  const admin = esAdminDesdeRolOId(usuario?.rol_nombre, usuario?.rol_id);
  const comite = admin ? solicitado ?? 1 : obtenerComiteDesdeRolOId(usuario?.rol_nombre, usuario?.rol_id);
  if (comite == null) {
    setResponseStatus(event, 403);
    return { success: false, error: "Sin permisos de comité" };
  }
  const id = event.context.params?.id;
  if (!id) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID requerido" };
  }
  const proyectoId = parseInt(id, 10);
  if (Number.isNaN(proyectoId) || proyectoId < 1) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID no válido" };
  }
  const detalle = await obtenerProyectoDetalleDrizzle(proyectoId);
  if (!detalle || detalle.proyecto.estado !== "enviado" && detalle.proyecto.estado !== "aprobado") {
    setResponseStatus(event, 404);
    return { success: false, error: "Proyecto no disponible para revisión" };
  }
  try {
    await upsertAprobacionRevisionDrizzle({
      proyectoId,
      comite,
      aprobado: 1,
      usuarioId
    });
    const aprobaciones = await listarAprobacionesRevisionDrizzle(proyectoId);
    const aprobados = new Set(
      aprobaciones.filter((a) => a.aprobado === 1).map((a) => a.comite).filter((c) => c === 1 || c === 2 || c === 3)
    );
    const completo = COMITES_REQUERIDOS.every((c) => aprobados.has(c));
    if (completo) {
      await actualizarProyectoCamposDrizzle(proyectoId, { estado: "aprobado" });
    }
    return {
      success: true,
      comite,
      aprobadoComite: true,
      aprobadoFinal: completo,
      aprobaciones
    };
  } catch (err) {
    return { success: false, error: "No se pudo registrar la aprobación" };
  }
});
export {
  aprobar_post as default
};
