import { d as defineEventHandler, w as getUsuarioIdDesdeSesion, x as setResponseStatus, B as obtenerUsuarioRolPorIdDrizzle, C as getQuery, D as listarProyectosEnviadosRevisionDrizzle } from "../../../../index.mjs";
import { p as parseComite, e as esAdminDesdeRolOId, o as obtenerComiteDesdeRolOId } from "../../../_/comites.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
const proyectos_get = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return { success: false, error: "No autorizado", proyectos: [] };
  }
  const usuario = await obtenerUsuarioRolPorIdDrizzle(usuarioId);
  const query = getQuery(event);
  const solicitado = parseComite(query.comite);
  const admin = esAdminDesdeRolOId(usuario?.rol_nombre, usuario?.rol_id);
  const comite = admin ? solicitado ?? 1 : obtenerComiteDesdeRolOId(usuario?.rol_nombre, usuario?.rol_id);
  if (comite == null) {
    setResponseStatus(event, 403);
    return { success: false, error: "Sin permisos de comité", proyectos: [] };
  }
  try {
    const proyectos = await listarProyectosEnviadosRevisionDrizzle();
    return {
      success: true,
      comite,
      proyectos
    };
  } catch (err) {
    return { success: false, error: "Error al listar proyectos enviados", proyectos: [] };
  }
});
export {
  proyectos_get as default
};
