import { d as defineEventHandler, w as getUsuarioIdDesdeSesion, x as setResponseStatus, y as obtenerProyectoDetalleDrizzle, z as listarComentariosRevisionProyectoDrizzle, A as listarAprobacionesRevisionDrizzle } from "../../../../../index.mjs";
import { N as NOMBRES_PASO } from "../../../../_/comites.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
const comentariosRevision_get = defineEventHandler(async (event) => {
  const usuarioId = getUsuarioIdDesdeSesion(event);
  if (usuarioId == null) {
    setResponseStatus(event, 401);
    return { success: false, error: "No autorizado" };
  }
  const id = event.context.params?.id;
  if (!id) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID requerido" };
  }
  const proyectoId = parseInt(id, 10);
  if (Number.isNaN(proyectoId) || proyectoId < 1) {
    setResponseStatus(event, 400);
    return { success: false, error: "ID no válido" };
  }
  try {
    const detalle = await obtenerProyectoDetalleDrizzle(proyectoId);
    if (!detalle) {
      setResponseStatus(event, 404);
      return { success: false, error: "Proyecto no encontrado" };
    }
    if (detalle.proyecto.usuario_id !== usuarioId) {
      setResponseStatus(event, 403);
      return { success: false, error: "No tiene permiso para este proyecto" };
    }
    const [comentarios, aprobaciones] = await Promise.all([
      listarComentariosRevisionProyectoDrizzle(proyectoId),
      listarAprobacionesRevisionDrizzle(proyectoId)
    ]);
    return {
      success: true,
      comentarios,
      aprobaciones,
      nombresPaso: NOMBRES_PASO
    };
  } catch {
    return { success: false, error: "Error al obtener comentarios de revisión" };
  }
});
export {
  comentariosRevision_get as default
};
