import { d as defineEventHandler, r as readBody, v as validarCodigoVerificacion, m as obtenerUsuarioVerificacionPorIdentificadorCorreoDrizzle, j as compararHashCodigoVerificacion, q as incrementarIntentosCodigoVerificacionDrizzle, t as confirmarCorreoVerificadoDrizzle, u as enviarConfirmacionRegistroCompletado } from "../../../../index.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
const verificarCorreoRegistro_post = defineEventHandler(async (event) => {
  const body = await readBody(event).catch(() => null);
  if (!body || typeof body !== "object") {
    return { success: false, error: "Datos requeridos" };
  }
  const payload = body;
  const nacionalidad = String(payload.nacionalidad || "").trim();
  const curp = String(payload.curp || "").trim().toUpperCase();
  const identificacion = String(payload.identificacion || "").trim();
  const correo = String(payload.correo || "").trim().toLowerCase();
  const codigo = String(payload.codigo || "").trim();
  if (!correo || !correo.includes("@")) {
    return { success: false, error: "Correo inválido" };
  }
  if (!validarCodigoVerificacion(codigo)) {
    return { success: false, error: "Código inválido" };
  }
  const usaCurp = nacionalidad === "mexicana";
  const identificador = usaCurp ? curp : identificacion;
  if (!identificador) {
    return { success: false, error: "Identificador inválido" };
  }
  try {
    const usuario = await obtenerUsuarioVerificacionPorIdentificadorCorreoDrizzle({
      usaCurp,
      identificador,
      correo
    });
    if (!usuario) {
      return { success: false, error: "No se encontró un registro pendiente para ese correo" };
    }
    if (usuario.correo_verificado === 1) {
      return { success: true };
    }
    const intentos = Number(usuario.codigo_verificacion_intentos || 0);
    if (intentos >= 5) {
      return {
        success: false,
        error: "Se alcanzó el límite de intentos. Solicite un nuevo código.",
        requiereReenvio: true
      };
    }
    const hash = String(usuario.codigo_verificacion_hash || "").trim();
    const expiraRaw = usuario.codigo_verificacion_expira;
    if (!hash || !expiraRaw) {
      return {
        success: false,
        error: "No hay código activo. Solicite un nuevo código.",
        requiereReenvio: true
      };
    }
    const expiraFecha = new Date(expiraRaw);
    if (Number.isNaN(expiraFecha.getTime()) || expiraFecha.getTime() < Date.now()) {
      return {
        success: false,
        error: "El código expiró. Solicite uno nuevo.",
        requiereReenvio: true
      };
    }
    const coincide = compararHashCodigoVerificacion(codigo, correo, hash);
    if (!coincide) {
      await incrementarIntentosCodigoVerificacionDrizzle(usuario.id);
      return { success: false, error: "Código incorrecto" };
    }
    await confirmarCorreoVerificadoDrizzle(usuario.id);
    try {
      await enviarConfirmacionRegistroCompletado({
        correo,
        nacionalidad: String(usuario.nacionalidad || nacionalidad),
        curp: usuario.curp,
        identificacion: usuario.identificacion,
        nombreCompleto: `${String(usuario.nombre || "").trim()} ${String(usuario.apellidos || "").trim()}`.trim()
      });
    } catch (error) {
      console.error("Error enviando correo de confirmación de registro:", error);
    }
    return { success: true };
  } catch {
    return { success: false, error: "Error al verificar el código" };
  }
});
export {
  verificarCorreoRegistro_post as default
};
