import { d as defineEventHandler, r as readBody, m as obtenerUsuarioVerificacionPorIdentificadorCorreoDrizzle, s as segundosParaReenvioPermitido, g as generarCodigoVerificacion, c as generarHashCodigoVerificacion, f as codigoVerificacionExpiraEn, n as actualizarCodigoVerificacionUsuarioDrizzle, p as enviarCodigoVerificacionRegistro } from "../../../../index.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
const registroReenviarCodigo_post = defineEventHandler(async (event) => {
  const body = await readBody(event).catch(() => null);
  if (!body || typeof body !== "object") {
    return { success: false, error: "Datos requeridos" };
  }
  const payload = body;
  const nacionalidad = String(payload.nacionalidad || "").trim();
  const curp = String(payload.curp || "").trim().toUpperCase();
  const identificacion = String(payload.identificacion || "").trim();
  const correo = String(payload.correo || "").trim().toLowerCase();
  const usaCurp = nacionalidad === "mexicana";
  const identificador = usaCurp ? curp : identificacion;
  if (!identificador || !correo) {
    return { success: false, error: "Datos incompletos para reenviar código" };
  }
  try {
    const usuario = await obtenerUsuarioVerificacionPorIdentificadorCorreoDrizzle({
      usaCurp,
      identificador,
      correo
    });
    if (!usuario) {
      return { success: false, error: "No se encontró el registro" };
    }
    if (usuario.correo_verificado === 1) {
      return { success: false, error: "El correo ya fue verificado" };
    }
    const segundosRestantes = segundosParaReenvioPermitido(usuario.codigo_verificacion_ultimo_envio);
    if (segundosRestantes > 0) {
      return {
        success: false,
        error: `Espere ${segundosRestantes}s para reenviar el código`,
        segundosRestantes
      };
    }
    const codigo = generarCodigoVerificacion();
    const codigoHash = generarHashCodigoVerificacion(codigo, correo);
    const codigoExpira = codigoVerificacionExpiraEn();
    await actualizarCodigoVerificacionUsuarioDrizzle({
      id: usuario.id,
      codigoHash,
      codigoExpira
    });
    try {
      await enviarCodigoVerificacionRegistro(correo, codigo);
      return { success: true, segundosRestantes: 60 };
    } catch {
      return { success: false, error: "No se pudo reenviar el código" };
    }
  } catch {
    return { success: false, error: "Error al reenviar el código" };
  }
});
export {
  registroReenviarCodigo_post as default
};
