import { d as defineEventHandler, r as readBody, v as validarCodigoVerificacion, o as obtenerUsuarioRecuperacionPorCurpDrizzle, j as compararHashCodigoVerificacion, k as incrementarIntentosRecuperacionDrizzle } from "../../../../index.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
const recuperacionVerificarCodigo_post = defineEventHandler(async (event) => {
  const body = await readBody(event).catch(() => null);
  if (!body || typeof body !== "object") {
    return { success: false, error: "Datos requeridos" };
  }
  const payload = body;
  const curp = String(payload.curp || "").trim().toUpperCase();
  const codigo = String(payload.codigo || "").trim();
  if (curp.length !== 18 || !/^[A-Z0-9]{18}$/.test(curp)) {
    return { success: false, error: "CURP inválido" };
  }
  if (!validarCodigoVerificacion(codigo)) {
    return { success: false, error: "Código inválido" };
  }
  try {
    const usuario = await obtenerUsuarioRecuperacionPorCurpDrizzle(curp);
    if (!usuario) {
      return { success: false, error: "Usuario no encontrado" };
    }
    const intentos = Number(usuario.codigo_recuperacion_intentos || 0);
    if (intentos >= 5) {
      return {
        success: false,
        error: "Se alcanzó el límite de intentos. Solicite un nuevo código.",
        requiereReenvio: true
      };
    }
    const correo = String(usuario.correo || "").trim().toLowerCase();
    const hash = String(usuario.codigo_recuperacion_hash || "").trim();
    const expiraRaw = usuario.codigo_recuperacion_expira;
    if (!correo || !hash || !expiraRaw) {
      return {
        success: false,
        error: "No hay código activo. Solicite un nuevo código.",
        requiereReenvio: true
      };
    }
    const expiraFecha = new Date(expiraRaw);
    if (Number.isNaN(expiraFecha.getTime()) || expiraFecha.getTime() < Date.now()) {
      return {
        success: false,
        error: "El código expiró. Solicite uno nuevo.",
        requiereReenvio: true
      };
    }
    const coincide = compararHashCodigoVerificacion(codigo, correo, hash);
    if (!coincide) {
      await incrementarIntentosRecuperacionDrizzle(usuario.id);
      return { success: false, error: "Código incorrecto" };
    }
    return { success: true };
  } catch {
    return { success: false, error: "Error al verificar el código" };
  }
});
export {
  recuperacionVerificarCodigo_post as default
};
