import { d as defineEventHandler, r as readBody, o as obtenerUsuarioRecuperacionPorCurpDrizzle, s as segundosParaReenvioPermitido, g as generarCodigoVerificacion, c as generarHashCodigoVerificacion, f as codigoVerificacionExpiraEn, h as actualizarCodigoRecuperacionUsuarioDrizzle, i as enviarCodigoRecuperacionContrasena } from "../../../../index.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
function enmascararCorreo(correo) {
  const [usuario, dominio] = correo.split("@");
  if (!usuario || !dominio) {
    return correo;
  }
  if (usuario.length <= 2) {
    return `${usuario[0] || "*"}*@${dominio}`;
  }
  return `${usuario.slice(0, 2)}***@${dominio}`;
}
const recuperacionEnviarCodigo_post = defineEventHandler(async (event) => {
  const body = await readBody(event).catch(() => null);
  if (!body || typeof body !== "object") {
    return { success: false, error: "Datos requeridos" };
  }
  const payload = body;
  const curp = String(payload.curp || "").trim().toUpperCase();
  if (curp.length !== 18 || !/^[A-Z0-9]{18}$/.test(curp)) {
    return { success: false, error: "CURP inválido" };
  }
  try {
    const usuario = await obtenerUsuarioRecuperacionPorCurpDrizzle(curp);
    if (!usuario) {
      return { success: false, error: "No existe un usuario registrado con ese CURP" };
    }
    const correo = String(usuario.correo || "").trim().toLowerCase();
    if (!correo || !correo.includes("@")) {
      return { success: false, error: "La cuenta no tiene correo válido para recuperación" };
    }
    const segundosRestantes = segundosParaReenvioPermitido(usuario.codigo_recuperacion_ultimo_envio);
    if (segundosRestantes > 0) {
      return {
        success: false,
        error: `Espere ${segundosRestantes}s para reenviar el código`,
        segundosRestantes,
        correoEnmascarado: enmascararCorreo(correo)
      };
    }
    const codigo = generarCodigoVerificacion();
    const codigoHash = generarHashCodigoVerificacion(codigo, correo);
    const codigoExpira = codigoVerificacionExpiraEn();
    await actualizarCodigoRecuperacionUsuarioDrizzle({
      id: usuario.id,
      codigoHash,
      codigoExpira
    });
    try {
      await enviarCodigoRecuperacionContrasena(
        correo,
        codigo,
        `${String(usuario.nombre || "").trim()} ${String(usuario.apellidos || "").trim()}`.trim()
      );
    } catch (error) {
      console.error("Error enviando código de recuperación:", error);
      return { success: false, error: "No se pudo enviar el código de recuperación" };
    }
    return {
      success: true,
      correoEnmascarado: enmascararCorreo(correo),
      segundosRestantes: 60
    };
  } catch {
    return { success: false, error: "Error al generar código de recuperación" };
  }
});
export {
  recuperacionEnviarCodigo_post as default
};
