import { d as defineEventHandler, r as readBody, b as actualizarRolUsuarioDrizzle, e as existeRolDrizzle } from "../../../../../index.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
const _id__patch = defineEventHandler(async (event) => {
  const id = event.context.params?.id;
  if (!id) {
    return { success: false, error: "ID requerido" };
  }
  const idNum = parseInt(id, 10);
  if (Number.isNaN(idNum) || idNum < 1) {
    return { success: false, error: "ID no válido" };
  }
  const body = await readBody(event).catch(() => null);
  if (!body || typeof body !== "object") {
    return { success: false, error: "Datos requeridos" };
  }
  const payload = body;
  const rolId = payload.rol_id != null ? parseInt(String(payload.rol_id), 10) : null;
  if (rolId !== null && (Number.isNaN(rolId) || rolId < 1)) {
    return { success: false, error: "Rol no válido" };
  }
  try {
    if (rolId === null) {
      await actualizarRolUsuarioDrizzle(idNum, 1);
    } else {
      const existe = await existeRolDrizzle(rolId);
      if (!existe) {
        return { success: false, error: "Rol no existe" };
      }
      await actualizarRolUsuarioDrizzle(idNum, rolId);
    }
    return { success: true };
  } catch (err) {
    return { success: false, error: "Error al actualizar rol" };
  }
});
export {
  _id__patch as default
};
