import { d as defineEventHandler, a as listarUsuariosAdminDrizzle } from "../../../../index.mjs";
import "node:http";
import "node:stream";
import "node:https";
import "node:http2";
import "bcryptjs";
import "drizzle-orm";
import "drizzle-orm/mysql2";
import "drizzle-orm/mysql-core";
import "mysql2/promise";
import "node:crypto";
import "nodemailer";
import "node:fs/promises";
import "node:path";
import "node:fs";
import "node:url";
const usuarios_get = defineEventHandler(async () => {
  try {
    const rows = await listarUsuariosAdminDrizzle();
    const lista = rows.map((u) => ({
      id: u.id ?? 0,
      nombre: u.nombre,
      apellidos: u.apellidos,
      correo: u.correo,
      curp: u.curp,
      identificacion: u.identificacion,
      rol_id: u.rol_id ?? 0,
      rol_nombre: u.rol_nombre
    }));
    return { success: true, usuarios: lista };
  } catch (err) {
    return { success: false, error: "Error al listar usuarios", usuarios: [] };
  }
});
export {
  usuarios_get as default
};
