import { useState, useEffect } from "react";
import { useNavigate } from "@tanstack/react-router";
import { t as tieneSesionActiva } from "./router-5yTRMCgc.mjs";
function useRequireAuth() {
  const navigate = useNavigate();
  const [verificado, setVerificado] = useState(false);
  useEffect(() => {
    if (typeof window === "undefined") return;
    if (!tieneSesionActiva()) {
      navigate({ to: "/login" });
      return;
    }
    setVerificado(true);
  }, [navigate]);
  return verificado;
}
export {
  useRequireAuth as u
};
