import { jsx, jsxs } from "react/jsx-runtime";
import { HugeiconsIcon } from "@hugeicons/react";
import { Sun01Icon, Moon02Icon } from "@hugeicons/core-free-icons";
import { useState, useEffect } from "react";
import { u as useTheme } from "./router-5yTRMCgc.mjs";
import { B as Button } from "./button-Bp95UwA9.mjs";
function ThemeToggle() {
  const [mounted, setMounted] = useState(false);
  const { theme, setTheme } = useTheme();
  useEffect(() => {
    setMounted(true);
  }, []);
  if (!mounted) {
    return /* @__PURE__ */ jsx("div", { className: "h-8 w-8" });
  }
  return /* @__PURE__ */ jsxs(
    Button,
    {
      variant: "ghost",
      size: "icon",
      onClick: () => setTheme(theme === "light" ? "dark" : "light"),
      className: "h-8 w-8 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground",
      children: [
        /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Sun01Icon, className: "h-[1.2rem] w-[1.2rem] rotate-0 scale-100 transition-all dark:-rotate-90 dark:scale-0" }),
        /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Moon02Icon, className: "absolute h-[1.2rem] w-[1.2rem] rotate-90 scale-0 transition-all dark:rotate-0 dark:scale-100" }),
        /* @__PURE__ */ jsx("span", { className: "sr-only", children: "Toggle theme" })
      ]
    }
  );
}
export {
  ThemeToggle as T
};
