import { createRouter, createRootRoute, createFileRoute, lazyRouteComponent, redirect, HeadContent, Scripts } from "@tanstack/react-router";
import { jsx, jsxs } from "react/jsx-runtime";
import { useState, useEffect, createContext, useContext } from "react";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { useTheme as useTheme$1 } from "next-themes";
import { Toaster as Toaster$1 } from "sonner";
import { HugeiconsIcon } from "@hugeicons/react";
import { Loading03Icon, MultiplicationSignCircleIcon, Alert02Icon, InformationCircleIcon, CheckmarkCircle02Icon } from "@hugeicons/core-free-icons";
const initialState = {
  theme: "system",
  setTheme: () => null
};
const ThemeProviderContext = createContext(initialState);
function ThemeProvider({
  children,
  defaultTheme = "system",
  storageKey = "hjm-ui-theme",
  ...props
}) {
  const [theme, setTheme] = useState(() => {
    if (typeof window === "undefined") return defaultTheme;
    return localStorage.getItem(storageKey) || defaultTheme;
  });
  useEffect(() => {
    const root = window.document.documentElement;
    const resolved = theme === "system" ? window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light" : theme;
    if (root.classList.contains(resolved)) return;
    root.classList.remove("light", "dark");
    root.classList.add(resolved);
  }, [theme]);
  const value = {
    theme,
    setTheme: (theme2) => {
      if (typeof window !== "undefined") {
        localStorage.setItem(storageKey, theme2);
      }
      setTheme(theme2);
    }
  };
  return /* @__PURE__ */ jsx(ThemeProviderContext.Provider, { ...props, value, children });
}
const useTheme = () => {
  const context = useContext(ThemeProviderContext);
  if (context === void 0)
    throw new Error("useTheme must be used within a ThemeProvider");
  return context;
};
const Toaster = ({ ...props }) => {
  const { theme = "system" } = useTheme$1();
  return /* @__PURE__ */ jsx(
    Toaster$1,
    {
      theme,
      className: "toaster group",
      icons: {
        success: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: CheckmarkCircle02Icon, strokeWidth: 2, className: "size-4" }),
        info: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: InformationCircleIcon, strokeWidth: 2, className: "size-4" }),
        warning: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Alert02Icon, strokeWidth: 2, className: "size-4" }),
        error: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: MultiplicationSignCircleIcon, strokeWidth: 2, className: "size-4" }),
        loading: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Loading03Icon, strokeWidth: 2, className: "size-4 animate-spin" })
      },
      style: {
        "--normal-bg": "var(--popover)",
        "--normal-text": "var(--popover-foreground)",
        "--normal-border": "var(--border)",
        "--border-radius": "var(--radius)"
      },
      toastOptions: {
        classNames: {
          toast: "cn-toast"
        }
      },
      ...props
    }
  );
};
const BASE_PATH = "/investigacionv2";
const appVersion = "1.4.10";
function assetPath(path) {
  return `${BASE_PATH}${path}`;
}
function apiUrl(path) {
  return `${BASE_PATH}${path.startsWith("/") ? path : `/${path}`}`;
}
const Route$c = createRootRoute({
  head: () => ({
    meta: [
      {
        charSet: "utf-8"
      },
      {
        name: "viewport",
        content: "width=device-width, initial-scale=1"
      },
      {
        title: "Registro de Proyectos de Investigación - Hospital Juárez de México"
      },
      {
        name: "description",
        content: "Sistema de gestión y registro de proyectos de investigación de la División de Investigación del Hospital Juárez de México"
      }
    ],
    links: [
      {
        rel: "icon",
        type: "image/svg+xml",
        href: assetPath("/LogoHJM.svg"),
        media: "(prefers-color-scheme: light)"
      },
      {
        rel: "icon",
        type: "image/svg+xml",
        href: assetPath("/LogoHJM-dark.svg"),
        media: "(prefers-color-scheme: dark)"
      }
    ]
  }),
  shellComponent: RootDocument,
  notFoundComponent: NotFound
});
function RootDocument({ children }) {
  const [queryClient] = useState(
    () => new QueryClient({
      defaultOptions: {
        queries: {
          staleTime: 60 * 1e3
        }
      }
    })
  );
  const themeScript = `(function(){var k='hjm-rpi-theme';var t=localStorage.getItem(k);var d=t==='dark'||(t==='system'&&typeof matchMedia!=='undefined'&&matchMedia('(prefers-color-scheme: dark)').matches);document.documentElement.classList.add(d?'dark':'light');})();`;
  return /* @__PURE__ */ jsxs("html", { lang: "es", children: [
    /* @__PURE__ */ jsxs("head", { children: [
      /* @__PURE__ */ jsx("script", { dangerouslySetInnerHTML: { __html: themeScript } }),
      /* @__PURE__ */ jsx(HeadContent, {})
    ] }),
    /* @__PURE__ */ jsxs("body", { children: [
      /* @__PURE__ */ jsx(QueryClientProvider, { client: queryClient, children: /* @__PURE__ */ jsxs(ThemeProvider, { defaultTheme: "light", storageKey: "hjm-rpi-theme", children: [
        children,
        /* @__PURE__ */ jsx(Toaster, {})
      ] }) }),
      /* @__PURE__ */ jsx(Scripts, {})
    ] })
  ] });
}
function NotFound() {
  return /* @__PURE__ */ jsx("div", { className: "min-h-screen flex items-center justify-center bg-muted px-6", children: /* @__PURE__ */ jsxs("div", { className: "max-w-md text-center space-y-3", children: [
    /* @__PURE__ */ jsx("h1", { className: "text-2xl font-semibold text-foreground", children: "Página no encontrada" }),
    /* @__PURE__ */ jsx("p", { className: "text-sm text-muted-foreground", children: "La ruta solicitada no existe o fue movida." })
  ] }) });
}
const $$splitComponentImporter$b = () => import("./registro-DUCE-WzC.mjs");
const Route$b = createFileRoute("/registro")({
  component: lazyRouteComponent($$splitComponentImporter$b, "component")
});
const $$splitComponentImporter$a = () => import("./recuperar-password-BGtmVetl.mjs");
const Route$a = createFileRoute("/recuperar-password")({
  component: lazyRouteComponent($$splitComponentImporter$a, "component")
});
const $$splitComponentImporter$9 = () => import("./login-CzbyiIIE.mjs");
const Route$9 = createFileRoute("/login")({
  component: lazyRouteComponent($$splitComponentImporter$9, "component")
});
const STORAGE_KEY = "rpi:usuario";
const DURACION_SESION_MS = 8 * 60 * 60 * 1e3;
function getUsuarioSesion() {
  if (typeof window === "undefined") return null;
  if (!tieneSesionActiva()) return null;
  try {
    const raw = sessionStorage.getItem(STORAGE_KEY);
    if (!raw) return null;
    const parsed = JSON.parse(raw);
    if (!parsed || typeof parsed !== "object") return null;
    return parsed;
  } catch {
    return null;
  }
}
function tieneSesionActiva() {
  if (typeof window === "undefined") return false;
  try {
    const raw = sessionStorage.getItem(STORAGE_KEY);
    if (!raw) return false;
    const parsed = JSON.parse(raw);
    if (!parsed || typeof parsed !== "object") return false;
    const expiraEn = parsed.expiraEn;
    if (typeof expiraEn !== "number" || Date.now() > expiraEn) {
      sessionStorage.removeItem(STORAGE_KEY);
      return false;
    }
    return true;
  } catch {
    return false;
  }
}
function debeRedirigirALogin() {
  if (typeof window === "undefined") return false;
  return !tieneSesionActiva();
}
function esAdmin() {
  if (typeof window === "undefined") return false;
  if (!tieneSesionActiva()) return false;
  try {
    const raw = sessionStorage.getItem(STORAGE_KEY);
    if (!raw) return false;
    const parsed = JSON.parse(raw);
    return parsed?.rol_nombre === "Admin";
  } catch {
    return false;
  }
}
const $$splitComponentImporter$8 = () => import("./_layout-DlybarTu.mjs");
const Route$8 = createFileRoute("/_layout")({
  beforeLoad: () => {
    if (debeRedirigirALogin()) {
      throw redirect({
        to: "/login"
      });
    }
  },
  component: lazyRouteComponent($$splitComponentImporter$8, "component")
});
const $$splitComponentImporter$7 = () => import("./index-0YOFQomt.mjs");
const Route$7 = createFileRoute("/")({
  component: lazyRouteComponent($$splitComponentImporter$7, "component")
});
const $$splitComponentImporter$6 = () => import("./_layout.revision-D6KXdtkj.mjs");
function parseComiteSearch(value) {
  const num = Number(value);
  if (num === 1 || num === 2 || num === 3) return num;
  return void 0;
}
function parseProyectoSearch(value) {
  const num = Number(value);
  if (!Number.isInteger(num) || num <= 0) return void 0;
  return num;
}
const Route$6 = createFileRoute("/_layout/revision")({
  validateSearch: (s) => ({
    proyecto: parseProyectoSearch(s?.proyecto),
    comite: parseComiteSearch(s?.comite)
  }),
  component: lazyRouteComponent($$splitComponentImporter$6, "component")
});
const $$splitComponentImporter$5 = () => import("./_layout.registro-proyecto-CrVEU3_7.mjs");
const TOTAL_STEPS = 8;
const LAST_STEP_INDEX = TOTAL_STEPS - 1;
function parseStep(value) {
  const step = Number(value);
  if (!Number.isInteger(step)) return void 0;
  if (step < 0 || step > LAST_STEP_INDEX) return void 0;
  return step;
}
const Route$5 = createFileRoute("/_layout/registro-proyecto")({
  validateSearch: (s) => ({
    proyecto: s?.proyecto != null ? Number(s.proyecto) : void 0,
    paso: parseStep(s?.paso)
  }),
  component: lazyRouteComponent($$splitComponentImporter$5, "component")
});
const $$splitComponentImporter$4 = () => import("./_layout.prueba-drizzle-DY0XrcN8.mjs");
const Route$4 = createFileRoute("/_layout/prueba-drizzle")({
  component: lazyRouteComponent($$splitComponentImporter$4, "component")
});
const $$splitComponentImporter$3 = () => import("./_layout.proyectos-BWB-QsBO.mjs");
const Route$3 = createFileRoute("/_layout/proyectos")({
  component: lazyRouteComponent($$splitComponentImporter$3, "component")
});
const $$splitComponentImporter$2 = () => import("./_layout.inicio-fMbRbvUV.mjs");
const Route$2 = createFileRoute("/_layout/inicio")({
  component: lazyRouteComponent($$splitComponentImporter$2, "component")
});
const $$splitComponentImporter$1 = () => import("./_layout.documentacion-DMUyywSv.mjs");
const Route$1 = createFileRoute("/_layout/documentacion")({
  component: lazyRouteComponent($$splitComponentImporter$1, "component")
});
const $$splitComponentImporter = () => import("./_layout.admin.usuarios-DKcAX4so.mjs");
const Route = createFileRoute("/_layout/admin/usuarios")({
  component: lazyRouteComponent($$splitComponentImporter, "component")
});
const RegistroRoute = Route$b.update({
  id: "/registro",
  path: "/registro",
  getParentRoute: () => Route$c
});
const RecuperarPasswordRoute = Route$a.update({
  id: "/recuperar-password",
  path: "/recuperar-password",
  getParentRoute: () => Route$c
});
const LoginRoute = Route$9.update({
  id: "/login",
  path: "/login",
  getParentRoute: () => Route$c
});
const LayoutRoute = Route$8.update({
  id: "/_layout",
  getParentRoute: () => Route$c
});
const IndexRoute = Route$7.update({
  id: "/",
  path: "/",
  getParentRoute: () => Route$c
});
const LayoutRevisionRoute = Route$6.update({
  id: "/revision",
  path: "/revision",
  getParentRoute: () => LayoutRoute
});
const LayoutRegistroProyectoRoute = Route$5.update({
  id: "/registro-proyecto",
  path: "/registro-proyecto",
  getParentRoute: () => LayoutRoute
});
const LayoutPruebaDrizzleRoute = Route$4.update({
  id: "/prueba-drizzle",
  path: "/prueba-drizzle",
  getParentRoute: () => LayoutRoute
});
const LayoutProyectosRoute = Route$3.update({
  id: "/proyectos",
  path: "/proyectos",
  getParentRoute: () => LayoutRoute
});
const LayoutInicioRoute = Route$2.update({
  id: "/inicio",
  path: "/inicio",
  getParentRoute: () => LayoutRoute
});
const LayoutDocumentacionRoute = Route$1.update({
  id: "/documentacion",
  path: "/documentacion",
  getParentRoute: () => LayoutRoute
});
const LayoutAdminUsuariosRoute = Route.update({
  id: "/admin/usuarios",
  path: "/admin/usuarios",
  getParentRoute: () => LayoutRoute
});
const LayoutRouteChildren = {
  LayoutDocumentacionRoute,
  LayoutInicioRoute,
  LayoutProyectosRoute,
  LayoutPruebaDrizzleRoute,
  LayoutRegistroProyectoRoute,
  LayoutRevisionRoute,
  LayoutAdminUsuariosRoute
};
const LayoutRouteWithChildren = LayoutRoute._addFileChildren(LayoutRouteChildren);
const rootRouteChildren = {
  IndexRoute,
  LayoutRoute: LayoutRouteWithChildren,
  LoginRoute,
  RecuperarPasswordRoute,
  RegistroRoute
};
const routeTree = Route$c._addFileChildren(rootRouteChildren)._addFileTypes();
const getRouter = () => {
  const router2 = createRouter({
    routeTree,
    basepath: BASE_PATH,
    scrollRestoration: true,
    defaultPreloadStaleTime: 0
  });
  return router2;
};
const router = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  getRouter
}, Symbol.toStringTag, { value: "Module" }));
export {
  BASE_PATH as B,
  DURACION_SESION_MS as D,
  Route$6 as R,
  assetPath as a,
  apiUrl as b,
  appVersion as c,
  Route$5 as d,
  esAdmin as e,
  getUsuarioSesion as g,
  router as r,
  tieneSesionActiva as t,
  useTheme as u
};
