import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { useNavigate, Link } from "@tanstack/react-router";
import { useState, useRef, useEffect } from "react";
import { HugeiconsIcon } from "@hugeicons/react";
import { Tick02Icon, IdentificationIcon, Mail01Icon, SmartPhone01Icon, LockedIcon, ViewOffSlashIcon, ViewIcon, ArrowLeft01Icon, ArrowRight01Icon, CheckmarkCircle02Icon } from "@hugeicons/core-free-icons";
import { C as Card, a as CardHeader, b as CardTitle, c as CardDescription, d as CardContent } from "./card-B_lDvuvx.mjs";
import { I as Input } from "./input-B66ag17B.mjs";
import { L as Label } from "./label-Cp5Wz1sX.mjs";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-D2Xe1kOZ.mjs";
import { B as Button } from "./button-Bp95UwA9.mjs";
import { P as Progress } from "./progress-YjR2HPKE.mjs";
import { Separator as Separator$1 } from "radix-ui";
import { c as cn } from "./utils-H80jjgLf.mjs";
import { S as Spinner } from "./spinner-jf2ZHWGj.mjs";
import { I as InputOTP, a as InputOTPGroup, b as InputOTPSlot } from "./input-otp-BqXXcLPx.mjs";
import { T as ThemeToggle } from "./theme-toggle-C2c9ak38.mjs";
import { A as AlertDialog, a as AlertDialogContent, b as AlertDialogHeader, c as AlertDialogTitle, d as AlertDialogDescription, e as AlertDialogFooter, f as AlertDialogCancel, g as AlertDialogMedia, h as AlertDialogAction } from "./alert-dialog-Da-A3hay.mjs";
import { a as assetPath, b as apiUrl, B as BASE_PATH } from "./router-5yTRMCgc.mjs";
import { REGEXP_ONLY_DIGITS } from "input-otp";
import "class-variance-authority";
import "clsx";
import "tailwind-merge";
import "@tanstack/react-query";
import "next-themes";
import "sonner";
function Separator({
  className,
  orientation = "horizontal",
  decorative = true,
  ...props
}) {
  return /* @__PURE__ */ jsx(
    Separator$1.Root,
    {
      "data-slot": "separator",
      decorative,
      orientation,
      className: cn(
        "bg-border shrink-0 data-[orientation=horizontal]:h-px data-[orientation=horizontal]:w-full data-[orientation=vertical]:w-px data-[orientation=vertical]:self-stretch",
        className
      ),
      ...props
    }
  );
}
const DOMINIOS_EMAIL = ["gmail.com", "outlook.com", "hotmail.com", "yahoo.com", "live.com", "icloud.com", "salud.gob.mx"];
function RegistroPage() {
  const navigate = useNavigate();
  const [isMounted, setIsMounted] = useState(false);
  const [currentStep, setCurrentStep] = useState(0);
  const [isLoadingCurp, setIsLoadingCurp] = useState(false);
  const [curpError, setCurpError] = useState("");
  const [curpDataLoaded, setCurpDataLoaded] = useState(false);
  const [curpYaRegistrado, setCurpYaRegistrado] = useState(false);
  const abortControllerRef = useRef(null);
  const [showPassword, setShowPassword] = useState(false);
  const [showConfirmPassword, setShowConfirmPassword] = useState(false);
  const [isSubmitting, setIsSubmitting] = useState(false);
  const [submitError, setSubmitError] = useState("");
  const [showExitoDialog, setShowExitoDialog] = useState(false);
  const [showVerificacionDialog, setShowVerificacionDialog] = useState(false);
  const [codigoVerificacion, setCodigoVerificacion] = useState("");
  const [errorVerificacion, setErrorVerificacion] = useState("");
  const [isVerificandoCodigo, setIsVerificandoCodigo] = useState(false);
  const [isReenviandoCodigo, setIsReenviandoCodigo] = useState(false);
  const [segundosRestantesReenvio, setSegundosRestantesReenvio] = useState(0);
  const [datosVerificacion, setDatosVerificacion] = useState(null);
  const [formData, setFormData] = useState({
    nacionalidad: "",
    curp: "",
    identificacion: "",
    nombre: "",
    apellidos: "",
    edad: "",
    genero: "",
    emailParte: "",
    emailDominio: "",
    lugarResidencia: "",
    formacionAcademica: "",
    institucionProcedencia: "",
    telefono: "",
    password: "",
    confirmacionPassword: ""
  });
  useEffect(() => {
    setIsMounted(true);
  }, []);
  useEffect(() => {
    if (segundosRestantesReenvio <= 0) {
      return;
    }
    const timer = setInterval(() => {
      setSegundosRestantesReenvio((prev) => prev > 0 ? prev - 1 : 0);
    }, 1e3);
    return () => clearInterval(timer);
  }, [segundosRestantesReenvio]);
  const steps = [{
    title: "Datos personales",
    description: "Nacionalidad, identificación y datos personales"
  }, {
    title: "Información",
    description: "Complete su perfil"
  }, {
    title: "Confirmación",
    description: "Confirme sus datos"
  }];
  const nextStep = () => {
    if (currentStep < steps.length - 1) {
      setCurrentStep(currentStep + 1);
    }
  };
  const prevStep = () => {
    if (currentStep > 0) {
      setCurrentStep(currentStep - 1);
    }
  };
  const handleInputChange = (field, value) => {
    setFormData((prev) => ({
      ...prev,
      [field]: value
    }));
  };
  const fetchCurpData = async (curp) => {
    if (curp.length !== 18) return;
    if (abortControllerRef.current) {
      abortControllerRef.current.abort();
    }
    abortControllerRef.current = new AbortController();
    setIsLoadingCurp(true);
    setCurpError("");
    try {
      const response = await fetch(`${BASE_PATH}/api/curp?curp=${curp}`, {
        signal: abortControllerRef.current.signal
      });
      if (!response.ok) {
        throw new Error(`Error ${response.status}: ${response.statusText}`);
      }
      const result = await response.json();
      if (result.success && result.data) {
        const resDisponible = await fetch(apiUrl(`/api/auth/curp-disponible?curp=${encodeURIComponent(curp)}`), {
          signal: abortControllerRef.current.signal
        });
        const dataDisponible = await resDisponible.json().catch(() => ({}));
        if (dataDisponible.disponible === false) {
          setCurpError("Este CURP ya está registrado");
          setCurpDataLoaded(false);
          setCurpYaRegistrado(true);
        } else {
          setCurpYaRegistrado(false);
          setFormData((prev) => ({
            ...prev,
            nombre: result.data.nombre || "",
            apellidos: `${result.data.apellidoPaterno || ""} ${result.data.apellidoMaterno || ""}`.trim(),
            edad: result.data.edad?.toString() || "",
            genero: result.data.sexo === "H" ? "masculino" : result.data.sexo === "M" ? "femenino" : ""
          }));
          setCurpDataLoaded(true);
        }
      } else {
        setCurpError(result.error || "No se encontraron datos para este CURP");
        setCurpDataLoaded(false);
      }
    } catch (error) {
      if (error instanceof Error && error.name === "AbortError") return;
      setCurpError(error instanceof Error ? error.message : "Error al consultar CURP");
    } finally {
      setIsLoadingCurp(false);
    }
  };
  const handleCurpChange = (value) => {
    const upperValue = value.toUpperCase();
    handleInputChange("curp", upperValue);
    setCurpError("");
    setCurpDataLoaded(false);
    setCurpYaRegistrado(false);
    if (upperValue.length === 18) {
      fetchCurpData(upperValue);
    }
  };
  const handleSubmit = async () => {
    setSubmitError("");
    setIsSubmitting(true);
    try {
      const res = await fetch(apiUrl("/api/auth/registro"), {
        method: "POST",
        headers: {
          "Content-Type": "application/json"
        },
        body: JSON.stringify({
          nacionalidad: formData.nacionalidad,
          curp: formData.curp,
          identificacion: formData.identificacion,
          nombre: formData.nombre,
          apellidos: formData.apellidos,
          edad: formData.edad,
          genero: formData.genero,
          emailParte: formData.emailParte.trim(),
          emailDominio: formData.emailDominio,
          lugarResidencia: formData.lugarResidencia,
          formacionAcademica: formData.formacionAcademica,
          institucionProcedencia: formData.institucionProcedencia,
          telefono: formData.telefono,
          password: formData.password
        })
      });
      const data = await res.json().catch(() => ({}));
      if (data.success) {
        setDatosVerificacion({
          nacionalidad: formData.nacionalidad,
          curp: formData.curp.trim().toUpperCase(),
          identificacion: formData.identificacion.trim(),
          correo: emailCompleto.toLowerCase()
        });
        setCodigoVerificacion("");
        setErrorVerificacion("");
        setSegundosRestantesReenvio(60);
        setShowVerificacionDialog(true);
        return;
      }
      setSubmitError(data.error || "Error al guardar el registro");
    } catch {
      setSubmitError("Error de conexión");
    } finally {
      setIsSubmitting(false);
    }
  };
  const handleVerificarCodigo = async () => {
    if (!datosVerificacion) {
      setErrorVerificacion("No hay datos de verificación disponibles");
      return;
    }
    const codigo = codigoVerificacion.trim();
    if (!/^\d{6}$/.test(codigo)) {
      setErrorVerificacion("Ingrese un código válido de 6 dígitos");
      return;
    }
    setErrorVerificacion("");
    setIsVerificandoCodigo(true);
    try {
      const res = await fetch(apiUrl("/api/auth/verificar-correo-registro"), {
        method: "POST",
        headers: {
          "Content-Type": "application/json"
        },
        body: JSON.stringify({
          nacionalidad: datosVerificacion.nacionalidad,
          curp: datosVerificacion.curp,
          identificacion: datosVerificacion.identificacion,
          correo: datosVerificacion.correo,
          codigo
        })
      });
      const data = await res.json().catch(() => ({}));
      if (data.success) {
        setShowVerificacionDialog(false);
        setShowExitoDialog(true);
        return;
      }
      setErrorVerificacion(data.error || "No se pudo verificar el código");
    } catch {
      setErrorVerificacion("Error de conexión");
    } finally {
      setIsVerificandoCodigo(false);
    }
  };
  const handleReenviarCodigo = async () => {
    if (!datosVerificacion) {
      return;
    }
    if (segundosRestantesReenvio > 0) {
      return;
    }
    setErrorVerificacion("");
    setIsReenviandoCodigo(true);
    try {
      const res = await fetch(apiUrl("/api/auth/registro-reenviar-codigo"), {
        method: "POST",
        headers: {
          "Content-Type": "application/json"
        },
        body: JSON.stringify({
          nacionalidad: datosVerificacion.nacionalidad,
          curp: datosVerificacion.curp,
          identificacion: datosVerificacion.identificacion,
          correo: datosVerificacion.correo
        })
      });
      const data = await res.json().catch(() => ({}));
      if (data.success) {
        setSegundosRestantesReenvio(typeof data.segundosRestantes === "number" ? data.segundosRestantes : 60);
        return;
      }
      if (typeof data.segundosRestantes === "number" && data.segundosRestantes > 0) {
        setSegundosRestantesReenvio(data.segundosRestantes);
      }
      setErrorVerificacion(data.error || "No se pudo reenviar el código");
    } catch {
      setErrorVerificacion("Error de conexión");
    } finally {
      setIsReenviandoCodigo(false);
    }
  };
  const canProceedFromStep0 = formData.nacionalidad === "mexicana" ? formData.curp.length === 18 && formData.nombre && formData.apellidos && formData.edad && formData.genero && !curpYaRegistrado : formData.nacionalidad === "extranjera" ? formData.identificacion.trim() && formData.nombre && formData.apellidos && formData.edad && formData.genero : false;
  const emailCompleto = formData.emailParte.trim() && formData.emailDominio ? `${formData.emailParte.trim()}@${formData.emailDominio}` : "";
  function fuerzaPassword(pwd) {
    if (!pwd) return {
      score: 0,
      label: ""
    };
    let score = 0;
    if (pwd.length >= 8) score += 25;
    if (pwd.length >= 12) score += 15;
    if (/[a-z]/.test(pwd) && /[A-Z]/.test(pwd)) score += 25;
    if (/\d/.test(pwd)) score += 20;
    if (/[^A-Za-z0-9]/.test(pwd)) score += 15;
    if (score >= 80) return {
      score: 100,
      label: "Fuerte"
    };
    if (score >= 55) return {
      score: 75,
      label: "Buena"
    };
    if (score >= 35) return {
      score: 50,
      label: "Regular"
    };
    if (score >= 25) return {
      score: 25,
      label: "Débil"
    };
    return {
      score: 0,
      label: ""
    };
  }
  const canProceedFromStep1 = formData.emailParte.trim() && formData.emailDominio && formData.lugarResidencia && formData.formacionAcademica && formData.institucionProcedencia && formData.telefono && formData.password.length >= 8 && formData.password === formData.confirmacionPassword;
  if (!isMounted) {
    return /* @__PURE__ */ jsx("div", { className: "min-h-screen bg-muted flex items-center justify-center", children: /* @__PURE__ */ jsx(Spinner, { className: "size-8 text-muted-foreground" }) });
  }
  return /* @__PURE__ */ jsxs("div", { className: "min-h-screen bg-muted flex flex-col", children: [
    /* @__PURE__ */ jsxs("header", { className: "sticky top-0 z-10 bg-muted", children: [
      /* @__PURE__ */ jsxs("div", { className: "flex h-16 items-center px-6 justify-between", children: [
        /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3", children: [
          /* @__PURE__ */ jsx("img", { src: assetPath("/LogoHJM.svg"), alt: "Hospital Juárez de México", className: "h-10 w-auto dark:invert" }),
          /* @__PURE__ */ jsx(Separator, { orientation: "vertical", className: "h-8" }),
          /* @__PURE__ */ jsx("h1", { className: "text-xl font-semibold", children: "Registro" })
        ] }),
        /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3", children: [
          /* @__PURE__ */ jsx(Separator, { orientation: "vertical", className: "h-8" }),
          /* @__PURE__ */ jsx(ThemeToggle, {})
        ] })
      ] }),
      /* @__PURE__ */ jsx(Separator, {})
    ] }),
    /* @__PURE__ */ jsx("div", { className: "flex-1 overflow-y-auto", children: /* @__PURE__ */ jsxs("div", { className: "container mx-auto p-6 pt-10 sm:p-8 max-w-4xl", children: [
      /* @__PURE__ */ jsxs("div", { className: "mb-8 space-y-2 text-center", children: [
        /* @__PURE__ */ jsx("h2", { className: "text-3xl font-bold tracking-tight", children: "Crear Cuenta" }),
        /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Complete el formulario para registrarse en el sistema" })
      ] }),
      /* @__PURE__ */ jsx("div", { className: "mb-8 flex justify-center", children: /* @__PURE__ */ jsx("div", { className: "flex items-center", children: steps.map((step, index) => /* @__PURE__ */ jsxs("div", { className: "flex items-center shrink-0", children: [
        /* @__PURE__ */ jsxs("div", { className: "flex flex-col items-center gap-2 shrink-0", children: [
          /* @__PURE__ */ jsx("div", { className: `
                        w-10 h-10 rounded-full flex items-center justify-center font-semibold transition-colors text-center
                        ${index < currentStep ? "bg-primary text-primary-foreground" : index === currentStep ? "bg-primary text-primary-foreground ring-4 ring-primary/20" : "bg-muted-foreground/20 text-muted-foreground"}
                      `, children: index < currentStep ? /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-5 w-5 shrink-0" }) : /* @__PURE__ */ jsx("span", { className: "inline-flex items-center justify-center w-full h-full leading-none", children: index + 1 }) }),
          /* @__PURE__ */ jsx("p", { className: `text-sm font-medium text-center hidden md:block ${index === currentStep ? "text-foreground" : "text-muted-foreground"}`, children: step.title })
        ] }),
        index < steps.length - 1 && /* @__PURE__ */ jsx("div", { className: `
                        w-12 md:w-24 h-0.5 mx-2 md:mx-4 transition-colors shrink-0
                        ${index < currentStep ? "bg-primary" : "bg-muted-foreground/20"}
                      ` })
      ] }, index)) }) }),
      /* @__PURE__ */ jsxs("div", { className: "space-y-6", children: [
        currentStep === 0 && /* @__PURE__ */ jsxs(Card, { children: [
          /* @__PURE__ */ jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsx(CardTitle, { children: "Datos personales" }),
            /* @__PURE__ */ jsx(CardDescription, { children: "Seleccione su nacionalidad y complete su identificación y datos personales" })
          ] }),
          /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
            /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsx(Label, { htmlFor: "nacionalidad", children: "Nacionalidad:" }),
              /* @__PURE__ */ jsxs(Select, { value: formData.nacionalidad, onValueChange: (value) => handleInputChange("nacionalidad", value), children: [
                /* @__PURE__ */ jsx(SelectTrigger, { id: "nacionalidad", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                /* @__PURE__ */ jsxs(SelectContent, { position: "popper", sideOffset: 5, children: [
                  /* @__PURE__ */ jsx(SelectItem, { value: "mexicana", children: "Mexicana" }),
                  /* @__PURE__ */ jsx(SelectItem, { value: "extranjera", children: "Extranjera" })
                ] })
              ] })
            ] }),
            formData.nacionalidad === "extranjera" && /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsx(Label, { htmlFor: "identificacion", children: "Introduzca su identificación (ID)" }),
              /* @__PURE__ */ jsxs("div", { className: "relative", children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: IdentificationIcon, size: 20, strokeWidth: 2, className: "absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground pointer-events-none" }),
                /* @__PURE__ */ jsx("div", { "aria-hidden": true, className: "absolute left-10 top-2 bottom-2 w-px bg-border pointer-events-none" }),
                /* @__PURE__ */ jsx(Input, { id: "identificacion", placeholder: "Número o código de identificación", value: formData.identificacion, onChange: (e) => handleInputChange("identificacion", e.target.value.replace(/[^A-Za-z0-9-]/g, "").toUpperCase()), className: "pl-12" })
              ] })
            ] }),
            formData.nacionalidad === "mexicana" && /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsx(Label, { htmlFor: "curp", children: "Introduzca su C.U.R.P." }),
              /* @__PURE__ */ jsxs("div", { className: "relative", children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: IdentificationIcon, size: 20, strokeWidth: 2, className: "absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground pointer-events-none" }),
                /* @__PURE__ */ jsx("div", { "aria-hidden": true, className: "absolute left-10 top-2 bottom-2 w-px bg-border pointer-events-none" }),
                /* @__PURE__ */ jsx(Input, { id: "curp", placeholder: "CURP de 18 caracteres", value: formData.curp, onChange: (e) => handleCurpChange(e.target.value), maxLength: 18, disabled: isLoadingCurp, className: `pl-12 ${curpError ? "border-destructive" : ""}` })
              ] }),
              isLoadingCurp && /* @__PURE__ */ jsx("p", { className: "text-sm text-muted-foreground", children: "Consultando CURP..." }),
              curpYaRegistrado && /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx("p", { className: "text-sm text-destructive", children: "Este CURP ya está registrado." }),
                /* @__PURE__ */ jsxs("p", { className: "text-xs text-muted-foreground", children: [
                  /* @__PURE__ */ jsx(Link, { to: "/login", className: "text-primary hover:underline", children: "Inicie sesión" }),
                  " o ",
                  /* @__PURE__ */ jsx(Link, { to: "/recuperar-password", className: "text-primary hover:underline", children: "recupere su contraseña" }),
                  "."
                ] })
              ] }),
              curpError && !curpYaRegistrado && /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-sm text-destructive", children: curpError }),
                /* @__PURE__ */ jsx("p", { className: "text-xs text-muted-foreground", children: "Por favor, complete los campos manualmente a continuación." })
              ] })
            ] }),
            (formData.nacionalidad === "extranjera" || formData.nacionalidad === "mexicana" && curpDataLoaded) && /* @__PURE__ */ jsxs(Fragment, { children: [
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "nombre", children: "Nombre:" }),
                  /* @__PURE__ */ jsx(Input, { id: "nombre", placeholder: "Nombre", value: formData.nombre, onChange: (e) => handleInputChange("nombre", e.target.value), disabled: formData.nacionalidad === "mexicana" && curpDataLoaded })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "apellidos", children: "Apellidos:" }),
                  /* @__PURE__ */ jsx(Input, { id: "apellidos", placeholder: "Apellidos", value: formData.apellidos, onChange: (e) => handleInputChange("apellidos", e.target.value), disabled: formData.nacionalidad === "mexicana" && curpDataLoaded })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "edad", children: "Edad:" }),
                  /* @__PURE__ */ jsx(Input, { id: "edad", type: "text", inputMode: "numeric", placeholder: "Edad", value: formData.edad, onChange: (e) => {
                    const digits = e.target.value.replace(/\D/g, "");
                    const num = parseInt(digits, 10);
                    const val = digits === "" ? "" : num > 99 ? "99" : digits;
                    handleInputChange("edad", val);
                  }, disabled: formData.nacionalidad === "mexicana" && curpDataLoaded, maxLength: 2 })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "genero", children: "Género:" }),
                  /* @__PURE__ */ jsxs(Select, { value: formData.genero, onValueChange: (value) => handleInputChange("genero", value), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "genero", disabled: formData.nacionalidad === "mexicana" && curpDataLoaded, children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsxs(SelectContent, { position: "popper", sideOffset: 5, children: [
                      /* @__PURE__ */ jsx(SelectItem, { value: "masculino", children: "Masculino" }),
                      /* @__PURE__ */ jsx(SelectItem, { value: "femenino", children: "Femenino" }),
                      /* @__PURE__ */ jsx(SelectItem, { value: "otro", children: "Otro" })
                    ] })
                  ] })
                ] })
              ] })
            ] })
          ] })
        ] }),
        currentStep === 1 && /* @__PURE__ */ jsxs(Card, { children: [
          /* @__PURE__ */ jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsx(CardTitle, { children: "Información Adicional" }),
            /* @__PURE__ */ jsx(CardDescription, { children: "Complete su perfil" })
          ] }),
          /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
            /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsx(Label, { children: "Correo Electrónico:" }),
              /* @__PURE__ */ jsxs("div", { className: "flex gap-2 flex-wrap sm:flex-nowrap", children: [
                /* @__PURE__ */ jsxs("div", { className: "relative flex-1 min-w-0", children: [
                  /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Mail01Icon, size: 20, strokeWidth: 2, className: "absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground pointer-events-none" }),
                  /* @__PURE__ */ jsx("div", { "aria-hidden": true, className: "absolute left-10 top-2 bottom-2 w-px bg-border pointer-events-none" }),
                  /* @__PURE__ */ jsx(Input, { id: "emailParte", type: "text", placeholder: "usuario", value: formData.emailParte, onChange: (e) => handleInputChange("emailParte", e.target.value.replace(/[^A-Za-z0-9._+-]/g, "")), className: "pl-12" })
                ] }),
                /* @__PURE__ */ jsx("span", { className: "self-center text-muted-foreground shrink-0", children: "@" }),
                /* @__PURE__ */ jsxs(Select, { value: formData.emailDominio, onValueChange: (value) => handleInputChange("emailDominio", value), children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "emailDominio", className: "w-full sm:w-[180px] shrink-0", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Dominio" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { position: "popper", sideOffset: 5, children: DOMINIOS_EMAIL.map((d) => /* @__PURE__ */ jsx(SelectItem, { value: d, children: d }, d)) })
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "lugarResidencia", children: "Estado de Residencia:" }),
                /* @__PURE__ */ jsxs(Select, { value: formData.lugarResidencia, onValueChange: (value) => handleInputChange("lugarResidencia", value), children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "lugarResidencia", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione un estado" }) }),
                  /* @__PURE__ */ jsxs(SelectContent, { position: "popper", sideOffset: 5, children: [
                    /* @__PURE__ */ jsx(SelectItem, { value: "aguascalientes", children: "Aguascalientes" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "baja-california", children: "Baja California" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "baja-california-sur", children: "Baja California Sur" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "campeche", children: "Campeche" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "chiapas", children: "Chiapas" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "chihuahua", children: "Chihuahua" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "cdmx", children: "Ciudad de México" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "coahuila", children: "Coahuila" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "colima", children: "Colima" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "durango", children: "Durango" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "guanajuato", children: "Guanajuato" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "guerrero", children: "Guerrero" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "hidalgo", children: "Hidalgo" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "jalisco", children: "Jalisco" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "estado-de-mexico", children: "Estado de México" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "michoacan", children: "Michoacán" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "morelos", children: "Morelos" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "nayarit", children: "Nayarit" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "nuevo-leon", children: "Nuevo León" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "oaxaca", children: "Oaxaca" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "puebla", children: "Puebla" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "queretaro", children: "Querétaro" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "quintana-roo", children: "Quintana Roo" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "san-luis-potosi", children: "San Luis Potosí" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "sinaloa", children: "Sinaloa" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "sonora", children: "Sonora" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "tabasco", children: "Tabasco" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "tamaulipas", children: "Tamaulipas" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "tlaxcala", children: "Tlaxcala" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "veracruz", children: "Veracruz" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "yucatan", children: "Yucatán" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "zacatecas", children: "Zacatecas" })
                  ] })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "formacionAcademica", children: "Formación Académica:" }),
                /* @__PURE__ */ jsxs(Select, { value: formData.formacionAcademica, onValueChange: (value) => handleInputChange("formacionAcademica", value), children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "formacionAcademica", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsxs(SelectContent, { position: "popper", sideOffset: 5, children: [
                    /* @__PURE__ */ jsx(SelectItem, { value: "licenciatura-ingenieria", children: "Licenciatura o Ingeniería" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "especialidad", children: "Especialidad" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "maestria", children: "Maestría" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "doctorado", children: "Doctorado" })
                  ] })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "institucionProcedencia", children: "Inst. de Procedencia:" }),
                /* @__PURE__ */ jsxs(Select, { value: formData.institucionProcedencia, onValueChange: (value) => handleInputChange("institucionProcedencia", value), children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "institucionProcedencia", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { position: "popper", sideOffset: 5, children: /* @__PURE__ */ jsx(SelectItem, { value: "hospital-juarez-mexico", children: "HOSPITAL JUÁREZ DE MÉXICO" }) })
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsx(Label, { htmlFor: "telefono", children: "Tel. celular:" }),
              /* @__PURE__ */ jsxs("div", { className: "relative", children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: SmartPhone01Icon, size: 20, strokeWidth: 2, className: "absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground pointer-events-none" }),
                /* @__PURE__ */ jsx("div", { "aria-hidden": true, className: "absolute left-10 top-2 bottom-2 w-px bg-border pointer-events-none" }),
                /* @__PURE__ */ jsx(Input, { id: "telefono", type: "tel", placeholder: "10 dígitos", value: formData.telefono, onChange: (e) => handleInputChange("telefono", e.target.value.replace(/\D/g, "")), maxLength: 10, className: "pl-12" })
              ] })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsx(Label, { htmlFor: "password", children: "Contraseña para su acceso:" }),
              /* @__PURE__ */ jsxs("div", { className: "relative", children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: LockedIcon, size: 20, strokeWidth: 2, className: "absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground pointer-events-none" }),
                /* @__PURE__ */ jsx("div", { "aria-hidden": true, className: "absolute left-10 top-2 bottom-2 w-px bg-border pointer-events-none" }),
                /* @__PURE__ */ jsx(Input, { id: "password", type: showPassword ? "text" : "password", placeholder: "Mínimo 8 caracteres", value: formData.password, onChange: (e) => handleInputChange("password", e.target.value), className: "pl-12 pr-10" }),
                /* @__PURE__ */ jsx("button", { type: "button", onClick: () => setShowPassword(!showPassword), className: "absolute right-3 top-1/2 -translate-y-1/2 text-muted-foreground hover:text-foreground transition-colors", tabIndex: -1, children: showPassword ? /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ViewOffSlashIcon, size: 20, strokeWidth: 2 }) : /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ViewIcon, size: 20, strokeWidth: 2 }) })
              ] }),
              formData.password && /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx(Progress, { value: fuerzaPassword(formData.password).score, className: "h-1.5" }),
                /* @__PURE__ */ jsxs("p", { className: "text-xs text-muted-foreground", children: [
                  "Fuerza: ",
                  fuerzaPassword(formData.password).label || "—"
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsx(Label, { htmlFor: "confirmacionPassword", children: "Confirmar contraseña:" }),
              /* @__PURE__ */ jsxs("div", { className: "relative", children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: LockedIcon, size: 20, strokeWidth: 2, className: "absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground pointer-events-none" }),
                /* @__PURE__ */ jsx("div", { "aria-hidden": true, className: "absolute left-10 top-2 bottom-2 w-px bg-border pointer-events-none" }),
                /* @__PURE__ */ jsx(Input, { id: "confirmacionPassword", type: showConfirmPassword ? "text" : "password", placeholder: "Repita su contraseña", value: formData.confirmacionPassword, onChange: (e) => handleInputChange("confirmacionPassword", e.target.value), className: "pl-12 pr-10" }),
                /* @__PURE__ */ jsx("button", { type: "button", onClick: () => setShowConfirmPassword(!showConfirmPassword), className: "absolute right-3 top-1/2 -translate-y-1/2 text-muted-foreground hover:text-foreground transition-colors", tabIndex: -1, children: showConfirmPassword ? /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ViewOffSlashIcon, size: 20, strokeWidth: 2 }) : /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ViewIcon, size: 20, strokeWidth: 2 }) })
              ] }),
              formData.confirmacionPassword && formData.password !== formData.confirmacionPassword && /* @__PURE__ */ jsx("p", { className: "text-xs text-destructive", children: "Las contraseñas no coinciden" })
            ] })
          ] })
        ] }),
        currentStep === 2 && /* @__PURE__ */ jsxs(Card, { children: [
          /* @__PURE__ */ jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsx(CardTitle, { children: "Confirmación de datos" }),
            /* @__PURE__ */ jsx(CardDescription, { children: "Revise que la información sea correcta antes de continuar" })
          ] }),
          /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
            submitError && /* @__PURE__ */ jsx("p", { className: "text-sm text-destructive text-center", children: submitError }),
            /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-4 text-sm", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Nacionalidad" }),
                /* @__PURE__ */ jsx("p", { className: "font-medium", children: formData.nacionalidad === "mexicana" ? "Mexicana" : formData.nacionalidad === "extranjera" ? "Extranjera" : "—" })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: formData.nacionalidad === "mexicana" ? "CURP" : "Identificación" }),
                /* @__PURE__ */ jsx("p", { className: "font-medium", children: formData.nacionalidad === "mexicana" ? formData.curp : formData.identificacion || "—" })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Nombre" }),
                /* @__PURE__ */ jsx("p", { className: "font-medium", children: formData.nombre || "—" })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Apellidos" }),
                /* @__PURE__ */ jsx("p", { className: "font-medium", children: formData.apellidos || "—" })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Edad" }),
                /* @__PURE__ */ jsx("p", { className: "font-medium", children: formData.edad || "—" })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Género" }),
                /* @__PURE__ */ jsx("p", { className: "font-medium", children: formData.genero === "masculino" ? "Masculino" : formData.genero === "femenino" ? "Femenino" : formData.genero === "otro" ? "Otro" : formData.genero || "—" })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Correo electrónico" }),
                /* @__PURE__ */ jsx("p", { className: "font-medium", children: emailCompleto || "—" })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Estado de residencia" }),
                /* @__PURE__ */ jsx("p", { className: "font-medium capitalize", children: formData.lugarResidencia.replace(/-/g, " ") || "—" })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Formación académica" }),
                /* @__PURE__ */ jsx("p", { className: "font-medium capitalize", children: formData.formacionAcademica.replace(/-/g, " ") || "—" })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Inst. de procedencia" }),
                /* @__PURE__ */ jsx("p", { className: "font-medium", children: formData.institucionProcedencia ? "Hospital Juárez de México" : "—" })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
                /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Tel. celular" }),
                /* @__PURE__ */ jsx("p", { className: "font-medium", children: formData.telefono || "—" })
              ] })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxs("div", { className: "flex justify-between pt-6", children: [
          /* @__PURE__ */ jsxs(Button, { variant: "outline", onClick: prevStep, disabled: Boolean(currentStep === 0), children: [
            /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ArrowLeft01Icon, className: "h-4 w-4 mr-2" }),
            "Anterior"
          ] }),
          /* @__PURE__ */ jsx("div", { className: "flex gap-2", children: currentStep < steps.length - 1 ? /* @__PURE__ */ jsxs(Button, { onClick: nextStep, disabled: Boolean(currentStep === 0 && !canProceedFromStep0 || currentStep === 1 && !canProceedFromStep1), children: [
            "Siguiente",
            /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ArrowRight01Icon, className: "h-4 w-4 ml-2" })
          ] }) : /* @__PURE__ */ jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsx(Button, { variant: "outline", onClick: () => navigate({
              to: "/login"
            }), children: "Salir" }),
            /* @__PURE__ */ jsxs(Button, { onClick: handleSubmit, disabled: isSubmitting, children: [
              /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-4 w-4 mr-2" }),
              isSubmitting ? "Guardando..." : "Confirmar"
            ] })
          ] }) })
        ] })
      ] }),
      /* @__PURE__ */ jsx("div", { className: "mt-6 text-center", children: /* @__PURE__ */ jsxs(Link, { to: "/login", className: "text-sm text-muted-foreground hover:text-foreground transition-colors", children: [
        "¿Ya tienes cuenta? ",
        /* @__PURE__ */ jsx("span", { className: "text-primary font-medium", children: "Iniciar Sesión" })
      ] }) }),
      /* @__PURE__ */ jsx(AlertDialog, { open: showVerificacionDialog, onOpenChange: setShowVerificacionDialog, children: /* @__PURE__ */ jsxs(AlertDialogContent, { className: "sm:max-w-[460px]", children: [
        /* @__PURE__ */ jsxs(AlertDialogHeader, { className: "text-left sm:text-left place-items-start", children: [
          /* @__PURE__ */ jsx(AlertDialogTitle, { children: "Verificar correo electrónico" }),
          /* @__PURE__ */ jsx(AlertDialogDescription, { asChild: true, children: /* @__PURE__ */ jsxs("div", { className: "space-y-3 text-sm", children: [
            /* @__PURE__ */ jsxs("p", { children: [
              "Enviamos un código de 6 dígitos a:",
              " ",
              /* @__PURE__ */ jsx("span", { className: "font-medium text-foreground", children: datosVerificacion?.correo || emailCompleto || "—" })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsx(Label, { htmlFor: "codigoVerificacion", children: "Código" }),
              /* @__PURE__ */ jsx(InputOTP, { id: "codigoVerificacion", value: codigoVerificacion, onChange: (value) => setCodigoVerificacion(value.replace(/\D/g, "").slice(0, 6)), maxLength: 6, pattern: REGEXP_ONLY_DIGITS, containerClassName: "justify-start", children: /* @__PURE__ */ jsxs(InputOTPGroup, { children: [
                /* @__PURE__ */ jsx(InputOTPSlot, { index: 0 }),
                /* @__PURE__ */ jsx(InputOTPSlot, { index: 1 }),
                /* @__PURE__ */ jsx(InputOTPSlot, { index: 2 }),
                /* @__PURE__ */ jsx(InputOTPSlot, { index: 3 }),
                /* @__PURE__ */ jsx(InputOTPSlot, { index: 4 }),
                /* @__PURE__ */ jsx(InputOTPSlot, { index: 5 })
              ] }) })
            ] }),
            errorVerificacion && /* @__PURE__ */ jsx("p", { className: "text-destructive", children: errorVerificacion })
          ] }) })
        ] }),
        /* @__PURE__ */ jsxs(AlertDialogFooter, { children: [
          /* @__PURE__ */ jsx(AlertDialogCancel, { disabled: isVerificandoCodigo, children: "Cerrar" }),
          /* @__PURE__ */ jsx(Button, { type: "button", variant: "outline", onClick: handleReenviarCodigo, disabled: isReenviandoCodigo || segundosRestantesReenvio > 0 || isVerificandoCodigo, children: isReenviandoCodigo ? "Reenviando..." : segundosRestantesReenvio > 0 ? `Reenviar en ${segundosRestantesReenvio}s` : "Reenviar código" }),
          /* @__PURE__ */ jsx(Button, { type: "button", onClick: handleVerificarCodigo, disabled: isVerificandoCodigo, children: isVerificandoCodigo ? "Verificando..." : "Verificar" })
        ] })
      ] }) }),
      /* @__PURE__ */ jsx(AlertDialog, { open: showExitoDialog, onOpenChange: setShowExitoDialog, children: /* @__PURE__ */ jsxs(AlertDialogContent, { className: "sm:max-w-[420px] gap-0 overflow-hidden p-0", children: [
        /* @__PURE__ */ jsxs(AlertDialogHeader, { className: "p-6 pb-4 text-center gap-4 place-items-center", children: [
          /* @__PURE__ */ jsx(AlertDialogMedia, { className: "size-16 rounded-full bg-primary/10 text-primary shrink-0 mb-0 *:size-9", children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: CheckmarkCircle02Icon, className: "size-9", strokeWidth: 1.75 }) }),
          /* @__PURE__ */ jsxs("div", { className: "space-y-1", children: [
            /* @__PURE__ */ jsx(AlertDialogTitle, { className: "text-xl", children: "Cuenta creada" }),
            /* @__PURE__ */ jsx(AlertDialogDescription, { asChild: true, children: /* @__PURE__ */ jsx("p", { className: "text-muted-foreground text-sm", children: "Correo verificado correctamente. Ya puede iniciar sesión en el sistema." }) })
          ] })
        ] }),
        /* @__PURE__ */ jsx("div", { className: "px-6 pb-4", children: /* @__PURE__ */ jsxs("div", { className: "rounded-lg border bg-muted/50 px-4 py-3 text-sm", children: [
          /* @__PURE__ */ jsx("p", { className: "font-medium text-foreground mb-1", children: "Para iniciar sesión use:" }),
          /* @__PURE__ */ jsxs("ul", { className: "text-muted-foreground space-y-0.5 list-none", children: [
            /* @__PURE__ */ jsx("li", { children: formData.nacionalidad === "mexicana" ? "CURP" : "Identificación" }),
            /* @__PURE__ */ jsx("li", { children: "Contraseña que definió" })
          ] })
        ] }) }),
        /* @__PURE__ */ jsx(AlertDialogFooter, { className: "p-6 pt-0 flex justify-center sm:justify-center border-0", children: /* @__PURE__ */ jsx(AlertDialogAction, { onClick: () => navigate({
          to: "/login"
        }), className: "min-w-[200px]", children: "Ir a iniciar sesión" }) })
      ] }) })
    ] }) })
  ] });
}
export {
  RegistroPage as component
};
