import { jsxs, jsx } from "react/jsx-runtime";
import { useState, useEffect } from "react";
import { useNavigate, Link } from "@tanstack/react-router";
import { HugeiconsIcon } from "@hugeicons/react";
import { IdentificationIcon, ArrowLeft02Icon, LockedIcon, ViewOffSlashIcon, ViewIcon, CheckmarkCircle02Icon } from "@hugeicons/core-free-icons";
import { B as Button } from "./button-Bp95UwA9.mjs";
import { I as Input } from "./input-B66ag17B.mjs";
import { L as Label } from "./label-Cp5Wz1sX.mjs";
import { A as AlertDialog, a as AlertDialogContent, b as AlertDialogHeader, c as AlertDialogTitle, d as AlertDialogDescription, e as AlertDialogFooter, f as AlertDialogCancel, g as AlertDialogMedia, h as AlertDialogAction } from "./alert-dialog-Da-A3hay.mjs";
import { I as InputOTP, a as InputOTPGroup, b as InputOTPSlot } from "./input-otp-BqXXcLPx.mjs";
import { a as assetPath, b as apiUrl } from "./router-5yTRMCgc.mjs";
import { REGEXP_ONLY_DIGITS } from "input-otp";
import { T as ThemeToggle } from "./theme-toggle-C2c9ak38.mjs";
import { u as useVersionDisplay } from "./use-version-display-nKsuhK8N.mjs";
import "class-variance-authority";
import "radix-ui";
import "./utils-H80jjgLf.mjs";
import "clsx";
import "tailwind-merge";
import "@tanstack/react-query";
import "next-themes";
import "sonner";
function ForgotPasswordForm() {
  const navigate = useNavigate();
  const [step, setStep] = useState("curp");
  const [isLoading, setIsLoading] = useState(false);
  const [showPassword, setShowPassword] = useState(false);
  const [showConfirmPassword, setShowConfirmPassword] = useState(false);
  const [showCodigoDialog, setShowCodigoDialog] = useState(false);
  const [showExitoDialog, setShowExitoDialog] = useState(false);
  const [codigoRecuperacion, setCodigoRecuperacion] = useState("");
  const [correoEnmascarado, setCorreoEnmascarado] = useState("");
  const [errorCodigo, setErrorCodigo] = useState("");
  const [errorCambio, setErrorCambio] = useState("");
  const [isVerificandoCodigo, setIsVerificandoCodigo] = useState(false);
  const [isReenviandoCodigo, setIsReenviandoCodigo] = useState(false);
  const [segundosRestantesReenvio, setSegundosRestantesReenvio] = useState(0);
  const [formData, setFormData] = useState({
    curp: "",
    nuevaContrasena: "",
    confirmarContrasena: ""
  });
  const [errors, setErrors] = useState({
    curp: "",
    nuevaContrasena: "",
    confirmarContrasena: ""
  });
  const [touched, setTouched] = useState({
    curp: false,
    nuevaContrasena: false,
    confirmarContrasena: false
  });
  useEffect(() => {
    if (segundosRestantesReenvio <= 0) {
      return;
    }
    const timer = setInterval(() => {
      setSegundosRestantesReenvio((prev) => prev > 0 ? prev - 1 : 0);
    }, 1e3);
    return () => clearInterval(timer);
  }, [segundosRestantesReenvio]);
  const validateCurp = (value) => {
    if (!value.trim()) {
      return "El CURP es requerido";
    }
    if (value.length !== 18) {
      return "El CURP debe tener 18 caracteres";
    }
    return "";
  };
  const validateNuevaContrasena = (value) => {
    if (!value) return "La contraseña es requerida";
    if (value.length < 8) return "La contraseña debe tener al menos 8 caracteres";
    return "";
  };
  const validateConfirmarContrasena = (value) => {
    if (!value) return "Confirme la contraseña";
    if (value !== formData.nuevaContrasena) return "Las contraseñas no coinciden";
    return "";
  };
  const enviarCodigoRecuperacion = async () => {
    const curp = formData.curp.trim().toUpperCase();
    const res = await fetch(apiUrl("/api/auth/recuperacion-enviar-codigo"), {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({ curp })
    });
    const data = await res.json().catch(() => ({}));
    return data;
  };
  const handleSubmitCurp = async (e) => {
    e.preventDefault();
    const curpError = validateCurp(formData.curp);
    if (curpError) {
      setTouched((prev) => ({ ...prev, curp: true }));
      setErrors((prev) => ({ ...prev, curp: curpError }));
      return;
    }
    setIsLoading(true);
    setErrors((prev) => ({ ...prev, curp: "" }));
    setErrorCodigo("");
    try {
      const data = await enviarCodigoRecuperacion();
      if (data.success) {
        setCorreoEnmascarado(data.correoEnmascarado || "");
        setSegundosRestantesReenvio(
          typeof data.segundosRestantes === "number" ? data.segundosRestantes : 60
        );
        setCodigoRecuperacion("");
        setShowCodigoDialog(true);
        return;
      }
      if (typeof data.segundosRestantes === "number" && data.segundosRestantes > 0) {
        setSegundosRestantesReenvio(data.segundosRestantes);
      }
      setErrors((prev) => ({
        ...prev,
        curp: data.error || "No se pudo iniciar la recuperación"
      }));
    } catch {
      setErrors((prev) => ({ ...prev, curp: "Error de conexión" }));
    } finally {
      setIsLoading(false);
    }
  };
  const handleVerificarCodigo = async () => {
    const codigo = codigoRecuperacion.trim();
    if (!/^\d{6}$/.test(codigo)) {
      setErrorCodigo("Ingrese un código válido de 6 dígitos");
      return;
    }
    setIsVerificandoCodigo(true);
    setErrorCodigo("");
    try {
      const res = await fetch(apiUrl("/api/auth/recuperacion-verificar-codigo"), {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({
          curp: formData.curp.trim().toUpperCase(),
          codigo
        })
      });
      const data = await res.json().catch(() => ({}));
      if (data.success) {
        setShowCodigoDialog(false);
        setStep("nueva-password");
        return;
      }
      setErrorCodigo(data.error || "No se pudo verificar el código");
    } catch {
      setErrorCodigo("Error de conexión");
    } finally {
      setIsVerificandoCodigo(false);
    }
  };
  const handleReenviarCodigo = async () => {
    if (segundosRestantesReenvio > 0) {
      return;
    }
    setIsReenviandoCodigo(true);
    setErrorCodigo("");
    try {
      const data = await enviarCodigoRecuperacion();
      if (data.success) {
        setCorreoEnmascarado(data.correoEnmascarado || correoEnmascarado);
        setSegundosRestantesReenvio(
          typeof data.segundosRestantes === "number" ? data.segundosRestantes : 60
        );
        return;
      }
      if (typeof data.segundosRestantes === "number" && data.segundosRestantes > 0) {
        setSegundosRestantesReenvio(data.segundosRestantes);
      }
      setErrorCodigo(data.error || "No se pudo reenviar el código");
    } catch {
      setErrorCodigo("Error de conexión");
    } finally {
      setIsReenviandoCodigo(false);
    }
  };
  const handleSubmitNuevaPassword = async (e) => {
    e.preventDefault();
    setErrorCambio("");
    if (!/^\d{6}$/.test(codigoRecuperacion.trim())) {
      setErrorCambio("Debe validar el código de recuperación primero");
      return;
    }
    const errNueva = validateNuevaContrasena(formData.nuevaContrasena);
    const errConfirmar = validateConfirmarContrasena(formData.confirmarContrasena);
    if (errNueva || errConfirmar) {
      setTouched((prev) => ({
        ...prev,
        nuevaContrasena: true,
        confirmarContrasena: true
      }));
      setErrors((prev) => ({
        ...prev,
        nuevaContrasena: errNueva,
        confirmarContrasena: errConfirmar
      }));
      return;
    }
    setIsLoading(true);
    try {
      const res = await fetch(apiUrl("/api/auth/cambiar-password-recuperacion"), {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({
          curp: formData.curp.trim().toUpperCase(),
          codigo: codigoRecuperacion.trim(),
          nuevaContrasena: formData.nuevaContrasena
        })
      });
      const data = await res.json().catch(() => ({}));
      if (data.success) {
        setShowExitoDialog(true);
        return;
      }
      setErrorCambio(data.error || "Error al cambiar la contraseña");
    } catch {
      setErrorCambio("Error de conexión");
    } finally {
      setIsLoading(false);
    }
  };
  const handleCancel = () => {
    navigate({ to: "/login" });
  };
  return /* @__PURE__ */ jsxs("div", { className: "space-y-5 sm:space-y-8", children: [
    /* @__PURE__ */ jsxs("div", { className: "space-y-3 sm:space-y-4", children: [
      /* @__PURE__ */ jsx("div", { className: "flex justify-center", children: /* @__PURE__ */ jsx(
        "img",
        {
          src: assetPath("/LogoHJM.svg"),
          alt: "Hospital Juárez de México",
          className: "h-28 w-auto dark:invert sm:h-32"
        }
      ) }),
      /* @__PURE__ */ jsxs("div", { className: "space-y-2 text-center", children: [
        /* @__PURE__ */ jsx("h2", { className: "text-3xl font-semibold text-foreground", children: "Recuperación de Contraseña" }),
        /* @__PURE__ */ jsx("p", { className: "text-sm text-muted-foreground", children: step === "curp" ? "Ingresa tu CURP para recibir un código de recuperación en tu correo" : "Ingresa tu nueva contraseña" })
      ] })
    ] }),
    step === "curp" ? /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmitCurp, className: "space-y-4 sm:space-y-6", children: [
      /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
        /* @__PURE__ */ jsx(Label, { htmlFor: "curp", className: "text-sm font-medium text-foreground", children: "CURP" }),
        /* @__PURE__ */ jsxs("div", { className: "relative", children: [
          /* @__PURE__ */ jsx(
            HugeiconsIcon,
            {
              icon: IdentificationIcon,
              size: 20,
              strokeWidth: 2,
              className: "absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground pointer-events-none"
            }
          ),
          /* @__PURE__ */ jsx(
            "div",
            {
              "aria-hidden": true,
              className: "absolute left-10 top-2 bottom-2 w-px bg-border pointer-events-none"
            }
          ),
          /* @__PURE__ */ jsx(
            Input,
            {
              id: "curp",
              type: "text",
              placeholder: "Ingresa tu CURP (18 caracteres)",
              value: formData.curp,
              onChange: (e) => setFormData((prev) => ({
                ...prev,
                curp: e.target.value.toUpperCase()
              })),
              onBlur: () => {
                setTouched((prev) => ({ ...prev, curp: true }));
                setErrors((prev) => ({ ...prev, curp: validateCurp(formData.curp) }));
              },
              className: `pl-12 transition-colors ${touched.curp && errors.curp ? "border-destructive focus-visible:ring-destructive" : ""}`,
              disabled: isLoading,
              maxLength: 18
            }
          )
        ] }),
        touched.curp && errors.curp && /* @__PURE__ */ jsx("p", { className: "text-sm text-destructive", children: errors.curp })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "flex flex-col gap-3", children: [
        /* @__PURE__ */ jsx(Button, { type: "submit", className: "w-full", disabled: isLoading, children: isLoading ? "Enviando código..." : "Continuar" }),
        /* @__PURE__ */ jsx(
          Button,
          {
            type: "button",
            variant: "outline",
            className: "w-full",
            onClick: handleCancel,
            disabled: isLoading,
            children: "Cancelar"
          }
        )
      ] }),
      /* @__PURE__ */ jsx("div", { className: "text-center", children: /* @__PURE__ */ jsxs(
        Link,
        {
          to: "/login",
          className: "inline-flex items-center gap-2 text-sm text-primary hover:text-primary/80 hover:underline transition-colors",
          children: [
            /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ArrowLeft02Icon, size: 16, strokeWidth: 2 }),
            "Volver al inicio de sesión"
          ]
        }
      ) })
    ] }) : /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmitNuevaPassword, className: "space-y-4 sm:space-y-6", children: [
      errorCambio && /* @__PURE__ */ jsx("p", { className: "text-sm text-destructive text-center", children: errorCambio }),
      /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
        /* @__PURE__ */ jsx(Label, { htmlFor: "nuevaContrasena", className: "text-sm font-medium text-foreground", children: "Nueva contraseña" }),
        /* @__PURE__ */ jsxs("div", { className: "relative", children: [
          /* @__PURE__ */ jsx(
            HugeiconsIcon,
            {
              icon: LockedIcon,
              size: 20,
              strokeWidth: 2,
              className: "absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground pointer-events-none"
            }
          ),
          /* @__PURE__ */ jsx(
            "div",
            {
              "aria-hidden": true,
              className: "absolute left-10 top-2 bottom-2 w-px bg-border pointer-events-none"
            }
          ),
          /* @__PURE__ */ jsx(
            Input,
            {
              id: "nuevaContrasena",
              type: showPassword ? "text" : "password",
              placeholder: "Mínimo 8 caracteres",
              value: formData.nuevaContrasena,
              onChange: (e) => setFormData((prev) => ({
                ...prev,
                nuevaContrasena: e.target.value
              })),
              onBlur: () => {
                setTouched((prev) => ({ ...prev, nuevaContrasena: true }));
                setErrors((prev) => ({
                  ...prev,
                  nuevaContrasena: validateNuevaContrasena(formData.nuevaContrasena)
                }));
              },
              className: `pl-12 pr-10 ${touched.nuevaContrasena && errors.nuevaContrasena ? "border-destructive focus-visible:ring-destructive" : ""}`,
              disabled: isLoading
            }
          ),
          /* @__PURE__ */ jsx(
            "button",
            {
              type: "button",
              onClick: () => setShowPassword(!showPassword),
              className: "absolute right-3 top-1/2 -translate-y-1/2 text-muted-foreground hover:text-foreground",
              tabIndex: -1,
              disabled: isLoading,
              children: showPassword ? /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ViewOffSlashIcon, size: 20, strokeWidth: 2 }) : /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ViewIcon, size: 20, strokeWidth: 2 })
            }
          )
        ] }),
        touched.nuevaContrasena && errors.nuevaContrasena && /* @__PURE__ */ jsx("p", { className: "text-sm text-destructive", children: errors.nuevaContrasena })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
        /* @__PURE__ */ jsx(Label, { htmlFor: "confirmarContrasena", className: "text-sm font-medium text-foreground", children: "Confirmar contraseña" }),
        /* @__PURE__ */ jsxs("div", { className: "relative", children: [
          /* @__PURE__ */ jsx(
            HugeiconsIcon,
            {
              icon: LockedIcon,
              size: 20,
              strokeWidth: 2,
              className: "absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground pointer-events-none"
            }
          ),
          /* @__PURE__ */ jsx(
            "div",
            {
              "aria-hidden": true,
              className: "absolute left-10 top-2 bottom-2 w-px bg-border pointer-events-none"
            }
          ),
          /* @__PURE__ */ jsx(
            Input,
            {
              id: "confirmarContrasena",
              type: showConfirmPassword ? "text" : "password",
              placeholder: "Repita la contraseña",
              value: formData.confirmarContrasena,
              onChange: (e) => setFormData((prev) => ({
                ...prev,
                confirmarContrasena: e.target.value
              })),
              onBlur: () => {
                setTouched((prev) => ({ ...prev, confirmarContrasena: true }));
                setErrors((prev) => ({
                  ...prev,
                  confirmarContrasena: validateConfirmarContrasena(
                    formData.confirmarContrasena
                  )
                }));
              },
              className: `pl-12 pr-10 ${touched.confirmarContrasena && errors.confirmarContrasena ? "border-destructive focus-visible:ring-destructive" : ""}`,
              disabled: isLoading
            }
          ),
          /* @__PURE__ */ jsx(
            "button",
            {
              type: "button",
              onClick: () => setShowConfirmPassword(!showConfirmPassword),
              className: "absolute right-3 top-1/2 -translate-y-1/2 text-muted-foreground hover:text-foreground",
              tabIndex: -1,
              disabled: isLoading,
              children: showConfirmPassword ? /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ViewOffSlashIcon, size: 20, strokeWidth: 2 }) : /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ViewIcon, size: 20, strokeWidth: 2 })
            }
          )
        ] }),
        touched.confirmarContrasena && errors.confirmarContrasena && /* @__PURE__ */ jsx("p", { className: "text-sm text-destructive", children: errors.confirmarContrasena })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "flex flex-col gap-3", children: [
        /* @__PURE__ */ jsx(Button, { type: "submit", className: "w-full", disabled: isLoading, children: isLoading ? "Guardando..." : "Cambiar contraseña" }),
        /* @__PURE__ */ jsx(
          Button,
          {
            type: "button",
            variant: "outline",
            className: "w-full",
            onClick: handleCancel,
            disabled: isLoading,
            children: "Cancelar"
          }
        )
      ] }),
      /* @__PURE__ */ jsx("div", { className: "text-center", children: /* @__PURE__ */ jsxs(
        Link,
        {
          to: "/login",
          className: "inline-flex items-center gap-2 text-sm text-primary hover:text-primary/80 hover:underline transition-colors",
          children: [
            /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ArrowLeft02Icon, size: 16, strokeWidth: 2 }),
            "Volver al inicio de sesión"
          ]
        }
      ) })
    ] }),
    /* @__PURE__ */ jsx(AlertDialog, { open: showCodigoDialog, onOpenChange: setShowCodigoDialog, children: /* @__PURE__ */ jsxs(AlertDialogContent, { className: "sm:max-w-[460px]", children: [
      /* @__PURE__ */ jsxs(AlertDialogHeader, { className: "text-left sm:text-left place-items-start", children: [
        /* @__PURE__ */ jsx(AlertDialogTitle, { children: "Verificación de recuperación" }),
        /* @__PURE__ */ jsx(AlertDialogDescription, { asChild: true, children: /* @__PURE__ */ jsxs("div", { className: "space-y-3 text-sm", children: [
          /* @__PURE__ */ jsxs("p", { children: [
            "Se ha enviado un código de recuperación al correo:",
            " ",
            /* @__PURE__ */ jsx("span", { className: "font-medium text-foreground", children: correoEnmascarado || "registrado en su cuenta" })
          ] }),
          /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsx(Label, { htmlFor: "codigoRecuperacion", children: "Código" }),
            /* @__PURE__ */ jsx(
              InputOTP,
              {
                id: "codigoRecuperacion",
                value: codigoRecuperacion,
                onChange: (value) => setCodigoRecuperacion(value.replace(/\D/g, "").slice(0, 6)),
                maxLength: 6,
                pattern: REGEXP_ONLY_DIGITS,
                containerClassName: "justify-start",
                children: /* @__PURE__ */ jsxs(InputOTPGroup, { children: [
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 0 }),
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 1 }),
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 2 }),
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 3 }),
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 4 }),
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 5 })
                ] })
              }
            )
          ] }),
          errorCodigo && /* @__PURE__ */ jsx("p", { className: "text-destructive", children: errorCodigo })
        ] }) })
      ] }),
      /* @__PURE__ */ jsxs(AlertDialogFooter, { children: [
        /* @__PURE__ */ jsx(AlertDialogCancel, { disabled: isVerificandoCodigo, children: "Cerrar" }),
        /* @__PURE__ */ jsx(
          Button,
          {
            type: "button",
            variant: "outline",
            onClick: handleReenviarCodigo,
            disabled: isReenviandoCodigo || segundosRestantesReenvio > 0 || isVerificandoCodigo,
            children: isReenviandoCodigo ? "Reenviando..." : segundosRestantesReenvio > 0 ? `Reenviar en ${segundosRestantesReenvio}s` : "Reenviar código"
          }
        ),
        /* @__PURE__ */ jsx(
          Button,
          {
            type: "button",
            onClick: handleVerificarCodigo,
            disabled: isVerificandoCodigo,
            children: isVerificandoCodigo ? "Verificando..." : "Verificar"
          }
        )
      ] })
    ] }) }),
    /* @__PURE__ */ jsx(AlertDialog, { open: showExitoDialog, onOpenChange: setShowExitoDialog, children: /* @__PURE__ */ jsxs(AlertDialogContent, { className: "sm:max-w-[420px] gap-0 overflow-hidden p-0", children: [
      /* @__PURE__ */ jsxs(AlertDialogHeader, { className: "p-6 pb-4 text-center gap-4 place-items-center", children: [
        /* @__PURE__ */ jsx(AlertDialogMedia, { className: "size-16 rounded-full bg-primary/10 text-primary shrink-0 mb-0 *:size-9", children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: CheckmarkCircle02Icon, className: "size-9", strokeWidth: 1.75 }) }),
        /* @__PURE__ */ jsx(AlertDialogTitle, { className: "text-xl", children: "Cambio de contraseña" }),
        /* @__PURE__ */ jsx(AlertDialogDescription, { asChild: true, children: /* @__PURE__ */ jsx("p", { className: "text-muted-foreground text-sm", children: "Su contraseña se cambió correctamente. Ya puede iniciar sesión con su nueva contraseña." }) })
      ] }),
      /* @__PURE__ */ jsx(AlertDialogFooter, { className: "p-6 pt-0 flex justify-center sm:justify-center border-0", children: /* @__PURE__ */ jsx(AlertDialogAction, { onClick: () => navigate({ to: "/login" }), className: "min-w-[200px]", children: "Ir al inicio de sesión" }) })
    ] }) })
  ] });
}
function ForgotPasswordPage() {
  const versionDisplay = useVersionDisplay();
  return /* @__PURE__ */ jsxs("div", { className: "min-h-dvh flex bg-muted", children: [
    /* @__PURE__ */ jsx("div", { className: "absolute top-4 right-4 hidden lg:block", children: /* @__PURE__ */ jsx(ThemeToggle, {}) }),
    /* @__PURE__ */ jsxs("div", { className: "hidden lg:flex lg:w-1/2 px-8 pb-8 pt-4 flex-col justify-between relative", children: [
      /* @__PURE__ */ jsxs("div", { className: "space-y-4 z-10", children: [
        /* @__PURE__ */ jsx("h1", { className: "text-2xl font-bold text-foreground leading-tight", children: "Registro de Proyectos de Investigación" }),
        /* @__PURE__ */ jsx("p", { className: "text-base text-muted-foreground", children: "División de Investigación" })
      ] }),
      /* @__PURE__ */ jsx("div", { className: "absolute inset-8 flex items-center justify-center", children: /* @__PURE__ */ jsx("img", { src: assetPath("/investigacion.webp"), alt: "Investigación", className: "max-w-full max-h-full object-contain" }) }),
      /* @__PURE__ */ jsx("div", { className: "text-sm text-muted-foreground z-10", children: "Sistema de gestión de proyectos de investigación" })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: "lg:w-1/2 w-full flex flex-col justify-center px-4 py-4 sm:px-8 sm:pb-8 sm:pt-4", children: [
      /* @__PURE__ */ jsx("div", { className: "flex items-center justify-center", children: /* @__PURE__ */ jsx("div", { className: "w-full max-w-lg bg-card border border-border rounded-lg sm:rounded-xl shadow-lg p-5 sm:p-10", children: /* @__PURE__ */ jsx(ForgotPasswordForm, {}) }) }),
      /* @__PURE__ */ jsxs("p", { className: "fixed right-4 bottom-1 z-10 text-right text-xs text-muted-foreground sm:right-8 sm:bottom-4 sm:text-sm lg:bottom-8", children: [
        "v",
        versionDisplay
      ] })
    ] })
  ] });
}
export {
  ForgotPasswordPage as component
};
