import { jsxs, jsx } from "react/jsx-runtime";
import { useCallback, useRef, useEffect, useState } from "react";
import { toast } from "sonner";
import { useNavigate, Link } from "@tanstack/react-router";
import { HugeiconsIcon } from "@hugeicons/react";
import { IdentificationIcon, LockedIcon, ViewOffSlashIcon, ViewIcon } from "@hugeicons/core-free-icons";
import { B as Button } from "./button-Bp95UwA9.mjs";
import { I as Input } from "./input-B66ag17B.mjs";
import { L as Label } from "./label-Cp5Wz1sX.mjs";
import { A as AlertDialog, a as AlertDialogContent, b as AlertDialogHeader, c as AlertDialogTitle, d as AlertDialogDescription, e as AlertDialogFooter, f as AlertDialogCancel } from "./alert-dialog-Da-A3hay.mjs";
import { I as InputOTP, a as InputOTPGroup, b as InputOTPSlot } from "./input-otp-BqXXcLPx.mjs";
import { a as assetPath, b as apiUrl, D as DURACION_SESION_MS } from "./router-5yTRMCgc.mjs";
import { REGEXP_ONLY_DIGITS } from "input-otp";
import { T as ThemeToggle } from "./theme-toggle-C2c9ak38.mjs";
import { u as useVersionDisplay } from "./use-version-display-nKsuhK8N.mjs";
import "class-variance-authority";
import "radix-ui";
import "./utils-H80jjgLf.mjs";
import "clsx";
import "tailwind-merge";
import "@tanstack/react-query";
import "next-themes";
function LoginForm() {
  const navigate = useNavigate();
  const [showPassword, setShowPassword] = useState(false);
  const [isLoading, setIsLoading] = useState(false);
  const [showVerificacionDialog, setShowVerificacionDialog] = useState(false);
  const [codigoVerificacion, setCodigoVerificacion] = useState("");
  const [errorVerificacion, setErrorVerificacion] = useState("");
  const [isVerificandoCodigo, setIsVerificandoCodigo] = useState(false);
  const [isReenviandoCodigo, setIsReenviandoCodigo] = useState(false);
  const [segundosRestantesReenvio, setSegundosRestantesReenvio] = useState(0);
  const [verificacionPendiente, setVerificacionPendiente] = useState(null);
  const [formData, setFormData] = useState({
    curp: "",
    password: ""
  });
  const [errors, setErrors] = useState({
    curp: "",
    password: ""
  });
  const [errorGeneral, setErrorGeneral] = useState("");
  const [touched, setTouched] = useState({
    curp: false,
    password: false
  });
  useEffect(() => {
    if (segundosRestantesReenvio <= 0) {
      return;
    }
    const timer = setInterval(() => {
      setSegundosRestantesReenvio((prev) => prev > 0 ? prev - 1 : 0);
    }, 1e3);
    return () => clearInterval(timer);
  }, [segundosRestantesReenvio]);
  const validateCurp = (value) => {
    if (!value.trim()) return "El CURP o ID es requerido";
    return "";
  };
  const validatePassword = (value) => {
    if (!value) {
      return "La contraseña es requerida";
    }
    if (value.length < 6) {
      return "La contraseña debe tener al menos 6 caracteres";
    }
    return "";
  };
  const handleBlur = (field) => {
    setTouched((prev) => ({ ...prev, [field]: true }));
    if (field === "curp") {
      setErrors((prev) => ({ ...prev, curp: validateCurp(formData.curp) }));
    } else {
      setErrors((prev) => ({ ...prev, password: validatePassword(formData.password) }));
    }
  };
  const handleChange = (field, value) => {
    const normalized = field === "curp" ? value.replace(/[^A-Za-z0-9]/g, "").toUpperCase() : value;
    setFormData((prev) => ({ ...prev, [field]: normalized }));
    if (touched[field]) {
      if (field === "curp") {
        setErrors((prev) => ({ ...prev, curp: validateCurp(normalized) }));
      } else {
        setErrors((prev) => ({ ...prev, password: validatePassword(normalized) }));
      }
    }
  };
  const guardarSesionYEntrar = (usuario) => {
    try {
      const expiraEn = Date.now() + DURACION_SESION_MS;
      sessionStorage.setItem("rpi:usuario", JSON.stringify({ ...usuario, expiraEn }));
    } catch {
    }
    navigate({ to: "/inicio" });
  };
  const intentarLogin = async () => {
    const res = await fetch(apiUrl("/api/auth/login"), {
      method: "POST",
      credentials: "include",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({
        curp: formData.curp,
        password: formData.password
      })
    });
    return res.json().catch(() => ({}));
  };
  const handleSubmit = async (e) => {
    e.preventDefault();
    setErrorGeneral("");
    const curpError = validateCurp(formData.curp);
    const passwordError = validatePassword(formData.password);
    if (curpError || passwordError) {
      setErrors({ curp: curpError, password: passwordError });
      setTouched({ curp: true, password: true });
      return;
    }
    setIsLoading(true);
    try {
      const data = await intentarLogin();
      if (data.success && data.usuario) {
        guardarSesionYEntrar(data.usuario);
        return;
      }
      if (data.requiereVerificacionCorreo && data.verificacion?.correo) {
        const nacionalidad = String(data.verificacion.nacionalidad || "").trim();
        const curp = String(data.verificacion.curp || "").trim().toUpperCase();
        const identificacion = String(data.verificacion.identificacion || "").trim();
        const correo = String(data.verificacion.correo || "").trim().toLowerCase();
        const usaCurp = nacionalidad === "mexicana";
        const identificador = usaCurp ? curp : identificacion;
        if (nacionalidad && correo && identificador) {
          setVerificacionPendiente({
            nacionalidad,
            curp: curp || void 0,
            identificacion: identificacion || void 0,
            correo
          });
          setCodigoVerificacion("");
          setErrorVerificacion("");
          setSegundosRestantesReenvio(0);
          setShowVerificacionDialog(true);
        } else {
          setErrorGeneral("No se pudo cargar la verificación de correo. Intente reenviar el código desde registro.");
        }
        return;
      }
      setErrorGeneral(data.error || "Error al iniciar sesión");
    } catch {
      setErrorGeneral("Error de conexión");
    } finally {
      setIsLoading(false);
    }
  };
  const handleVerificarCodigo = async () => {
    if (!verificacionPendiente) {
      return;
    }
    const codigo = codigoVerificacion.trim();
    if (!/^\d{6}$/.test(codigo)) {
      setErrorVerificacion("Ingrese un código válido de 6 dígitos");
      return;
    }
    setIsVerificandoCodigo(true);
    setErrorVerificacion("");
    try {
      const res = await fetch(apiUrl("/api/auth/verificar-correo-registro"), {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({
          nacionalidad: verificacionPendiente.nacionalidad,
          curp: verificacionPendiente.curp,
          identificacion: verificacionPendiente.identificacion,
          correo: verificacionPendiente.correo,
          codigo
        })
      });
      const data = await res.json().catch(() => ({}));
      if (!data.success) {
        setErrorVerificacion(data.error || "No se pudo verificar el código");
        return;
      }
      const loginData = await intentarLogin();
      if (loginData.success && loginData.usuario) {
        setShowVerificacionDialog(false);
        guardarSesionYEntrar(loginData.usuario);
        return;
      }
      setErrorVerificacion(loginData.error || "Correo verificado, pero no se pudo iniciar sesión");
    } catch {
      setErrorVerificacion("Error de conexión");
    } finally {
      setIsVerificandoCodigo(false);
    }
  };
  const handleReenviarCodigo = async () => {
    if (!verificacionPendiente || segundosRestantesReenvio > 0) {
      return;
    }
    setIsReenviandoCodigo(true);
    setErrorVerificacion("");
    try {
      const res = await fetch(apiUrl("/api/auth/registro-reenviar-codigo"), {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({
          nacionalidad: verificacionPendiente.nacionalidad,
          curp: verificacionPendiente.curp,
          identificacion: verificacionPendiente.identificacion,
          correo: verificacionPendiente.correo
        })
      });
      const data = await res.json().catch(() => ({}));
      if (data.success) {
        setSegundosRestantesReenvio(
          typeof data.segundosRestantes === "number" ? data.segundosRestantes : 60
        );
        return;
      }
      if (typeof data.segundosRestantes === "number" && data.segundosRestantes > 0) {
        setSegundosRestantesReenvio(data.segundosRestantes);
      }
      setErrorVerificacion(data.error || "No se pudo reenviar el código");
    } catch {
      setErrorVerificacion("Error de conexión");
    } finally {
      setIsReenviandoCodigo(false);
    }
  };
  return /* @__PURE__ */ jsxs("div", { className: "space-y-5 sm:space-y-8", children: [
    /* @__PURE__ */ jsxs("div", { className: "space-y-3 sm:space-y-4", children: [
      /* @__PURE__ */ jsx("div", { className: "flex justify-center", children: /* @__PURE__ */ jsx(
        "img",
        {
          src: assetPath("/LogoHJM.svg"),
          alt: "Hospital Juárez de México",
          className: "h-28 w-auto dark:invert sm:h-32 login-logo-entrance",
          onContextMenu: (e) => e.preventDefault(),
          onDragStart: (e) => e.preventDefault(),
          draggable: false
        }
      ) }),
      /* @__PURE__ */ jsxs("div", { className: "space-y-3 text-center sm:space-y-2", children: [
        /* @__PURE__ */ jsx("p", { className: "mx-auto max-w-[16ch] text-center text-2xl font-semibold leading-snug text-foreground sm:hidden", children: "Registro de Proyectos de Investigación" }),
        /* @__PURE__ */ jsx("h2", { className: "text-xs font-semibold tracking-[0.08em] uppercase text-muted-foreground sm:text-3xl sm:font-semibold sm:normal-case sm:tracking-normal sm:text-foreground", children: "Bienvenido" }),
        /* @__PURE__ */ jsx("p", { className: "hidden text-sm text-muted-foreground sm:block", children: "Ingresa tus credenciales para acceder al sistema" })
      ] })
    ] }),
    /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "space-y-4 sm:space-y-6", children: [
      errorGeneral && /* @__PURE__ */ jsx("p", { className: "text-sm text-destructive text-center", children: errorGeneral }),
      /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
        /* @__PURE__ */ jsx(
          Label,
          {
            htmlFor: "curp",
            className: "text-sm font-medium text-foreground",
            children: "CURP o ID"
          }
        ),
        /* @__PURE__ */ jsxs("div", { className: "relative", children: [
          /* @__PURE__ */ jsx(
            HugeiconsIcon,
            {
              icon: IdentificationIcon,
              size: 20,
              strokeWidth: 2,
              className: "absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground pointer-events-none"
            }
          ),
          /* @__PURE__ */ jsx(
            "div",
            {
              "aria-hidden": true,
              className: "absolute left-10 top-2 bottom-2 w-px bg-border pointer-events-none"
            }
          ),
          /* @__PURE__ */ jsx(
            Input,
            {
              id: "curp",
              type: "text",
              placeholder: "Ingresa tu CURP o ID",
              value: formData.curp,
              onChange: (e) => handleChange("curp", e.target.value),
              onBlur: () => handleBlur("curp"),
              className: `pl-12 transition-colors ${touched.curp && errors.curp ? "border-destructive focus-visible:ring-destructive" : ""}`,
              disabled: isLoading,
              maxLength: 18
            }
          )
        ] }),
        touched.curp && errors.curp && /* @__PURE__ */ jsx("p", { className: "text-sm text-destructive", children: errors.curp })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
        /* @__PURE__ */ jsx(
          Label,
          {
            htmlFor: "password",
            className: "text-sm font-medium text-foreground",
            children: "Contraseña"
          }
        ),
        /* @__PURE__ */ jsxs("div", { className: "relative", children: [
          /* @__PURE__ */ jsx(
            HugeiconsIcon,
            {
              icon: LockedIcon,
              size: 20,
              strokeWidth: 2,
              className: "absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground pointer-events-none"
            }
          ),
          /* @__PURE__ */ jsx(
            "div",
            {
              "aria-hidden": true,
              className: "absolute left-10 top-2 bottom-2 w-px bg-border pointer-events-none"
            }
          ),
          /* @__PURE__ */ jsx(
            Input,
            {
              id: "password",
              type: showPassword ? "text" : "password",
              placeholder: "Ingresa tu contraseña",
              value: formData.password,
              onChange: (e) => handleChange("password", e.target.value),
              onBlur: () => handleBlur("password"),
              className: `pl-12 pr-10 transition-colors ${touched.password && errors.password ? "border-destructive focus-visible:ring-destructive" : ""}`,
              disabled: isLoading
            }
          ),
          /* @__PURE__ */ jsx(
            "button",
            {
              type: "button",
              onClick: () => setShowPassword(!showPassword),
              className: "absolute right-3 top-1/2 -translate-y-1/2 text-muted-foreground hover:text-foreground transition-colors",
              tabIndex: -1,
              disabled: isLoading,
              children: showPassword ? /* @__PURE__ */ jsx(
                HugeiconsIcon,
                {
                  icon: ViewOffSlashIcon,
                  size: 20,
                  strokeWidth: 2
                }
              ) : /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ViewIcon, size: 20, strokeWidth: 2 })
            }
          )
        ] }),
        touched.password && errors.password && /* @__PURE__ */ jsx("p", { className: "text-sm text-destructive", children: errors.password })
      ] }),
      /* @__PURE__ */ jsx(
        Button,
        {
          type: "submit",
          className: "w-full",
          disabled: isLoading,
          children: isLoading ? "Iniciando sesión..." : "Iniciar Sesión"
        }
      ),
      /* @__PURE__ */ jsxs("div", { className: "flex flex-col sm:flex-row sm:items-center sm:justify-between gap-6 sm:gap-2 text-sm", children: [
        /* @__PURE__ */ jsx(
          Link,
          {
            to: "/recuperar-password",
            className: "text-primary hover:text-primary/80 hover:underline transition-colors",
            children: "¿Olvidaste tu contraseña?"
          }
        ),
        /* @__PURE__ */ jsxs(
          Link,
          {
            to: "/registro",
            className: "text-muted-foreground hover:text-foreground transition-colors",
            children: [
              "¿No tienes cuenta?",
              " ",
              /* @__PURE__ */ jsx("span", { className: "text-primary font-medium", children: "Regístrate" })
            ]
          }
        )
      ] })
    ] }),
    /* @__PURE__ */ jsx(AlertDialog, { open: showVerificacionDialog, onOpenChange: setShowVerificacionDialog, children: /* @__PURE__ */ jsxs(AlertDialogContent, { className: "sm:max-w-[460px]", children: [
      /* @__PURE__ */ jsxs(AlertDialogHeader, { className: "text-left sm:text-left place-items-start", children: [
        /* @__PURE__ */ jsx(AlertDialogTitle, { children: "Verificar correo electrónico" }),
        /* @__PURE__ */ jsx(AlertDialogDescription, { asChild: true, children: /* @__PURE__ */ jsxs("div", { className: "space-y-3 text-sm", children: [
          /* @__PURE__ */ jsxs("p", { children: [
            "Debe verificar su correo antes de continuar. Ingrese el código enviado a:",
            " ",
            /* @__PURE__ */ jsx("span", { className: "font-medium text-foreground", children: verificacionPendiente?.correo || "—" })
          ] }),
          /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsx(Label, { htmlFor: "codigoVerificacionLogin", children: "Código" }),
            /* @__PURE__ */ jsx(
              InputOTP,
              {
                id: "codigoVerificacionLogin",
                value: codigoVerificacion,
                onChange: (value) => setCodigoVerificacion(value.replace(/\D/g, "").slice(0, 6)),
                maxLength: 6,
                pattern: REGEXP_ONLY_DIGITS,
                containerClassName: "justify-start",
                children: /* @__PURE__ */ jsxs(InputOTPGroup, { children: [
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 0 }),
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 1 }),
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 2 }),
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 3 }),
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 4 }),
                  /* @__PURE__ */ jsx(InputOTPSlot, { index: 5 })
                ] })
              }
            )
          ] }),
          errorVerificacion && /* @__PURE__ */ jsx("p", { className: "text-destructive", children: errorVerificacion })
        ] }) })
      ] }),
      /* @__PURE__ */ jsxs(AlertDialogFooter, { children: [
        /* @__PURE__ */ jsx(AlertDialogCancel, { disabled: isVerificandoCodigo, children: "Cerrar" }),
        /* @__PURE__ */ jsx(
          Button,
          {
            type: "button",
            variant: "outline",
            onClick: handleReenviarCodigo,
            disabled: isReenviandoCodigo || segundosRestantesReenvio > 0 || isVerificandoCodigo,
            children: isReenviandoCodigo ? "Reenviando..." : segundosRestantesReenvio > 0 ? `Reenviar en ${segundosRestantesReenvio}s` : "Reenviar código"
          }
        ),
        /* @__PURE__ */ jsx(
          Button,
          {
            type: "button",
            onClick: handleVerificarCodigo,
            disabled: isVerificandoCodigo,
            children: isVerificandoCodigo ? "Verificando..." : "Verificar"
          }
        )
      ] })
    ] }) })
  ] });
}
const SECUENCIA = ["j", "ArrowUp", "l", "ArrowDown"];
const TIEMPO_MAX_MS = 1200;
function coincideTecla(esperada, key) {
  if (esperada === "ArrowUp" || esperada === "ArrowDown") return key === esperada;
  return key.toLowerCase() === esperada;
}
function useCreditos(onActivar) {
  const indice = useRef(0);
  const ultimaTecla = useRef(0);
  useEffect(() => {
    const handleKeyDown = (e) => {
      if (e.repeat) return;
      const target = e.target;
      const esInput = target.tagName === "INPUT" || target.tagName === "TEXTAREA" || target.tagName === "SELECT" || target.isContentEditable;
      if (esInput) return;
      const ahora = Date.now();
      if (ahora - ultimaTecla.current > TIEMPO_MAX_MS) indice.current = 0;
      const esperada = SECUENCIA[indice.current];
      if (coincideTecla(esperada, e.key)) {
        if (e.key === "ArrowUp" || e.key === "ArrowDown") e.preventDefault();
        indice.current += 1;
        ultimaTecla.current = ahora;
        if (indice.current === SECUENCIA.length) {
          indice.current = 0;
          onActivar();
        }
      } else {
        indice.current = 0;
      }
    };
    window.addEventListener("keydown", handleKeyDown);
    return () => window.removeEventListener("keydown", handleKeyDown);
  }, [onActivar]);
}
const CREDITO_SISTEMA = "JOSÉ LUIS ROCHIN UPTON";
function LoginPage() {
  const versionDisplay = useVersionDisplay();
  const onCreditos = useCallback(() => {
    toast(`Desarrollado por ${CREDITO_SISTEMA}`, {
      duration: 4e3,
      className: "text-sm"
    });
  }, []);
  useCreditos(onCreditos);
  return /* @__PURE__ */ jsxs("div", { className: "min-h-dvh flex bg-muted", children: [
    /* @__PURE__ */ jsx("div", { className: "absolute top-4 right-4 hidden lg:block login-theme-entrance", children: /* @__PURE__ */ jsx(ThemeToggle, {}) }),
    /* @__PURE__ */ jsxs("div", { className: "hidden lg:flex lg:w-1/2 px-8 pb-8 pt-4 flex-col justify-between relative", children: [
      /* @__PURE__ */ jsxs("div", { className: "space-y-4 z-10 login-header-top-entrance", children: [
        /* @__PURE__ */ jsx("h1", { className: "text-2xl font-bold text-foreground leading-tight", children: "Registro de Proyectos de Investigación" }),
        /* @__PURE__ */ jsx("p", { className: "text-base text-muted-foreground", children: "División de Investigación" })
      ] }),
      /* @__PURE__ */ jsx("div", { className: "absolute inset-8 flex items-center justify-center", children: /* @__PURE__ */ jsx("img", { src: assetPath("/investigacion.webp"), alt: "Investigación", className: "max-w-full max-h-full object-contain login-image-entrance", onContextMenu: (e) => e.preventDefault(), onDragStart: (e) => e.preventDefault(), draggable: false }) }),
      /* @__PURE__ */ jsx("div", { className: "text-sm text-muted-foreground z-10 login-header-bottom-entrance", children: "Sistema de gestión de proyectos de investigación" })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: "lg:w-1/2 w-full flex flex-col justify-center px-4 py-4 sm:px-8 sm:pb-8 sm:pt-4", children: [
      /* @__PURE__ */ jsx("div", { className: "flex items-center justify-center", children: /* @__PURE__ */ jsx("div", { className: "w-full max-w-lg bg-card border border-border rounded-lg sm:rounded-xl shadow-lg p-5 sm:p-10 content-entrance", children: /* @__PURE__ */ jsx(LoginForm, {}) }) }),
      /* @__PURE__ */ jsxs("p", { className: "fixed right-4 bottom-1 z-10 text-right text-xs text-muted-foreground sm:right-8 sm:bottom-4 sm:text-sm lg:bottom-8 login-version-entrance", children: [
        "v",
        versionDisplay
      ] })
    ] })
  ] });
}
export {
  LoginPage as component
};
