const PASOS_POR_COMITE = {
  1: [0, 1, 2],
  2: [3, 4, 5],
  3: [6, 7]
};
const NOMBRES_PASO = [
  "Solicitud y proponente",
  "Características",
  "Colaboradores",
  "Descripción del proyecto",
  "Datos de investigadores",
  "Marco de Referencia del Proyecto",
  "Material y Método",
  "Organización administrativa"
];
const TIPOS_ARCHIVO_POR_PASO = {
  0: ["carta_aprobacion"],
  1: ["carta_colaboracion"],
  5: ["marco_referencia"],
  6: ["recoleccion_datos"],
  7: ["programa_gasto", "cronograma"]
};
function obtenerComiteDesdeRol(rolNombre) {
  if (!rolNombre) return null;
  const normalizado = normalizarRol(rolNombre);
  const match = normalizado.match(/comite\s*([123])/);
  if (!match) return null;
  const comite = Number(match[1]);
  if (comite === 1 || comite === 2 || comite === 3) return comite;
  return null;
}
function esAdminDesdeRol(rolNombre) {
  return normalizarRol(rolNombre).includes("admin");
}
function obtenerComiteDesdeRolOId(rolNombre, rolId) {
  const desdeNombre = obtenerComiteDesdeRol(rolNombre);
  if (desdeNombre != null) return desdeNombre;
  if (rolId === 3) return 1;
  if (rolId === 4) return 2;
  if (rolId === 5) return 3;
  return null;
}
function esAdminDesdeRolOId(rolNombre, rolId) {
  if (rolId === 2) return true;
  return esAdminDesdeRol(rolNombre);
}
function parseComite(value) {
  const num = Number(value);
  if (num === 1 || num === 2 || num === 3) return num;
  return null;
}
function normalizarRol(rolNombre) {
  return String(rolNombre || "").normalize("NFD").replace(/[\u0300-\u036f]/g, "").toLowerCase().trim();
}
export {
  NOMBRES_PASO as N,
  PASOS_POR_COMITE as P,
  TIPOS_ARCHIVO_POR_PASO as T,
  esAdminDesdeRolOId as e,
  obtenerComiteDesdeRolOId as o,
  parseComite as p
};
