import { jsx, jsxs } from "react/jsx-runtime";
import { Dialog as Dialog$1 } from "radix-ui";
import { HugeiconsIcon } from "@hugeicons/react";
import { Cancel01Icon } from "@hugeicons/core-free-icons";
import { c as cn } from "./utils-H80jjgLf.mjs";
import { B as Button } from "./button-Bp95UwA9.mjs";
import { b as apiUrl } from "./router-5yTRMCgc.mjs";
function Dialog({
  ...props
}) {
  return /* @__PURE__ */ jsx(Dialog$1.Root, { "data-slot": "dialog", ...props });
}
function DialogTrigger({
  ...props
}) {
  return /* @__PURE__ */ jsx(Dialog$1.Trigger, { "data-slot": "dialog-trigger", ...props });
}
function DialogPortal({
  ...props
}) {
  return /* @__PURE__ */ jsx(Dialog$1.Portal, { "data-slot": "dialog-portal", ...props });
}
function DialogOverlay({
  className,
  ...props
}) {
  return /* @__PURE__ */ jsx(
    Dialog$1.Overlay,
    {
      "data-slot": "dialog-overlay",
      className: cn("data-open:animate-in data-closed:animate-out data-closed:fade-out-0 data-open:fade-in-0 bg-black/10 duration-100 supports-backdrop-filter:backdrop-blur-xs fixed inset-0 isolate z-50", className),
      ...props
    }
  );
}
function DialogContent({
  className,
  children,
  showCloseButton = true,
  ...props
}) {
  return /* @__PURE__ */ jsxs(DialogPortal, { children: [
    /* @__PURE__ */ jsx(DialogOverlay, {}),
    /* @__PURE__ */ jsxs(
      Dialog$1.Content,
      {
        "data-slot": "dialog-content",
        className: cn(
          "bg-background data-open:animate-in data-closed:animate-out data-closed:fade-out-0 data-open:fade-in-0 data-closed:zoom-out-95 data-open:zoom-in-95 ring-foreground/10 grid max-w-[calc(100%-2rem)] gap-6 rounded-xl p-6 text-sm ring-1 duration-100 sm:max-w-md fixed top-1/2 left-1/2 z-50 w-full -translate-x-1/2 -translate-y-1/2",
          className
        ),
        ...props,
        children: [
          children,
          showCloseButton && /* @__PURE__ */ jsx(Dialog$1.Close, { "data-slot": "dialog-close", asChild: true, children: /* @__PURE__ */ jsxs(Button, { variant: "ghost", className: "absolute top-4 right-4", size: "icon-sm", children: [
            /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, strokeWidth: 2 }),
            /* @__PURE__ */ jsx("span", { className: "sr-only", children: "Close" })
          ] }) })
        ]
      }
    )
  ] });
}
function DialogHeader({ className, ...props }) {
  return /* @__PURE__ */ jsx(
    "div",
    {
      "data-slot": "dialog-header",
      className: cn("gap-2 flex flex-col", className),
      ...props
    }
  );
}
function DialogTitle({
  className,
  ...props
}) {
  return /* @__PURE__ */ jsx(
    Dialog$1.Title,
    {
      "data-slot": "dialog-title",
      className: cn("leading-none font-medium", className),
      ...props
    }
  );
}
function DialogDescription({
  className,
  ...props
}) {
  return /* @__PURE__ */ jsx(
    Dialog$1.Description,
    {
      "data-slot": "dialog-description",
      className: cn("text-muted-foreground *:[a]:hover:text-foreground text-sm *:[a]:underline *:[a]:underline-offset-3", className),
      ...props
    }
  );
}
const defaults = {
  credentials: "include",
  headers: { "Content-Type": "application/json" }
};
async function crearProyecto() {
  const res = await fetch(apiUrl("/api/proyectos"), { ...defaults, method: "POST" });
  const data = await res.json().catch(() => ({}));
  if (!res.ok) return { success: false, error: data?.error || "Error al crear proyecto" };
  return { success: true, id: data.id };
}
async function listarProyectos() {
  const res = await fetch(apiUrl("/api/proyectos"), { ...defaults, method: "GET" });
  const data = await res.json().catch(() => ({}));
  if (!res.ok) return { success: false, error: data?.error, proyectos: [] };
  return { success: true, proyectos: data.proyectos || [] };
}
async function obtenerProyecto(id) {
  const res = await fetch(apiUrl(`/api/proyectos/${id}`), { ...defaults, method: "GET" });
  const data = await res.json().catch(() => ({}));
  if (!res.ok) return { success: false, error: data?.error };
  return {
    success: true,
    proyecto: data.proyecto,
    datosPorPaso: data.datosPorPaso || {},
    archivos: data.archivos || []
  };
}
async function obtenerComentariosRevisionProyecto(id) {
  const res = await fetch(apiUrl(`/api/proyectos/${id}/comentarios-revision`), { ...defaults, method: "GET" });
  const data = await res.json().catch(() => ({}));
  if (!res.ok) return { success: false, error: data?.error || "Error al obtener comentarios" };
  return {
    success: true,
    comentarios: data.comentarios || [],
    aprobaciones: data.aprobaciones || [],
    nombresPaso: data.nombresPaso || []
  };
}
async function actualizarProyecto(id, body) {
  const res = await fetch(apiUrl(`/api/proyectos/${id}`), {
    ...defaults,
    method: "PATCH",
    body: JSON.stringify(body)
  });
  const data = await res.json().catch(() => ({}));
  if (!res.ok) return { success: false, error: data?.error || "Error al actualizar" };
  return { success: true };
}
async function subirArchivoProyecto(proyectoId, tipoArchivo, file) {
  const form = new FormData();
  form.append("tipo_archivo", tipoArchivo);
  form.append("archivo", file);
  const res = await fetch(apiUrl(`/api/proyectos/${proyectoId}/archivos`), {
    credentials: "include",
    method: "POST",
    body: form
  });
  const data = await res.json().catch(() => ({}));
  if (!res.ok) return { success: false, error: data?.error || "Error al subir archivo" };
  return { success: true, ruta_servidor: data.ruta_servidor, nombre_original: data.nombre_original };
}
function urlArchivoProyecto(proyectoId, tipoArchivo) {
  return apiUrl(`/api/proyectos/${proyectoId}/archivos/${tipoArchivo}`);
}
export {
  Dialog as D,
  DialogTrigger as a,
  DialogContent as b,
  DialogHeader as c,
  DialogTitle as d,
  DialogDescription as e,
  actualizarProyecto as f,
  crearProyecto as g,
  obtenerComentariosRevisionProyecto as h,
  listarProyectos as l,
  obtenerProyecto as o,
  subirArchivoProyecto as s,
  urlArchivoProyecto as u
};
