import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { useNavigate } from "@tanstack/react-router";
import { HugeiconsIcon } from "@hugeicons/react";
import { Tick02Icon, InformationCircleIcon, Upload01Icon, FileUploadIcon, Cancel01Icon, Calendar03Icon, PlusSignIcon, ArrowLeft01Icon, ArrowRight01Icon, ArrowLeftIcon, ArrowRightIcon, ArrowDownIcon } from "@hugeicons/core-free-icons";
import { format } from "date-fns";
import { es } from "date-fns/locale";
import * as React from "react";
import { useState, useRef, useCallback, useEffect, useMemo } from "react";
import { C as Card, a as CardHeader, b as CardTitle, d as CardContent, c as CardDescription } from "./card-B_lDvuvx.mjs";
import { I as Input } from "./input-B66ag17B.mjs";
import { L as Label } from "./label-Cp5Wz1sX.mjs";
import { T as Textarea } from "./textarea-D2EGKnT3.mjs";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-D2Xe1kOZ.mjs";
import { Switch as Switch$1, Popover as Popover$1 } from "radix-ui";
import { c as cn } from "./utils-H80jjgLf.mjs";
import { cva } from "class-variance-authority";
import { B as Badge } from "./badge-D2nuHzhh.mjs";
import { B as Button, b as buttonVariants } from "./button-Bp95UwA9.mjs";
import { o as obtenerProyecto, u as urlArchivoProyecto, D as Dialog, a as DialogTrigger, b as DialogContent, c as DialogHeader, d as DialogTitle, e as DialogDescription, s as subirArchivoProyecto, f as actualizarProyecto, g as crearProyecto } from "./api-proyectos-BavXVf60.mjs";
import { getDefaultClassNames, DayPicker } from "react-day-picker";
import { P as Progress } from "./progress-YjR2HPKE.mjs";
import { d as Route$5, g as getUsuarioSesion, b as apiUrl } from "./router-5yTRMCgc.mjs";
import "clsx";
import "tailwind-merge";
import "@tanstack/react-query";
import "next-themes";
import "sonner";
function Switch({
  className,
  size = "default",
  ...props
}) {
  return /* @__PURE__ */ jsx(
    Switch$1.Root,
    {
      "data-slot": "switch",
      "data-size": size,
      className: cn(
        "data-checked:bg-primary data-unchecked:bg-input focus-visible:border-ring focus-visible:ring-ring/50 aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive dark:aria-invalid:border-destructive/50 dark:data-unchecked:bg-input/80 shrink-0 rounded-full border border-transparent shadow-xs focus-visible:ring-[3px] aria-invalid:ring-[3px] data-[size=default]:h-[18.4px] data-[size=default]:w-[32px] data-[size=sm]:h-[14px] data-[size=sm]:w-[24px] peer group/switch relative inline-flex items-center transition-all outline-none after:absolute after:-inset-x-3 after:-inset-y-2 data-disabled:cursor-not-allowed data-disabled:opacity-50",
        className
      ),
      ...props,
      children: /* @__PURE__ */ jsx(
        Switch$1.Thumb,
        {
          "data-slot": "switch-thumb",
          className: "bg-background dark:data-unchecked:bg-foreground dark:data-checked:bg-primary-foreground rounded-full group-data-[size=default]/switch:size-4 group-data-[size=sm]/switch:size-3 group-data-[size=default]/switch:data-checked:translate-x-[calc(100%-2px)] group-data-[size=sm]/switch:data-checked:translate-x-[calc(100%-2px)] group-data-[size=default]/switch:data-unchecked:translate-x-0 group-data-[size=sm]/switch:data-unchecked:translate-x-0 pointer-events-none block ring-0 transition-transform"
        }
      )
    }
  );
}
const alertVariants = cva("grid gap-0.5 rounded-lg border px-4 py-3 text-left text-sm has-data-[slot=alert-action]:relative has-data-[slot=alert-action]:pr-18 has-[>svg]:grid-cols-[auto_1fr] has-[>svg]:gap-x-2.5 *:[svg]:row-span-2 *:[svg]:translate-y-0.5 *:[svg]:text-current *:[svg:not([class*='size-'])]:size-4 w-full relative group/alert", {
  variants: {
    variant: {
      default: "bg-card text-card-foreground",
      destructive: "text-destructive bg-card *:data-[slot=alert-description]:text-destructive/90 *:[svg]:text-current"
    }
  },
  defaultVariants: {
    variant: "default"
  }
});
function Alert({
  className,
  variant,
  ...props
}) {
  return /* @__PURE__ */ jsx(
    "div",
    {
      "data-slot": "alert",
      role: "alert",
      className: cn(alertVariants({ variant }), className),
      ...props
    }
  );
}
function AlertDescription({
  className,
  ...props
}) {
  return /* @__PURE__ */ jsx(
    "div",
    {
      "data-slot": "alert-description",
      className: cn(
        "text-muted-foreground text-sm text-balance md:text-pretty [&_p:not(:last-child)]:mb-4 [&_a]:hover:text-foreground [&_a]:underline [&_a]:underline-offset-3",
        className
      ),
      ...props
    }
  );
}
function AlertAction({ className, ...props }) {
  return /* @__PURE__ */ jsx(
    "div",
    {
      "data-slot": "alert-action",
      className: cn("absolute top-2.5 right-3", className),
      ...props
    }
  );
}
function Popover({
  ...props
}) {
  return /* @__PURE__ */ jsx(Popover$1.Root, { "data-slot": "popover", ...props });
}
function PopoverTrigger({
  ...props
}) {
  return /* @__PURE__ */ jsx(Popover$1.Trigger, { "data-slot": "popover-trigger", ...props });
}
function PopoverContent({
  className,
  align = "center",
  sideOffset = 4,
  ...props
}) {
  return /* @__PURE__ */ jsx(Popover$1.Portal, { children: /* @__PURE__ */ jsx(
    Popover$1.Content,
    {
      "data-slot": "popover-content",
      align,
      sideOffset,
      className: cn(
        "bg-popover text-popover-foreground data-open:animate-in data-closed:animate-out data-closed:fade-out-0 data-open:fade-in-0 data-closed:zoom-out-95 data-open:zoom-in-95 data-[side=bottom]:slide-in-from-top-2 data-[side=left]:slide-in-from-right-2 data-[side=right]:slide-in-from-left-2 data-[side=top]:slide-in-from-bottom-2 ring-foreground/10 flex flex-col gap-4 rounded-md p-4 text-sm shadow-md ring-1 duration-100 z-50 w-72 origin-(--radix-popover-content-transform-origin) outline-hidden",
        className
      ),
      ...props
    }
  ) });
}
function Calendar({
  className,
  classNames,
  showOutsideDays = true,
  captionLayout = "label",
  buttonVariant = "ghost",
  formatters,
  components,
  locale = es,
  ...props
}) {
  const defaultClassNames = getDefaultClassNames();
  return /* @__PURE__ */ jsx(
    DayPicker,
    {
      locale,
      showOutsideDays,
      className: cn(
        "p-3 [--cell-radius:var(--radius-md)] [--cell-size:--spacing(8)] bg-background group/calendar [[data-slot=card-content]_&]:bg-transparent [[data-slot=popover-content]_&]:bg-transparent",
        String.raw`rtl:**:[.rdp-button\_next>svg]:rotate-180`,
        String.raw`rtl:**:[.rdp-button\_previous>svg]:rotate-180`,
        className
      ),
      captionLayout,
      formatters: {
        formatMonthDropdown: (date) => date.toLocaleString("es", { month: "short" }),
        ...formatters
      },
      classNames: {
        root: cn("w-fit", defaultClassNames.root),
        months: cn(
          "flex gap-4 flex-col md:flex-row relative",
          defaultClassNames.months
        ),
        month: cn("flex flex-col w-full gap-4", defaultClassNames.month),
        nav: cn(
          "flex items-center gap-1 w-full absolute top-0 inset-x-0 justify-between",
          defaultClassNames.nav
        ),
        button_previous: cn(
          buttonVariants({ variant: buttonVariant }),
          "size-(--cell-size) aria-disabled:opacity-50 p-0 select-none",
          defaultClassNames.button_previous
        ),
        button_next: cn(
          buttonVariants({ variant: buttonVariant }),
          "size-(--cell-size) aria-disabled:opacity-50 p-0 select-none",
          defaultClassNames.button_next
        ),
        month_caption: cn(
          "flex items-center justify-center h-(--cell-size) w-full px-(--cell-size)",
          defaultClassNames.month_caption
        ),
        dropdowns: cn(
          "w-full flex items-center text-sm font-medium justify-center h-(--cell-size) gap-1.5",
          defaultClassNames.dropdowns
        ),
        dropdown_root: cn(
          "relative cn-calendar-dropdown-root rounded-(--cell-radius)",
          defaultClassNames.dropdown_root
        ),
        dropdown: cn(
          "absolute bg-popover inset-0 opacity-0",
          defaultClassNames.dropdown
        ),
        caption_label: cn(
          "select-none font-medium",
          captionLayout === "label" ? "text-sm" : "cn-calendar-caption-label rounded-(--cell-radius) flex items-center gap-1 text-sm  [&>svg]:text-muted-foreground [&>svg]:size-3.5",
          defaultClassNames.caption_label
        ),
        table: "w-full border-collapse",
        weekdays: cn("flex", defaultClassNames.weekdays),
        weekday: cn(
          "text-muted-foreground rounded-(--cell-radius) flex-1 font-normal text-[0.8rem] select-none",
          defaultClassNames.weekday
        ),
        week: cn("flex w-full mt-2", defaultClassNames.week),
        week_number_header: cn(
          "select-none w-(--cell-size)",
          defaultClassNames.week_number_header
        ),
        week_number: cn(
          "text-[0.8rem] select-none text-muted-foreground",
          defaultClassNames.week_number
        ),
        day: cn(
          "relative w-full rounded-(--cell-radius) h-full p-0 text-center [&:last-child[data-selected=true]_button]:rounded-r-(--cell-radius) group/day aspect-square select-none",
          props.showWeekNumber ? "[&:nth-child(2)[data-selected=true]_button]:rounded-l-(--cell-radius)" : "[&:first-child[data-selected=true]_button]:rounded-l-(--cell-radius)",
          defaultClassNames.day
        ),
        range_start: cn(
          "rounded-l-(--cell-radius) bg-muted relative after:bg-muted after:absolute after:inset-y-0 after:w-4 after:right-0 -z-0 isolate",
          defaultClassNames.range_start
        ),
        range_middle: cn("rounded-none", defaultClassNames.range_middle),
        range_end: cn(
          "rounded-r-(--cell-radius) bg-muted relative after:bg-muted-200 after:absolute after:inset-y-0 after:w-4 after:left-0 -z-0 isolate",
          defaultClassNames.range_end
        ),
        today: cn(
          "bg-muted text-foreground rounded-(--cell-radius) data-[selected=true]:rounded-none",
          defaultClassNames.today
        ),
        outside: cn(
          "text-muted-foreground aria-selected:text-muted-foreground",
          defaultClassNames.outside
        ),
        disabled: cn(
          "text-muted-foreground opacity-50",
          defaultClassNames.disabled
        ),
        hidden: cn("invisible", defaultClassNames.hidden),
        ...classNames
      },
      components: {
        Root: ({ className: className2, rootRef, ...props2 }) => {
          return /* @__PURE__ */ jsx(
            "div",
            {
              "data-slot": "calendar",
              ref: rootRef,
              className: cn(className2),
              ...props2
            }
          );
        },
        Chevron: ({ className: className2, orientation, ...props2 }) => {
          if (orientation === "left") {
            return /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ArrowLeftIcon, strokeWidth: 2, className: cn("size-4", className2), ...props2 });
          }
          if (orientation === "right") {
            return /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ArrowRightIcon, strokeWidth: 2, className: cn("size-4", className2), ...props2 });
          }
          return /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ArrowDownIcon, strokeWidth: 2, className: cn("size-4", className2), ...props2 });
        },
        DayButton: CalendarDayButton,
        WeekNumber: ({ children, ...props2 }) => {
          return /* @__PURE__ */ jsx("td", { ...props2, children: /* @__PURE__ */ jsx("div", { className: "flex size-(--cell-size) items-center justify-center text-center", children }) });
        },
        ...components
      },
      ...props
    }
  );
}
function CalendarDayButton({
  className,
  day,
  modifiers,
  ...props
}) {
  const defaultClassNames = getDefaultClassNames();
  const ref = React.useRef(null);
  React.useEffect(() => {
    if (modifiers.focused) ref.current?.focus();
  }, [modifiers.focused]);
  return /* @__PURE__ */ jsx(
    Button,
    {
      ref,
      variant: "ghost",
      size: "icon",
      "data-day": day.date.toLocaleDateString(),
      "data-selected-single": modifiers.selected && !modifiers.range_start && !modifiers.range_end && !modifiers.range_middle,
      "data-range-start": modifiers.range_start,
      "data-range-end": modifiers.range_end,
      "data-range-middle": modifiers.range_middle,
      className: cn(
        "data-[selected-single=true]:bg-primary data-[selected-single=true]:text-primary-foreground data-[range-middle=true]:bg-muted data-[range-middle=true]:text-foreground data-[range-start=true]:bg-primary data-[range-start=true]:text-primary-foreground data-[range-end=true]:bg-primary data-[range-end=true]:text-primary-foreground group-data-[focused=true]/day:border-ring group-data-[focused=true]/day:ring-ring/50 dark:hover:text-foreground relative isolate z-10 flex aspect-square size-auto w-full min-w-(--cell-size) flex-col gap-1 border-0 leading-none font-normal group-data-[focused=true]/day:relative group-data-[focused=true]/day:z-10 group-data-[focused=true]/day:ring-[3px] data-[range-end=true]:rounded-(--cell-radius) data-[range-end=true]:rounded-r-(--cell-radius) data-[range-middle=true]:rounded-none data-[range-start=true]:rounded-(--cell-radius) data-[range-start=true]:rounded-l-(--cell-radius) [&>span]:text-xs [&>span]:opacity-70",
        defaultClassNames.day,
        className
      ),
      ...props
    }
  );
}
const DISCIPLINAS = [{
  value: "1",
  label: "Alergia e Inmunología Clínica"
}, {
  value: "2",
  label: "Anatomía Patológica"
}, {
  value: "3",
  label: "Maestria"
}, {
  value: "4",
  label: "Doctorado"
}, {
  value: "5",
  label: "Anestesiología"
}, {
  value: "6",
  label: "Biología de la Reproducción Humana"
}, {
  value: "7",
  label: "Cardiología"
}, {
  value: "8",
  label: "Cardiología Intervencionista"
}, {
  value: "9",
  label: "Cirugía General"
}, {
  value: "10",
  label: "Cirugía Maxilofacial"
}, {
  value: "11",
  label: "Cirugía Analógica"
}, {
  value: "12",
  label: "Endoscopia Gastrointestinal"
}, {
  value: "13",
  label: "Epidemiologia"
}, {
  value: "14",
  label: "Gastroenterología"
}, {
  value: "15",
  label: "Ginecología Oncológica"
}, {
  value: "16",
  label: "Ginecología Y Obstetricia"
}, {
  value: "17",
  label: "Hematología"
}, {
  value: "18",
  label: "Imagenologia, Diagnóstica y Terapéutica"
}, {
  value: "19",
  label: "Investigación"
}, {
  value: "20",
  label: "Medicina Critica"
}, {
  value: "21",
  label: "Medicina de Urgencias"
}, {
  value: "22",
  label: "Medicina del Dolor"
}, {
  value: "23",
  label: "Medicina Interna"
}, {
  value: "24",
  label: "Motilidad Gastrointestinal"
}, {
  value: "25",
  label: "Nefrología"
}, {
  value: "26",
  label: "Neuroanestesiologia"
}, {
  value: "27",
  label: "Neurocirugía"
}, {
  value: "28",
  label: "Neurología"
}, {
  value: "29",
  label: "Oftalmología"
}, {
  value: "30",
  label: "Oncología Quirúrgica Cabeza y Cuello"
}, {
  value: "31",
  label: "Otorrinolaringología y Cirugía De Cabeza y Cuello"
}, {
  value: "32",
  label: "Pediatría"
}, {
  value: "33",
  label: "Reumatología"
}, {
  value: "34",
  label: "Soporte Nutricional y Metabólico"
}, {
  value: "35",
  label: "Terapia Endovascular Neurológica"
}, {
  value: "36",
  label: "Toxicología"
}, {
  value: "37",
  label: "Trasplante Renal"
}, {
  value: "38",
  label: "Traumatología Y Ortopedia"
}, {
  value: "39",
  label: "Urología"
}];
const NIVEL_MAXIMO_ESTUDIOS = [{
  value: "licenciatura",
  label: "Licenciatura o Ingenieria"
}, {
  value: "especialidad",
  label: "Especialidad"
}, {
  value: "maestria",
  label: "Maestria"
}, {
  value: "doctorado",
  label: "Doctorado"
}, {
  value: "postdoctorado",
  label: "Postdoctorado"
}];
const ESPECIALIDADES = [{
  value: "1",
  label: "Alergia e Inmunología Clínica"
}, {
  value: "2",
  label: "Anatomía Patológica"
}, {
  value: "3",
  label: "Anestesiología"
}, {
  value: "4",
  label: "Biología de la Reproducción Humana"
}, {
  value: "5",
  label: "Cardiología"
}, {
  value: "6",
  label: "Cardiología Intervencionista"
}, {
  value: "7",
  label: "Cirugía General"
}, {
  value: "8",
  label: "Cirugía Maxilofacial"
}, {
  value: "9",
  label: "Cirugía Analógica"
}, {
  value: "10",
  label: "Endoscopia Gastrointestinal"
}, {
  value: "11",
  label: "Epidemiologia"
}, {
  value: "12",
  label: "Gastroenterología"
}, {
  value: "13",
  label: "Ginecología Oncológica"
}, {
  value: "14",
  label: "Ginecología Y Obstetricia"
}, {
  value: "15",
  label: "Hematología"
}, {
  value: "16",
  label: "Imagenologia, Diagnóstica y Terapéutica"
}, {
  value: "17",
  label: "Investigación"
}, {
  value: "18",
  label: "Medicina Critica"
}, {
  value: "19",
  label: "Medicina de Urgencias"
}, {
  value: "20",
  label: "Medicina del Dolor"
}, {
  value: "21",
  label: "Medicina Interna"
}, {
  value: "22",
  label: "Motilidad Gastrointestinal"
}, {
  value: "23",
  label: "Nefrología"
}, {
  value: "24",
  label: "Neuroanestesiologia"
}, {
  value: "25",
  label: "Neurocirugía"
}, {
  value: "26",
  label: "Neurología"
}, {
  value: "27",
  label: "Oftalmología"
}, {
  value: "28",
  label: "Oncología Quirúrgica Cabeza y Cuello"
}, {
  value: "29",
  label: "Otorrinolaringología y Cirugía De Cabeza y Cuello"
}, {
  value: "30",
  label: "Pediatría"
}, {
  value: "31",
  label: "Reumatología"
}, {
  value: "32",
  label: "Soporte Nutricional y Metabólico"
}, {
  value: "33",
  label: "Terapia Endovascular Neurológica"
}, {
  value: "34",
  label: "Toxicología"
}, {
  value: "35",
  label: "Trasplante Renal"
}, {
  value: "36",
  label: "Traumatología Y Ortopedia"
}, {
  value: "37",
  label: "Urología"
}];
const NIVELES = [{
  value: "candidato",
  label: "Candidato"
}, {
  value: "1",
  label: "1"
}, {
  value: "2",
  label: "2"
}, {
  value: "3",
  label: "3"
}, {
  value: "emerito",
  label: "Emerito"
}];
const LINEAS_INVESTIGACION = [{
  value: "1",
  label: "Obesidad, síndrome metabólico y diabetes"
}, {
  value: "2",
  label: "Neoplasias diversas"
}, {
  value: "3",
  label: "Morbi-mortalidad materno-infantil"
}, {
  value: "4",
  label: "Epidemiología de las infecciones y resistencia microbiana"
}, {
  value: "5",
  label: "Inflamación y enfermedades auto-inmunes"
}, {
  value: "6",
  label: "Enfermedades neurodegenerativas y salud mental"
}, {
  value: "7",
  label: "Enfermedades cardiovasculares"
}, {
  value: "8",
  label: "Servicios quirúrgicos, trauma y rehabilitación"
}, {
  value: "9",
  label: "Efecto de la práctica de enfermería y cuidado del paciente"
}, {
  value: "10",
  label: "Uso de medicamentos y efectos adversos"
}];
const TIPOS_RIESGO = [{
  value: "riesgo_mayor_minimo",
  label: "Riesgo mayor al mínimo"
}, {
  value: "riesgo_minimo",
  label: "Riesgo mínimo"
}, {
  value: "sin_riesgo",
  label: "Sin riesgo"
}, {
  value: "no_aplica",
  label: "No aplica"
}];
const TIPOS_INVESTIGACION = [{
  value: "biomedica",
  label: "Biomédica"
}, {
  value: "clinica",
  label: "Clínica"
}, {
  value: "sociomedica_epidemiologica",
  label: "Sociomédica/Epidemiológica"
}];
const TIPOS_PROTOCOLO = [{
  value: "investigacion_original",
  label: "Investigación Original"
}, {
  value: "tesis_medica",
  label: "Tesis Médica"
}, {
  value: "industria_quimico_farmaceutica",
  label: "Investigación Industria Químico Farmaceutica o Afín"
}, {
  value: "tesis_enfermeria",
  label: "Tesis de Enfermería"
}];
const TIPOS_DISENO = [{
  value: "experimental",
  label: "Experimental"
}, {
  value: "cuasi_experimental",
  label: "Cuasi-experimental"
}, {
  value: "observacional_analitico",
  label: "Observacional analítico"
}, {
  value: "observacional_descriptivo",
  label: "Observacional descriptivo"
}, {
  value: "casos_controles",
  label: "Casos y controles"
}, {
  value: "cohortes",
  label: "Cohortes"
}, {
  value: "transversal",
  label: "Transversal"
}, {
  value: "serie_casos",
  label: "Serie de casos"
}, {
  value: "otro",
  label: "Otro"
}];
const PARTICIPACION_INVESTIGADOR = [{
  value: "observador",
  label: "Observador"
}, {
  value: "participante",
  label: "Participante"
}, {
  value: "mixto",
  label: "Mixto"
}];
const TEMPORALIDAD_ESTUDIO = [{
  value: "transversal",
  label: "Transversal"
}, {
  value: "longitudinal",
  label: "Longitudinal"
}, {
  value: "retrospectivo",
  label: "Retrospectivo"
}, {
  value: "prospectivo",
  label: "Prospectivo"
}];
const LECTURA_DATOS = [{
  value: "primarios",
  label: "Datos primarios"
}, {
  value: "secundarios",
  label: "Datos secundarios"
}, {
  value: "mixtos",
  label: "Mixtos"
}];
const ANALISIS_DATOS = [{
  value: "cualitativo",
  label: "Cualitativo"
}, {
  value: "cuantitativo",
  label: "Cuantitativo"
}, {
  value: "mixto",
  label: "Mixto"
}];
const VARIABLES_ESTUDIO = [{
  value: "dependientes",
  label: "Variables dependientes"
}, {
  value: "independientes",
  label: "Variables independientes"
}, {
  value: "confusoras",
  label: "Variables confusoras"
}, {
  value: "todas",
  label: "Todas las anteriores"
}];
const FUENTES_FINANCIAMIENTO = [{
  value: "interno",
  label: "Interno"
}, {
  value: "externo",
  label: "Externo"
}];
const TIPOS_ESTUDIO = [{
  value: "experimental",
  label: "Experimental"
}, {
  value: "observacional",
  label: "Observacional"
}];
const TIPOS_COLABORACION = [{
  value: "nacional",
  label: "Nacional"
}, {
  value: "internacional",
  label: "Internacional"
}];
const INSTITUCIONES_ACADEMICAS = [{
  value: "unam",
  label: "UNAM"
}, {
  value: "ipn",
  label: "IPN"
}, {
  value: "uam",
  label: "UAM"
}, {
  value: "otra",
  label: "Otra"
}];
const DIRECTORES_ENSENANZA = [{
  value: "1",
  label: "Director de Enseñanza 1"
}, {
  value: "2",
  label: "Director de Enseñanza 2"
}];
const TOTAL_STEPS = 8;
const LAST_STEP_INDEX = TOTAL_STEPS - 1;
function esCurpValida(value) {
  return /^[A-Z]{4}\d{6}[HM][A-Z]{5}[A-Z0-9]\d$/.test(value);
}
function asRecord(value) {
  if (!value || typeof value !== "object" || Array.isArray(value)) return null;
  return value;
}
function asString(value) {
  return typeof value === "string" ? value.trim() : "";
}
function sanitizeTelefono(value) {
  return asString(value).replace(/\D/g, "").slice(0, 10);
}
function sanitizeExtension(value) {
  return asString(value).replace(/\D/g, "").slice(0, 4);
}
function sanitizeOnlyNumbers(value) {
  return value.replace(/\D/g, "");
}
function sanitizeInvestigadorPrincipal(value) {
  const row = asRecord(value);
  if (!row) return null;
  const clean = {
    nombre: asString(row.nombre),
    adscripcion: asString(row.adscripcion),
    funcion: asString(row.funcion),
    correo: asString(row.correo),
    extension: sanitizeExtension(row.extension),
    nivelEstudios: asString(row.nivelEstudios),
    statusSni: asString(row.statusSni),
    esResponsable: Boolean(row.esResponsable)
  };
  if (!clean.nombre) return null;
  return clean;
}
function sanitizeCoinvestigador(value) {
  const row = asRecord(value);
  if (!row) return null;
  const clean = {
    nombre: asString(row.nombre),
    adscripcion: asString(row.adscripcion),
    funcion: asString(row.funcion),
    correo: asString(row.correo),
    extension: sanitizeExtension(row.extension),
    nivelEstudios: asString(row.nivelEstudios),
    statusSni: asString(row.statusSni)
  };
  if (!clean.nombre) return null;
  return clean;
}
function sanitizeDepartamentoParticipante(value) {
  const row = asRecord(value);
  if (!row) return null;
  const clean = {
    area: asString(row.area),
    responsable: asString(row.responsable)
  };
  if (!clean.area && !clean.responsable) return null;
  return clean;
}
function sanitizeInstitucionParticipante(value) {
  const row = asRecord(value);
  if (!row) return null;
  const clean = {
    clues: asString(row.clues),
    nombreInstitucion: asString(row.nombreInstitucion),
    nombreParticipante: asString(row.nombreParticipante),
    puesto: asString(row.puesto),
    numConvenio: asString(row.numConvenio),
    adscripcion: asString(row.adscripcion),
    telefono: sanitizeTelefono(row.telefono),
    correo: asString(row.correo)
  };
  if (!clean.clues && !clean.nombreInstitucion && !clean.nombreParticipante && !clean.puesto && !clean.numConvenio && !clean.adscripcion && !clean.telefono && !clean.correo) return null;
  return clean;
}
function sanitizeAutorizacionDepto(value) {
  const row = asRecord(value);
  return {
    departamentoCoordinacion: asString(row?.departamentoCoordinacion),
    responsableDepto: asString(row?.responsableDepto),
    claveAreaDepto: asString(row?.claveAreaDepto),
    subdireccionArea: asString(row?.subdireccionArea),
    responsableSubdir: asString(row?.responsableSubdir),
    claveAreaSubdir: asString(row?.claveAreaSubdir)
  };
}
function sanitizeIntencionDidactica(value) {
  const row = asRecord(value);
  return {
    especialidad: asString(row?.especialidad),
    institucionAcademica: asString(row?.institucionAcademica),
    directorEnsenanza: asString(row?.directorEnsenanza)
  };
}
function RegistroProyectoPage() {
  const [titulo, setTitulo] = useState("");
  const [tituloLength, setTituloLength] = useState(0);
  const maxTituloLength = 500;
  const [tipoSolicitud, setTipoSolicitud] = useState("");
  const [lineaInvestigacion, setLineaInvestigacion] = useState("");
  const [telefonoOficina, setTelefonoOficina] = useState("");
  const [extensionOficina, setExtensionOficina] = useState("");
  const [adscripcionProponente, setAdscripcionProponente] = useState("");
  const [disciplinaProponente, setDisciplinaProponente] = useState("");
  const [especialidadProponente, setEspecialidadProponente] = useState("");
  const [nivelProponente, setNivelProponente] = useState("");
  const [perteneceSniProponente, setPerteneceSniProponente] = useState(false);
  const [uploadedFile, setUploadedFile] = useState(null);
  const [subiendoArchivoPaso0, setSubiendoArchivoPaso0] = useState(false);
  const [popupArchivoSubidoPaso0, setPopupArchivoSubidoPaso0] = useState(false);
  const [progresoArchivoPaso0, setProgresoArchivoPaso0] = useState(0);
  const [isDragging, setIsDragging] = useState(false);
  const [isDialogOpen, setIsDialogOpen] = useState(false);
  const fileInputRef = useRef(null);
  const [uploadedFileColaboracion, setUploadedFileColaboracion] = useState(null);
  const [subiendoArchivoPaso1, setSubiendoArchivoPaso1] = useState(false);
  const [popupArchivoSubidoPaso1, setPopupArchivoSubidoPaso1] = useState(false);
  const [isDraggingColaboracion, setIsDraggingColaboracion] = useState(false);
  const [isDialogOpenColaboracion, setIsDialogOpenColaboracion] = useState(false);
  const fileInputRefColaboracion = useRef(null);
  const [instituciones, setInstituciones] = useState([]);
  const [nuevaInstitucion, setNuevaInstitucion] = useState("");
  const [requiereFarmacovigilancia, setRequiereFarmacovigilancia] = useState(false);
  const [fechaInicio, setFechaInicio] = useState(void 0);
  const [fechaTermino, setFechaTermino] = useState(void 0);
  const [tipoRiesgoPaso1, setTipoRiesgoPaso1] = useState("");
  const [tipoInvestigacionPaso1, setTipoInvestigacionPaso1] = useState("");
  const [tipoProtocoloPaso1, setTipoProtocoloPaso1] = useState("");
  const [fuenteFinanciamientoPaso1, setFuenteFinanciamientoPaso1] = useState("");
  const [montoPaso1, setMontoPaso1] = useState("");
  const [agenciaFinanciadoraPaso1, setAgenciaFinanciadoraPaso1] = useState("");
  const [tipoEstudioPaso1, setTipoEstudioPaso1] = useState("");
  const [tieneColaboracionPaso1, setTieneColaboracionPaso1] = useState("");
  const [tipoColaboracionPaso1, setTipoColaboracionPaso1] = useState("");
  const [fechaInicioProyecto, setFechaInicioProyecto] = useState(void 0);
  const [fechaTerminoProyecto, setFechaTerminoProyecto] = useState(void 0);
  const [tituloDescriptivo, setTituloDescriptivo] = useState("");
  const [areaEstudioProyecto, setAreaEstudioProyecto] = useState("");
  const [areaProyecto, setAreaProyecto] = useState("");
  const [subareaInvestigacionProyecto, setSubareaInvestigacionProyecto] = useState("");
  const [lineasPrioritariasClasifica, setLineasPrioritariasClasifica] = useState("");
  const [vigenciaDias, setVigenciaDias] = useState("");
  const [descripcionProyecto, setDescripcionProyecto] = useState("");
  const [currentStep, setCurrentStep] = useState(0);
  const [tiposAyuda, setTiposAyuda] = useState([]);
  const [nuevaAyuda, setNuevaAyuda] = useState({
    infraestructura: "",
    personal: "",
    material: "",
    equipo: ""
  });
  const [marcoReferencia, setMarcoReferencia] = useState({
    sintesisProyecto: "",
    planteamientoProblemaPregunta: "",
    objetivoGeneral: "",
    antecedentes: "",
    justificacionProyecto: "",
    objetivoEspecifico: ""
  });
  const [archivoMarcoReferencia, setArchivoMarcoReferencia] = useState(null);
  const [subiendoArchivoPaso5, setSubiendoArchivoPaso5] = useState(false);
  const [popupArchivoSubidoPaso5, setPopupArchivoSubidoPaso5] = useState(false);
  const [isDraggingMarcoRef, setIsDraggingMarcoRef] = useState(false);
  const [isDialogOpenMarcoRef, setIsDialogOpenMarcoRef] = useState(false);
  const fileInputRefMarcoRef = useRef(null);
  const [materialMetodo, setMaterialMetodo] = useState({
    tipoInvestigacion: "",
    tipoDiseno: "",
    participacionInvestigador: "",
    temporalidadEstudio: "",
    lecturaDatos: "",
    analisisDatos: ""
  });
  const [procedimiento, setProcedimiento] = useState({
    universoPoblacion: "",
    tamanoMuestra: "",
    defUnidadesObservacion: "",
    defGrupoControl: "",
    criteriosInclusion: "",
    criteriosExclusion: "",
    criteriosEliminacion: "",
    variablesEstudio: "",
    pruebaPiloto: "",
    materialMetodos: "",
    analisisEstadisticos: "",
    bibliografia: ""
  });
  const [archivoRecoleccionDatos, setArchivoRecoleccionDatos] = useState(null);
  const [subiendoArchivoPaso6, setSubiendoArchivoPaso6] = useState(false);
  const [popupArchivoSubidoPaso6, setPopupArchivoSubidoPaso6] = useState(false);
  const [isDraggingRecoleccion, setIsDraggingRecoleccion] = useState(false);
  const [isDialogOpenRecoleccion, setIsDialogOpenRecoleccion] = useState(false);
  const fileInputRefRecoleccion = useRef(null);
  const [aspectosEticos, setAspectosEticos] = useState({
    tipoRiesgo: ""
  });
  const [filasRiesgoHipotesis, setFilasRiesgoHipotesis] = useState([{
    objetivo: "",
    descripcion: "",
    prueba: "",
    resultadoEsperado: ""
  }]);
  const [recursosHumanos, setRecursosHumanos] = useState([]);
  const [formRecursoHumano, setFormRecursoHumano] = useState({
    nombramientoRol: "",
    gradoAcademico: "",
    horasMes: "",
    funciones: "",
    centroAdscripcion: ""
  });
  const [recursosMateriales, setRecursosMateriales] = useState([]);
  const [formRecursoMaterial, setFormRecursoMaterial] = useState({
    articuloServicio: "",
    tipoGasto: "",
    descripcion: "",
    cantidad: "",
    observaciones: ""
  });
  const [subsidios, setSubsidios] = useState([]);
  const [formSubsidio, setFormSubsidio] = useState({
    institucion: "",
    nombreConvocatoria: "",
    subsidioInterno: "",
    subsidioExterno: ""
  });
  const [productosCompromiso, setProductosCompromiso] = useState("");
  const [archivoProgramaGasto, setArchivoProgramaGasto] = useState(null);
  const [subiendoArchivoPaso7Programa, setSubiendoArchivoPaso7Programa] = useState(false);
  const [popupArchivoSubidoPaso7Programa, setPopupArchivoSubidoPaso7Programa] = useState(false);
  const [archivoCronograma, setArchivoCronograma] = useState(null);
  const [subiendoArchivoPaso7Cronograma, setSubiendoArchivoPaso7Cronograma] = useState(false);
  const [popupArchivoSubidoPaso7Cronograma, setPopupArchivoSubidoPaso7Cronograma] = useState(false);
  const [isDraggingProgramaGasto, setIsDraggingProgramaGasto] = useState(false);
  const [isDialogOpenProgramaGasto, setIsDialogOpenProgramaGasto] = useState(false);
  const fileInputRefProgramaGasto = useRef(null);
  const [isDraggingCronograma, setIsDraggingCronograma] = useState(false);
  const [isDialogOpenCronograma, setIsDialogOpenCronograma] = useState(false);
  const fileInputRefCronograma = useRef(null);
  const [investigadoresPrincipales, setInvestigadoresPrincipales] = useState([]);
  const [formInvestigadorPrincipal, setFormInvestigadorPrincipal] = useState({
    nombre: "",
    adscripcion: "",
    funcion: "",
    correo: "",
    extension: "",
    nivelEstudios: "",
    statusSni: "",
    esResponsable: true
  });
  const [autorizacionDepto, setAutorizacionDepto] = useState({
    departamentoCoordinacion: "",
    responsableDepto: "",
    claveAreaDepto: "",
    subdireccionArea: "",
    responsableSubdir: "",
    claveAreaSubdir: ""
  });
  const [coinvestigadores, setCoinvestigadores] = useState([]);
  const [formCoinvestigador, setFormCoinvestigador] = useState({
    nombre: "",
    adscripcion: "",
    funcion: "",
    correo: "",
    extension: "",
    nivelEstudios: "",
    statusSni: ""
  });
  const [departamentosParticipantes, setDepartamentosParticipantes] = useState([]);
  const [formDepartamento, setFormDepartamento] = useState({
    area: "",
    responsable: ""
  });
  const [institucionesParticipantes, setInstitucionesParticipantes] = useState([]);
  const [formInstitucion, setFormInstitucion] = useState({
    clues: "",
    nombreInstitucion: "",
    nombreParticipante: "",
    puesto: "",
    numConvenio: "",
    adscripcion: "",
    telefono: "",
    correo: ""
  });
  const [intencionDidactica, setIntencionDidactica] = useState({
    especialidad: "",
    institucionAcademica: "",
    directorEnsenanza: ""
  });
  const [datosColaboradorPaso2, setDatosColaboradorPaso2] = useState({
    curpIdentificacion: "",
    nombre: "",
    correo: "",
    telefonoParticular: "",
    telefonoOficina: "",
    extension: "",
    adscripcion: "",
    nivelEstudios: "",
    disciplina: "",
    especialidad: "",
    nivel: "",
    sni: false
  });
  const [consultandoCurpColaborador, setConsultandoCurpColaborador] = useState(false);
  const [errorCurpColaborador, setErrorCurpColaborador] = useState("");
  const [nombreColaboradorBloqueado, setNombreColaboradorBloqueado] = useState(false);
  const abortControllerCurpColaboradorRef = useRef(null);
  const [proyectoId, setProyectoId] = useState(null);
  const [archivosSubidos, setArchivosSubidos] = useState({});
  const [archivoVistaPrevia, setArchivoVistaPrevia] = useState(null);
  const [inicializandoProyecto, setInicializandoProyecto] = useState(true);
  const [guardandoPaso, setGuardandoPaso] = useState(false);
  const [errorGuardado, setErrorGuardado] = useState("");
  const [popupSolicitudEnviada, setPopupSolicitudEnviada] = useState(false);
  const [proyectoEnviado, setProyectoEnviado] = useState(false);
  const navigate = useNavigate();
  const search = Route$5.useSearch();
  const setStepInUrl = useCallback((step, replace = false, nextProyectoId) => {
    const boundedStep = Math.max(0, Math.min(step, LAST_STEP_INDEX));
    setCurrentStep(boundedStep);
    navigate({
      to: "/registro-proyecto",
      search: {
        proyecto: nextProyectoId ?? proyectoId ?? search.proyecto,
        paso: boundedStep
      },
      replace
    });
  }, [navigate, proyectoId, search.proyecto]);
  const usuario = getUsuarioSesion();
  useEffect(() => {
    if (search.paso == null) return;
    const boundedStep = Math.max(0, Math.min(search.paso, LAST_STEP_INDEX));
    if (boundedStep !== currentStep) setCurrentStep(boundedStep);
  }, [search.paso, currentStep]);
  useEffect(() => {
    if (!usuario?.id) {
      setInicializandoProyecto(false);
      return;
    }
    const idFromUrl = search.proyecto;
    if (idFromUrl && Number.isInteger(idFromUrl) && idFromUrl > 0) {
      if (proyectoId === idFromUrl) {
        setInicializandoProyecto(false);
        return;
      }
      obtenerProyecto(idFromUrl).then((r) => {
        if (r.success && r.proyecto) {
          setProyectoId(idFromUrl);
          setProyectoEnviado(r.proyecto.estado === "enviado" || r.proyecto.estado === "aprobado");
          if (r.datosPorPaso) {
            const d = r.datosPorPaso;
            if (d[0] && typeof d[0] === "object" && d[0] !== null) {
              const x = d[0];
              if (typeof x.titulo === "string") setTitulo(x.titulo);
              if (typeof x.tipoSolicitud === "string") setTipoSolicitud(x.tipoSolicitud);
              if (typeof x.lineaInvestigacion === "string") setLineaInvestigacion(x.lineaInvestigacion);
              if (typeof x.telefonoOficina === "string") setTelefonoOficina(x.telefonoOficina);
              if (typeof x.extensionOficina === "string") setExtensionOficina(x.extensionOficina);
              if (typeof x.adscripcionProponente === "string") setAdscripcionProponente(x.adscripcionProponente);
              if (typeof x.disciplinaProponente === "string") setDisciplinaProponente(x.disciplinaProponente);
              if (typeof x.especialidadProponente === "string") setEspecialidadProponente(x.especialidadProponente);
              if (typeof x.nivelProponente === "string") setNivelProponente(x.nivelProponente);
              if (x.perteneceSniProponente != null) setPerteneceSniProponente(Boolean(x.perteneceSniProponente));
              if (typeof x.titulo === "string") setTituloLength(x.titulo.length);
            }
            if (d[1]) {
              const x = d[1];
              if (x.requiereFarmacovigilancia != null) setRequiereFarmacovigilancia(Boolean(x.requiereFarmacovigilancia));
              if (x.fechaInicio) setFechaInicio(new Date(x.fechaInicio));
              if (x.fechaTermino) setFechaTermino(new Date(x.fechaTermino));
              if (typeof x.tipoRiesgoPaso1 === "string") setTipoRiesgoPaso1(x.tipoRiesgoPaso1);
              if (typeof x.tipoInvestigacionPaso1 === "string") setTipoInvestigacionPaso1(x.tipoInvestigacionPaso1);
              if (typeof x.tipoProtocoloPaso1 === "string") setTipoProtocoloPaso1(x.tipoProtocoloPaso1);
              if (typeof x.fuenteFinanciamientoPaso1 === "string") setFuenteFinanciamientoPaso1(x.fuenteFinanciamientoPaso1);
              if (typeof x.montoPaso1 === "string") setMontoPaso1(x.montoPaso1);
              if (typeof x.agenciaFinanciadoraPaso1 === "string") setAgenciaFinanciadoraPaso1(x.agenciaFinanciadoraPaso1);
              if (typeof x.tipoEstudioPaso1 === "string") setTipoEstudioPaso1(x.tipoEstudioPaso1);
              if (typeof x.tieneColaboracionPaso1 === "string") setTieneColaboracionPaso1(x.tieneColaboracionPaso1);
              if (typeof x.tipoColaboracionPaso1 === "string") setTipoColaboracionPaso1(x.tipoColaboracionPaso1);
              if (Array.isArray(x.instituciones)) setInstituciones(x.instituciones);
            }
            if (d[2] && typeof d[2] === "object" && d[2] !== null) {
              const x = d[2];
              if (Array.isArray(x.tiposAyuda)) setTiposAyuda(x.tiposAyuda);
              if (x.datosColaboradorPaso2 && typeof x.datosColaboradorPaso2 === "object") {
                const c = x.datosColaboradorPaso2;
                setDatosColaboradorPaso2({
                  curpIdentificacion: typeof c.curpIdentificacion === "string" ? c.curpIdentificacion : "",
                  nombre: typeof c.nombre === "string" ? c.nombre : "",
                  correo: typeof c.correo === "string" ? c.correo : "",
                  telefonoParticular: typeof c.telefonoParticular === "string" ? c.telefonoParticular : "",
                  telefonoOficina: typeof c.telefonoOficina === "string" ? c.telefonoOficina : "",
                  extension: typeof c.extension === "string" ? c.extension : "",
                  adscripcion: typeof c.adscripcion === "string" ? c.adscripcion : "",
                  nivelEstudios: typeof c.nivelEstudios === "string" ? c.nivelEstudios : "",
                  disciplina: typeof c.disciplina === "string" ? c.disciplina : "",
                  especialidad: typeof c.especialidad === "string" ? c.especialidad : "",
                  nivel: typeof c.nivel === "string" ? c.nivel : "",
                  sni: Boolean(c.sni)
                });
              }
              if (x.intencionDidactica && typeof x.intencionDidactica === "object") {
                const i = x.intencionDidactica;
                setIntencionDidactica({
                  especialidad: i.especialidad || "",
                  institucionAcademica: i.institucionAcademica || "",
                  directorEnsenanza: i.directorEnsenanza || ""
                });
              } else if ("especialidad" in x) {
                const i = x;
                setIntencionDidactica({
                  especialidad: i.especialidad || "",
                  institucionAcademica: i.institucionAcademica || "",
                  directorEnsenanza: i.directorEnsenanza || ""
                });
              }
            }
            if (d[4]) {
              const x = d[4];
              if (Array.isArray(x.investigadoresPrincipales)) {
                setInvestigadoresPrincipales(x.investigadoresPrincipales.map((item) => sanitizeInvestigadorPrincipal(item)).filter((item) => item !== null));
              }
              if (Array.isArray(x.coinvestigadores)) {
                setCoinvestigadores(x.coinvestigadores.map((item) => sanitizeCoinvestigador(item)).filter((item) => item !== null));
              }
              if (Array.isArray(x.departamentosParticipantes)) {
                setDepartamentosParticipantes(x.departamentosParticipantes.map((item) => sanitizeDepartamentoParticipante(item)).filter((item) => item !== null));
              }
              if (Array.isArray(x.institucionesParticipantes)) {
                setInstitucionesParticipantes(x.institucionesParticipantes.map((item) => sanitizeInstitucionParticipante(item)).filter((item) => item !== null));
              }
              setAutorizacionDepto(sanitizeAutorizacionDepto(x.autorizacionDepto));
              if (x.intencionDidactica && typeof x.intencionDidactica === "object") {
                setIntencionDidactica(sanitizeIntencionDidactica(x.intencionDidactica));
              }
            }
            if (d[3] && typeof d[3] === "object" && d[3] !== null) {
              const x = d[3];
              if (x.fechaInicioProyecto) setFechaInicioProyecto(new Date(x.fechaInicioProyecto));
              if (x.fechaTerminoProyecto) setFechaTerminoProyecto(new Date(x.fechaTerminoProyecto));
              if (typeof x.tituloDescriptivo === "string") setTituloDescriptivo(x.tituloDescriptivo);
              if (typeof x.areaEstudioProyecto === "string") setAreaEstudioProyecto(x.areaEstudioProyecto);
              if (typeof x.areaProyecto === "string") setAreaProyecto(x.areaProyecto);
              if (typeof x.subareaInvestigacionProyecto === "string") setSubareaInvestigacionProyecto(x.subareaInvestigacionProyecto);
              if (typeof x.lineasPrioritariasClasifica === "string") setLineasPrioritariasClasifica(x.lineasPrioritariasClasifica);
              if (typeof x.vigenciaDias === "string") setVigenciaDias(x.vigenciaDias);
              if (typeof x.descripcionProyecto === "string") setDescripcionProyecto(x.descripcionProyecto);
            }
            if (d[5] && typeof d[5] === "object" && d[5] !== null) {
              const x = d[5];
              if (x.marcoReferencia && typeof x.marcoReferencia === "object") setMarcoReferencia(x.marcoReferencia);
            }
            if (d[6]) {
              const x = d[6];
              if (x.materialMetodo && typeof x.materialMetodo === "object") setMaterialMetodo(x.materialMetodo);
              if (x.procedimiento && typeof x.procedimiento === "object") setProcedimiento(x.procedimiento);
              if (x.aspectosEticos && typeof x.aspectosEticos === "object") setAspectosEticos(x.aspectosEticos);
              if (Array.isArray(x.filasRiesgoHipotesis)) setFilasRiesgoHipotesis(x.filasRiesgoHipotesis);
            }
            if (d[7]) {
              const x = d[7];
              if (Array.isArray(x.recursosHumanos)) setRecursosHumanos(x.recursosHumanos);
              if (Array.isArray(x.recursosMateriales)) setRecursosMateriales(x.recursosMateriales);
              if (Array.isArray(x.subsidios)) setSubsidios(x.subsidios);
              if (typeof x.productosCompromiso === "string") setProductosCompromiso(x.productosCompromiso);
            }
          }
          if (r.archivos?.length) {
            const map = {};
            for (const a of r.archivos) map[a.tipo_archivo] = {
              nombre_original: a.nombre_original,
              ruta_servidor: a.ruta_servidor
            };
            setArchivosSubidos(map);
          }
          if (r.proyecto?.paso_actual != null) {
            if (search.paso == null) {
              setStepInUrl(r.proyecto.paso_actual, true, idFromUrl);
            } else {
              setCurrentStep(Math.max(0, Math.min(search.paso, LAST_STEP_INDEX)));
            }
          }
        }
        setInicializandoProyecto(false);
      }).catch(() => setInicializandoProyecto(false));
      return;
    }
    setInicializandoProyecto(false);
  }, [usuario?.id, search.proyecto, search.paso, proyectoId, setStepInUrl]);
  const nombreCompletoProponente = useMemo(() => {
    if (!usuario?.nombre && !usuario?.apellidos) return "";
    return [usuario.nombre, usuario.apellidos].filter(Boolean).join(" ").trim();
  }, [usuario?.nombre, usuario?.apellidos]);
  const nivelEstudiosProponenteValue = useMemo(() => {
    if (!usuario?.formacion_academica) return "";
    const fa = usuario.formacion_academica.trim().toLowerCase().replace(/-/g, " ");
    const found = NIVEL_MAXIMO_ESTUDIOS.find((n) => n.value === usuario.formacion_academica?.trim().toLowerCase() || fa === n.value || fa === n.label.toLowerCase() || fa.startsWith(n.value) || n.label.toLowerCase().replace(/\s+/g, " ").includes(fa) || fa.includes(n.value));
    return found ? found.value : "";
  }, [usuario?.formacion_academica]);
  const proponenteBloqueado = !!usuario;
  const archivoCartaAprobacionGuardado = archivosSubidos.carta_aprobacion;
  const archivoCartaColaboracionGuardado = archivosSubidos.carta_colaboracion;
  const archivoMarcoReferenciaGuardado = archivosSubidos.marco_referencia;
  const archivoRecoleccionDatosGuardado = archivosSubidos.recoleccion_datos;
  const archivoProgramaGastoGuardado = archivosSubidos.programa_gasto;
  const archivoCronogramaGuardado = archivosSubidos.cronograma;
  const abrirVistaArchivo = useCallback((tipoArchivo, nombre) => {
    if (proyectoId == null) return;
    setArchivoVistaPrevia({
      nombre,
      url: urlArchivoProyecto(proyectoId, tipoArchivo)
    });
  }, [proyectoId]);
  const proponenteSnapshot = useMemo(() => ({
    curpIdentificacion: usuario?.curp ?? usuario?.identificacion ?? "",
    nombreCompleto: nombreCompletoProponente,
    correo: usuario?.correo ?? "",
    telefono: usuario?.telefono ?? "",
    nivelMaximoEstudios: nivelEstudiosProponenteValue
  }), [usuario?.curp, usuario?.identificacion, usuario?.correo, usuario?.telefono, nombreCompletoProponente, nivelEstudiosProponenteValue]);
  const steps = [{
    title: "Solicitud y proponente"
  }, {
    title: "Características"
  }, {
    title: "Colaboradores"
  }, {
    title: "Descripción del proyecto"
  }, {
    title: "Datos de investigadores"
  }, {
    title: "Marco de Referencia del Proyecto"
  }, {
    title: "Material y Método"
  }, {
    title: "Organización administrativa"
  }];
  const getDatosPaso = useCallback((paso) => {
    switch (paso) {
      case 0:
        return {
          titulo,
          tipoSolicitud,
          lineaInvestigacion,
          telefonoOficina,
          extensionOficina,
          adscripcionProponente,
          disciplinaProponente,
          especialidadProponente,
          nivelProponente,
          perteneceSniProponente,
          proponenteSnapshot
        };
      case 1:
        return {
          requiereFarmacovigilancia,
          fechaInicio: fechaInicio?.toISOString?.() ?? null,
          fechaTermino: fechaTermino?.toISOString?.() ?? null,
          tipoRiesgoPaso1,
          tipoInvestigacionPaso1,
          tipoProtocoloPaso1,
          fuenteFinanciamientoPaso1,
          montoPaso1,
          agenciaFinanciadoraPaso1,
          tipoEstudioPaso1,
          tieneColaboracionPaso1,
          tipoColaboracionPaso1,
          instituciones
        };
      case 2:
        return {
          tiposAyuda,
          datosColaboradorPaso2
        };
      case 3:
        return {
          fechaInicioProyecto: fechaInicioProyecto?.toISOString?.() ?? null,
          fechaTerminoProyecto: fechaTerminoProyecto?.toISOString?.() ?? null,
          tituloDescriptivo,
          areaEstudioProyecto,
          areaProyecto,
          subareaInvestigacionProyecto,
          lineasPrioritariasClasifica,
          vigenciaDias,
          descripcionProyecto
        };
      case 4:
        return {
          ...(() => {
            const cleanInvestigadoresPrincipales = investigadoresPrincipales.map((item) => sanitizeInvestigadorPrincipal(item)).filter((item) => item !== null);
            const cleanCoinvestigadores = coinvestigadores.map((item) => sanitizeCoinvestigador(item)).filter((item) => item !== null);
            const cleanDepartamentosParticipantes = departamentosParticipantes.map((item) => sanitizeDepartamentoParticipante(item)).filter((item) => item !== null);
            const cleanInstitucionesParticipantes = institucionesParticipantes.map((item) => sanitizeInstitucionParticipante(item)).filter((item) => item !== null);
            const cleanAutorizacionDepto = sanitizeAutorizacionDepto(autorizacionDepto);
            const cleanIntencionDidactica = sanitizeIntencionDidactica(intencionDidactica);
            const hasAutorizacionDepto = Object.values(cleanAutorizacionDepto).some(Boolean);
            const hasIntencionDidactica = Object.values(cleanIntencionDidactica).some(Boolean);
            return {
              ...cleanInvestigadoresPrincipales.length > 0 ? {
                investigadoresPrincipales: cleanInvestigadoresPrincipales
              } : {},
              ...cleanCoinvestigadores.length > 0 ? {
                coinvestigadores: cleanCoinvestigadores
              } : {},
              ...cleanDepartamentosParticipantes.length > 0 ? {
                departamentosParticipantes: cleanDepartamentosParticipantes
              } : {},
              ...cleanInstitucionesParticipantes.length > 0 ? {
                institucionesParticipantes: cleanInstitucionesParticipantes
              } : {},
              ...hasAutorizacionDepto ? {
                autorizacionDepto: cleanAutorizacionDepto
              } : {},
              ...hasIntencionDidactica ? {
                intencionDidactica: cleanIntencionDidactica
              } : {}
            };
          })()
        };
      case 5:
        return {
          marcoReferencia
        };
      case 6:
        return {
          materialMetodo,
          procedimiento,
          aspectosEticos,
          filasRiesgoHipotesis
        };
      case 7:
        return {
          recursosHumanos,
          recursosMateriales,
          subsidios,
          productosCompromiso
        };
      default:
        return {};
    }
  }, [titulo, tipoSolicitud, lineaInvestigacion, telefonoOficina, extensionOficina, adscripcionProponente, disciplinaProponente, especialidadProponente, nivelProponente, perteneceSniProponente, proponenteSnapshot, requiereFarmacovigilancia, fechaInicio, fechaTermino, tipoRiesgoPaso1, tipoInvestigacionPaso1, tipoProtocoloPaso1, fuenteFinanciamientoPaso1, montoPaso1, agenciaFinanciadoraPaso1, tipoEstudioPaso1, tieneColaboracionPaso1, tipoColaboracionPaso1, tiposAyuda, instituciones, datosColaboradorPaso2, intencionDidactica, investigadoresPrincipales, coinvestigadores, departamentosParticipantes, institucionesParticipantes, autorizacionDepto, marcoReferencia, materialMetodo, procedimiento, aspectosEticos, filasRiesgoHipotesis, recursosHumanos, recursosMateriales, subsidios, productosCompromiso, fechaInicioProyecto, fechaTerminoProyecto, tituloDescriptivo, areaEstudioProyecto, areaProyecto, subareaInvestigacionProyecto, lineasPrioritariasClasifica, vigenciaDias, descripcionProyecto]);
  const guardarPasoYAvanzar = async () => {
    if (guardandoPaso) return;
    if (proyectoEnviado) {
      setErrorGuardado("El proyecto ya fue enviado y está en modo solo lectura");
      return;
    }
    setErrorGuardado("");
    if (!pasoActualCompleto) {
      setErrorGuardado("Complete todos los campos obligatorios de este paso para continuar");
      return;
    }
    setGuardandoPaso(true);
    try {
      let idProyecto = proyectoId;
      if (idProyecto == null) {
        if (currentStep !== 0) {
          setErrorGuardado("No se pudo identificar el proyecto para guardar este paso");
          return;
        }
        const creado = await crearProyecto();
        if (!creado.success || !creado.id) {
          setErrorGuardado(creado.error || "No se pudo crear el proyecto");
          return;
        }
        idProyecto = creado.id;
        setProyectoId(creado.id);
        navigate({
          to: "/registro-proyecto",
          search: {
            proyecto: creado.id,
            paso: currentStep
          },
          replace: true
        });
      }
      if (currentStep === 0 && uploadedFile) {
        if (!uploadedFile.name.toLowerCase().endsWith(".pdf")) {
          setErrorGuardado("Solo se permiten archivos PDF");
          return;
        }
        setSubiendoArchivoPaso0(true);
        setPopupArchivoSubidoPaso0(false);
        const r = await subirArchivoProyecto(idProyecto, "carta_aprobacion", uploadedFile);
        if (!r.success) {
          setSubiendoArchivoPaso0(false);
          setProgresoArchivoPaso0(0);
          setErrorGuardado(r.error || "No se pudo subir el archivo");
          return;
        }
        setSubiendoArchivoPaso0(false);
        setProgresoArchivoPaso0(100);
        setPopupArchivoSubidoPaso0(true);
        if (r.success && r.nombre_original) setArchivosSubidos((prev) => ({
          ...prev,
          carta_aprobacion: {
            nombre_original: r.nombre_original,
            ruta_servidor: r.ruta_servidor
          }
        }));
      }
      if (currentStep === 1 && uploadedFileColaboracion) {
        if (!uploadedFileColaboracion.name.toLowerCase().endsWith(".pdf")) {
          setErrorGuardado("Solo se permiten archivos PDF");
          return;
        }
        setSubiendoArchivoPaso1(true);
        setPopupArchivoSubidoPaso1(false);
        let r;
        try {
          r = await subirArchivoProyecto(idProyecto, "carta_colaboracion", uploadedFileColaboracion);
        } catch {
          r = {
            success: false,
            error: "No se pudo subir el archivo"
          };
        }
        setSubiendoArchivoPaso1(false);
        if (!r.success) {
          setErrorGuardado(r.error || "No se pudo subir el archivo");
          return;
        }
        const nombreOriginalColaboracion = r.nombre_original;
        const rutaServidorColaboracion = r.ruta_servidor;
        if (typeof nombreOriginalColaboracion === "string" && typeof rutaServidorColaboracion === "string") {
          setArchivosSubidos((prev) => ({
            ...prev,
            carta_colaboracion: {
              nombre_original: nombreOriginalColaboracion,
              ruta_servidor: rutaServidorColaboracion
            }
          }));
          setPopupArchivoSubidoPaso1(true);
          setUploadedFileColaboracion(null);
          if (fileInputRefColaboracion.current) fileInputRefColaboracion.current.value = "";
        }
      }
      if (currentStep === 5 && archivoMarcoReferencia) {
        if (!archivoMarcoReferencia.name.toLowerCase().endsWith(".pdf")) {
          setErrorGuardado("Solo se permiten archivos PDF");
          return;
        }
        setSubiendoArchivoPaso5(true);
        setPopupArchivoSubidoPaso5(false);
        let r;
        try {
          r = await subirArchivoProyecto(idProyecto, "marco_referencia", archivoMarcoReferencia);
        } catch {
          r = {
            success: false,
            error: "No se pudo subir el archivo"
          };
        }
        setSubiendoArchivoPaso5(false);
        if (!r.success) {
          setErrorGuardado(r.error || "No se pudo subir el archivo");
          return;
        }
        const nombreOriginalMarco = r.nombre_original;
        const rutaServidorMarco = r.ruta_servidor;
        if (typeof nombreOriginalMarco === "string" && typeof rutaServidorMarco === "string") {
          setArchivosSubidos((prev) => ({
            ...prev,
            marco_referencia: {
              nombre_original: nombreOriginalMarco,
              ruta_servidor: rutaServidorMarco
            }
          }));
          setPopupArchivoSubidoPaso5(true);
          setArchivoMarcoReferencia(null);
          if (fileInputRefMarcoRef.current) fileInputRefMarcoRef.current.value = "";
        }
      }
      if (currentStep === 6 && archivoRecoleccionDatos) {
        if (!archivoRecoleccionDatos.name.toLowerCase().endsWith(".pdf")) {
          setErrorGuardado("Solo se permiten archivos PDF");
          return;
        }
        setSubiendoArchivoPaso6(true);
        setPopupArchivoSubidoPaso6(false);
        let r;
        try {
          r = await subirArchivoProyecto(idProyecto, "recoleccion_datos", archivoRecoleccionDatos);
        } catch {
          r = {
            success: false,
            error: "No se pudo subir el archivo"
          };
        }
        setSubiendoArchivoPaso6(false);
        if (!r.success) {
          setErrorGuardado(r.error || "No se pudo subir el archivo");
          return;
        }
        const nombreOriginalRecoleccion = r.nombre_original;
        const rutaServidorRecoleccion = r.ruta_servidor;
        if (typeof nombreOriginalRecoleccion === "string" && typeof rutaServidorRecoleccion === "string") {
          setArchivosSubidos((prev) => ({
            ...prev,
            recoleccion_datos: {
              nombre_original: nombreOriginalRecoleccion,
              ruta_servidor: rutaServidorRecoleccion
            }
          }));
          setPopupArchivoSubidoPaso6(true);
          setArchivoRecoleccionDatos(null);
          if (fileInputRefRecoleccion.current) fileInputRefRecoleccion.current.value = "";
        }
      }
      if (currentStep === 7 && archivoProgramaGasto) {
        if (!archivoProgramaGasto.name.toLowerCase().endsWith(".pdf")) {
          setErrorGuardado("Solo se permiten archivos PDF");
          return;
        }
        setSubiendoArchivoPaso7Programa(true);
        setPopupArchivoSubidoPaso7Programa(false);
        let r;
        try {
          r = await subirArchivoProyecto(idProyecto, "programa_gasto", archivoProgramaGasto);
        } catch {
          r = {
            success: false,
            error: "No se pudo subir el archivo"
          };
        }
        setSubiendoArchivoPaso7Programa(false);
        if (!r.success) {
          setErrorGuardado(r.error || "No se pudo subir el archivo");
          return;
        }
        const nombreOriginalPrograma = r.nombre_original;
        const rutaServidorPrograma = r.ruta_servidor;
        if (typeof nombreOriginalPrograma === "string" && typeof rutaServidorPrograma === "string") {
          setArchivosSubidos((prev) => ({
            ...prev,
            programa_gasto: {
              nombre_original: nombreOriginalPrograma,
              ruta_servidor: rutaServidorPrograma
            }
          }));
          setPopupArchivoSubidoPaso7Programa(true);
          setArchivoProgramaGasto(null);
          if (fileInputRefProgramaGasto.current) fileInputRefProgramaGasto.current.value = "";
        }
      }
      if (currentStep === 7 && archivoCronograma) {
        if (!archivoCronograma.name.toLowerCase().endsWith(".pdf")) {
          setErrorGuardado("Solo se permiten archivos PDF");
          return;
        }
        setSubiendoArchivoPaso7Cronograma(true);
        setPopupArchivoSubidoPaso7Cronograma(false);
        let r;
        try {
          r = await subirArchivoProyecto(idProyecto, "cronograma", archivoCronograma);
        } catch {
          r = {
            success: false,
            error: "No se pudo subir el archivo"
          };
        }
        setSubiendoArchivoPaso7Cronograma(false);
        if (!r.success) {
          setErrorGuardado(r.error || "No se pudo subir el archivo");
          return;
        }
        const nombreOriginalCronograma = r.nombre_original;
        const rutaServidorCronograma = r.ruta_servidor;
        if (typeof nombreOriginalCronograma === "string" && typeof rutaServidorCronograma === "string") {
          setArchivosSubidos((prev) => ({
            ...prev,
            cronograma: {
              nombre_original: nombreOriginalCronograma,
              ruta_servidor: rutaServidorCronograma
            }
          }));
          setPopupArchivoSubidoPaso7Cronograma(true);
          setArchivoCronograma(null);
          if (fileInputRefCronograma.current) fileInputRefCronograma.current.value = "";
        }
      }
      const datos = getDatosPaso(currentStep);
      const nextStep2 = Math.min(currentStep + 1, steps.length - 1);
      const actualizado = await actualizarProyecto(idProyecto, {
        paso: currentStep,
        datos,
        paso_actual: nextStep2
      });
      if (!actualizado.success) {
        setErrorGuardado(actualizado.error || "No se pudo guardar el paso");
        return;
      }
      if (currentStep < steps.length - 1) setStepInUrl(nextStep2);
    } finally {
      setGuardandoPaso(false);
    }
  };
  const enviarSolicitud = async () => {
    if (proyectoId == null || guardandoPaso) return;
    if (proyectoEnviado) {
      setErrorGuardado("El proyecto ya fue enviado y está en modo solo lectura");
      return;
    }
    setErrorGuardado("");
    setGuardandoPaso(true);
    try {
      if (archivoProgramaGasto) {
        if (!archivoProgramaGasto.name.toLowerCase().endsWith(".pdf")) {
          setErrorGuardado("Solo se permiten archivos PDF");
          return;
        }
        setSubiendoArchivoPaso7Programa(true);
        let r;
        try {
          r = await subirArchivoProyecto(proyectoId, "programa_gasto", archivoProgramaGasto);
        } catch {
          r = {
            success: false,
            error: "No se pudo subir el archivo"
          };
        }
        setSubiendoArchivoPaso7Programa(false);
        if (!r.success) {
          setErrorGuardado(r.error || "No se pudo subir el archivo");
          return;
        }
        if (typeof r.nombre_original === "string" && typeof r.ruta_servidor === "string") {
          setArchivosSubidos((prev) => ({
            ...prev,
            programa_gasto: {
              nombre_original: r.nombre_original,
              ruta_servidor: r.ruta_servidor
            }
          }));
          setArchivoProgramaGasto(null);
          if (fileInputRefProgramaGasto.current) fileInputRefProgramaGasto.current.value = "";
        }
      }
      if (archivoCronograma) {
        if (!archivoCronograma.name.toLowerCase().endsWith(".pdf")) {
          setErrorGuardado("Solo se permiten archivos PDF");
          return;
        }
        setSubiendoArchivoPaso7Cronograma(true);
        let r;
        try {
          r = await subirArchivoProyecto(proyectoId, "cronograma", archivoCronograma);
        } catch {
          r = {
            success: false,
            error: "No se pudo subir el archivo"
          };
        }
        setSubiendoArchivoPaso7Cronograma(false);
        if (!r.success) {
          setErrorGuardado(r.error || "No se pudo subir el archivo");
          return;
        }
        if (typeof r.nombre_original === "string" && typeof r.ruta_servidor === "string") {
          setArchivosSubidos((prev) => ({
            ...prev,
            cronograma: {
              nombre_original: r.nombre_original,
              ruta_servidor: r.ruta_servidor
            }
          }));
          setArchivoCronograma(null);
          if (fileInputRefCronograma.current) fileInputRefCronograma.current.value = "";
        }
      }
      const datosPaso0 = getDatosPaso(0);
      const guardadoPaso0 = await actualizarProyecto(proyectoId, {
        paso: 0,
        datos: datosPaso0
      });
      if (!guardadoPaso0.success) {
        setErrorGuardado(guardadoPaso0.error || "No se pudo guardar la información del proponente");
        return;
      }
      const datos = getDatosPaso(7);
      const enviado = await actualizarProyecto(proyectoId, {
        paso: 7,
        datos,
        paso_actual: 7,
        estado: "enviado"
      });
      if (!enviado.success) {
        setErrorGuardado(enviado.error || "No se pudo enviar el proyecto");
        return;
      }
      setProyectoEnviado(true);
      setPopupSolicitudEnviada(true);
    } finally {
      setGuardandoPaso(false);
    }
  };
  const nextStep = () => {
    if (currentStep < steps.length - 1) {
      if (proyectoEnviado) {
        setStepInUrl(currentStep + 1);
        return;
      }
      void guardarPasoYAvanzar();
    }
  };
  const pasoActualCompleto = useMemo(() => {
    const hasText = (value) => value.trim().length > 0;
    const hasAllTexts = (values) => values.every(hasText);
    const hasValidPhone = (value) => /^\d{10}$/.test(value.trim());
    const hasValidExtension = (value) => /^\d{1,4}$/.test(value.trim());
    if (currentStep === 0) {
      const requiereCartaAprobacion = tipoSolicitud === "aprobacion_expedita" || tipoSolicitud === "registro_colaboracion_meta_analisis";
      const tieneCartaAprobacion = Boolean(uploadedFile || archivoCartaAprobacionGuardado);
      return hasAllTexts([titulo, tipoSolicitud, lineaInvestigacion, telefonoOficina, extensionOficina, adscripcionProponente, disciplinaProponente, especialidadProponente, nivelProponente]) && hasValidPhone(telefonoOficina) && hasValidExtension(extensionOficina) && (!requiereCartaAprobacion || tieneCartaAprobacion);
    }
    if (currentStep === 1) {
      const tieneColaboracion = tieneColaboracionPaso1 === "si";
      const tieneCartaColaboracion = Boolean(uploadedFileColaboracion || archivoCartaColaboracionGuardado);
      const colaboracionCompleta = !tieneColaboracion || hasText(tipoColaboracionPaso1) && instituciones.length > 0 && tieneCartaColaboracion;
      return hasAllTexts([tipoRiesgoPaso1, tipoInvestigacionPaso1, tipoProtocoloPaso1, fuenteFinanciamientoPaso1, montoPaso1, agenciaFinanciadoraPaso1, tipoEstudioPaso1, tieneColaboracionPaso1]) && Boolean(fechaInicio) && Boolean(fechaTermino) && colaboracionCompleta;
    }
    if (currentStep === 2) {
      return tiposAyuda.length > 0 && hasAllTexts([datosColaboradorPaso2.curpIdentificacion, datosColaboradorPaso2.nombre, datosColaboradorPaso2.correo, datosColaboradorPaso2.telefonoParticular, datosColaboradorPaso2.telefonoOficina, datosColaboradorPaso2.extension, datosColaboradorPaso2.adscripcion, datosColaboradorPaso2.nivelEstudios, datosColaboradorPaso2.disciplina, datosColaboradorPaso2.especialidad, datosColaboradorPaso2.nivel]) && hasValidPhone(datosColaboradorPaso2.telefonoParticular) && hasValidPhone(datosColaboradorPaso2.telefonoOficina) && hasValidExtension(datosColaboradorPaso2.extension);
    }
    if (currentStep === 3) {
      return hasAllTexts([tituloDescriptivo, areaEstudioProyecto, areaProyecto, subareaInvestigacionProyecto, lineasPrioritariasClasifica, vigenciaDias, descripcionProyecto]) && Boolean(fechaInicioProyecto) && Boolean(fechaTerminoProyecto) && /^\d+$/.test(vigenciaDias.trim());
    }
    if (currentStep === 4) {
      const cleanInvestigadoresPrincipales = investigadoresPrincipales.map((item) => sanitizeInvestigadorPrincipal(item)).filter((item) => item !== null);
      const cleanCoinvestigadores = coinvestigadores.map((item) => sanitizeCoinvestigador(item)).filter((item) => item !== null);
      const cleanDepartamentosParticipantes = departamentosParticipantes.map((item) => sanitizeDepartamentoParticipante(item)).filter((item) => item !== null);
      const cleanInstitucionesParticipantes = institucionesParticipantes.map((item) => sanitizeInstitucionParticipante(item)).filter((item) => item !== null);
      const cleanAutorizacionDepto = sanitizeAutorizacionDepto(autorizacionDepto);
      const cleanIntencionDidactica = sanitizeIntencionDidactica(intencionDidactica);
      return cleanInvestigadoresPrincipales.length > 0 && cleanCoinvestigadores.length > 0 && cleanDepartamentosParticipantes.length > 0 && cleanInstitucionesParticipantes.length > 0 && hasAllTexts(Object.values(cleanAutorizacionDepto)) && hasAllTexts(Object.values(cleanIntencionDidactica));
    }
    if (currentStep === 5) {
      const tieneMarcoReferencia = Boolean(archivoMarcoReferencia || archivoMarcoReferenciaGuardado);
      return hasAllTexts(Object.values(marcoReferencia)) && tieneMarcoReferencia;
    }
    if (currentStep === 6) {
      const tieneArchivoRecoleccion = Boolean(archivoRecoleccionDatos || archivoRecoleccionDatosGuardado);
      const filasCompletas = filasRiesgoHipotesis.length > 0 && filasRiesgoHipotesis.every((fila) => hasAllTexts([fila.objetivo, fila.descripcion, fila.prueba, fila.resultadoEsperado]));
      return hasAllTexts([materialMetodo.tipoInvestigacion, materialMetodo.tipoDiseno, materialMetodo.participacionInvestigador, materialMetodo.temporalidadEstudio, materialMetodo.lecturaDatos, materialMetodo.analisisDatos, procedimiento.universoPoblacion, procedimiento.tamanoMuestra, procedimiento.defUnidadesObservacion, procedimiento.defGrupoControl, procedimiento.criteriosInclusion, procedimiento.criteriosExclusion, procedimiento.criteriosEliminacion, procedimiento.variablesEstudio, procedimiento.pruebaPiloto, procedimiento.materialMetodos, procedimiento.analisisEstadisticos, procedimiento.bibliografia, aspectosEticos.tipoRiesgo]) && tieneArchivoRecoleccion && filasCompletas;
    }
    if (currentStep === 7) {
      const tieneProgramaGasto = Boolean(archivoProgramaGasto || archivoProgramaGastoGuardado);
      const tieneCronograma = Boolean(archivoCronograma || archivoCronogramaGuardado);
      return recursosHumanos.length > 0 && recursosMateriales.length > 0 && subsidios.length > 0 && hasText(productosCompromiso) && tieneProgramaGasto && tieneCronograma;
    }
    return true;
  }, [currentStep, titulo, tipoSolicitud, lineaInvestigacion, telefonoOficina, extensionOficina, adscripcionProponente, disciplinaProponente, especialidadProponente, nivelProponente, uploadedFile, archivoCartaAprobacionGuardado, tipoRiesgoPaso1, tipoInvestigacionPaso1, tipoProtocoloPaso1, fuenteFinanciamientoPaso1, montoPaso1, agenciaFinanciadoraPaso1, tipoEstudioPaso1, tieneColaboracionPaso1, tipoColaboracionPaso1, fechaInicio, fechaTermino, instituciones, uploadedFileColaboracion, archivoCartaColaboracionGuardado, tiposAyuda, datosColaboradorPaso2, tituloDescriptivo, areaEstudioProyecto, areaProyecto, subareaInvestigacionProyecto, lineasPrioritariasClasifica, vigenciaDias, descripcionProyecto, fechaInicioProyecto, fechaTerminoProyecto, investigadoresPrincipales, coinvestigadores, departamentosParticipantes, institucionesParticipantes, autorizacionDepto, intencionDidactica, marcoReferencia, archivoMarcoReferencia, archivoMarcoReferenciaGuardado, materialMetodo, procedimiento, aspectosEticos, filasRiesgoHipotesis, archivoRecoleccionDatos, archivoRecoleccionDatosGuardado, recursosHumanos, recursosMateriales, subsidios, productosCompromiso, archivoProgramaGasto, archivoProgramaGastoGuardado, archivoCronograma, archivoCronogramaGuardado]);
  const prevStep = () => {
    if (currentStep > 0) {
      setStepInUrl(currentStep - 1);
    }
  };
  useEffect(() => {
    const el = document.querySelector(".content-entrance");
    if (el) el.scrollTo({
      top: 0,
      behavior: "smooth"
    });
  }, [currentStep]);
  useEffect(() => {
    if (!subiendoArchivoPaso0) return;
    setProgresoArchivoPaso0(12);
    const timer = setInterval(() => {
      setProgresoArchivoPaso0((prev) => {
        if (prev >= 90) return prev;
        return Math.min(prev + 8, 90);
      });
    }, 250);
    return () => clearInterval(timer);
  }, [subiendoArchivoPaso0]);
  const handleFileChange = (e) => {
    const file = e.target.files?.[0];
    if (file) {
      setUploadedFile(file);
      setPopupArchivoSubidoPaso0(false);
      setIsDialogOpen(false);
    }
  };
  const handleDragOver = (e) => {
    e.preventDefault();
    setIsDragging(true);
  };
  const handleDragLeave = (e) => {
    e.preventDefault();
    setIsDragging(false);
  };
  const handleDrop = (e) => {
    e.preventDefault();
    setIsDragging(false);
    const file = e.dataTransfer.files?.[0];
    if (file) {
      setUploadedFile(file);
      setPopupArchivoSubidoPaso0(false);
      setIsDialogOpen(false);
    }
  };
  const removeFile = () => {
    setUploadedFile(null);
    setPopupArchivoSubidoPaso0(false);
    if (fileInputRef.current) {
      fileInputRef.current.value = "";
    }
  };
  const agregarInstitucion = () => {
    if (nuevaInstitucion.trim()) {
      setInstituciones([...instituciones, nuevaInstitucion.trim()]);
      setNuevaInstitucion("");
    }
  };
  const eliminarInstitucion = (index) => {
    setInstituciones(instituciones.filter((_, i) => i !== index));
  };
  const agregarTipoAyuda = () => {
    if (nuevaAyuda.infraestructura || nuevaAyuda.personal || nuevaAyuda.material || nuevaAyuda.equipo) {
      setTiposAyuda([...tiposAyuda, nuevaAyuda]);
      setNuevaAyuda({
        infraestructura: "",
        personal: "",
        material: "",
        equipo: ""
      });
    }
  };
  const eliminarTipoAyuda = (index) => {
    setTiposAyuda(tiposAyuda.filter((_, i) => i !== index));
  };
  const handleFileChangeColaboracion = (e) => {
    const file = e.target.files?.[0];
    if (file) {
      setUploadedFileColaboracion(file);
      setPopupArchivoSubidoPaso1(false);
      setIsDialogOpenColaboracion(false);
    }
  };
  const handleDragOverColaboracion = (e) => {
    e.preventDefault();
    setIsDraggingColaboracion(true);
  };
  const handleDragLeaveColaboracion = (e) => {
    e.preventDefault();
    setIsDraggingColaboracion(false);
  };
  const handleDropColaboracion = (e) => {
    e.preventDefault();
    setIsDraggingColaboracion(false);
    const file = e.dataTransfer.files?.[0];
    if (file) {
      setUploadedFileColaboracion(file);
      setPopupArchivoSubidoPaso1(false);
      setIsDialogOpenColaboracion(false);
    }
  };
  const removeFileColaboracion = () => {
    setUploadedFileColaboracion(null);
    setPopupArchivoSubidoPaso1(false);
    if (fileInputRefColaboracion.current) {
      fileInputRefColaboracion.current.value = "";
    }
  };
  const handleCurpIdentificacionColaboradorChange = (value) => {
    const normalizado = value.toUpperCase().replace(/[^A-Z0-9]/g, "");
    setDatosColaboradorPaso2((prev) => ({
      ...prev,
      curpIdentificacion: normalizado
    }));
    setErrorCurpColaborador("");
    setNombreColaboradorBloqueado(false);
  };
  useEffect(() => {
    const identificador = datosColaboradorPaso2.curpIdentificacion.trim().toUpperCase();
    if (!esCurpValida(identificador)) {
      setConsultandoCurpColaborador(false);
      setErrorCurpColaborador("");
      setNombreColaboradorBloqueado(false);
      if (abortControllerCurpColaboradorRef.current) {
        abortControllerCurpColaboradorRef.current.abort();
      }
      return;
    }
    const timer = setTimeout(async () => {
      if (abortControllerCurpColaboradorRef.current) {
        abortControllerCurpColaboradorRef.current.abort();
      }
      const controller = new AbortController();
      abortControllerCurpColaboradorRef.current = controller;
      setConsultandoCurpColaborador(true);
      setErrorCurpColaborador("");
      try {
        const res = await fetch(apiUrl(`/api/curp?curp=${encodeURIComponent(identificador)}`), {
          credentials: "include",
          signal: controller.signal
        });
        const r = await res.json().catch(() => ({}));
        if (!res.ok || !r.success || !r.data) {
          setErrorCurpColaborador(r?.error || "No se pudo consultar CURP");
          setNombreColaboradorBloqueado(false);
          return;
        }
        const nombreCompleto = `${String(r.data.nombre || "").trim()} ${String(r.data.apellidoPaterno || "").trim()} ${String(r.data.apellidoMaterno || "").trim()}`.trim().replace(/\s+/g, " ");
        if (nombreCompleto) {
          setDatosColaboradorPaso2((prev) => ({
            ...prev,
            nombre: nombreCompleto
          }));
          setNombreColaboradorBloqueado(true);
        } else {
          setNombreColaboradorBloqueado(false);
        }
      } catch (error) {
        if (error instanceof Error && error.name === "AbortError") return;
        setErrorCurpColaborador("No se pudo consultar CURP");
        setNombreColaboradorBloqueado(false);
      } finally {
        setConsultandoCurpColaborador(false);
      }
    }, 350);
    return () => clearTimeout(timer);
  }, [datosColaboradorPaso2.curpIdentificacion]);
  useEffect(() => {
    return () => {
      if (abortControllerCurpColaboradorRef.current) {
        abortControllerCurpColaboradorRef.current.abort();
      }
    };
  }, []);
  const handleFileChangeMarcoRef = (e) => {
    const file = e.target.files?.[0];
    if (file) {
      setArchivoMarcoReferencia(file);
      setPopupArchivoSubidoPaso5(false);
      setIsDialogOpenMarcoRef(false);
    }
  };
  const handleDragOverMarcoRef = (e) => {
    e.preventDefault();
    setIsDraggingMarcoRef(true);
  };
  const handleDragLeaveMarcoRef = (e) => {
    e.preventDefault();
    setIsDraggingMarcoRef(false);
  };
  const handleDropMarcoRef = (e) => {
    e.preventDefault();
    setIsDraggingMarcoRef(false);
    const file = e.dataTransfer.files?.[0];
    if (file) {
      setArchivoMarcoReferencia(file);
      setPopupArchivoSubidoPaso5(false);
      setIsDialogOpenMarcoRef(false);
    }
  };
  const removeFileMarcoRef = () => {
    setArchivoMarcoReferencia(null);
    setPopupArchivoSubidoPaso5(false);
    if (fileInputRefMarcoRef.current) {
      fileInputRefMarcoRef.current.value = "";
    }
  };
  const handleFileChangeRecoleccion = (e) => {
    const file = e.target.files?.[0];
    if (file) {
      setArchivoRecoleccionDatos(file);
      setPopupArchivoSubidoPaso6(false);
      setIsDialogOpenRecoleccion(false);
    }
  };
  const handleDragOverRecoleccion = (e) => {
    e.preventDefault();
    setIsDraggingRecoleccion(true);
  };
  const handleDragLeaveRecoleccion = (e) => {
    e.preventDefault();
    setIsDraggingRecoleccion(false);
  };
  const handleDropRecoleccion = (e) => {
    e.preventDefault();
    setIsDraggingRecoleccion(false);
    const file = e.dataTransfer.files?.[0];
    if (file) {
      setArchivoRecoleccionDatos(file);
      setPopupArchivoSubidoPaso6(false);
      setIsDialogOpenRecoleccion(false);
    }
  };
  const removeFileRecoleccion = () => {
    setArchivoRecoleccionDatos(null);
    setPopupArchivoSubidoPaso6(false);
    if (fileInputRefRecoleccion.current) {
      fileInputRefRecoleccion.current.value = "";
    }
  };
  const agregarFilaRiesgoHipotesis = () => {
    setFilasRiesgoHipotesis([...filasRiesgoHipotesis, {
      objetivo: "",
      descripcion: "",
      prueba: "",
      resultadoEsperado: ""
    }]);
  };
  const actualizarFilaRiesgoHipotesis = (index, campo, valor) => {
    const next = [...filasRiesgoHipotesis];
    next[index] = {
      ...next[index],
      [campo]: valor
    };
    setFilasRiesgoHipotesis(next);
  };
  const eliminarFilaRiesgoHipotesis = (index) => {
    if (filasRiesgoHipotesis.length <= 1) return;
    setFilasRiesgoHipotesis(filasRiesgoHipotesis.filter((_, i) => i !== index));
  };
  const agregarRecursoHumano = () => {
    if (formRecursoHumano.nombramientoRol.trim() || formRecursoHumano.gradoAcademico.trim() || formRecursoHumano.horasMes.trim() || formRecursoHumano.funciones.trim() || formRecursoHumano.centroAdscripcion.trim()) {
      setRecursosHumanos([...recursosHumanos, formRecursoHumano]);
      setFormRecursoHumano({
        nombramientoRol: "",
        gradoAcademico: "",
        horasMes: "",
        funciones: "",
        centroAdscripcion: ""
      });
    }
  };
  const eliminarRecursoHumano = (index) => {
    setRecursosHumanos(recursosHumanos.filter((_, i) => i !== index));
  };
  const agregarRecursoMaterial = () => {
    if (formRecursoMaterial.articuloServicio.trim() || formRecursoMaterial.tipoGasto.trim() || formRecursoMaterial.descripcion.trim() || formRecursoMaterial.cantidad.trim() || formRecursoMaterial.observaciones.trim()) {
      setRecursosMateriales([...recursosMateriales, formRecursoMaterial]);
      setFormRecursoMaterial({
        articuloServicio: "",
        tipoGasto: "",
        descripcion: "",
        cantidad: "",
        observaciones: ""
      });
    }
  };
  const eliminarRecursoMaterial = (index) => {
    setRecursosMateriales(recursosMateriales.filter((_, i) => i !== index));
  };
  const agregarSubsidio = () => {
    if (formSubsidio.institucion.trim() || formSubsidio.nombreConvocatoria.trim() || formSubsidio.subsidioInterno.trim() || formSubsidio.subsidioExterno.trim()) {
      setSubsidios([...subsidios, formSubsidio]);
      setFormSubsidio({
        institucion: "",
        nombreConvocatoria: "",
        subsidioInterno: "",
        subsidioExterno: ""
      });
    }
  };
  const eliminarSubsidio = (index) => {
    setSubsidios(subsidios.filter((_, i) => i !== index));
  };
  const agregarInvestigadorPrincipal = () => {
    if (!formInvestigadorPrincipal.nombre?.trim()) return;
    setInvestigadoresPrincipales([...investigadoresPrincipales, {
      ...formInvestigadorPrincipal
    }]);
    setFormInvestigadorPrincipal({
      nombre: "",
      adscripcion: "",
      funcion: "",
      correo: "",
      extension: "",
      nivelEstudios: "",
      statusSni: "",
      esResponsable: true
    });
  };
  const eliminarInvestigadorPrincipal = (index) => {
    setInvestigadoresPrincipales(investigadoresPrincipales.filter((_, i) => i !== index));
  };
  const agregarCoinvestigador = () => {
    if (!formCoinvestigador.nombre?.trim()) return;
    setCoinvestigadores([...coinvestigadores, {
      ...formCoinvestigador
    }]);
    setFormCoinvestigador({
      nombre: "",
      adscripcion: "",
      funcion: "",
      correo: "",
      extension: "",
      nivelEstudios: "",
      statusSni: ""
    });
  };
  const eliminarCoinvestigador = (index) => {
    setCoinvestigadores(coinvestigadores.filter((_, i) => i !== index));
  };
  const agregarDepartamento = () => {
    if (!formDepartamento.area?.trim()) return;
    setDepartamentosParticipantes([...departamentosParticipantes, {
      ...formDepartamento
    }]);
    setFormDepartamento({
      area: "",
      responsable: ""
    });
  };
  const eliminarDepartamento = (index) => {
    setDepartamentosParticipantes(departamentosParticipantes.filter((_, i) => i !== index));
  };
  const agregarInstitucionParticipante = () => {
    if (!formInstitucion.clues?.trim() || !formInstitucion.nombreInstitucion?.trim()) return;
    setInstitucionesParticipantes([...institucionesParticipantes, {
      ...formInstitucion
    }]);
    setFormInstitucion({
      clues: "",
      nombreInstitucion: "",
      nombreParticipante: "",
      puesto: "",
      numConvenio: "",
      adscripcion: "",
      telefono: "",
      correo: ""
    });
  };
  const eliminarInstitucionParticipante = (index) => {
    setInstitucionesParticipantes(institucionesParticipantes.filter((_, i) => i !== index));
  };
  const totalSubsidio = (s) => {
    const interno = parseFloat(s.subsidioInterno) || 0;
    const externo = parseFloat(s.subsidioExterno) || 0;
    return (interno + externo).toFixed(2);
  };
  const handleFileChangeProgramaGasto = (e) => {
    const file = e.target.files?.[0];
    if (file) {
      setArchivoProgramaGasto(file);
      setPopupArchivoSubidoPaso7Programa(false);
      setIsDialogOpenProgramaGasto(false);
    }
  };
  const handleDragOverProgramaGasto = (e) => {
    e.preventDefault();
    setIsDraggingProgramaGasto(true);
  };
  const handleDragLeaveProgramaGasto = (e) => {
    e.preventDefault();
    setIsDraggingProgramaGasto(false);
  };
  const handleDropProgramaGasto = (e) => {
    e.preventDefault();
    setIsDraggingProgramaGasto(false);
    const file = e.dataTransfer.files?.[0];
    if (file) {
      setArchivoProgramaGasto(file);
      setPopupArchivoSubidoPaso7Programa(false);
      setIsDialogOpenProgramaGasto(false);
    }
  };
  const removeFileProgramaGasto = () => {
    setArchivoProgramaGasto(null);
    setPopupArchivoSubidoPaso7Programa(false);
    if (fileInputRefProgramaGasto.current) {
      fileInputRefProgramaGasto.current.value = "";
    }
  };
  const handleFileChangeCronograma = (e) => {
    const file = e.target.files?.[0];
    if (file) {
      setArchivoCronograma(file);
      setPopupArchivoSubidoPaso7Cronograma(false);
      setIsDialogOpenCronograma(false);
    }
  };
  const handleDragOverCronograma = (e) => {
    e.preventDefault();
    setIsDraggingCronograma(true);
  };
  const handleDragLeaveCronograma = (e) => {
    e.preventDefault();
    setIsDraggingCronograma(false);
  };
  const handleDropCronograma = (e) => {
    e.preventDefault();
    setIsDraggingCronograma(false);
    const file = e.dataTransfer.files?.[0];
    if (file) {
      setArchivoCronograma(file);
      setPopupArchivoSubidoPaso7Cronograma(false);
      setIsDialogOpenCronograma(false);
    }
  };
  const removeFileCronograma = () => {
    setArchivoCronograma(null);
    setPopupArchivoSubidoPaso7Cronograma(false);
    if (fileInputRefCronograma.current) {
      fileInputRefCronograma.current.value = "";
    }
  };
  if (inicializandoProyecto) {
    return /* @__PURE__ */ jsx("div", { className: "container mx-auto p-8 max-w-6xl pb-8", children: /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Cargando proyecto..." }) });
  }
  return /* @__PURE__ */ jsxs("div", { className: "container mx-auto p-8 max-w-6xl pb-8", children: [
    /* @__PURE__ */ jsxs("div", { className: "mb-6 space-y-2", children: [
      /* @__PURE__ */ jsx("h1", { className: "text-3xl font-bold tracking-tight", children: "Solicitud de Registro de Protocolos de Investigación" }),
      /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: "Complete el formulario con la información del protocolo" })
    ] }),
    proyectoEnviado && /* @__PURE__ */ jsxs("div", { className: "mb-6 rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-emerald-900", children: [
      /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2 text-sm font-semibold", children: [
        /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-4 w-4" }),
        "Enviado para revisión"
      ] }),
      /* @__PURE__ */ jsx("p", { className: "mt-1 text-sm", children: "Este proyecto ya fue enviado al comité. Está disponible solo para consulta." })
    ] }),
    /* @__PURE__ */ jsx("div", { className: "mb-8", children: /* @__PURE__ */ jsx("div", { className: "flex items-start justify-between gap-4", children: steps.map((step, index) => /* @__PURE__ */ jsxs("div", { className: "flex items-start flex-1 min-w-0", children: [
      /* @__PURE__ */ jsxs("div", { className: "flex flex-col items-center gap-2 w-full", children: [
        /* @__PURE__ */ jsx("div", { className: `
                          w-10 h-10 shrink-0 rounded-full flex items-center justify-center text-sm font-semibold transition-colors
                          ${index < currentStep ? "bg-primary text-primary-foreground" : index === currentStep ? "bg-primary text-primary-foreground ring-4 ring-primary/20" : "bg-muted text-muted-foreground"}
                        `, children: index < currentStep ? /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-5 w-5" }) : /* @__PURE__ */ jsx("span", { children: index + 1 }) }),
        /* @__PURE__ */ jsx("div", { className: "text-center hidden md:block w-full", children: /* @__PURE__ */ jsx("p", { className: `text-sm font-medium leading-tight ${index === currentStep ? "text-foreground" : "text-muted-foreground"}`, children: step.title }) })
      ] }),
      index < steps.length - 1 && /* @__PURE__ */ jsx("div", { className: `
                          flex-1 h-0.5 mx-2 mt-5 shrink-0 transition-colors min-w-[0.5rem]
                          ${index < currentStep ? "bg-primary" : "bg-muted"}
                        ` })
    ] }, index)) }) }),
    /* @__PURE__ */ jsxs("div", { className: "space-y-6", children: [
      /* @__PURE__ */ jsxs("div", { className: proyectoEnviado ? "[&_button]:pointer-events-none [&_input]:pointer-events-none [&_textarea]:pointer-events-none [&_[role=switch]]:pointer-events-none [&_[role=combobox]]:pointer-events-none" : "", children: [
        currentStep === 0 && /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsx(CardTitle, { children: "Solicitud" }) }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "solicitud", children: "Tipo de Solicitud" }),
                /* @__PURE__ */ jsxs(Select, { value: tipoSolicitud || void 0, onValueChange: setTipoSolicitud, children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "solicitud", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsxs(SelectContent, { children: [
                    /* @__PURE__ */ jsx(SelectItem, { value: "evaluacion", children: "Evaluación" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "enmienda", children: "Enmienda" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "aprobacion_expedita", children: "Aprobación Expedita*" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "registro_colaboracion_meta_analisis", children: "Registro de Colaboración/Meta-Análisis*" })
                  ] })
                ] })
              ] }),
              /* @__PURE__ */ jsxs(Alert, { children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: InformationCircleIcon, className: "h-4 w-4" }),
                /* @__PURE__ */ jsx(AlertDescription, { className: "flex items-center justify-between gap-4 pr-32", children: "Se adjunta una carta de aprobación expedida por otros comités debidamente registrados ante COFEPRIS y CONBIOÉTICA" }),
                /* @__PURE__ */ jsx(AlertAction, { className: "top-1/2 -translate-y-1/2", children: /* @__PURE__ */ jsxs(Dialog, { open: isDialogOpen, onOpenChange: setIsDialogOpen, children: [
                  /* @__PURE__ */ jsx(DialogTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(Button, { variant: "outline", size: "sm", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Upload01Icon, className: "h-4 w-4 mr-2" }),
                    uploadedFile || archivoCartaAprobacionGuardado ? "Cambiar archivo" : "Subir archivo"
                  ] }) }),
                  /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-md", children: [
                    /* @__PURE__ */ jsxs(DialogHeader, { children: [
                      /* @__PURE__ */ jsx(DialogTitle, { children: "Subir Carta de Aprobación Expedida o Registro de Colaboración" }),
                      /* @__PURE__ */ jsx(DialogDescription, { children: "Arrastre y suelte el archivo o haga clic para seleccionar" })
                    ] }),
                    /* @__PURE__ */ jsxs("div", { onDragOver: handleDragOver, onDragLeave: handleDragLeave, onDrop: handleDrop, className: `
                              border-2 border-dashed rounded-lg p-8 text-center cursor-pointer transition-colors
                              ${isDragging ? "border-primary bg-primary/5" : "border-muted-foreground/25 hover:border-primary/50"}
                            `, onClick: () => fileInputRef.current?.click(), children: [
                      /* @__PURE__ */ jsx("input", { ref: fileInputRef, type: "file", className: "hidden", onChange: handleFileChange, accept: ".pdf,application/pdf" }),
                      /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-12 w-12 mx-auto mb-4 text-muted-foreground" }),
                      /* @__PURE__ */ jsx("p", { className: "text-sm text-muted-foreground mb-2", children: "Arrastre y suelte aquí los archivos" }),
                      /* @__PURE__ */ jsx("p", { className: "text-xs text-muted-foreground mb-4", children: "(o haga clic para seleccionar archivo)" }),
                      /* @__PURE__ */ jsx(Button, { type: "button", variant: "secondary", size: "sm", children: "Seleccionar archivo" })
                    ] })
                  ] })
                ] }) })
              ] }),
              uploadedFile && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-3 bg-muted rounded-lg", children: [
                /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                  /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-4 w-4 text-primary" }),
                  /* @__PURE__ */ jsx("span", { className: "text-sm font-medium", children: uploadedFile.name }),
                  /* @__PURE__ */ jsxs(Badge, { variant: "secondary", children: [
                    (uploadedFile.size / 1024).toFixed(2),
                    " KB"
                  ] })
                ] }),
                /* @__PURE__ */ jsx(Button, { variant: "ghost", size: "sm", onClick: removeFile, children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) })
              ] }),
              !uploadedFile && archivoCartaAprobacionGuardado && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-3 bg-muted rounded-lg", children: [
                /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                  /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-4 w-4 text-primary" }),
                  /* @__PURE__ */ jsx("span", { className: "text-sm font-medium", children: archivoCartaAprobacionGuardado.nombre_original }),
                  /* @__PURE__ */ jsx(Badge, { variant: "secondary", children: "Guardado" })
                ] }),
                proyectoId != null && /* @__PURE__ */ jsx(Button, { variant: "outline", size: "sm", className: proyectoEnviado ? "!pointer-events-auto" : void 0, onClick: () => abrirVistaArchivo("carta_aprobacion", archivoCartaAprobacionGuardado.nombre_original), children: "Ver archivo" })
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsxs(CardHeader, { children: [
              /* @__PURE__ */ jsx(CardTitle, { children: "Datos del Proponente" }),
              /* @__PURE__ */ jsx(CardDescription, { children: "Información personal del investigador responsable" })
            ] }),
            /* @__PURE__ */ jsx(CardContent, { children: /* @__PURE__ */ jsxs("div", { className: "grid gap-6", children: [
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "curp", children: "C.U.R.P. / ID (extranjero)" }),
                  /* @__PURE__ */ jsx(Input, { id: "curp", placeholder: "CURP o identificación", value: usuario?.curp ?? usuario?.identificacion ?? "", readOnly: true, disabled: proponenteBloqueado, className: proponenteBloqueado ? "bg-muted" : void 0 })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "nombre", children: "Nombre" }),
                  /* @__PURE__ */ jsx(Input, { id: "nombre", placeholder: "Nombre completo", value: nombreCompletoProponente, readOnly: true, disabled: proponenteBloqueado, className: proponenteBloqueado ? "bg-muted" : void 0 })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "email", children: "Correo electrónico" }),
                  /* @__PURE__ */ jsx(Input, { id: "email", type: "email", placeholder: "correo@ejemplo.com", value: usuario?.correo ?? "", readOnly: true, disabled: proponenteBloqueado, className: proponenteBloqueado ? "bg-muted" : void 0 })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "tel-particular", children: "Teléfono Particular" }),
                  /* @__PURE__ */ jsx(Input, { id: "tel-particular", placeholder: "Teléfono", value: usuario?.telefono ?? "", readOnly: true, disabled: proponenteBloqueado, className: proponenteBloqueado ? "bg-muted" : void 0 })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "tel-oficina", children: "Teléfono Oficina" }),
                  /* @__PURE__ */ jsx(Input, { id: "tel-oficina", placeholder: "Teléfono", inputMode: "numeric", maxLength: 10, value: telefonoOficina, onChange: (e) => {
                    const soloNumeros = e.target.value.replace(/\D/g, "").slice(0, 10);
                    setTelefonoOficina(soloNumeros);
                  } })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "extension", children: "Extensión" }),
                  /* @__PURE__ */ jsx(Input, { id: "extension", placeholder: "Ext.", inputMode: "numeric", maxLength: 4, value: extensionOficina, onChange: (e) => {
                    const soloNumeros = e.target.value.replace(/\D/g, "").slice(0, 4);
                    setExtensionOficina(soloNumeros);
                  } })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "adscripcion", children: "Adscripción" }),
                  /* @__PURE__ */ jsx(Input, { id: "adscripcion", placeholder: "Adscripción", value: adscripcionProponente, onChange: (e) => setAdscripcionProponente(e.target.value) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "nivel-estudios", children: "Nivel Máximo de Estudios" }),
                  /* @__PURE__ */ jsxs(Select, { value: nivelEstudiosProponenteValue || void 0, disabled: proponenteBloqueado, children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "nivel-estudios", className: proponenteBloqueado ? "bg-muted" : void 0, children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: NIVEL_MAXIMO_ESTUDIOS.map((n) => /* @__PURE__ */ jsx(SelectItem, { value: n.value, children: n.label }, n.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "disciplina", children: "Disciplina" }),
                  /* @__PURE__ */ jsxs(Select, { value: disciplinaProponente || void 0, onValueChange: setDisciplinaProponente, children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "disciplina", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: DISCIPLINAS.map((d) => /* @__PURE__ */ jsx(SelectItem, { value: d.value, children: d.label }, d.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "especialidad", children: "Especialidad" }),
                  /* @__PURE__ */ jsxs(Select, { value: especialidadProponente || void 0, onValueChange: setEspecialidadProponente, children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "especialidad", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: ESPECIALIDADES.map((e) => /* @__PURE__ */ jsx(SelectItem, { value: e.value, children: e.label }, e.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "nivel", children: "Nivel" }),
                  /* @__PURE__ */ jsxs(Select, { value: nivelProponente || void 0, onValueChange: setNivelProponente, children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "nivel", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: NIVELES.map((n) => /* @__PURE__ */ jsx(SelectItem, { value: n.value, children: n.label }, n.value)) })
                  ] })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "flex items-center space-x-3 p-4 bg-muted rounded-lg", children: [
                /* @__PURE__ */ jsx(Switch, { id: "sni", checked: perteneceSniProponente, onCheckedChange: setPerteneceSniProponente }),
                /* @__PURE__ */ jsx(Label, { htmlFor: "sni", className: "cursor-pointer font-normal", children: "¿Pertenece al Sistema Nacional de Investigadores (SNI)?" })
              ] })
            ] }) })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsxs(CardHeader, { children: [
              /* @__PURE__ */ jsx(CardTitle, { children: "Información del Protocolo" }),
              /* @__PURE__ */ jsx(CardDescription, { children: "Detalles sobre el proyecto de investigación" })
            ] }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-6", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "titulo", children: "Título del Protocolo/Tesis de Investigación" }),
                  /* @__PURE__ */ jsxs(Badge, { variant: tituloLength > maxTituloLength ? "destructive" : "secondary", children: [
                    tituloLength,
                    " / ",
                    maxTituloLength
                  ] })
                ] }),
                /* @__PURE__ */ jsx(Textarea, { id: "titulo", placeholder: "Ingrese el título del protocolo o tesis de investigación", rows: 4, maxLength: maxTituloLength, value: titulo, onChange: (e) => {
                  const v = e.target.value.slice(0, maxTituloLength);
                  setTitulo(v);
                  setTituloLength(v.length);
                } })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "linea-investigacion", children: "Líneas de investigación prioritarias en Salud del HJM, a la que corresponde la investigación propuesta" }),
                /* @__PURE__ */ jsxs(Select, { value: lineaInvestigacion || void 0, onValueChange: setLineaInvestigacion, children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "linea-investigacion", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: LINEAS_INVESTIGACION.map((l) => /* @__PURE__ */ jsx(SelectItem, { value: l.value, children: l.label }, l.value)) })
                ] })
              ] })
            ] })
          ] })
        ] }),
        currentStep === 1 && /* @__PURE__ */ jsxs(Card, { children: [
          /* @__PURE__ */ jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsx(CardTitle, { children: "Características del Protocolo" }),
            /* @__PURE__ */ jsx(CardDescription, { children: "Información técnica y operativa del proyecto" })
          ] }),
          /* @__PURE__ */ jsxs(CardContent, { className: "space-y-6", children: [
            /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "tipo-riesgo", children: "Tipo de Riesgo" }),
                /* @__PURE__ */ jsxs(Select, { value: tipoRiesgoPaso1 || void 0, onValueChange: setTipoRiesgoPaso1, children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "tipo-riesgo", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: TIPOS_RIESGO.map((r) => /* @__PURE__ */ jsx(SelectItem, { value: r.value, children: r.label }, r.value)) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "tipo-investigacion", children: "Tipo de Investigación" }),
                /* @__PURE__ */ jsxs(Select, { value: tipoInvestigacionPaso1 || void 0, onValueChange: setTipoInvestigacionPaso1, children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "tipo-investigacion", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: TIPOS_INVESTIGACION.map((t) => /* @__PURE__ */ jsx(SelectItem, { value: t.value, children: t.label }, t.value)) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "tipo-protocolo", children: "Tipo de Protocolo" }),
                /* @__PURE__ */ jsxs(Select, { value: tipoProtocoloPaso1 || void 0, onValueChange: setTipoProtocoloPaso1, children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "tipo-protocolo", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: TIPOS_PROTOCOLO.map((t) => /* @__PURE__ */ jsx(SelectItem, { value: t.value, children: t.label }, t.value)) })
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "fuente-financiamiento", children: "Fuente de Financiamiento" }),
                /* @__PURE__ */ jsxs(Select, { value: fuenteFinanciamientoPaso1 || void 0, onValueChange: setFuenteFinanciamientoPaso1, children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "fuente-financiamiento", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: FUENTES_FINANCIAMIENTO.map((f) => /* @__PURE__ */ jsx(SelectItem, { value: f.value, children: f.label }, f.value)) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "monto", children: "Monto $" }),
                /* @__PURE__ */ jsx(Input, { id: "monto", type: "number", placeholder: "0.00", value: montoPaso1, onChange: (e) => setMontoPaso1(e.target.value) })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "agencia-financiadora", children: "Indique la Agencia/Institución Financiadora" }),
                /* @__PURE__ */ jsx(Input, { id: "agencia-financiadora", placeholder: "Nombre de la agencia", value: agenciaFinanciadoraPaso1, onChange: (e) => setAgenciaFinanciadoraPaso1(e.target.value) })
              ] })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "flex items-center space-x-3 p-4 bg-muted rounded-lg", children: [
              /* @__PURE__ */ jsx(Switch, { id: "farmacovigilancia", checked: requiereFarmacovigilancia, onCheckedChange: setRequiereFarmacovigilancia }),
              /* @__PURE__ */ jsx(Label, { htmlFor: "farmacovigilancia", className: "cursor-pointer font-normal", children: "¿El protocolo contiene aspectos / objetivos / resultados que pudieran requerir notificación a Farmacovigilancia?" })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "tipo-estudio", children: "Tipo de Estudio" }),
                /* @__PURE__ */ jsxs(Select, { value: tipoEstudioPaso1 || void 0, onValueChange: setTipoEstudioPaso1, children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "tipo-estudio", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: TIPOS_ESTUDIO.map((t) => /* @__PURE__ */ jsx(SelectItem, { value: t.value, children: t.label }, t.value)) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "fecha-inicio", children: "Fecha de Inicio Protocolo" }),
                /* @__PURE__ */ jsxs(Popover, { children: [
                  /* @__PURE__ */ jsx(PopoverTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(Button, { id: "fecha-inicio", variant: "outline", className: "w-full justify-start text-left font-normal", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Calendar03Icon, className: "mr-2 size-4" }),
                    fechaInicio ? format(fechaInicio, "d 'de' MMMM, yyyy", {
                      locale: es
                    }) : "Seleccionar fecha"
                  ] }) }),
                  /* @__PURE__ */ jsx(PopoverContent, { className: "w-auto p-0", align: "start", children: /* @__PURE__ */ jsx(Calendar, { mode: "single", selected: fechaInicio, onSelect: setFechaInicio, locale: es, className: "rounded-lg border", captionLayout: "dropdown", startMonth: new Date(2020, 0), endMonth: new Date(2050, 11), disabled: (date) => date < new Date(2020, 0, 1) || date > new Date(2050, 11, 31) }) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "fecha-termino", children: "Fecha de Término Protocolo" }),
                /* @__PURE__ */ jsxs(Popover, { children: [
                  /* @__PURE__ */ jsx(PopoverTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(Button, { id: "fecha-termino", variant: "outline", className: "w-full justify-start text-left font-normal", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Calendar03Icon, className: "mr-2 size-4" }),
                    fechaTermino ? format(fechaTermino, "d 'de' MMMM, yyyy", {
                      locale: es
                    }) : "Seleccionar fecha"
                  ] }) }),
                  /* @__PURE__ */ jsx(PopoverContent, { className: "w-auto p-0", align: "start", children: /* @__PURE__ */ jsx(Calendar, { mode: "single", selected: fechaTermino, onSelect: setFechaTermino, locale: es, className: "rounded-lg border", captionLayout: "dropdown", startMonth: new Date(2020, 0), endMonth: new Date(2050, 11), disabled: (date) => date < new Date(2020, 0, 1) || date > new Date(2050, 11, 31) }) })
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "space-y-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "colaboracion", children: "¿Cuenta el protocolo con colaboración interinstitucional?" }),
                /* @__PURE__ */ jsxs(Select, { value: tieneColaboracionPaso1 || void 0, onValueChange: setTieneColaboracionPaso1, children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "colaboracion", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsxs(SelectContent, { children: [
                    /* @__PURE__ */ jsx(SelectItem, { value: "si", children: "Sí" }),
                    /* @__PURE__ */ jsx(SelectItem, { value: "no", children: "No" })
                  ] })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "tipo-colaboracion", children: "Tipo de colaboración" }),
                /* @__PURE__ */ jsxs(Select, { value: tipoColaboracionPaso1 || void 0, onValueChange: setTipoColaboracionPaso1, children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "tipo-colaboracion", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: TIPOS_COLABORACION.map((t) => /* @__PURE__ */ jsx(SelectItem, { value: t.value, children: t.label }, t.value)) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs(Alert, { children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: InformationCircleIcon, className: "h-4 w-4" }),
                /* @__PURE__ */ jsx(AlertDescription, { className: "flex items-center justify-between gap-4 pr-32", children: "En caso de haber indicado que habrá colaboración interinstitucional se deberá anexar una carta de colaboración firmada por el responsable de investigación de cada institución participante" }),
                /* @__PURE__ */ jsx(AlertAction, { className: "top-1/2 -translate-y-1/2", children: /* @__PURE__ */ jsxs(Dialog, { open: isDialogOpenColaboracion, onOpenChange: setIsDialogOpenColaboracion, children: [
                  /* @__PURE__ */ jsx(DialogTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(Button, { variant: "outline", size: "sm", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Upload01Icon, className: "h-4 w-4 mr-2" }),
                    uploadedFileColaboracion || archivoCartaColaboracionGuardado ? "Cambiar archivo" : "Subir archivo"
                  ] }) }),
                  /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-md", children: [
                    /* @__PURE__ */ jsxs(DialogHeader, { children: [
                      /* @__PURE__ */ jsx(DialogTitle, { children: "Subir Carta de Colaboración" }),
                      /* @__PURE__ */ jsx(DialogDescription, { children: "Arrastre y suelte el archivo o haga clic para seleccionar" })
                    ] }),
                    /* @__PURE__ */ jsxs("div", { onDragOver: handleDragOverColaboracion, onDragLeave: handleDragLeaveColaboracion, onDrop: handleDropColaboracion, className: `
                                border-2 border-dashed rounded-lg p-8 text-center cursor-pointer transition-colors
                                ${isDraggingColaboracion ? "border-primary bg-primary/5" : "border-muted-foreground/25 hover:border-primary/50"}
                              `, onClick: () => fileInputRefColaboracion.current?.click(), children: [
                      /* @__PURE__ */ jsx("input", { ref: fileInputRefColaboracion, type: "file", className: "hidden", onChange: handleFileChangeColaboracion, accept: ".pdf,application/pdf" }),
                      /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-12 w-12 mx-auto mb-4 text-muted-foreground" }),
                      /* @__PURE__ */ jsx("p", { className: "text-sm text-muted-foreground mb-2", children: "Arrastre y suelte aquí los archivos" }),
                      /* @__PURE__ */ jsx("p", { className: "text-xs text-muted-foreground mb-4", children: "(o haga clic para seleccionar archivo)" }),
                      /* @__PURE__ */ jsx(Button, { type: "button", variant: "secondary", size: "sm", children: "Seleccionar archivo" })
                    ] })
                  ] })
                ] }) })
              ] }),
              uploadedFileColaboracion && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-3 bg-muted rounded-lg", children: [
                /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                  /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-4 w-4 text-primary" }),
                  /* @__PURE__ */ jsx("span", { className: "text-sm font-medium", children: uploadedFileColaboracion.name }),
                  /* @__PURE__ */ jsxs(Badge, { variant: "secondary", children: [
                    (uploadedFileColaboracion.size / 1024).toFixed(2),
                    " KB"
                  ] })
                ] }),
                /* @__PURE__ */ jsx(Button, { variant: "ghost", size: "sm", onClick: removeFileColaboracion, children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) })
              ] }),
              !uploadedFileColaboracion && archivoCartaColaboracionGuardado && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-3 bg-muted rounded-lg", children: [
                /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                  /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-4 w-4 text-primary" }),
                  /* @__PURE__ */ jsx("span", { className: "text-sm font-medium", children: archivoCartaColaboracionGuardado.nombre_original }),
                  /* @__PURE__ */ jsx(Badge, { variant: "secondary", children: "Guardado" })
                ] }),
                proyectoId != null && /* @__PURE__ */ jsx(Button, { variant: "outline", size: "sm", className: proyectoEnviado ? "!pointer-events-auto" : void 0, onClick: () => abrirVistaArchivo("carta_colaboracion", archivoCartaColaboracionGuardado.nombre_original), children: "Ver archivo" })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-3", children: [
                /* @__PURE__ */ jsx(Label, { children: "Nombre de la Institución Participante" }),
                /* @__PURE__ */ jsxs("div", { className: "flex gap-2", children: [
                  /* @__PURE__ */ jsx(Input, { placeholder: "Nombre de la institución participante", value: nuevaInstitucion, onChange: (e) => setNuevaInstitucion(e.target.value), onKeyDown: (e) => {
                    if (e.key === "Enter") {
                      e.preventDefault();
                      agregarInstitucion();
                    }
                  } }),
                  /* @__PURE__ */ jsxs(Button, { type: "button", onClick: agregarInstitucion, disabled: !nuevaInstitucion.trim(), children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: PlusSignIcon, className: "h-4 w-4 mr-2" }),
                    "Agregar"
                  ] })
                ] }),
                instituciones.length > 0 && /* @__PURE__ */ jsxs("div", { className: "space-y-2 mt-4", children: [
                  /* @__PURE__ */ jsxs(Label, { className: "text-sm text-muted-foreground", children: [
                    "Instituciones agregadas (",
                    instituciones.length,
                    ")"
                  ] }),
                  /* @__PURE__ */ jsx("div", { className: "space-y-2", children: instituciones.map((institucion, index) => /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-3 bg-muted rounded-lg", children: [
                    /* @__PURE__ */ jsx("span", { className: "text-sm", children: institucion }),
                    /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: () => eliminarInstitucion(index), children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) })
                  ] }, index)) })
                ] })
              ] })
            ] })
          ] })
        ] }),
        currentStep === 2 && /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsxs(CardHeader, { children: [
              /* @__PURE__ */ jsx(CardTitle, { children: "Tipo de Ayuda" }),
              /* @__PURE__ */ jsx(CardDescription, { children: "Indique en esta sección el tipo de ayuda que la institución colaboradora proporcionará al protocolo propuesto" })
            ] }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-6", children: [
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "infraestructura", children: "Infraestructura" }),
                  /* @__PURE__ */ jsx(Input, { id: "infraestructura", placeholder: "Infraestructura", value: nuevaAyuda.infraestructura, onChange: (e) => setNuevaAyuda({
                    ...nuevaAyuda,
                    infraestructura: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "personal-ayuda", children: "Personal" }),
                  /* @__PURE__ */ jsx(Input, { id: "personal-ayuda", placeholder: "Personal", value: nuevaAyuda.personal, onChange: (e) => setNuevaAyuda({
                    ...nuevaAyuda,
                    personal: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "material-ayuda", children: "Material" }),
                  /* @__PURE__ */ jsx(Input, { id: "material-ayuda", placeholder: "Material", value: nuevaAyuda.material, onChange: (e) => setNuevaAyuda({
                    ...nuevaAyuda,
                    material: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "equipo-ayuda", children: "Equipo" }),
                  /* @__PURE__ */ jsx(Input, { id: "equipo-ayuda", placeholder: "Equipo", value: nuevaAyuda.equipo, onChange: (e) => setNuevaAyuda({
                    ...nuevaAyuda,
                    equipo: e.target.value
                  }) })
                ] })
              ] }),
              /* @__PURE__ */ jsx("div", { className: "flex justify-end", children: /* @__PURE__ */ jsxs(Button, { type: "button", onClick: agregarTipoAyuda, disabled: !nuevaAyuda.infraestructura && !nuevaAyuda.personal && !nuevaAyuda.material && !nuevaAyuda.equipo, children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: PlusSignIcon, className: "h-4 w-4 mr-2" }),
                "Agregar"
              ] }) }),
              tiposAyuda.length > 0 && /* @__PURE__ */ jsxs("div", { className: "space-y-4", children: [
                /* @__PURE__ */ jsxs(Label, { className: "text-sm text-muted-foreground", children: [
                  "Tipos de ayuda agregados (",
                  tiposAyuda.length,
                  ")"
                ] }),
                /* @__PURE__ */ jsx("div", { className: "border rounded-lg overflow-hidden", children: /* @__PURE__ */ jsxs("table", { className: "w-full", children: [
                  /* @__PURE__ */ jsx("thead", { className: "bg-muted", children: /* @__PURE__ */ jsxs("tr", { children: [
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "No." }),
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Infraestructura" }),
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Personal" }),
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Material" }),
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Equipo" }),
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium w-16" })
                  ] }) }),
                  /* @__PURE__ */ jsx("tbody", { className: "divide-y", children: tiposAyuda.map((ayuda, index) => /* @__PURE__ */ jsxs("tr", { className: "hover:bg-muted/50", children: [
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: index + 1 }),
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: ayuda.infraestructura || "-" }),
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: ayuda.personal || "-" }),
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: ayuda.material || "-" }),
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: ayuda.equipo || "-" }),
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: () => eliminarTipoAyuda(index), children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) }) })
                  ] }, index)) })
                ] }) })
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsxs(CardHeader, { children: [
              /* @__PURE__ */ jsx(CardTitle, { children: "Datos Colaborador" }),
              /* @__PURE__ */ jsx(CardDescription, { children: "Información del colaborador de la investigación" })
            ] }),
            /* @__PURE__ */ jsx(CardContent, { children: /* @__PURE__ */ jsxs("div", { className: "grid gap-6", children: [
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "curp-colaborador", children: "C.U.R.P. / ID" }),
                  /* @__PURE__ */ jsx(Input, { id: "curp-colaborador", placeholder: "Ingrese CURP o ID del colaborador", value: datosColaboradorPaso2.curpIdentificacion, onChange: (e) => handleCurpIdentificacionColaboradorChange(e.target.value) }),
                  consultandoCurpColaborador && /* @__PURE__ */ jsx("p", { className: "text-xs text-muted-foreground", children: "Consultando CURP…" }),
                  !!errorCurpColaborador && /* @__PURE__ */ jsx("p", { className: "text-xs text-destructive", children: errorCurpColaborador })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "nombre-colaborador", children: "Nombre" }),
                  /* @__PURE__ */ jsx(Input, { id: "nombre-colaborador", placeholder: "Nombre completo", value: datosColaboradorPaso2.nombre, readOnly: nombreColaboradorBloqueado, disabled: nombreColaboradorBloqueado, className: nombreColaboradorBloqueado ? "bg-muted" : void 0, onChange: (e) => setDatosColaboradorPaso2((prev) => ({
                    ...prev,
                    nombre: e.target.value
                  })) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "email-colaborador", children: "Correo electrónico" }),
                /* @__PURE__ */ jsx(Input, { id: "email-colaborador", type: "email", placeholder: "correo@ejemplo.com", value: datosColaboradorPaso2.correo, onChange: (e) => setDatosColaboradorPaso2((prev) => ({
                  ...prev,
                  correo: e.target.value
                })) })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "tel-particular-colaborador", children: "Teléfono Particular" }),
                  /* @__PURE__ */ jsx(Input, { id: "tel-particular-colaborador", placeholder: "Teléfono", inputMode: "numeric", maxLength: 10, value: datosColaboradorPaso2.telefonoParticular, onChange: (e) => setDatosColaboradorPaso2((prev) => ({
                    ...prev,
                    telefonoParticular: e.target.value.replace(/\D/g, "").slice(0, 10)
                  })) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "tel-oficina-colaborador", children: "Teléfono Oficina" }),
                  /* @__PURE__ */ jsx(Input, { id: "tel-oficina-colaborador", placeholder: "Teléfono", inputMode: "numeric", maxLength: 10, value: datosColaboradorPaso2.telefonoOficina, onChange: (e) => setDatosColaboradorPaso2((prev) => ({
                    ...prev,
                    telefonoOficina: e.target.value.replace(/\D/g, "").slice(0, 10)
                  })) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "extension-colaborador", children: "Extensión" }),
                  /* @__PURE__ */ jsx(Input, { id: "extension-colaborador", placeholder: "Ext.", inputMode: "numeric", maxLength: 4, value: datosColaboradorPaso2.extension, onChange: (e) => setDatosColaboradorPaso2((prev) => ({
                    ...prev,
                    extension: e.target.value.replace(/\D/g, "").slice(0, 4)
                  })) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "adscripcion-colaborador", children: "Adscripción" }),
                  /* @__PURE__ */ jsx(Input, { id: "adscripcion-colaborador", placeholder: "Adscripción", value: datosColaboradorPaso2.adscripcion, onChange: (e) => setDatosColaboradorPaso2((prev) => ({
                    ...prev,
                    adscripcion: e.target.value
                  })) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "nivel-estudios-colaborador", children: "Nivel Máximo de Estudios" }),
                  /* @__PURE__ */ jsxs(Select, { value: datosColaboradorPaso2.nivelEstudios || void 0, onValueChange: (v) => setDatosColaboradorPaso2((prev) => ({
                    ...prev,
                    nivelEstudios: v
                  })), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "nivel-estudios-colaborador", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: NIVEL_MAXIMO_ESTUDIOS.map((n) => /* @__PURE__ */ jsx(SelectItem, { value: n.value, children: n.label }, n.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "disciplina-colaborador", children: "Disciplina" }),
                  /* @__PURE__ */ jsxs(Select, { value: datosColaboradorPaso2.disciplina || void 0, onValueChange: (v) => setDatosColaboradorPaso2((prev) => ({
                    ...prev,
                    disciplina: v
                  })), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "disciplina-colaborador", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: DISCIPLINAS.map((d) => /* @__PURE__ */ jsx(SelectItem, { value: d.value, children: d.label }, d.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "especialidad-colaborador", children: "Especialidad" }),
                  /* @__PURE__ */ jsxs(Select, { value: datosColaboradorPaso2.especialidad || void 0, onValueChange: (v) => setDatosColaboradorPaso2((prev) => ({
                    ...prev,
                    especialidad: v
                  })), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "especialidad-colaborador", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: ESPECIALIDADES.map((e) => /* @__PURE__ */ jsx(SelectItem, { value: e.value, children: e.label }, e.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "nivel-colaborador", children: "Nivel" }),
                  /* @__PURE__ */ jsxs(Select, { value: datosColaboradorPaso2.nivel || void 0, onValueChange: (v) => setDatosColaboradorPaso2((prev) => ({
                    ...prev,
                    nivel: v
                  })), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "nivel-colaborador", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: NIVELES.map((n) => /* @__PURE__ */ jsx(SelectItem, { value: n.value, children: n.label }, n.value)) })
                  ] })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "flex items-center space-x-3 p-4 bg-muted rounded-lg", children: [
                /* @__PURE__ */ jsx(Switch, { id: "sni-colaborador", checked: datosColaboradorPaso2.sni, onCheckedChange: (checked) => setDatosColaboradorPaso2((prev) => ({
                  ...prev,
                  sni: checked
                })) }),
                /* @__PURE__ */ jsx(Label, { htmlFor: "sni-colaborador", className: "cursor-pointer font-normal", children: "¿Pertenece al Sistema Nacional de Investigadores (SNI)?" })
              ] })
            ] }) })
          ] })
        ] }),
        currentStep === 3 && /* @__PURE__ */ jsxs(Card, { children: [
          /* @__PURE__ */ jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsx(CardTitle, { children: "Descripción del proyecto" }),
            /* @__PURE__ */ jsx(CardDescription, { children: "Título, programa estratégico, líneas prioritarias y vigencia" })
          ] }),
          /* @__PURE__ */ jsxs(CardContent, { className: "space-y-6", children: [
            /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsx(Label, { htmlFor: "titulo-descriptivo", children: "Título descriptivo del proyecto" }),
              /* @__PURE__ */ jsx(Input, { id: "titulo-descriptivo", placeholder: "Ingrese el título descriptivo del proyecto", value: tituloDescriptivo, onChange: (e) => setTituloDescriptivo(e.target.value) })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "space-y-4", children: [
              /* @__PURE__ */ jsx("h4", { className: "text-sm font-medium", children: "Programa Estratégico" }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "area-estudio", children: "Área de Estudio" }),
                  /* @__PURE__ */ jsxs(Select, { value: areaEstudioProyecto || void 0, onValueChange: setAreaEstudioProyecto, children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "area-estudio", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: /* @__PURE__ */ jsx(SelectItem, { value: "placeholder", children: "Seleccione una opción" }) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "area", children: "Área" }),
                  /* @__PURE__ */ jsx(Input, { id: "area", placeholder: "Área", value: areaProyecto, onChange: (e) => setAreaProyecto(e.target.value) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "subarea-investigacion", children: "Sub área de Investigación" }),
                  /* @__PURE__ */ jsxs(Select, { value: subareaInvestigacionProyecto || void 0, onValueChange: setSubareaInvestigacionProyecto, children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "subarea-investigacion", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: /* @__PURE__ */ jsx(SelectItem, { value: "placeholder", children: "Seleccione una opción" }) })
                  ] })
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsx(Label, { htmlFor: "lineas-prioritarias-clasifica", children: "Líneas prioritarias de investigación y generación de conocimiento se clasifica" }),
              /* @__PURE__ */ jsxs(Select, { value: lineasPrioritariasClasifica || void 0, onValueChange: setLineasPrioritariasClasifica, children: [
                /* @__PURE__ */ jsx(SelectTrigger, { id: "lineas-prioritarias-clasifica", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                /* @__PURE__ */ jsx(SelectContent, { children: LINEAS_INVESTIGACION.map((l) => /* @__PURE__ */ jsx(SelectItem, { value: l.value, children: l.label }, l.value)) })
              ] })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "fecha-inicio-proyecto", children: "Fecha de inicio" }),
                /* @__PURE__ */ jsxs(Popover, { children: [
                  /* @__PURE__ */ jsx(PopoverTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(Button, { id: "fecha-inicio-proyecto", variant: "outline", className: "w-full justify-start text-left font-normal", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Calendar03Icon, className: "mr-2 size-4" }),
                    fechaInicioProyecto ? format(fechaInicioProyecto, "d 'de' MMMM, yyyy", {
                      locale: es
                    }) : "Seleccionar fecha"
                  ] }) }),
                  /* @__PURE__ */ jsx(PopoverContent, { className: "w-auto p-0", align: "start", children: /* @__PURE__ */ jsx(Calendar, { mode: "single", selected: fechaInicioProyecto, onSelect: setFechaInicioProyecto, locale: es, className: "rounded-lg border", captionLayout: "dropdown", startMonth: new Date(2020, 0), endMonth: new Date(2050, 11), disabled: (date) => date < new Date(2020, 0, 1) || date > new Date(2050, 11, 31) }) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "fecha-termino-proyecto", children: "Fecha de término" }),
                /* @__PURE__ */ jsxs(Popover, { children: [
                  /* @__PURE__ */ jsx(PopoverTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(Button, { id: "fecha-termino-proyecto", variant: "outline", className: "w-full justify-start text-left font-normal", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Calendar03Icon, className: "mr-2 size-4" }),
                    fechaTerminoProyecto ? format(fechaTerminoProyecto, "d 'de' MMMM, yyyy", {
                      locale: es
                    }) : "Seleccionar fecha"
                  ] }) }),
                  /* @__PURE__ */ jsx(PopoverContent, { className: "w-auto p-0", align: "start", children: /* @__PURE__ */ jsx(Calendar, { mode: "single", selected: fechaTerminoProyecto, onSelect: setFechaTerminoProyecto, locale: es, className: "rounded-lg border", captionLayout: "dropdown", startMonth: new Date(2020, 0), endMonth: new Date(2050, 11), disabled: (date) => date < new Date(2020, 0, 1) || date > new Date(2050, 11, 31) }) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "vigencia-dias", children: "Vigencia del proyecto en días" }),
                /* @__PURE__ */ jsx(Input, { id: "vigencia-dias", type: "text", inputMode: "numeric", pattern: "[0-9]*", placeholder: "Días", autoComplete: "off", value: vigenciaDias, onKeyDown: (e) => {
                  const control = ["Backspace", "Delete", "Tab", "ArrowLeft", "ArrowRight", "Home", "End"];
                  if (control.includes(e.key)) return;
                  if ((e.ctrlKey || e.metaKey) && ["a", "c", "v", "x"].includes(e.key.toLowerCase())) return;
                  if (!/^[0-9]$/.test(e.key)) e.preventDefault();
                }, onPaste: (e) => {
                  e.preventDefault();
                  const pegado = (e.clipboardData?.getData("text") ?? "").replace(/\D/g, "");
                  setVigenciaDias((prev) => (prev + pegado).replace(/\D/g, ""));
                }, onChange: (e) => setVigenciaDias(e.target.value.replace(/\D/g, "")) })
              ] })
            ] }),
            /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsx(Label, { htmlFor: "descripcion-proyecto", children: "Descripción del proyecto" }),
              /* @__PURE__ */ jsx(Textarea, { id: "descripcion-proyecto", placeholder: "Ingrese la descripción del proyecto o protocolo de investigación", rows: 6, className: "resize-y min-h-[120px]", value: descripcionProyecto, onChange: (e) => setDescripcionProyecto(e.target.value) })
            ] })
          ] })
        ] }),
        currentStep === 4 && /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsx(CardTitle, { children: "Investigador Principal" }),
              /* @__PURE__ */ jsxs(Button, { type: "button", onClick: agregarInvestigadorPrincipal, disabled: !formInvestigadorPrincipal.nombre?.trim(), children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: PlusSignIcon, className: "h-4 w-4 mr-2" }),
                "Agregar"
              ] })
            ] }) }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "ip-nombre", children: "Nombre" }),
                  /* @__PURE__ */ jsx(Input, { id: "ip-nombre", value: formInvestigadorPrincipal.nombre, onChange: (e) => setFormInvestigadorPrincipal({
                    ...formInvestigadorPrincipal,
                    nombre: e.target.value
                  }), placeholder: "Nombre" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "ip-adscripcion", children: "Adscripción" }),
                  /* @__PURE__ */ jsx(Input, { id: "ip-adscripcion", value: formInvestigadorPrincipal.adscripcion, onChange: (e) => setFormInvestigadorPrincipal({
                    ...formInvestigadorPrincipal,
                    adscripcion: e.target.value
                  }), placeholder: "Adscripción" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "ip-funcion", children: "Función" }),
                  /* @__PURE__ */ jsx(Input, { id: "ip-funcion", value: formInvestigadorPrincipal.funcion, onChange: (e) => setFormInvestigadorPrincipal({
                    ...formInvestigadorPrincipal,
                    funcion: e.target.value
                  }), placeholder: "Función" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "ip-correo", children: "Correo Electrónico" }),
                  /* @__PURE__ */ jsx(Input, { id: "ip-correo", type: "email", value: formInvestigadorPrincipal.correo, onChange: (e) => setFormInvestigadorPrincipal({
                    ...formInvestigadorPrincipal,
                    correo: e.target.value
                  }), placeholder: "Correo" })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "ip-extension", children: "Extensión" }),
                  /* @__PURE__ */ jsx(Input, { id: "ip-extension", inputMode: "numeric", maxLength: 4, value: formInvestigadorPrincipal.extension, onChange: (e) => setFormInvestigadorPrincipal({
                    ...formInvestigadorPrincipal,
                    extension: e.target.value.replace(/\D/g, "").slice(0, 4)
                  }), placeholder: "Ext." })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "ip-nivel-estudios", children: "Nivel máximo de estudios" }),
                  /* @__PURE__ */ jsxs(Select, { value: formInvestigadorPrincipal.nivelEstudios || void 0, onValueChange: (v) => setFormInvestigadorPrincipal({
                    ...formInvestigadorPrincipal,
                    nivelEstudios: v
                  }), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "ip-nivel-estudios", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: NIVEL_MAXIMO_ESTUDIOS.map((n) => /* @__PURE__ */ jsx(SelectItem, { value: n.value, children: n.label }, n.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "ip-status-sni", children: "Status en el SNI" }),
                  /* @__PURE__ */ jsxs(Select, { value: formInvestigadorPrincipal.statusSni || void 0, onValueChange: (v) => setFormInvestigadorPrincipal({
                    ...formInvestigadorPrincipal,
                    statusSni: v
                  }), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "ip-status-sni", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: NIVELES.map((n) => /* @__PURE__ */ jsx(SelectItem, { value: n.value, children: n.label }, n.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "flex items-center space-x-3 pt-8", children: [
                  /* @__PURE__ */ jsx(Switch, { id: "ip-responsable", checked: formInvestigadorPrincipal.esResponsable, onCheckedChange: (v) => setFormInvestigadorPrincipal({
                    ...formInvestigadorPrincipal,
                    esResponsable: v
                  }) }),
                  /* @__PURE__ */ jsx(Label, { htmlFor: "ip-responsable", className: "cursor-pointer font-normal", children: "¿Es Responsable del Proyecto?" })
                ] })
              ] }),
              investigadoresPrincipales.length > 0 && /* @__PURE__ */ jsx("div", { className: "border rounded-lg overflow-hidden", children: /* @__PURE__ */ jsxs("table", { className: "w-full", children: [
                /* @__PURE__ */ jsx("thead", { className: "bg-muted", children: /* @__PURE__ */ jsxs("tr", { children: [
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "No." }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Nombre" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Adscripción" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Función" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 w-16" })
                ] }) }),
                /* @__PURE__ */ jsx("tbody", { className: "divide-y", children: investigadoresPrincipales.map((inv, index) => /* @__PURE__ */ jsxs("tr", { className: "hover:bg-muted/50", children: [
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: index + 1 }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: inv.nombre }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: inv.adscripcion }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: inv.funcion }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3", children: /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: () => eliminarInvestigadorPrincipal(index), children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) }) })
                ] }, index)) })
              ] }) })
            ] })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsx(CardTitle, { children: "Autorización del Departamento para realizar el Estudio" }) }),
            /* @__PURE__ */ jsx(CardContent, { children: /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "aut-depto", children: "Departamento / Coordinación" }),
                  /* @__PURE__ */ jsx(Input, { id: "aut-depto", value: autorizacionDepto.departamentoCoordinacion, onChange: (e) => setAutorizacionDepto({
                    ...autorizacionDepto,
                    departamentoCoordinacion: e.target.value
                  }), placeholder: "Departamento o coordinación" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "aut-resp-depto", children: "Responsable" }),
                  /* @__PURE__ */ jsx(Input, { id: "aut-resp-depto", value: autorizacionDepto.responsableDepto, onChange: (e) => setAutorizacionDepto({
                    ...autorizacionDepto,
                    responsableDepto: e.target.value
                  }), placeholder: "Responsable" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "aut-clave-depto", children: "Clave Área" }),
                  /* @__PURE__ */ jsx(Input, { id: "aut-clave-depto", value: autorizacionDepto.claveAreaDepto, onChange: (e) => setAutorizacionDepto({
                    ...autorizacionDepto,
                    claveAreaDepto: e.target.value
                  }), placeholder: "Clave área" })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "aut-subdir", children: "Subdirección de área" }),
                  /* @__PURE__ */ jsx(Input, { id: "aut-subdir", value: autorizacionDepto.subdireccionArea, onChange: (e) => setAutorizacionDepto({
                    ...autorizacionDepto,
                    subdireccionArea: e.target.value
                  }), placeholder: "Subdirección de área" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "aut-resp-subdir", children: "Responsable" }),
                  /* @__PURE__ */ jsx(Input, { id: "aut-resp-subdir", value: autorizacionDepto.responsableSubdir, onChange: (e) => setAutorizacionDepto({
                    ...autorizacionDepto,
                    responsableSubdir: e.target.value
                  }), placeholder: "Responsable" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "aut-clave-subdir", children: "Clave Área" }),
                  /* @__PURE__ */ jsx(Input, { id: "aut-clave-subdir", value: autorizacionDepto.claveAreaSubdir, onChange: (e) => setAutorizacionDepto({
                    ...autorizacionDepto,
                    claveAreaSubdir: e.target.value
                  }), placeholder: "Clave área" })
                ] })
              ] })
            ] }) })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsx(CardTitle, { children: "Coinvestigadores" }),
              /* @__PURE__ */ jsxs(Button, { type: "button", onClick: agregarCoinvestigador, disabled: !formCoinvestigador.nombre?.trim(), children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: PlusSignIcon, className: "h-4 w-4 mr-2" }),
                "Agregar"
              ] })
            ] }) }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "co-nombre", children: "Nombre" }),
                  /* @__PURE__ */ jsx(Input, { id: "co-nombre", value: formCoinvestigador.nombre, onChange: (e) => setFormCoinvestigador({
                    ...formCoinvestigador,
                    nombre: e.target.value
                  }), placeholder: "Nombre" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "co-adscripcion", children: "Adscripción" }),
                  /* @__PURE__ */ jsx(Input, { id: "co-adscripcion", value: formCoinvestigador.adscripcion, onChange: (e) => setFormCoinvestigador({
                    ...formCoinvestigador,
                    adscripcion: e.target.value
                  }), placeholder: "Adscripción" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "co-funcion", children: "Función" }),
                  /* @__PURE__ */ jsx(Input, { id: "co-funcion", value: formCoinvestigador.funcion, onChange: (e) => setFormCoinvestigador({
                    ...formCoinvestigador,
                    funcion: e.target.value
                  }), placeholder: "Función" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "co-correo", children: "Correo Electrónico" }),
                  /* @__PURE__ */ jsx(Input, { id: "co-correo", type: "email", value: formCoinvestigador.correo, onChange: (e) => setFormCoinvestigador({
                    ...formCoinvestigador,
                    correo: e.target.value
                  }), placeholder: "Correo" })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "co-extension", children: "Extensión" }),
                  /* @__PURE__ */ jsx(Input, { id: "co-extension", inputMode: "numeric", maxLength: 4, value: formCoinvestigador.extension, onChange: (e) => setFormCoinvestigador({
                    ...formCoinvestigador,
                    extension: e.target.value.replace(/\D/g, "").slice(0, 4)
                  }), placeholder: "Ext." })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "co-nivel-estudios", children: "Nivel máximo de estudios" }),
                  /* @__PURE__ */ jsxs(Select, { value: formCoinvestigador.nivelEstudios || void 0, onValueChange: (v) => setFormCoinvestigador({
                    ...formCoinvestigador,
                    nivelEstudios: v
                  }), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "co-nivel-estudios", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: NIVEL_MAXIMO_ESTUDIOS.map((n) => /* @__PURE__ */ jsx(SelectItem, { value: n.value, children: n.label }, n.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "co-status-sni", children: "Status en el SNI" }),
                  /* @__PURE__ */ jsxs(Select, { value: formCoinvestigador.statusSni || void 0, onValueChange: (v) => setFormCoinvestigador({
                    ...formCoinvestigador,
                    statusSni: v
                  }), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "co-status-sni", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: NIVELES.map((n) => /* @__PURE__ */ jsx(SelectItem, { value: n.value, children: n.label }, n.value)) })
                  ] })
                ] })
              ] }),
              coinvestigadores.length > 0 && /* @__PURE__ */ jsx("div", { className: "border rounded-lg overflow-hidden", children: /* @__PURE__ */ jsxs("table", { className: "w-full", children: [
                /* @__PURE__ */ jsx("thead", { className: "bg-muted", children: /* @__PURE__ */ jsxs("tr", { children: [
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "No." }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Nombre" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Adscripción" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Función" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 w-16" })
                ] }) }),
                /* @__PURE__ */ jsx("tbody", { className: "divide-y", children: coinvestigadores.map((co, index) => /* @__PURE__ */ jsxs("tr", { className: "hover:bg-muted/50", children: [
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: index + 1 }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: co.nombre }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: co.adscripcion }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: co.funcion }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3", children: /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: () => eliminarCoinvestigador(index), children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) }) })
                ] }, index)) })
              ] }) })
            ] })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsx(CardTitle, { children: "Departamentos Participantes" }),
              /* @__PURE__ */ jsxs(Button, { type: "button", onClick: agregarDepartamento, disabled: !formDepartamento.area?.trim(), children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: PlusSignIcon, className: "h-4 w-4 mr-2" }),
                "Agregar"
              ] })
            ] }) }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "dp-area", children: "Área" }),
                  /* @__PURE__ */ jsx(Input, { id: "dp-area", value: formDepartamento.area, onChange: (e) => setFormDepartamento({
                    ...formDepartamento,
                    area: e.target.value
                  }), placeholder: "Área" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "dp-responsable", children: "Responsable" }),
                  /* @__PURE__ */ jsx(Input, { id: "dp-responsable", value: formDepartamento.responsable, onChange: (e) => setFormDepartamento({
                    ...formDepartamento,
                    responsable: e.target.value
                  }), placeholder: "Responsable" })
                ] })
              ] }),
              departamentosParticipantes.length > 0 && /* @__PURE__ */ jsx("div", { className: "border rounded-lg overflow-hidden", children: /* @__PURE__ */ jsxs("table", { className: "w-full", children: [
                /* @__PURE__ */ jsx("thead", { className: "bg-muted", children: /* @__PURE__ */ jsxs("tr", { children: [
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Área" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Responsable" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 w-16" })
                ] }) }),
                /* @__PURE__ */ jsx("tbody", { className: "divide-y", children: departamentosParticipantes.map((dp, index) => /* @__PURE__ */ jsxs("tr", { className: "hover:bg-muted/50", children: [
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: dp.area }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: dp.responsable }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3", children: /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: () => eliminarDepartamento(index), children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) }) })
                ] }, index)) })
              ] }) })
            ] })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsx(CardTitle, { children: "Instituciones Participantes" }),
              /* @__PURE__ */ jsxs(Button, { type: "button", onClick: agregarInstitucionParticipante, disabled: !formInstitucion.clues?.trim() || !formInstitucion.nombreInstitucion?.trim(), children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: PlusSignIcon, className: "h-4 w-4 mr-2" }),
                "Agregar"
              ] })
            ] }) }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "inst-clues", children: "CLUES" }),
                  /* @__PURE__ */ jsx(Input, { id: "inst-clues", value: formInstitucion.clues, onChange: (e) => setFormInstitucion({
                    ...formInstitucion,
                    clues: e.target.value
                  }), placeholder: "CLUES" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "inst-nombre", children: "Nombre de la Institución" }),
                  /* @__PURE__ */ jsx(Input, { id: "inst-nombre", value: formInstitucion.nombreInstitucion, onChange: (e) => setFormInstitucion({
                    ...formInstitucion,
                    nombreInstitucion: e.target.value
                  }), placeholder: "Nombre institución" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "inst-participante", children: "Nombre del Participante" }),
                  /* @__PURE__ */ jsx(Input, { id: "inst-participante", value: formInstitucion.nombreParticipante, onChange: (e) => setFormInstitucion({
                    ...formInstitucion,
                    nombreParticipante: e.target.value
                  }), placeholder: "Participante" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "inst-puesto", children: "Puesto" }),
                  /* @__PURE__ */ jsx(Input, { id: "inst-puesto", value: formInstitucion.puesto, onChange: (e) => setFormInstitucion({
                    ...formInstitucion,
                    puesto: e.target.value
                  }), placeholder: "Puesto" })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "inst-convenio", children: "Núm. Convenio" }),
                  /* @__PURE__ */ jsx(Input, { id: "inst-convenio", value: formInstitucion.numConvenio, onChange: (e) => setFormInstitucion({
                    ...formInstitucion,
                    numConvenio: e.target.value
                  }), placeholder: "Núm. Convenio" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "inst-adscripcion", children: "Adscripción" }),
                  /* @__PURE__ */ jsx(Input, { id: "inst-adscripcion", value: formInstitucion.adscripcion, onChange: (e) => setFormInstitucion({
                    ...formInstitucion,
                    adscripcion: e.target.value
                  }), placeholder: "Adscripción" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "inst-telefono", children: "Teléfono" }),
                  /* @__PURE__ */ jsx(Input, { id: "inst-telefono", inputMode: "numeric", maxLength: 10, value: formInstitucion.telefono, onChange: (e) => setFormInstitucion({
                    ...formInstitucion,
                    telefono: e.target.value.replace(/\D/g, "").slice(0, 10)
                  }), placeholder: "Teléfono" })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "inst-correo", children: "Correo" }),
                  /* @__PURE__ */ jsx(Input, { id: "inst-correo", type: "email", value: formInstitucion.correo, onChange: (e) => setFormInstitucion({
                    ...formInstitucion,
                    correo: e.target.value
                  }), placeholder: "Correo" })
                ] })
              ] }),
              institucionesParticipantes.length > 0 && /* @__PURE__ */ jsx("div", { className: "border rounded-lg overflow-hidden", children: /* @__PURE__ */ jsxs("table", { className: "w-full", children: [
                /* @__PURE__ */ jsx("thead", { className: "bg-muted", children: /* @__PURE__ */ jsxs("tr", { children: [
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "No." }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "CLUES" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Institución" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Participante" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Puesto" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 w-16" })
                ] }) }),
                /* @__PURE__ */ jsx("tbody", { className: "divide-y", children: institucionesParticipantes.map((inst, index) => /* @__PURE__ */ jsxs("tr", { className: "hover:bg-muted/50", children: [
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: index + 1 }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: inst.clues }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: inst.nombreInstitucion }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: inst.nombreParticipante }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: inst.puesto }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3", children: /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: () => eliminarInstitucionParticipante(index), children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) }) })
                ] }, index)) })
              ] }) })
            ] })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsx(CardTitle, { children: "Intención didáctica" }) }),
            /* @__PURE__ */ jsx(CardContent, { children: /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "id-especialidad", children: "Especialidad" }),
                /* @__PURE__ */ jsxs(Select, { value: intencionDidactica.especialidad || void 0, onValueChange: (v) => setIntencionDidactica({
                  ...intencionDidactica,
                  especialidad: v
                }), children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "id-especialidad", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: ESPECIALIDADES.map((e) => /* @__PURE__ */ jsx(SelectItem, { value: e.value, children: e.label }, e.value)) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "id-institucion", children: "Institución Académica" }),
                /* @__PURE__ */ jsxs(Select, { value: intencionDidactica.institucionAcademica || void 0, onValueChange: (v) => setIntencionDidactica({
                  ...intencionDidactica,
                  institucionAcademica: v
                }), children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "id-institucion", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: INSTITUCIONES_ACADEMICAS.map((i) => /* @__PURE__ */ jsx(SelectItem, { value: i.value, children: i.label }, i.value)) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "id-director", children: "Director de Enseñanza" }),
                /* @__PURE__ */ jsxs(Select, { value: intencionDidactica.directorEnsenanza || void 0, onValueChange: (v) => setIntencionDidactica({
                  ...intencionDidactica,
                  directorEnsenanza: v
                }), children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "id-director", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: DIRECTORES_ENSENANZA.map((d) => /* @__PURE__ */ jsx(SelectItem, { value: d.value, children: d.label }, d.value)) })
                ] })
              ] })
            ] }) })
          ] })
        ] }),
        currentStep === 5 && /* @__PURE__ */ jsxs(Card, { children: [
          /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsx(CardTitle, { children: "Marco de Referencia del Proyecto" }) }),
          /* @__PURE__ */ jsxs(CardContent, { className: "space-y-6", children: [
            /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                    /* @__PURE__ */ jsx(Label, { htmlFor: "sintesis-proyecto", children: "Síntesis del Proyecto" }),
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: InformationCircleIcon, className: "h-4 w-4 text-muted-foreground" })
                  ] }),
                  /* @__PURE__ */ jsx(Textarea, { id: "sintesis-proyecto", placeholder: "Síntesis del proyecto", rows: 4, className: "resize-y", value: marcoReferencia.sintesisProyecto, onChange: (e) => setMarcoReferencia({
                    ...marcoReferencia,
                    sintesisProyecto: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                    /* @__PURE__ */ jsx(Label, { htmlFor: "planteamiento-problema", children: "Planteamiento del problema y pregunta de investigación" }),
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: InformationCircleIcon, className: "h-4 w-4 text-muted-foreground" })
                  ] }),
                  /* @__PURE__ */ jsx(Textarea, { id: "planteamiento-problema", placeholder: "Planteamiento del problema y pregunta de investigación", rows: 4, className: "resize-y", value: marcoReferencia.planteamientoProblemaPregunta, onChange: (e) => setMarcoReferencia({
                    ...marcoReferencia,
                    planteamientoProblemaPregunta: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                    /* @__PURE__ */ jsx(Label, { htmlFor: "objetivo-general", children: "Objetivo general de la investigación" }),
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: InformationCircleIcon, className: "h-4 w-4 text-muted-foreground" })
                  ] }),
                  /* @__PURE__ */ jsx(Textarea, { id: "objetivo-general", placeholder: "Objetivo general de la investigación", rows: 4, className: "resize-y", value: marcoReferencia.objetivoGeneral, onChange: (e) => setMarcoReferencia({
                    ...marcoReferencia,
                    objetivoGeneral: e.target.value
                  }) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                    /* @__PURE__ */ jsx(Label, { htmlFor: "antecedentes", children: "Antecedentes" }),
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: InformationCircleIcon, className: "h-4 w-4 text-muted-foreground" })
                  ] }),
                  /* @__PURE__ */ jsx(Textarea, { id: "antecedentes", placeholder: "Antecedentes", rows: 4, className: "resize-y", value: marcoReferencia.antecedentes, onChange: (e) => setMarcoReferencia({
                    ...marcoReferencia,
                    antecedentes: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                    /* @__PURE__ */ jsx(Label, { htmlFor: "justificacion-proyecto", children: "Justificación del proyecto" }),
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: InformationCircleIcon, className: "h-4 w-4 text-muted-foreground" })
                  ] }),
                  /* @__PURE__ */ jsx(Textarea, { id: "justificacion-proyecto", placeholder: "Justificación del proyecto", rows: 4, className: "resize-y", value: marcoReferencia.justificacionProyecto, onChange: (e) => setMarcoReferencia({
                    ...marcoReferencia,
                    justificacionProyecto: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                    /* @__PURE__ */ jsx(Label, { htmlFor: "objetivo-especifico", children: "Objetivo específico" }),
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: InformationCircleIcon, className: "h-4 w-4 text-muted-foreground" })
                  ] }),
                  /* @__PURE__ */ jsx(Textarea, { id: "objetivo-especifico", placeholder: "Objetivo específico", rows: 4, className: "resize-y", value: marcoReferencia.objetivoEspecifico, onChange: (e) => setMarcoReferencia({
                    ...marcoReferencia,
                    objetivoEspecifico: e.target.value
                  }) })
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsx("div", { className: "flex justify-center pt-4", children: /* @__PURE__ */ jsxs(Dialog, { open: isDialogOpenMarcoRef, onOpenChange: setIsDialogOpenMarcoRef, children: [
              /* @__PURE__ */ jsx(DialogTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(Button, { variant: "outline", size: "lg", children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Upload01Icon, className: "h-4 w-4 mr-2" }),
                archivoMarcoReferencia || archivoMarcoReferenciaGuardado ? "Cambiar archivo" : "Subir archivo"
              ] }) }),
              /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-md", children: [
                /* @__PURE__ */ jsxs(DialogHeader, { children: [
                  /* @__PURE__ */ jsx(DialogTitle, { children: "Subir archivo" }),
                  /* @__PURE__ */ jsx(DialogDescription, { children: "Arrastre y suelte el archivo o haga clic para seleccionar" })
                ] }),
                /* @__PURE__ */ jsxs("div", { onDragOver: handleDragOverMarcoRef, onDragLeave: handleDragLeaveMarcoRef, onDrop: handleDropMarcoRef, className: `
                              border-2 border-dashed rounded-lg p-8 text-center cursor-pointer transition-colors
                              ${isDraggingMarcoRef ? "border-primary bg-primary/5" : "border-muted-foreground/25 hover:border-primary/50"}
                            `, onClick: () => fileInputRefMarcoRef.current?.click(), children: [
                  /* @__PURE__ */ jsx("input", { ref: fileInputRefMarcoRef, type: "file", className: "hidden", onChange: handleFileChangeMarcoRef, accept: ".pdf,application/pdf" }),
                  /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-12 w-12 mx-auto mb-4 text-muted-foreground" }),
                  /* @__PURE__ */ jsx("p", { className: "text-sm text-muted-foreground mb-2", children: "Arrastre y suelte aquí los archivos" }),
                  /* @__PURE__ */ jsx("p", { className: "text-xs text-muted-foreground mb-4", children: "(o haga clic para seleccionar archivo)" }),
                  /* @__PURE__ */ jsx(Button, { type: "button", variant: "secondary", size: "sm", children: "Seleccionar archivo" })
                ] })
              ] })
            ] }) }),
            archivoMarcoReferencia && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-3 bg-muted rounded-lg", children: [
              /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-4 w-4 text-primary" }),
                /* @__PURE__ */ jsx("span", { className: "text-sm font-medium", children: archivoMarcoReferencia.name }),
                /* @__PURE__ */ jsxs(Badge, { variant: "secondary", children: [
                  (archivoMarcoReferencia.size / 1024).toFixed(2),
                  " KB"
                ] })
              ] }),
              /* @__PURE__ */ jsx(Button, { variant: "ghost", size: "sm", onClick: removeFileMarcoRef, children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) })
            ] }),
            !archivoMarcoReferencia && archivoMarcoReferenciaGuardado && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-3 bg-muted rounded-lg", children: [
              /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-4 w-4 text-primary" }),
                /* @__PURE__ */ jsx("span", { className: "text-sm font-medium", children: archivoMarcoReferenciaGuardado.nombre_original }),
                /* @__PURE__ */ jsx(Badge, { variant: "secondary", children: "Guardado" })
              ] }),
              proyectoId != null && /* @__PURE__ */ jsx(Button, { variant: "outline", size: "sm", className: proyectoEnviado ? "!pointer-events-auto" : void 0, onClick: () => abrirVistaArchivo("marco_referencia", archivoMarcoReferenciaGuardado.nombre_original), children: "Ver archivo" })
            ] })
          ] })
        ] }),
        currentStep === 6 && /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsx("div", { className: "mb-4", children: /* @__PURE__ */ jsx("h2", { className: "text-xl font-semibold", children: "Paso 7: Material y Método" }) }),
          /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 lg:grid-cols-3 gap-6", children: [
            /* @__PURE__ */ jsxs("div", { className: "space-y-4", children: [
              /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsx(CardContent, { className: "pt-6", children: /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "mat-tipo-investigacion", children: "Tipo de Investigación" }),
                /* @__PURE__ */ jsxs(Select, { value: materialMetodo.tipoInvestigacion || void 0, onValueChange: (v) => setMaterialMetodo({
                  ...materialMetodo,
                  tipoInvestigacion: v
                }), children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "mat-tipo-investigacion", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: TIPOS_INVESTIGACION.map((t) => /* @__PURE__ */ jsx(SelectItem, { value: t.value, children: t.label }, t.value)) })
                ] })
              ] }) }) }),
              /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsx(CardContent, { className: "pt-6", children: /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "mat-tipo-diseno", children: "Tipo de Diseño" }),
                /* @__PURE__ */ jsxs(Select, { value: materialMetodo.tipoDiseno || void 0, onValueChange: (v) => setMaterialMetodo({
                  ...materialMetodo,
                  tipoDiseno: v
                }), children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "mat-tipo-diseno", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: TIPOS_DISENO.map((t) => /* @__PURE__ */ jsx(SelectItem, { value: t.value, children: t.label }, t.value)) })
                ] })
              ] }) }) })
            ] }),
            /* @__PURE__ */ jsx("div", { className: "lg:col-span-2", children: /* @__PURE__ */ jsxs(Card, { children: [
              /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsx(CardTitle, { children: "Características del Estudio" }) }),
              /* @__PURE__ */ jsx(CardContent, { children: /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 sm:grid-cols-2 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { children: "Por la participación del investigador" }),
                  /* @__PURE__ */ jsxs(Select, { value: materialMetodo.participacionInvestigador || void 0, onValueChange: (v) => setMaterialMetodo({
                    ...materialMetodo,
                    participacionInvestigador: v
                  }), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: PARTICIPACION_INVESTIGADOR.map((p) => /* @__PURE__ */ jsx(SelectItem, { value: p.value, children: p.label }, p.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { children: "Por temporalidad del estudio" }),
                  /* @__PURE__ */ jsxs(Select, { value: materialMetodo.temporalidadEstudio || void 0, onValueChange: (v) => setMaterialMetodo({
                    ...materialMetodo,
                    temporalidadEstudio: v
                  }), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: TEMPORALIDAD_ESTUDIO.map((t) => /* @__PURE__ */ jsx(SelectItem, { value: t.value, children: t.label }, t.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { children: "Por la lectura de datos" }),
                  /* @__PURE__ */ jsxs(Select, { value: materialMetodo.lecturaDatos || void 0, onValueChange: (v) => setMaterialMetodo({
                    ...materialMetodo,
                    lecturaDatos: v
                  }), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: LECTURA_DATOS.map((l) => /* @__PURE__ */ jsx(SelectItem, { value: l.value, children: l.label }, l.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { children: "Por el análisis de datos" }),
                  /* @__PURE__ */ jsxs(Select, { value: materialMetodo.analisisDatos || void 0, onValueChange: (v) => setMaterialMetodo({
                    ...materialMetodo,
                    analisisDatos: v
                  }), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: ANALISIS_DATOS.map((a) => /* @__PURE__ */ jsx(SelectItem, { value: a.value, children: a.label }, a.value)) })
                  ] })
                ] })
              ] }) })
            ] }) })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsx(CardTitle, { children: "Procedimiento" }) }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "proc-universo", children: "Universo o población" }),
                  /* @__PURE__ */ jsx(Textarea, { id: "proc-universo", placeholder: "Universo o población", rows: 3, className: "resize-y", value: procedimiento.universoPoblacion, onChange: (e) => setProcedimiento({
                    ...procedimiento,
                    universoPoblacion: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "proc-muestra", children: "Tamaño de la muestra" }),
                  /* @__PURE__ */ jsx(Textarea, { id: "proc-muestra", placeholder: "Tamaño de la muestra", rows: 3, className: "resize-y", value: procedimiento.tamanoMuestra, onChange: (e) => setProcedimiento({
                    ...procedimiento,
                    tamanoMuestra: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "proc-unidades", children: "Def. Unidades de observación" }),
                  /* @__PURE__ */ jsx(Textarea, { id: "proc-unidades", placeholder: "Definición de unidades de observación", rows: 3, className: "resize-y", value: procedimiento.defUnidadesObservacion, onChange: (e) => setProcedimiento({
                    ...procedimiento,
                    defUnidadesObservacion: e.target.value
                  }) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "proc-control", children: "Def. del grupo control" }),
                  /* @__PURE__ */ jsx(Textarea, { id: "proc-control", placeholder: "Definición del grupo control", rows: 3, className: "resize-y", value: procedimiento.defGrupoControl, onChange: (e) => setProcedimiento({
                    ...procedimiento,
                    defGrupoControl: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "proc-inclusion", children: "Criterios de Inclusión" }),
                  /* @__PURE__ */ jsx(Textarea, { id: "proc-inclusion", placeholder: "Criterios de inclusión", rows: 3, className: "resize-y", value: procedimiento.criteriosInclusion, onChange: (e) => setProcedimiento({
                    ...procedimiento,
                    criteriosInclusion: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "proc-exclusion", children: "Criterios de exclusión" }),
                  /* @__PURE__ */ jsx(Textarea, { id: "proc-exclusion", placeholder: "Criterios de exclusión", rows: 3, className: "resize-y", value: procedimiento.criteriosExclusion, onChange: (e) => setProcedimiento({
                    ...procedimiento,
                    criteriosExclusion: e.target.value
                  }) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "proc-eliminacion", children: "Criterios de eliminación" }),
                  /* @__PURE__ */ jsx(Textarea, { id: "proc-eliminacion", placeholder: "Criterios de eliminación", rows: 3, className: "resize-y", value: procedimiento.criteriosEliminacion, onChange: (e) => setProcedimiento({
                    ...procedimiento,
                    criteriosEliminacion: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "proc-variables", children: "Variables de estudio" }),
                  /* @__PURE__ */ jsxs(Select, { value: procedimiento.variablesEstudio || void 0, onValueChange: (v) => setProcedimiento({
                    ...procedimiento,
                    variablesEstudio: v
                  }), children: [
                    /* @__PURE__ */ jsx(SelectTrigger, { id: "proc-variables", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                    /* @__PURE__ */ jsx(SelectContent, { children: VARIABLES_ESTUDIO.map((v) => /* @__PURE__ */ jsx(SelectItem, { value: v.value, children: v.label }, v.value)) })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "proc-piloto", children: "Prueba piloto" }),
                  /* @__PURE__ */ jsx(Textarea, { id: "proc-piloto", placeholder: "Prueba piloto", rows: 3, className: "resize-y", value: procedimiento.pruebaPiloto, onChange: (e) => setProcedimiento({
                    ...procedimiento,
                    pruebaPiloto: e.target.value
                  }) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-4", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { children: "Forma de recolección de datos" }),
                  /* @__PURE__ */ jsxs(Dialog, { open: isDialogOpenRecoleccion, onOpenChange: setIsDialogOpenRecoleccion, children: [
                    /* @__PURE__ */ jsx(DialogTrigger, { asChild: true, children: /* @__PURE__ */ jsxs("div", { role: "button", tabIndex: 0, onKeyDown: (e) => {
                      if (e.key === "Enter" || e.key === " ") {
                        e.preventDefault();
                        setIsDialogOpenRecoleccion(true);
                      }
                    }, className: "border-2 border-dashed rounded-lg p-6 text-center cursor-pointer transition-colors flex flex-col items-center justify-center min-h-[100px] border-muted-foreground/25 hover:border-primary/50", onClick: () => setIsDialogOpenRecoleccion(true), children: [
                      /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Upload01Icon, className: "h-8 w-8 mb-2 text-muted-foreground" }),
                      /* @__PURE__ */ jsx("p", { className: "text-sm text-muted-foreground", children: archivoRecoleccionDatos || archivoRecoleccionDatosGuardado ? "Cambiar archivo" : "Subir archivo" })
                    ] }) }),
                    /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-md", children: [
                      /* @__PURE__ */ jsxs(DialogHeader, { children: [
                        /* @__PURE__ */ jsx(DialogTitle, { children: "Subir archivo de recolección de datos" }),
                        /* @__PURE__ */ jsx(DialogDescription, { children: "Arrastre y suelte el archivo o haga clic para seleccionar" })
                      ] }),
                      /* @__PURE__ */ jsxs("div", { onDragOver: handleDragOverRecoleccion, onDragLeave: handleDragLeaveRecoleccion, onDrop: handleDropRecoleccion, className: `border-2 border-dashed rounded-lg p-6 text-center cursor-pointer transition-colors ${isDraggingRecoleccion ? "border-primary bg-primary/5" : "border-muted-foreground/25 hover:border-primary/50"}`, onClick: () => fileInputRefRecoleccion.current?.click(), children: [
                        /* @__PURE__ */ jsx("input", { ref: fileInputRefRecoleccion, type: "file", className: "hidden", onChange: handleFileChangeRecoleccion, accept: ".pdf,application/pdf" }),
                        /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-10 w-10 mx-auto mb-2 text-muted-foreground" }),
                        /* @__PURE__ */ jsx("p", { className: "text-sm text-muted-foreground", children: "Arrastre el archivo o haga clic" })
                      ] })
                    ] })
                  ] }),
                  archivoRecoleccionDatos && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-2 bg-muted rounded text-sm", children: [
                    /* @__PURE__ */ jsx("span", { children: archivoRecoleccionDatos.name }),
                    /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: removeFileRecoleccion, children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) })
                  ] }),
                  !archivoRecoleccionDatos && archivoRecoleccionDatosGuardado && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-2 bg-muted rounded text-sm", children: [
                    /* @__PURE__ */ jsx("span", { children: archivoRecoleccionDatosGuardado.nombre_original }),
                    /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                      /* @__PURE__ */ jsx(Badge, { variant: "secondary", children: "Guardado" }),
                      proyectoId != null && /* @__PURE__ */ jsx(Button, { type: "button", variant: "outline", size: "sm", className: proyectoEnviado ? "!pointer-events-auto" : void 0, onClick: () => abrirVistaArchivo("recoleccion_datos", archivoRecoleccionDatosGuardado.nombre_original), children: "Ver archivo" })
                    ] })
                  ] })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "proc-material", children: "Material y Métodos" }),
                  /* @__PURE__ */ jsx(Textarea, { id: "proc-material", placeholder: "Material y métodos", rows: 3, className: "resize-y", value: procedimiento.materialMetodos, onChange: (e) => setProcedimiento({
                    ...procedimiento,
                    materialMetodos: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "proc-estadisticos", children: "Análisis Estadísticos" }),
                  /* @__PURE__ */ jsx(Textarea, { id: "proc-estadisticos", placeholder: "Análisis estadísticos", rows: 3, className: "resize-y", value: procedimiento.analisisEstadisticos, onChange: (e) => setProcedimiento({
                    ...procedimiento,
                    analisisEstadisticos: e.target.value
                  }) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "proc-bibliografia", children: "Bibliografía" }),
                /* @__PURE__ */ jsx(Textarea, { id: "proc-bibliografia", placeholder: "Bibliografía", rows: 4, className: "resize-y w-full", value: procedimiento.bibliografia, onChange: (e) => setProcedimiento({
                  ...procedimiento,
                  bibliografia: e.target.value
                }) })
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsxs(CardHeader, { children: [
              /* @__PURE__ */ jsx(CardTitle, { children: "Aspectos éticos" }),
              /* @__PURE__ */ jsx(CardDescription, { children: "De acuerdo al artículo 17 del Reglamento de la Ley General de Salud en Materia de Investigación para la Salud, la participación de los pacientes en este estudio conlleva un tipo de riesgo:" })
            ] }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "max-w-sm space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "etico-riesgo", children: "Tipo de riesgo" }),
                /* @__PURE__ */ jsxs(Select, { value: aspectosEticos.tipoRiesgo || void 0, onValueChange: (v) => setAspectosEticos({
                  ...aspectosEticos,
                  tipoRiesgo: v
                }), children: [
                  /* @__PURE__ */ jsx(SelectTrigger, { id: "etico-riesgo", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Seleccione" }) }),
                  /* @__PURE__ */ jsx(SelectContent, { children: TIPOS_RIESGO.map((r) => /* @__PURE__ */ jsx(SelectItem, { value: r.value, children: r.label }, r.value)) })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-3", children: [
                /* @__PURE__ */ jsx("h4", { className: "font-medium", children: "Explique motivo del riesgo y pruebas de hipótesis" }),
                /* @__PURE__ */ jsx("div", { className: "border rounded-lg overflow-hidden", children: /* @__PURE__ */ jsxs("table", { className: "w-full", children: [
                  /* @__PURE__ */ jsx("thead", { className: "bg-muted", children: /* @__PURE__ */ jsxs("tr", { children: [
                    /* @__PURE__ */ jsx("th", { className: "px-3 py-2 text-left text-sm font-medium", children: "Objetivo" }),
                    /* @__PURE__ */ jsx("th", { className: "px-3 py-2 text-left text-sm font-medium", children: "Descripción" }),
                    /* @__PURE__ */ jsx("th", { className: "px-3 py-2 text-left text-sm font-medium", children: "Prueba" }),
                    /* @__PURE__ */ jsx("th", { className: "px-3 py-2 text-left text-sm font-medium", children: "Resultado esperado" }),
                    /* @__PURE__ */ jsx("th", { className: "w-10 px-2 py-2" })
                  ] }) }),
                  /* @__PURE__ */ jsx("tbody", { className: "divide-y", children: filasRiesgoHipotesis.map((fila, index) => /* @__PURE__ */ jsxs("tr", { className: "hover:bg-muted/30", children: [
                    /* @__PURE__ */ jsx("td", { className: "p-2 align-top", children: /* @__PURE__ */ jsx(Textarea, { placeholder: "Objetivo", rows: 2, className: "resize-y min-h-[60px] border-0 focus-visible:ring-0 bg-transparent", value: fila.objetivo, onChange: (e) => actualizarFilaRiesgoHipotesis(index, "objetivo", e.target.value) }) }),
                    /* @__PURE__ */ jsx("td", { className: "p-2 align-top", children: /* @__PURE__ */ jsx(Textarea, { placeholder: "Descripción", rows: 2, className: "resize-y min-h-[60px] border-0 focus-visible:ring-0 bg-transparent", value: fila.descripcion, onChange: (e) => actualizarFilaRiesgoHipotesis(index, "descripcion", e.target.value) }) }),
                    /* @__PURE__ */ jsx("td", { className: "p-2 align-top", children: /* @__PURE__ */ jsx(Textarea, { placeholder: "Prueba", rows: 2, className: "resize-y min-h-[60px] border-0 focus-visible:ring-0 bg-transparent", value: fila.prueba, onChange: (e) => actualizarFilaRiesgoHipotesis(index, "prueba", e.target.value) }) }),
                    /* @__PURE__ */ jsx("td", { className: "p-2 align-top", children: /* @__PURE__ */ jsx(Textarea, { placeholder: "Resultado esperado", rows: 2, className: "resize-y min-h-[60px] border-0 focus-visible:ring-0 bg-transparent", value: fila.resultadoEsperado, onChange: (e) => actualizarFilaRiesgoHipotesis(index, "resultadoEsperado", e.target.value) }) }),
                    /* @__PURE__ */ jsx("td", { className: "p-2 align-top", children: /* @__PURE__ */ jsxs("div", { className: "flex gap-1", children: [
                      /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: () => agregarFilaRiesgoHipotesis(), title: "Agregar fila", children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: PlusSignIcon, className: "h-4 w-4" }) }),
                      /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: () => eliminarFilaRiesgoHipotesis(index), disabled: filasRiesgoHipotesis.length <= 1, title: "Eliminar fila", children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) })
                    ] }) })
                  ] }, index)) })
                ] }) })
              ] })
            ] })
          ] })
        ] }),
        currentStep === 7 && /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsx(CardTitle, { children: "Recursos Humanos requeridos por el proyecto" }) }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-5 gap-4 items-end", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "nombramiento-rol", children: "Nombamiento Rol en el Proyecto" }),
                  /* @__PURE__ */ jsx(Input, { id: "nombramiento-rol", placeholder: "Rol en el proyecto", value: formRecursoHumano.nombramientoRol, onChange: (e) => setFormRecursoHumano({
                    ...formRecursoHumano,
                    nombramientoRol: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "grado-academico-rh", children: "Grado Académico" }),
                  /* @__PURE__ */ jsx(Input, { id: "grado-academico-rh", placeholder: "Grado académico", value: formRecursoHumano.gradoAcademico, onChange: (e) => setFormRecursoHumano({
                    ...formRecursoHumano,
                    gradoAcademico: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "horas-mes", children: "Horas/mes" }),
                  /* @__PURE__ */ jsx(Input, { id: "horas-mes", placeholder: "Horas/mes", inputMode: "numeric", value: formRecursoHumano.horasMes, onChange: (e) => setFormRecursoHumano({
                    ...formRecursoHumano,
                    horasMes: sanitizeOnlyNumbers(e.target.value)
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "funciones-rh", children: "Funciones" }),
                  /* @__PURE__ */ jsx(Input, { id: "funciones-rh", placeholder: "Funciones", value: formRecursoHumano.funciones, onChange: (e) => setFormRecursoHumano({
                    ...formRecursoHumano,
                    funciones: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "centro-adscripcion", children: "Centro Adscripción" }),
                  /* @__PURE__ */ jsx(Input, { id: "centro-adscripcion", placeholder: "Centro de adscripción", value: formRecursoHumano.centroAdscripcion, onChange: (e) => setFormRecursoHumano({
                    ...formRecursoHumano,
                    centroAdscripcion: e.target.value
                  }) })
                ] })
              ] }),
              /* @__PURE__ */ jsx("div", { className: "flex justify-end", children: /* @__PURE__ */ jsxs(Button, { type: "button", onClick: agregarRecursoHumano, children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: PlusSignIcon, className: "h-4 w-4 mr-2" }),
                "Agregar"
              ] }) }),
              recursosHumanos.length > 0 && /* @__PURE__ */ jsx("div", { className: "border rounded-lg overflow-hidden", children: /* @__PURE__ */ jsxs("table", { className: "w-full", children: [
                /* @__PURE__ */ jsx("thead", { className: "bg-muted", children: /* @__PURE__ */ jsxs("tr", { children: [
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "csc" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Nombamiento Rol en el Proyecto" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Grado Académico" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Horas/mes" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium w-16" })
                ] }) }),
                /* @__PURE__ */ jsx("tbody", { className: "divide-y", children: recursosHumanos.map((rh, index) => /* @__PURE__ */ jsxs("tr", { className: "hover:bg-muted/50", children: [
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: index + 1 }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: rh.nombramientoRol || "-" }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: rh.gradoAcademico || "-" }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: rh.horasMes || "-" }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: () => eliminarRecursoHumano(index), children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) }) })
                ] }, index)) })
              ] }) })
            ] })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsx(CardTitle, { children: "Recursos materiales, servicios y/o equipo" }) }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
              /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-5 gap-4 items-end", children: [
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "articulo-servicio", children: "Artículo y/o Servicio" }),
                  /* @__PURE__ */ jsx(Input, { id: "articulo-servicio", placeholder: "Artículo o servicio", value: formRecursoMaterial.articuloServicio, onChange: (e) => setFormRecursoMaterial({
                    ...formRecursoMaterial,
                    articuloServicio: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "tipo-gasto", children: "Tipo de Gasto" }),
                  /* @__PURE__ */ jsx(Input, { id: "tipo-gasto", placeholder: "Tipo de gasto", value: formRecursoMaterial.tipoGasto, onChange: (e) => setFormRecursoMaterial({
                    ...formRecursoMaterial,
                    tipoGasto: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "descripcion-rm", children: "Descripción" }),
                  /* @__PURE__ */ jsx(Input, { id: "descripcion-rm", placeholder: "Descripción", value: formRecursoMaterial.descripcion, onChange: (e) => setFormRecursoMaterial({
                    ...formRecursoMaterial,
                    descripcion: e.target.value
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "cantidad-rm", children: "Cantidad" }),
                  /* @__PURE__ */ jsx(Input, { id: "cantidad-rm", placeholder: "Cantidad", inputMode: "numeric", value: formRecursoMaterial.cantidad, onChange: (e) => setFormRecursoMaterial({
                    ...formRecursoMaterial,
                    cantidad: sanitizeOnlyNumbers(e.target.value)
                  }) })
                ] }),
                /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                  /* @__PURE__ */ jsx(Label, { htmlFor: "observaciones-rm", children: "Observaciones" }),
                  /* @__PURE__ */ jsx(Input, { id: "observaciones-rm", placeholder: "Observaciones", value: formRecursoMaterial.observaciones, onChange: (e) => setFormRecursoMaterial({
                    ...formRecursoMaterial,
                    observaciones: e.target.value
                  }) })
                ] })
              ] }),
              /* @__PURE__ */ jsx("div", { className: "flex justify-end", children: /* @__PURE__ */ jsxs(Button, { type: "button", onClick: agregarRecursoMaterial, children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: PlusSignIcon, className: "h-4 w-4 mr-2" }),
                "Agregar"
              ] }) }),
              recursosMateriales.length > 0 && /* @__PURE__ */ jsx("div", { className: "border rounded-lg overflow-hidden", children: /* @__PURE__ */ jsxs("table", { className: "w-full", children: [
                /* @__PURE__ */ jsx("thead", { className: "bg-muted", children: /* @__PURE__ */ jsxs("tr", { children: [
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "csc" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Artículo y/o Servicio" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Tipo de Gasto" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Descripción" }),
                  /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium w-16" })
                ] }) }),
                /* @__PURE__ */ jsx("tbody", { className: "divide-y", children: recursosMateriales.map((rm, index) => /* @__PURE__ */ jsxs("tr", { className: "hover:bg-muted/50", children: [
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: index + 1 }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: rm.articuloServicio || "-" }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: rm.tipoGasto || "-" }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: rm.descripcion || "-" }),
                  /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: () => eliminarRecursoMaterial(index), children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) }) })
                ] }, index)) })
              ] }) })
            ] })
          ] }),
          /* @__PURE__ */ jsxs(Card, { children: [
            /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsx(CardTitle, { children: "Fuentes de financiamiento y programación de gasto del proyecto" }) }),
            /* @__PURE__ */ jsxs(CardContent, { className: "space-y-6", children: [
              /* @__PURE__ */ jsxs("div", { className: "space-y-4", children: [
                /* @__PURE__ */ jsx("h4", { className: "text-sm font-medium", children: "a) Ingresos Tipo de Subsidios" }),
                /* @__PURE__ */ jsxs("div", { className: "grid grid-cols-1 md:grid-cols-5 gap-4 items-end", children: [
                  /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                    /* @__PURE__ */ jsx(Label, { htmlFor: "subsidio-institucion", children: "Institución" }),
                    /* @__PURE__ */ jsx(Input, { id: "subsidio-institucion", placeholder: "Institución", value: formSubsidio.institucion, onChange: (e) => setFormSubsidio({
                      ...formSubsidio,
                      institucion: e.target.value
                    }) })
                  ] }),
                  /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                    /* @__PURE__ */ jsx(Label, { htmlFor: "nombre-convocatoria", children: "Nombre de Convocatoria" }),
                    /* @__PURE__ */ jsx(Input, { id: "nombre-convocatoria", placeholder: "Convocatoria, Comité, Programa o Instancia", value: formSubsidio.nombreConvocatoria, onChange: (e) => setFormSubsidio({
                      ...formSubsidio,
                      nombreConvocatoria: e.target.value
                    }) })
                  ] }),
                  /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                    /* @__PURE__ */ jsx(Label, { htmlFor: "subsidio-interno", children: "Subsidio Interno ($MN)" }),
                    /* @__PURE__ */ jsx(Input, { id: "subsidio-interno", placeholder: "0", inputMode: "numeric", value: formSubsidio.subsidioInterno, onChange: (e) => setFormSubsidio({
                      ...formSubsidio,
                      subsidioInterno: sanitizeOnlyNumbers(e.target.value)
                    }) })
                  ] }),
                  /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                    /* @__PURE__ */ jsx(Label, { htmlFor: "subsidio-externo", children: "Subsidio Externo ($MN)" }),
                    /* @__PURE__ */ jsx(Input, { id: "subsidio-externo", placeholder: "0", inputMode: "numeric", value: formSubsidio.subsidioExterno, onChange: (e) => setFormSubsidio({
                      ...formSubsidio,
                      subsidioExterno: sanitizeOnlyNumbers(e.target.value)
                    }) })
                  ] }),
                  /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                    /* @__PURE__ */ jsx(Label, { children: "Total" }),
                    /* @__PURE__ */ jsx(Input, { readOnly: true, className: "bg-muted", value: totalSubsidio(formSubsidio), placeholder: "Total" })
                  ] })
                ] }),
                /* @__PURE__ */ jsx("div", { className: "flex justify-end", children: /* @__PURE__ */ jsxs(Button, { type: "button", onClick: agregarSubsidio, children: [
                  /* @__PURE__ */ jsx(HugeiconsIcon, { icon: PlusSignIcon, className: "h-4 w-4 mr-2" }),
                  "Agregar"
                ] }) }),
                subsidios.length > 0 && /* @__PURE__ */ jsx("div", { className: "border rounded-lg overflow-hidden", children: /* @__PURE__ */ jsxs("table", { className: "w-full", children: [
                  /* @__PURE__ */ jsx("thead", { className: "bg-muted", children: /* @__PURE__ */ jsxs("tr", { children: [
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "csc" }),
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Institución" }),
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Nombre de Convocatoria, Comité, Programa o Instancia de Autorización" }),
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Subsidio Interno ($MN)" }),
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Subsidio Externo ($MN)" }),
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium", children: "Total" }),
                    /* @__PURE__ */ jsx("th", { className: "px-4 py-3 text-left text-sm font-medium w-16" })
                  ] }) }),
                  /* @__PURE__ */ jsx("tbody", { className: "divide-y", children: subsidios.map((s, index) => /* @__PURE__ */ jsxs("tr", { className: "hover:bg-muted/50", children: [
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: index + 1 }),
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: s.institucion || "-" }),
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: s.nombreConvocatoria || "-" }),
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: s.subsidioInterno || "-" }),
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: s.subsidioExterno || "-" }),
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: totalSubsidio(s) }),
                    /* @__PURE__ */ jsx("td", { className: "px-4 py-3 text-sm", children: /* @__PURE__ */ jsx(Button, { type: "button", variant: "ghost", size: "sm", onClick: () => eliminarSubsidio(index), children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) }) })
                  ] }, index)) })
                ] }) })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { children: "b) Programa de Gasto (Desglose Financiero y Calendario de gastos)" }),
                /* @__PURE__ */ jsxs(Dialog, { open: isDialogOpenProgramaGasto, onOpenChange: setIsDialogOpenProgramaGasto, children: [
                  /* @__PURE__ */ jsx(DialogTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(Button, { variant: "outline", size: "sm", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Upload01Icon, className: "h-4 w-4 mr-2" }),
                    archivoProgramaGasto || archivoProgramaGastoGuardado ? "Cambiar archivo" : "Subir archivo"
                  ] }) }),
                  /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-md", children: [
                    /* @__PURE__ */ jsxs(DialogHeader, { children: [
                      /* @__PURE__ */ jsx(DialogTitle, { children: "Subir Programa de Gasto" }),
                      /* @__PURE__ */ jsx(DialogDescription, { children: "Arrastre y suelte el archivo o haga clic para seleccionar" })
                    ] }),
                    /* @__PURE__ */ jsxs("div", { onDragOver: handleDragOverProgramaGasto, onDragLeave: handleDragLeaveProgramaGasto, onDrop: handleDropProgramaGasto, className: `border-2 border-dashed rounded-lg p-8 text-center cursor-pointer transition-colors ${isDraggingProgramaGasto ? "border-primary bg-primary/5" : "border-muted-foreground/25 hover:border-primary/50"}`, onClick: () => fileInputRefProgramaGasto.current?.click(), children: [
                      /* @__PURE__ */ jsx("input", { ref: fileInputRefProgramaGasto, type: "file", className: "hidden", onChange: handleFileChangeProgramaGasto, accept: ".pdf,application/pdf" }),
                      /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-12 w-12 mx-auto mb-4 text-muted-foreground" }),
                      /* @__PURE__ */ jsx("p", { className: "text-sm text-muted-foreground mb-2", children: "Arrastre y suelte aquí los archivos" }),
                      /* @__PURE__ */ jsx(Button, { type: "button", variant: "secondary", size: "sm", children: "Seleccionar archivo" })
                    ] })
                  ] })
                ] }),
                archivoProgramaGasto && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-3 bg-muted rounded-lg mt-2", children: [
                  /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-4 w-4 text-primary" }),
                    /* @__PURE__ */ jsx("span", { className: "text-sm font-medium", children: archivoProgramaGasto.name }),
                    /* @__PURE__ */ jsxs(Badge, { variant: "secondary", children: [
                      (archivoProgramaGasto.size / 1024).toFixed(2),
                      " KB"
                    ] })
                  ] }),
                  /* @__PURE__ */ jsx(Button, { variant: "ghost", size: "sm", onClick: removeFileProgramaGasto, children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) })
                ] }),
                !archivoProgramaGasto && archivoProgramaGastoGuardado && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-3 bg-muted rounded-lg mt-2", children: [
                  /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-4 w-4 text-primary" }),
                    /* @__PURE__ */ jsx("span", { className: "text-sm font-medium", children: archivoProgramaGastoGuardado.nombre_original }),
                    /* @__PURE__ */ jsx(Badge, { variant: "secondary", children: "Guardado" })
                  ] }),
                  proyectoId != null && /* @__PURE__ */ jsx(Button, { variant: "outline", size: "sm", className: proyectoEnviado ? "!pointer-events-auto" : void 0, onClick: () => abrirVistaArchivo("programa_gasto", archivoProgramaGastoGuardado.nombre_original), children: "Ver archivo" })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { children: "c) Cronograma de Actividades" }),
                /* @__PURE__ */ jsxs(Dialog, { open: isDialogOpenCronograma, onOpenChange: setIsDialogOpenCronograma, children: [
                  /* @__PURE__ */ jsx(DialogTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(Button, { variant: "outline", size: "sm", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Upload01Icon, className: "h-4 w-4 mr-2" }),
                    archivoCronograma || archivoCronogramaGuardado ? "Cambiar archivo" : "Subir archivo"
                  ] }) }),
                  /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-md", children: [
                    /* @__PURE__ */ jsxs(DialogHeader, { children: [
                      /* @__PURE__ */ jsx(DialogTitle, { children: "Subir Cronograma de Actividades" }),
                      /* @__PURE__ */ jsx(DialogDescription, { children: "Arrastre y suelte el archivo o haga clic para seleccionar" })
                    ] }),
                    /* @__PURE__ */ jsxs("div", { onDragOver: handleDragOverCronograma, onDragLeave: handleDragLeaveCronograma, onDrop: handleDropCronograma, className: `border-2 border-dashed rounded-lg p-8 text-center cursor-pointer transition-colors ${isDraggingCronograma ? "border-primary bg-primary/5" : "border-muted-foreground/25 hover:border-primary/50"}`, onClick: () => fileInputRefCronograma.current?.click(), children: [
                      /* @__PURE__ */ jsx("input", { ref: fileInputRefCronograma, type: "file", className: "hidden", onChange: handleFileChangeCronograma, accept: ".pdf,application/pdf" }),
                      /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-12 w-12 mx-auto mb-4 text-muted-foreground" }),
                      /* @__PURE__ */ jsx("p", { className: "text-sm text-muted-foreground mb-2", children: "Arrastre y suelte aquí los archivos" }),
                      /* @__PURE__ */ jsx(Button, { type: "button", variant: "secondary", size: "sm", children: "Seleccionar archivo" })
                    ] })
                  ] })
                ] }),
                archivoCronograma && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-3 bg-muted rounded-lg mt-2", children: [
                  /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-4 w-4 text-primary" }),
                    /* @__PURE__ */ jsx("span", { className: "text-sm font-medium", children: archivoCronograma.name }),
                    /* @__PURE__ */ jsxs(Badge, { variant: "secondary", children: [
                      (archivoCronograma.size / 1024).toFixed(2),
                      " KB"
                    ] })
                  ] }),
                  /* @__PURE__ */ jsx(Button, { variant: "ghost", size: "sm", onClick: removeFileCronograma, children: /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Cancel01Icon, className: "h-4 w-4" }) })
                ] }),
                !archivoCronograma && archivoCronogramaGuardado && /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between p-3 bg-muted rounded-lg mt-2", children: [
                  /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                    /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-4 w-4 text-primary" }),
                    /* @__PURE__ */ jsx("span", { className: "text-sm font-medium", children: archivoCronogramaGuardado.nombre_original }),
                    /* @__PURE__ */ jsx(Badge, { variant: "secondary", children: "Guardado" })
                  ] }),
                  proyectoId != null && /* @__PURE__ */ jsx(Button, { variant: "outline", size: "sm", className: proyectoEnviado ? "!pointer-events-auto" : void 0, onClick: () => abrirVistaArchivo("cronograma", archivoCronogramaGuardado.nombre_original), children: "Ver archivo" })
                ] })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
                /* @__PURE__ */ jsx(Label, { htmlFor: "productos-compromiso", children: "d) Productos a los que se compromete con este proyecto" }),
                /* @__PURE__ */ jsx(Textarea, { id: "productos-compromiso", placeholder: "Describa los productos o entregables del proyecto", rows: 5, className: "resize-y", value: productosCompromiso, onChange: (e) => setProductosCompromiso(e.target.value) })
              ] })
            ] })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "sticky bottom-0 py-4 bg-muted -mx-8 px-8 flex justify-between z-10 mt-8", children: [
        /* @__PURE__ */ jsxs(Button, { variant: "outline", onClick: prevStep, disabled: currentStep === 0, children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ArrowLeft01Icon, className: "h-4 w-4 mr-2" }),
          "Anterior"
        ] }),
        /* @__PURE__ */ jsx("div", { className: "flex gap-2", children: currentStep < steps.length - 1 ? /* @__PURE__ */ jsxs(Button, { onClick: nextStep, disabled: guardandoPaso || !pasoActualCompleto && !proyectoEnviado, children: [
          guardandoPaso ? "Guardando…" : "Siguiente",
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ArrowRight01Icon, className: "h-4 w-4 ml-2" })
        ] }) : /* @__PURE__ */ jsxs(Button, { onClick: () => void enviarSolicitud(), disabled: guardandoPaso || proyectoEnviado, children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-4 w-4 mr-2" }),
          proyectoEnviado ? "Solicitud enviada" : guardandoPaso ? "Enviando…" : "Enviar Solicitud"
        ] }) })
      ] }),
      errorGuardado && /* @__PURE__ */ jsx("p", { className: "mt-2 text-sm text-destructive", children: errorGuardado })
    ] }),
    /* @__PURE__ */ jsx(Dialog, { open: subiendoArchivoPaso0, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm [&>button]:hidden", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-5 w-5 text-primary" }),
          "Subiendo archivo"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "Estamos guardando tu archivo, espera un momento." })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3 py-2 text-sm text-muted-foreground", children: [
        /* @__PURE__ */ jsx("span", { className: "inline-block h-4 w-4 rounded-full border-2 border-primary border-t-transparent animate-spin" }),
        "Cargando..."
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
        /* @__PURE__ */ jsx(Progress, { value: progresoArchivoPaso0 }),
        /* @__PURE__ */ jsxs("p", { className: "text-xs text-muted-foreground text-right", children: [
          progresoArchivoPaso0,
          "%"
        ] })
      ] })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: subiendoArchivoPaso1, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm [&>button]:hidden", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-5 w-5 text-primary" }),
          "Subiendo archivo"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "Estamos guardando la carta de colaboración, espera un momento." })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3 py-2 text-sm text-muted-foreground", children: [
        /* @__PURE__ */ jsx("span", { className: "inline-block h-4 w-4 rounded-full border-2 border-primary border-t-transparent animate-spin" }),
        "Cargando..."
      ] })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: subiendoArchivoPaso5, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm [&>button]:hidden", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-5 w-5 text-primary" }),
          "Subiendo archivo"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "Estamos guardando el marco de referencia, espera un momento." })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3 py-2 text-sm text-muted-foreground", children: [
        /* @__PURE__ */ jsx("span", { className: "inline-block h-4 w-4 rounded-full border-2 border-primary border-t-transparent animate-spin" }),
        "Cargando..."
      ] })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: subiendoArchivoPaso6, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm [&>button]:hidden", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-5 w-5 text-primary" }),
          "Subiendo archivo"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "Estamos guardando el archivo de recolección de datos, espera un momento." })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3 py-2 text-sm text-muted-foreground", children: [
        /* @__PURE__ */ jsx("span", { className: "inline-block h-4 w-4 rounded-full border-2 border-primary border-t-transparent animate-spin" }),
        "Cargando..."
      ] })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: subiendoArchivoPaso7Programa, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm [&>button]:hidden", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-5 w-5 text-primary" }),
          "Subiendo archivo"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "Estamos guardando el programa de gasto, espera un momento." })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3 py-2 text-sm text-muted-foreground", children: [
        /* @__PURE__ */ jsx("span", { className: "inline-block h-4 w-4 rounded-full border-2 border-primary border-t-transparent animate-spin" }),
        "Cargando..."
      ] })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: subiendoArchivoPaso7Cronograma, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm [&>button]:hidden", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileUploadIcon, className: "h-5 w-5 text-primary" }),
          "Subiendo archivo"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "Estamos guardando el cronograma, espera un momento." })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3 py-2 text-sm text-muted-foreground", children: [
        /* @__PURE__ */ jsx("span", { className: "inline-block h-4 w-4 rounded-full border-2 border-primary border-t-transparent animate-spin" }),
        "Cargando..."
      ] })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: popupArchivoSubidoPaso0, onOpenChange: setPopupArchivoSubidoPaso0, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-5 w-5 text-green-600" }),
          "Archivo subido"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "El archivo se subió correctamente." })
      ] }),
      /* @__PURE__ */ jsx(Progress, { value: 100 }),
      /* @__PURE__ */ jsx("div", { className: "flex justify-end", children: /* @__PURE__ */ jsx(Button, { type: "button", onClick: () => {
        setPopupArchivoSubidoPaso0(false);
        setProgresoArchivoPaso0(0);
      }, children: "Entendido" }) })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: popupArchivoSubidoPaso1, onOpenChange: setPopupArchivoSubidoPaso1, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-5 w-5 text-green-600" }),
          "Archivo subido"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "La carta de colaboración se subió correctamente." })
      ] }),
      /* @__PURE__ */ jsx(Progress, { value: 100 }),
      /* @__PURE__ */ jsx("div", { className: "flex justify-end", children: /* @__PURE__ */ jsx(Button, { type: "button", onClick: () => setPopupArchivoSubidoPaso1(false), children: "Entendido" }) })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: popupArchivoSubidoPaso5, onOpenChange: setPopupArchivoSubidoPaso5, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-5 w-5 text-green-600" }),
          "Archivo subido"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "El marco de referencia se subió correctamente." })
      ] }),
      /* @__PURE__ */ jsx(Progress, { value: 100 }),
      /* @__PURE__ */ jsx("div", { className: "flex justify-end", children: /* @__PURE__ */ jsx(Button, { type: "button", onClick: () => setPopupArchivoSubidoPaso5(false), children: "Entendido" }) })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: popupArchivoSubidoPaso6, onOpenChange: setPopupArchivoSubidoPaso6, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-5 w-5 text-green-600" }),
          "Archivo subido"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "El archivo de recolección de datos se subió correctamente." })
      ] }),
      /* @__PURE__ */ jsx(Progress, { value: 100 }),
      /* @__PURE__ */ jsx("div", { className: "flex justify-end", children: /* @__PURE__ */ jsx(Button, { type: "button", onClick: () => setPopupArchivoSubidoPaso6(false), children: "Entendido" }) })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: popupArchivoSubidoPaso7Programa, onOpenChange: setPopupArchivoSubidoPaso7Programa, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-5 w-5 text-green-600" }),
          "Archivo subido"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "El programa de gasto se subió correctamente." })
      ] }),
      /* @__PURE__ */ jsx(Progress, { value: 100 }),
      /* @__PURE__ */ jsx("div", { className: "flex justify-end", children: /* @__PURE__ */ jsx(Button, { type: "button", onClick: () => setPopupArchivoSubidoPaso7Programa(false), children: "Entendido" }) })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: popupArchivoSubidoPaso7Cronograma, onOpenChange: setPopupArchivoSubidoPaso7Cronograma, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-5 w-5 text-green-600" }),
          "Archivo subido"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "El cronograma se subió correctamente." })
      ] }),
      /* @__PURE__ */ jsx(Progress, { value: 100 }),
      /* @__PURE__ */ jsx("div", { className: "flex justify-end", children: /* @__PURE__ */ jsx(Button, { type: "button", onClick: () => setPopupArchivoSubidoPaso7Cronograma(false), children: "Entendido" }) })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: popupSolicitudEnviada, onOpenChange: setPopupSolicitudEnviada, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-sm", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Tick02Icon, className: "h-5 w-5 text-green-600" }),
          "Enviado correctamente"
        ] }),
        /* @__PURE__ */ jsx(DialogDescription, { children: "Tu solicitud se envió correctamente." })
      ] }),
      /* @__PURE__ */ jsx("div", { className: "flex justify-end", children: /* @__PURE__ */ jsx(Button, { type: "button", onClick: () => {
        setPopupSolicitudEnviada(false);
        navigate({
          to: "/inicio"
        });
      }, children: "Entendido" }) })
    ] }) }),
    /* @__PURE__ */ jsx(Dialog, { open: !!archivoVistaPrevia, onOpenChange: (open) => {
      if (!open) setArchivoVistaPrevia(null);
    }, children: /* @__PURE__ */ jsxs(DialogContent, { className: "w-[calc(100vw-1rem)] h-[calc(100vh-1rem)] !max-w-none sm:!max-w-none p-3 gap-3", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsx(DialogTitle, { children: archivoVistaPrevia?.nombre ?? "Archivo PDF" }),
        /* @__PURE__ */ jsx(DialogDescription, { className: "sr-only", children: "Visualizador de PDF" })
      ] }),
      archivoVistaPrevia?.url && /* @__PURE__ */ jsx("div", { className: "h-[calc(100vh-5.5rem)]", children: /* @__PURE__ */ jsx("iframe", { src: `${archivoVistaPrevia.url}#toolbar=1&navpanes=0&scrollbar=1`, title: archivoVistaPrevia.nombre, className: "h-full w-full rounded-md border" }) })
    ] }) })
  ] });
}
export {
  RegistroProyectoPage as component
};
