import { jsx, jsxs } from "react/jsx-runtime";
import { useQuery } from "@tanstack/react-query";
import { u as useRequireAuth } from "./use-require-auth-D-C-TxBR.mjs";
import { b as apiUrl } from "./router-5yTRMCgc.mjs";
import { C as Card, a as CardHeader, b as CardTitle, c as CardDescription, d as CardContent } from "./card-B_lDvuvx.mjs";
import { B as Button } from "./button-Bp95UwA9.mjs";
import { S as Spinner } from "./spinner-jf2ZHWGj.mjs";
import "react";
import "@tanstack/react-router";
import "next-themes";
import "sonner";
import "@hugeicons/react";
import "@hugeicons/core-free-icons";
import "./utils-H80jjgLf.mjs";
import "clsx";
import "tailwind-merge";
import "class-variance-authority";
import "radix-ui";
async function fetchDrizzleUsuarios() {
  const res = await fetch(apiUrl("/api/test/drizzle-usuarios"));
  const data = await res.json();
  if (!res.ok || !data.success) {
    throw new Error(data.error || "Error consultando usuarios con Drizzle");
  }
  return data;
}
function PruebaDrizzlePage() {
  const listo = useRequireAuth();
  const {
    data,
    isLoading,
    isError,
    error,
    refetch,
    isFetching
  } = useQuery({
    queryKey: ["test", "drizzle", "usuarios"],
    queryFn: fetchDrizzleUsuarios,
    enabled: listo
  });
  if (!listo || isLoading) {
    return /* @__PURE__ */ jsx("div", { className: "min-h-screen flex items-center justify-center bg-muted", children: /* @__PURE__ */ jsx(Spinner, { className: "size-8 text-muted-foreground" }) });
  }
  return /* @__PURE__ */ jsx("div", { className: "max-w-6xl mx-auto p-6", children: /* @__PURE__ */ jsxs(Card, { children: [
    /* @__PURE__ */ jsxs(CardHeader, { children: [
      /* @__PURE__ */ jsx(CardTitle, { children: "Prueba Drizzle" }),
      /* @__PURE__ */ jsx(CardDescription, { children: "Endpoint de prueba para listar usuarios desde MySQL usando Drizzle ORM." })
    ] }),
    /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4", children: [
      /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3", children: [
        /* @__PURE__ */ jsx(Button, { onClick: () => void refetch(), disabled: isFetching, children: isFetching ? "Consultando..." : "Refrescar" }),
        /* @__PURE__ */ jsxs("p", { className: "text-sm text-muted-foreground", children: [
          "Total: ",
          data?.total ?? 0
        ] })
      ] }),
      isError && /* @__PURE__ */ jsx("div", { className: "rounded-md border border-destructive/30 bg-destructive/5 p-3 text-sm text-destructive", children: error instanceof Error ? error.message : "Error desconocido" }),
      !isError && /* @__PURE__ */ jsx("div", { className: "overflow-auto rounded-md border", children: /* @__PURE__ */ jsxs("table", { className: "w-full text-sm", children: [
        /* @__PURE__ */ jsx("thead", { className: "bg-muted/50", children: /* @__PURE__ */ jsxs("tr", { children: [
          /* @__PURE__ */ jsx("th", { className: "p-2 text-left", children: "ID" }),
          /* @__PURE__ */ jsx("th", { className: "p-2 text-left", children: "Nombre" }),
          /* @__PURE__ */ jsx("th", { className: "p-2 text-left", children: "Correo" }),
          /* @__PURE__ */ jsx("th", { className: "p-2 text-left", children: "CURP / Identificación" }),
          /* @__PURE__ */ jsx("th", { className: "p-2 text-left", children: "Rol" }),
          /* @__PURE__ */ jsx("th", { className: "p-2 text-left", children: "Raw" })
        ] }) }),
        /* @__PURE__ */ jsx("tbody", { children: (data?.usuarios ?? []).map((u, index) => /* @__PURE__ */ jsxs("tr", { className: "border-t align-top", children: [
          /* @__PURE__ */ jsx("td", { className: "p-2 font-mono", children: u.id ?? "—" }),
          /* @__PURE__ */ jsx("td", { className: "p-2", children: [u.nombre, u.apellidos].filter(Boolean).join(" ") || "—" }),
          /* @__PURE__ */ jsx("td", { className: "p-2", children: u.correo ?? "—" }),
          /* @__PURE__ */ jsx("td", { className: "p-2", children: u.curp ?? u.identificacion ?? "—" }),
          /* @__PURE__ */ jsx("td", { className: "p-2", children: u.rol_nombre ?? (u.rol_id != null ? String(u.rol_id) : "—") }),
          /* @__PURE__ */ jsx("td", { className: "p-2 max-w-[500px]", children: /* @__PURE__ */ jsx("pre", { className: "whitespace-pre-wrap break-words text-xs text-muted-foreground", children: JSON.stringify(u, null, 2) }) })
        ] }, u.id ?? `row-${index}`)) })
      ] }) })
    ] })
  ] }) });
}
export {
  PruebaDrizzlePage as component
};
