import { jsxs, jsx } from "react/jsx-runtime";
import { Link } from "@tanstack/react-router";
import { useQuery } from "@tanstack/react-query";
import { useState } from "react";
import { HugeiconsIcon } from "@hugeicons/react";
import { File02Icon, FileEditIcon, Comment01Icon } from "@hugeicons/core-free-icons";
import { format } from "date-fns";
import { es } from "date-fns/locale";
import { C as Card, a as CardHeader, b as CardTitle, c as CardDescription, d as CardContent } from "./card-B_lDvuvx.mjs";
import { l as listarProyectos, h as obtenerComentariosRevisionProyecto, D as Dialog, b as DialogContent, c as DialogHeader, d as DialogTitle, e as DialogDescription } from "./api-proyectos-BavXVf60.mjs";
import { T as Table, a as TableHeader, b as TableRow, c as TableHead, d as TableBody, e as TableCell } from "./table-SNBC4Iim.mjs";
import { B as Button } from "./button-Bp95UwA9.mjs";
import { B as Badge } from "./badge-D2nuHzhh.mjs";
import { S as Spinner } from "./spinner-jf2ZHWGj.mjs";
import { u as useRequireAuth } from "./use-require-auth-D-C-TxBR.mjs";
import "./utils-H80jjgLf.mjs";
import "clsx";
import "tailwind-merge";
import "radix-ui";
import "./router-5yTRMCgc.mjs";
import "next-themes";
import "sonner";
import "class-variance-authority";
const NOMBRES_PASO = ["Solicitud y proponente", "Características", "Colaboradores", "Descripción del proyecto", "Datos de investigadores", "Marco de Referencia", "Material y Método", "Organización administrativa"];
function ProyectosPage() {
  const listo = useRequireAuth();
  const [proyectoComentariosId, setProyectoComentariosId] = useState(null);
  const {
    data,
    isLoading,
    isError,
    error
  } = useQuery({
    queryKey: ["proyectos"],
    queryFn: async () => {
      const r = await listarProyectos();
      if (!r.success) throw new Error(r.error || "Error al cargar proyectos");
      return r.proyectos ?? [];
    },
    enabled: listo
  });
  const queryComentarios = useQuery({
    queryKey: ["proyectos", "comentarios", proyectoComentariosId],
    queryFn: async () => {
      if (proyectoComentariosId == null) throw new Error("Proyecto no seleccionado");
      const r = await obtenerComentariosRevisionProyecto(proyectoComentariosId);
      if (!r.success) throw new Error(r.error || "No se pudieron cargar los comentarios");
      return r;
    },
    enabled: proyectoComentariosId != null
  });
  const proyectos = data ?? [];
  if (!listo) return null;
  return /* @__PURE__ */ jsxs("div", { className: "container mx-auto p-8 max-w-6xl", children: [
    /* @__PURE__ */ jsxs("div", { className: "mb-8 space-y-2", children: [
      /* @__PURE__ */ jsx("h1", { className: "text-4xl font-bold tracking-tight", children: "Proyectos" }),
      /* @__PURE__ */ jsx("p", { className: "text-lg text-muted-foreground", children: "Listado y seguimiento de proyectos de investigación" })
    ] }),
    /* @__PURE__ */ jsxs(Card, { children: [
      /* @__PURE__ */ jsxs(CardHeader, { children: [
        /* @__PURE__ */ jsxs(CardTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: File02Icon, className: "size-5" }),
          "Mis proyectos"
        ] }),
        /* @__PURE__ */ jsx(CardDescription, { children: "Proyectos en borrador o ya enviados. Puedes continuar editando los que estén en borrador." })
      ] }),
      /* @__PURE__ */ jsxs(CardContent, { children: [
        isLoading && /* @__PURE__ */ jsx("div", { className: "flex items-center justify-center py-12", children: /* @__PURE__ */ jsx(Spinner, { className: "size-8" }) }),
        isError && /* @__PURE__ */ jsx("p", { className: "text-destructive py-6 text-center", children: error instanceof Error ? error.message : "Error al cargar proyectos" }),
        !isLoading && !isError && proyectos.length === 0 && /* @__PURE__ */ jsxs("div", { className: "py-12 text-center text-muted-foreground", children: [
          /* @__PURE__ */ jsx("p", { className: "mb-4", children: "Aún no tienes proyectos registrados." }),
          /* @__PURE__ */ jsx(Button, { asChild: true, children: /* @__PURE__ */ jsxs(Link, { to: "/registro-proyecto", search: {
            proyecto: void 0,
            paso: void 0
          }, children: [
            /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileEditIcon, className: "size-4 mr-2" }),
            "Crear primer proyecto"
          ] }) })
        ] }),
        !isLoading && !isError && proyectos.length > 0 && /* @__PURE__ */ jsxs(Table, { children: [
          /* @__PURE__ */ jsx(TableHeader, { children: /* @__PURE__ */ jsxs(TableRow, { children: [
            /* @__PURE__ */ jsx(TableHead, { className: "w-16", children: "Id" }),
            /* @__PURE__ */ jsx(TableHead, { children: "Estado" }),
            /* @__PURE__ */ jsx(TableHead, { children: "Último paso" }),
            /* @__PURE__ */ jsx(TableHead, { children: "Última actualización" }),
            /* @__PURE__ */ jsx(TableHead, { className: "w-56 text-right", children: "Acciones" })
          ] }) }),
          /* @__PURE__ */ jsx(TableBody, { children: proyectos.map((p) => /* @__PURE__ */ jsxs(TableRow, { children: [
            /* @__PURE__ */ jsx(TableCell, { className: "font-mono text-muted-foreground", children: p.id }),
            /* @__PURE__ */ jsx(TableCell, { children: /* @__PURE__ */ jsx(Badge, { variant: p.estado === "borrador" ? "secondary" : "default", children: p.estado === "aprobado" ? "Aprobado" : p.estado === "enviado" ? "Enviado" : "Borrador" }) }),
            /* @__PURE__ */ jsx(TableCell, { children: p.estado === "aprobado" ? "Aprobado por comités" : p.estado === "enviado" ? "Completado" : NOMBRES_PASO[p.paso_actual] ?? `Paso ${p.paso_actual + 1}` }),
            /* @__PURE__ */ jsx(TableCell, { className: "text-muted-foreground", children: format(new Date(p.fecha_actualizacion), "d 'de' MMMM yyyy, HH:mm", {
              locale: es
            }) }),
            /* @__PURE__ */ jsx(TableCell, { className: "text-right", children: /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-end gap-2", children: [
              (p.estado === "enviado" || p.estado === "aprobado") && /* @__PURE__ */ jsxs(Button, { variant: "outline", size: "sm", onClick: () => setProyectoComentariosId(p.id), children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Comment01Icon, className: "size-4 mr-1" }),
                "Ver comentarios"
              ] }),
              /* @__PURE__ */ jsx(Button, { variant: "outline", size: "sm", asChild: true, children: /* @__PURE__ */ jsxs(Link, { to: "/registro-proyecto", search: {
                proyecto: p.id,
                paso: p.estado === "enviado" || p.estado === "aprobado" ? 0 : p.paso_actual
              }, children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileEditIcon, className: "size-4 mr-1" }),
                p.estado === "borrador" ? "Continuar" : "Ver"
              ] }) })
            ] }) })
          ] }, p.id)) })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsx(Dialog, { open: proyectoComentariosId != null, onOpenChange: (open) => {
      if (!open) setProyectoComentariosId(null);
    }, children: /* @__PURE__ */ jsxs(DialogContent, { className: "sm:max-w-3xl", children: [
      /* @__PURE__ */ jsxs(DialogHeader, { children: [
        /* @__PURE__ */ jsx(DialogTitle, { children: "Comentarios de revisión" }),
        /* @__PURE__ */ jsxs(DialogDescription, { children: [
          "Proyecto #",
          proyectoComentariosId ?? "—",
          " · Comentarios emitidos por los comités."
        ] })
      ] }),
      queryComentarios.isLoading && /* @__PURE__ */ jsx("div", { className: "py-8 flex items-center justify-center", children: /* @__PURE__ */ jsx(Spinner, { className: "size-6" }) }),
      queryComentarios.isError && /* @__PURE__ */ jsx("p", { className: "text-destructive text-sm", children: queryComentarios.error instanceof Error ? queryComentarios.error.message : "No se pudieron cargar los comentarios" }),
      !queryComentarios.isLoading && !queryComentarios.isError && /* @__PURE__ */ jsxs("div", { className: "space-y-3 max-h-[60vh] overflow-auto pr-1", children: [
        /* @__PURE__ */ jsxs("div", { className: "rounded-lg border p-3 bg-card", children: [
          /* @__PURE__ */ jsx("p", { className: "text-sm font-medium mb-2", children: "Estado de comités" }),
          /* @__PURE__ */ jsx("div", { className: "grid grid-cols-1 sm:grid-cols-3 gap-2", children: [1, 2, 3].map((comite) => {
            const aprobacion = (queryComentarios.data?.aprobaciones ?? []).find((a) => a.comite === comite && Number(a.aprobado) === 1);
            return /* @__PURE__ */ jsxs("div", { className: "rounded-md border p-2", children: [
              /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between gap-2", children: [
                /* @__PURE__ */ jsxs("span", { className: "text-sm font-medium", children: [
                  "Comité ",
                  comite
                ] }),
                /* @__PURE__ */ jsx(Badge, { variant: aprobacion ? "default" : "secondary", children: aprobacion ? "Aprobado" : "Pendiente" })
              ] }),
              /* @__PURE__ */ jsx("p", { className: "text-xs text-muted-foreground mt-1", children: aprobacion ? `${aprobacion.autor_nombre} · ${format(new Date(aprobacion.fecha_aprobacion), "d 'de' MMM yyyy", {
                locale: es
              })}` : "Sin aprobación aún" })
            ] }, comite);
          }) })
        ] }),
        (queryComentarios.data?.comentarios ?? []).length === 0 && /* @__PURE__ */ jsx("p", { className: "text-sm text-muted-foreground", children: "Aún no hay comentarios de comité para este proyecto." }),
        (queryComentarios.data?.comentarios ?? []).map((c) => /* @__PURE__ */ jsxs("div", { className: "rounded-lg border p-3 bg-card", children: [
          /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between gap-2", children: [
            /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
              /* @__PURE__ */ jsxs(Badge, { variant: "secondary", children: [
                "Comité ",
                c.comite
              ] }),
              /* @__PURE__ */ jsx(Badge, { variant: "outline", children: queryComentarios.data?.nombresPaso?.[c.paso] ?? `Paso ${c.paso + 1}` })
            ] }),
            /* @__PURE__ */ jsx("span", { className: "text-xs text-muted-foreground", children: format(new Date(c.fecha_comentario), "d 'de' MMM yyyy", {
              locale: es
            }) })
          ] }),
          /* @__PURE__ */ jsx("p", { className: "mt-2 text-sm whitespace-pre-wrap", children: c.comentario }),
          /* @__PURE__ */ jsx("p", { className: "mt-2 text-xs text-muted-foreground", children: c.autor_nombre })
        ] }, c.id))
      ] })
    ] }) })
  ] });
}
export {
  ProyectosPage as component
};
