import { jsxs, jsx, Fragment } from "react/jsx-runtime";
import { useNavigate } from "@tanstack/react-router";
import { useEffect, useState, useMemo } from "react";
import { useQueryClient, useQuery, useMutation } from "@tanstack/react-query";
import { toast } from "sonner";
import { createColumnHelper, useReactTable, getFilteredRowModel, getCoreRowModel, flexRender } from "@tanstack/react-table";
import { HugeiconsIcon } from "@hugeicons/react";
import { Search01Icon } from "@hugeicons/core-free-icons";
import { e as esAdmin, b as apiUrl } from "./router-5yTRMCgc.mjs";
import { u as useRequireAuth } from "./use-require-auth-D-C-TxBR.mjs";
import { C as Card, a as CardHeader, b as CardTitle, c as CardDescription, d as CardContent } from "./card-B_lDvuvx.mjs";
import { T as Table, a as TableHeader, b as TableRow, c as TableHead, d as TableBody, e as TableCell } from "./table-SNBC4Iim.mjs";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-D2Xe1kOZ.mjs";
import { A as AlertDialog, a as AlertDialogContent, b as AlertDialogHeader, c as AlertDialogTitle, d as AlertDialogDescription, e as AlertDialogFooter, f as AlertDialogCancel, h as AlertDialogAction } from "./alert-dialog-Da-A3hay.mjs";
import { I as Input } from "./input-B66ag17B.mjs";
import { L as Label } from "./label-Cp5Wz1sX.mjs";
import { S as Spinner } from "./spinner-jf2ZHWGj.mjs";
import "next-themes";
import "./utils-H80jjgLf.mjs";
import "clsx";
import "tailwind-merge";
import "radix-ui";
import "./button-Bp95UwA9.mjs";
import "class-variance-authority";
function normalizar(s) {
  return (s ?? "").trim().toLowerCase().normalize("NFD").replace(new RegExp("\\p{Diacritic}", "gu"), "");
}
const columnHelper = createColumnHelper();
async function fetchRoles() {
  const res = await fetch(apiUrl("/api/admin/roles"));
  const data = await res.json();
  if (data.success && Array.isArray(data.roles)) return data.roles;
  return [];
}
async function fetchUsuarios() {
  const res = await fetch(apiUrl("/api/admin/usuarios"));
  const data = await res.json();
  if (data.success && Array.isArray(data.usuarios)) return data.usuarios;
  throw new Error(data.error || "Error al cargar usuarios");
}
async function patchRolUsuario(id, rolId) {
  const res = await fetch(apiUrl(`/api/admin/usuarios/${id}`), {
    method: "PATCH",
    headers: {
      "Content-Type": "application/json"
    },
    body: JSON.stringify({
      rol_id: rolId
    })
  });
  const data = await res.json();
  if (!data.success) throw new Error(data.error || "No se pudo actualizar el rol");
}
function AdminUsuariosPage() {
  const navigate = useNavigate();
  const queryClient = useQueryClient();
  const listo = useRequireAuth();
  useEffect(() => {
    if (listo && !esAdmin()) {
      navigate({
        to: "/inicio"
      });
    }
  }, [listo, navigate]);
  const [busqueda, setBusqueda] = useState("");
  const [confirmacionRol, setConfirmacionRol] = useState(null);
  const {
    data: roles = []
  } = useQuery({
    queryKey: ["admin", "roles"],
    queryFn: fetchRoles
  });
  const {
    data: usuarios = [],
    isLoading: cargando,
    isError: errorUsuarios,
    error: errorUsuariosMsg
  } = useQuery({
    queryKey: ["admin", "usuarios"],
    queryFn: fetchUsuarios
  });
  const mutationRol = useMutation({
    mutationFn: ({
      id,
      rolId
    }) => patchRolUsuario(id, rolId),
    onSuccess: async (_, {
      rolId
    }) => {
      await queryClient.invalidateQueries({
        queryKey: ["admin", "usuarios"]
      });
      const rol = roles.find((r) => r.id === rolId);
      toast.success(rol ? `Rol actualizado a ${rol.nombre}` : "Rol actualizado correctamente");
    },
    onError: (err) => {
      toast.error(err.message || "Error de conexión");
    },
    onSettled: () => {
      setConfirmacionRol(null);
    }
  });
  const actualizandoId = mutationRol.isPending && mutationRol.variables ? mutationRol.variables.id : null;
  const alSeleccionarRol = (usuario, rolId) => {
    if (usuario.rol_id === rolId) return;
    const rol = roles.find((r) => r.id === rolId);
    const nombre = [usuario.nombre, usuario.apellidos].filter(Boolean).join(" ") || "Usuario";
    setConfirmacionRol({
      usuarioId: usuario.id,
      usuarioNombre: nombre,
      rolId,
      rolNombre: rol?.nombre ?? ""
    });
  };
  const confirmarCambioRol = () => {
    if (confirmacionRol) {
      mutationRol.mutate({
        id: confirmacionRol.usuarioId,
        rolId: confirmacionRol.rolId
      });
    }
  };
  const columns = useMemo(() => [columnHelper.accessor((row) => String(row.id), {
    id: "id",
    header: () => null,
    cell: () => null,
    enableHiding: true
  }), columnHelper.accessor("nombre", {
    header: "Nombre",
    cell: (info) => info.getValue() ?? "—"
  }), columnHelper.accessor("apellidos", {
    header: "Apellidos",
    cell: (info) => info.getValue() ?? "—"
  }), columnHelper.accessor("correo", {
    header: "Correo",
    cell: (info) => info.getValue() ?? "—"
  }), columnHelper.accessor((row) => row.curp ?? row.identificacion ?? "", {
    id: "curp_identificacion",
    header: "CURP / Identificación",
    cell: (info) => info.getValue() || "—"
  }), columnHelper.display({
    id: "rol",
    header: "Rol",
    cell: ({
      row
    }) => /* @__PURE__ */ jsxs(Select, { value: String(row.original.rol_id), onValueChange: (value) => alSeleccionarRol(row.original, parseInt(value, 10)), disabled: actualizandoId === row.original.id, children: [
      /* @__PURE__ */ jsx(SelectTrigger, { className: "w-full", size: "sm", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Rol" }) }),
      /* @__PURE__ */ jsx(SelectContent, { children: roles.map((r) => /* @__PURE__ */ jsx(SelectItem, { value: String(r.id), children: r.nombre }, r.id)) })
    ] })
  })], [roles, actualizandoId]);
  const table = useReactTable({
    data: usuarios,
    columns,
    state: {
      globalFilter: busqueda,
      columnVisibility: {
        id: false
      }
    },
    onGlobalFilterChange: setBusqueda,
    getCoreRowModel: getCoreRowModel(),
    getFilteredRowModel: getFilteredRowModel(),
    globalFilterFn: (row, columnId, filterValue) => {
      const val = row.getValue(columnId);
      return normalizar(String(val ?? "")).includes(normalizar(String(filterValue ?? "")));
    }
  });
  const filas = table.getRowModel().rows;
  const hayFiltro = busqueda.trim().length > 0;
  const error = errorUsuarios ? errorUsuariosMsg instanceof Error ? errorUsuariosMsg.message : "Error al cargar usuarios" : "";
  if (!listo || !esAdmin()) {
    return /* @__PURE__ */ jsx("div", { className: "min-h-screen flex items-center justify-center bg-muted", children: /* @__PURE__ */ jsx(Spinner, { className: "size-8 text-muted-foreground" }) });
  }
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(AlertDialog, { open: confirmacionRol !== null, onOpenChange: (open) => {
      if (!open) setConfirmacionRol(null);
    }, children: /* @__PURE__ */ jsxs(AlertDialogContent, { children: [
      /* @__PURE__ */ jsxs(AlertDialogHeader, { children: [
        /* @__PURE__ */ jsx(AlertDialogTitle, { children: "Confirmar cambio de rol" }),
        /* @__PURE__ */ jsx(AlertDialogDescription, { children: confirmacionRol && /* @__PURE__ */ jsxs(Fragment, { children: [
          '¿Asignar el rol "',
          confirmacionRol.rolNombre,
          '" a ',
          confirmacionRol.usuarioNombre,
          "?"
        ] }) })
      ] }),
      /* @__PURE__ */ jsxs(AlertDialogFooter, { children: [
        /* @__PURE__ */ jsx(AlertDialogCancel, { disabled: mutationRol.isPending, children: "Cancelar" }),
        /* @__PURE__ */ jsx(AlertDialogAction, { disabled: mutationRol.isPending, onClick: confirmarCambioRol, children: mutationRol.isPending ? /* @__PURE__ */ jsxs("span", { className: "inline-flex items-center gap-2", children: [
          /* @__PURE__ */ jsx(Spinner, { className: "size-4" }),
          "Guardando..."
        ] }) : "Confirmar" })
      ] })
    ] }) }),
    /* @__PURE__ */ jsxs("div", { className: "container mx-auto p-8 max-w-6xl", children: [
      /* @__PURE__ */ jsxs("div", { className: "mb-8 space-y-2", children: [
        /* @__PURE__ */ jsx("h1", { className: "text-4xl font-bold tracking-tight", children: "Panel de administración" }),
        /* @__PURE__ */ jsx("p", { className: "text-lg text-muted-foreground", children: "Gestión de usuarios del sistema" })
      ] }),
      /* @__PURE__ */ jsxs(Card, { children: [
        /* @__PURE__ */ jsx(CardHeader, { children: /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(CardTitle, { className: "text-xl", children: "Usuarios" }),
          /* @__PURE__ */ jsx(CardDescription, { children: "Listado de usuarios y asignación de rol. Por defecto el rol es Médico al registrarse." })
        ] }) }),
        /* @__PURE__ */ jsxs(CardContent, { children: [
          error && /* @__PURE__ */ jsx("p", { className: "text-sm text-destructive mb-4", children: error }),
          !cargando && usuarios.length > 0 && /* @__PURE__ */ jsxs("div", { className: "mb-4 flex flex-col gap-2 sm:flex-row sm:items-end", children: [
            /* @__PURE__ */ jsxs("div", { className: "flex-1", children: [
              /* @__PURE__ */ jsx(Label, { htmlFor: "busqueda-usuarios", className: "sr-only", children: "Buscar por ID, CURP, identificación, nombre o apellido" }),
              /* @__PURE__ */ jsxs("div", { className: "relative", children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Search01Icon, className: "absolute left-2.5 top-1/2 size-4 -translate-y-1/2 text-muted-foreground" }),
                /* @__PURE__ */ jsx(Input, { id: "busqueda-usuarios", type: "search", placeholder: "Buscar por ID, CURP, identificación, nombre o apellido", value: busqueda, onChange: (e) => table.setGlobalFilter(e.target.value), className: "pl-8" })
              ] })
            ] }),
            hayFiltro && /* @__PURE__ */ jsxs("p", { className: "text-sm text-muted-foreground sm:pb-2", children: [
              filas.length,
              " resultado",
              filas.length !== 1 ? "s" : ""
            ] })
          ] }),
          cargando ? /* @__PURE__ */ jsx("div", { className: "flex justify-center py-8", children: /* @__PURE__ */ jsx(Spinner, { className: "size-8 text-muted-foreground" }) }) : usuarios.length === 0 ? /* @__PURE__ */ jsx("p", { className: "text-muted-foreground py-8", children: "No hay usuarios registrados." }) : filas.length === 0 ? /* @__PURE__ */ jsx("p", { className: "text-muted-foreground py-8", children: "No hay coincidencias con la búsqueda." }) : /* @__PURE__ */ jsxs(Table, { className: "[&_tr]:border-border", children: [
            /* @__PURE__ */ jsx(TableHeader, { children: table.getHeaderGroups().map((headerGroup) => /* @__PURE__ */ jsx(TableRow, { children: headerGroup.headers.map((header) => /* @__PURE__ */ jsx(TableHead, { className: header.column.id === "rol" ? "w-[180px]" : void 0, children: header.isPlaceholder ? null : flexRender(header.column.columnDef.header, header.getContext()) }, header.id)) }, headerGroup.id)) }),
            /* @__PURE__ */ jsx(TableBody, { children: filas.map((row) => /* @__PURE__ */ jsx(TableRow, { children: row.getVisibleCells().map((cell) => /* @__PURE__ */ jsx(TableCell, { children: flexRender(cell.column.columnDef.cell, cell.getContext()) }, cell.id)) }, row.id)) })
          ] })
        ] })
      ] })
    ] })
  ] });
}
export {
  AdminUsuariosPage as component
};
