import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import * as React from "react";
import { useEffect } from "react";
import { useRouter, useRouterState, Link, useNavigate, Outlet } from "@tanstack/react-router";
import { u as useTheme, a as assetPath, g as getUsuarioSesion } from "./router-5yTRMCgc.mjs";
import { u as useRequireAuth } from "./use-require-auth-D-C-TxBR.mjs";
import { Slot } from "@radix-ui/react-slot";
import { cva } from "class-variance-authority";
import { HugeiconsIcon } from "@hugeicons/react";
import { DashboardSquare01Icon, FileEditIcon, File02Icon, FileVerifiedIcon, BookOpen01Icon, UserGroupIcon, UserIcon, ArrowUpDownIcon, Moon02Icon, Sun01Icon, Logout01Icon, LayoutAlignLeftIcon, PanelLeftIcon } from "@hugeicons/core-free-icons";
import { c as cn } from "./utils-H80jjgLf.mjs";
import { B as Button } from "./button-Bp95UwA9.mjs";
import { DropdownMenu as DropdownMenu$1, Tooltip as Tooltip$1 } from "radix-ui";
import { motion } from "framer-motion";
import { T as ThemeToggle } from "./theme-toggle-C2c9ak38.mjs";
import { S as Spinner } from "./spinner-jf2ZHWGj.mjs";
import "@tanstack/react-query";
import "next-themes";
import "sonner";
import "clsx";
import "tailwind-merge";
const MOBILE_BREAKPOINT = 768;
function useIsMobile() {
  const [isMobile, setIsMobile] = React.useState(
    void 0
  );
  React.useEffect(() => {
    const mql = window.matchMedia(`(max-width: ${MOBILE_BREAKPOINT - 1}px)`);
    const onChange = () => {
      setIsMobile(window.innerWidth < MOBILE_BREAKPOINT);
    };
    mql.addEventListener("change", onChange);
    setIsMobile(window.innerWidth < MOBILE_BREAKPOINT);
    return () => mql.removeEventListener("change", onChange);
  }, []);
  return !!isMobile;
}
function TooltipProvider({
  delayDuration = 0,
  ...props
}) {
  return /* @__PURE__ */ jsx(
    Tooltip$1.Provider,
    {
      "data-slot": "tooltip-provider",
      delayDuration,
      ...props
    }
  );
}
function Tooltip({
  ...props
}) {
  return /* @__PURE__ */ jsx(TooltipProvider, { children: /* @__PURE__ */ jsx(Tooltip$1.Root, { "data-slot": "tooltip", ...props }) });
}
function TooltipTrigger({
  ...props
}) {
  return /* @__PURE__ */ jsx(Tooltip$1.Trigger, { "data-slot": "tooltip-trigger", ...props });
}
function TooltipContent({
  className,
  sideOffset = 0,
  children,
  ...props
}) {
  return /* @__PURE__ */ jsx(Tooltip$1.Portal, { children: /* @__PURE__ */ jsxs(
    Tooltip$1.Content,
    {
      "data-slot": "tooltip-content",
      sideOffset,
      className: cn(
        "data-open:animate-in data-open:fade-in-0 data-open:zoom-in-95 data-[state=delayed-open]:animate-in data-[state=delayed-open]:fade-in-0 data-[state=delayed-open]:zoom-in-95 data-closed:animate-out data-closed:fade-out-0 data-closed:zoom-out-95 data-[side=bottom]:slide-in-from-top-2 data-[side=left]:slide-in-from-right-2 data-[side=right]:slide-in-from-left-2 data-[side=top]:slide-in-from-bottom-2 rounded-md px-3 py-1.5 text-xs bg-popover text-popover-foreground ring-foreground/10 ring-1 shadow-md z-50 w-fit max-w-xs origin-(--radix-tooltip-content-transform-origin)",
        className
      ),
      ...props,
      children: [
        children,
        /* @__PURE__ */ jsx(Tooltip$1.Arrow, { className: "size-2.5 translate-y-[calc(-50%_-_2px)] rotate-45 rounded-[2px] bg-popover fill-popover z-50 translate-y-[calc(-50%_-_2px)]" })
      ]
    }
  ) });
}
const SIDEBAR_COOKIE_NAME = "sidebar_state";
const SIDEBAR_COOKIE_MAX_AGE = 60 * 60 * 24 * 7;
const SIDEBAR_WIDTH = "16rem";
const SIDEBAR_WIDTH_ICON = "3rem";
const SIDEBAR_KEYBOARD_SHORTCUT = "b";
const SIDEBAR_KEYBOARD_SHORTCUT_WINDOWS = "Ctrl + B";
const SidebarContext = React.createContext(null);
function useSidebar() {
  const context = React.useContext(SidebarContext);
  if (!context) {
    throw new Error("useSidebar must be used within a SidebarProvider.");
  }
  return context;
}
function SidebarProvider({
  defaultOpen = true,
  open: openProp,
  onOpenChange: setOpenProp,
  className,
  style,
  children,
  ...props
}) {
  const isMobile = useIsMobile();
  const [openMobile, setOpenMobile] = React.useState(false);
  const [_open, _setOpen] = React.useState(defaultOpen);
  const open = openProp ?? _open;
  const setOpen = React.useCallback(
    (value) => {
      const openState = typeof value === "function" ? value(open) : value;
      if (setOpenProp) {
        setOpenProp(openState);
      } else {
        _setOpen(openState);
      }
      document.cookie = `${SIDEBAR_COOKIE_NAME}=${openState}; path=/; max-age=${SIDEBAR_COOKIE_MAX_AGE}`;
    },
    [setOpenProp, open]
  );
  const toggleSidebar = React.useCallback(() => {
    return isMobile ? setOpenMobile((open2) => !open2) : setOpen((open2) => !open2);
  }, [isMobile, setOpen, setOpenMobile]);
  React.useEffect(() => {
    const handleKeyDown = (event) => {
      if (event.key.toLowerCase() === SIDEBAR_KEYBOARD_SHORTCUT && (event.metaKey || event.ctrlKey)) {
        event.preventDefault();
        toggleSidebar();
      }
    };
    window.addEventListener("keydown", handleKeyDown);
    return () => window.removeEventListener("keydown", handleKeyDown);
  }, [toggleSidebar]);
  const state = open ? "expanded" : "collapsed";
  const contextValue = React.useMemo(
    () => ({
      state,
      open,
      setOpen,
      isMobile,
      openMobile,
      setOpenMobile,
      toggleSidebar
    }),
    [state, open, setOpen, isMobile, openMobile, setOpenMobile, toggleSidebar]
  );
  return /* @__PURE__ */ jsx(SidebarContext.Provider, { value: contextValue, children: /* @__PURE__ */ jsx(TooltipProvider, { delayDuration: 0, children: /* @__PURE__ */ jsx(
    "div",
    {
      "data-slot": "sidebar-wrapper",
      style: {
        "--sidebar-width": SIDEBAR_WIDTH,
        "--sidebar-width-icon": SIDEBAR_WIDTH_ICON,
        ...style
      },
      className: cn(
        "group/sidebar-wrapper has-data-[variant=inset]:bg-muted flex min-h-svh w-full",
        className
      ),
      ...props,
      children
    }
  ) }) });
}
function Sidebar({
  side = "left",
  variant = "sidebar",
  collapsible = "offcanvas",
  className,
  children,
  ...props
}) {
  const { isMobile, state, openMobile, setOpenMobile, toggleSidebar } = useSidebar();
  if (collapsible === "none") {
    return /* @__PURE__ */ jsx(
      "div",
      {
        "data-slot": "sidebar",
        className: cn(
          "bg-muted text-foreground flex h-full w-(--sidebar-width) flex-col",
          className
        ),
        ...props,
        children
      }
    );
  }
  if (isMobile) {
    return /* @__PURE__ */ jsxs(
      "div",
      {
        className: "fixed inset-0 z-50 pointer-events-none",
        "aria-hidden": !openMobile,
        children: [
          /* @__PURE__ */ jsx(
            "div",
            {
              className: cn(
                "fixed left-0 top-0 h-full w-[85vw] max-w-sm bg-black/10 transition-opacity duration-300",
                openMobile ? "opacity-100 pointer-events-auto" : "opacity-0 pointer-events-none"
              ),
              onClick: () => setOpenMobile(false),
              onKeyDown: (e) => e.key === "Escape" && setOpenMobile(false),
              role: "button",
              tabIndex: -1,
              "aria-label": "Cerrar menú"
            }
          ),
          /* @__PURE__ */ jsx(
            "div",
            {
              "data-sidebar": "sidebar",
              "data-slot": "sidebar",
              "data-mobile": "true",
              className: cn(
                "fixed left-0 top-0 h-full w-[85vw] max-w-sm bg-muted text-foreground flex flex-col p-0 pointer-events-auto transition-transform duration-300 ease-[cubic-bezier(0.4,0,0.2,1)]",
                openMobile ? "translate-x-0" : "-translate-x-full"
              ),
              ...props,
              children: /* @__PURE__ */ jsx("div", { className: "flex h-full w-full flex-col overflow-y-auto", children })
            }
          )
        ]
      }
    );
  }
  return /* @__PURE__ */ jsxs(
    "div",
    {
      className: "group peer text-foreground hidden md:block",
      "data-state": state,
      "data-collapsible": state === "collapsed" ? collapsible : "",
      "data-variant": variant,
      "data-side": side,
      "data-slot": "sidebar",
      children: [
        /* @__PURE__ */ jsx(
          "div",
          {
            "data-slot": "sidebar-gap",
            className: cn(
              "relative w-(--sidebar-width) bg-transparent transition-[width] duration-200 ease-linear",
              "group-data-[collapsible=offcanvas]:w-0",
              "group-data-[side=right]:rotate-180",
              variant === "floating" || variant === "inset" ? "group-data-[collapsible=icon]:w-[calc(var(--sidebar-width-icon)+(--spacing(4)))]" : "group-data-[collapsible=icon]:w-(--sidebar-width-icon)"
            )
          }
        ),
        /* @__PURE__ */ jsx(
          "div",
          {
            "data-slot": "sidebar-container",
            className: cn(
              "fixed inset-y-0 z-10 hidden h-svh w-(--sidebar-width) transition-[left,right,width] duration-200 ease-linear md:flex",
              variant !== "floating" && variant !== "inset" && "bg-muted",
              side === "left" ? "left-0 group-data-[collapsible=offcanvas]:left-[calc(var(--sidebar-width)*-1)]" : "right-0 group-data-[collapsible=offcanvas]:right-[calc(var(--sidebar-width)*-1)]",
              variant === "floating" || variant === "inset" ? "p-2 group-data-[collapsible=icon]:w-[calc(var(--sidebar-width-icon)+(--spacing(4))+2px)]" : "group-data-[collapsible=icon]:w-(--sidebar-width-icon)",
              className
            ),
            ...props,
            children: /* @__PURE__ */ jsxs(
              "div",
              {
                "data-sidebar": "sidebar",
                "data-slot": "sidebar-inner",
                className: cn(
                  "bg-muted group-data-[variant=floating]:border-border flex h-full w-full flex-col group-data-[variant=floating]:rounded-lg group-data-[variant=floating]:border group-data-[variant=floating]:shadow-sm relative",
                  variant !== "floating" && variant !== "inset" && (side === "left" ? "border-r border-sidebar-border" : "border-l border-sidebar-border"),
                  side === "left" ? "sidebar-entrance-left" : "sidebar-entrance-right"
                ),
                children: [
                  children,
                  /* @__PURE__ */ jsx(
                    "button",
                    {
                      onClick: toggleSidebar,
                      className: "absolute top-0 right-0 h-full w-1 cursor-w-resize hover:bg-primary/10 transition-colors",
                      "aria-label": "Toggle sidebar"
                    }
                  )
                ]
              }
            )
          }
        )
      ]
    }
  );
}
function SidebarTrigger({
  className,
  onClick,
  ...props
}) {
  const { toggleSidebar, state, isMobile, openMobile } = useSidebar();
  const isMac = React.useMemo(() => {
    if (typeof window === "undefined") return false;
    return window.navigator.platform.toUpperCase().includes("MAC");
  }, []);
  const icon = isMobile ? openMobile ? LayoutAlignLeftIcon : PanelLeftIcon : state === "collapsed" ? LayoutAlignLeftIcon : PanelLeftIcon;
  return /* @__PURE__ */ jsxs(Tooltip, { children: [
    /* @__PURE__ */ jsx(TooltipTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(
      Button,
      {
        "data-sidebar": "trigger",
        "data-slot": "sidebar-trigger",
        variant: "ghost",
        size: "icon",
        className: cn("size-7 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground", className),
        onClick: (event) => {
          onClick?.(event);
          toggleSidebar();
        },
        ...props,
        children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon }),
          /* @__PURE__ */ jsx("span", { className: "sr-only", children: "Toggle Sidebar" })
        ]
      }
    ) }),
    /* @__PURE__ */ jsx(TooltipContent, { side: "bottom", align: "center", className: "text-xs text-center ring-0", children: /* @__PURE__ */ jsx("span", { className: "font-medium", children: isMac ? "⌘ B" : SIDEBAR_KEYBOARD_SHORTCUT_WINDOWS }) })
  ] });
}
function SidebarRail({ className, ...props }) {
  const { toggleSidebar } = useSidebar();
  return /* @__PURE__ */ jsx(
    "button",
    {
      "data-sidebar": "rail",
      "data-slot": "sidebar-rail",
      "aria-label": "Toggle Sidebar",
      tabIndex: -1,
      onClick: toggleSidebar,
      title: "Toggle Sidebar",
      className: cn(
        "hover:after:bg-border absolute inset-y-0 z-20 hidden w-4 -translate-x-1/2 transition-all ease-linear group-data-[side=left]:-right-4 group-data-[side=right]:left-0 after:absolute after:inset-y-0 after:left-1/2 after:w-px after:bg-border sm:flex",
        "in-data-[side=left]:cursor-w-resize in-data-[side=right]:cursor-e-resize",
        "[[data-side=left][data-state=collapsed]_&]:cursor-e-resize [[data-side=right][data-state=collapsed]_&]:cursor-w-resize",
        "hover:group-data-[collapsible=offcanvas]:bg-muted group-data-[collapsible=offcanvas]:translate-x-0 group-data-[collapsible=offcanvas]:after:left-full",
        "[[data-side=left][data-collapsible=offcanvas]_&]:-right-2",
        "[[data-side=right][data-collapsible=offcanvas]_&]:-left-2",
        className
      ),
      ...props
    }
  );
}
function SidebarInset({ className, ...props }) {
  return /* @__PURE__ */ jsx(
    "main",
    {
      "data-slot": "sidebar-inset",
      className: cn(
        "bg-background relative flex w-full flex-1 flex-col",
        "md:peer-data-[variant=inset]:m-2 md:peer-data-[variant=inset]:ml-0 md:peer-data-[variant=inset]:rounded-xl md:peer-data-[variant=inset]:shadow-sm md:peer-data-[variant=inset]:peer-data-[state=collapsed]:ml-2",
        className
      ),
      ...props
    }
  );
}
function SidebarHeader({ className, ...props }) {
  return /* @__PURE__ */ jsx(
    "div",
    {
      "data-slot": "sidebar-header",
      "data-sidebar": "header",
      className: cn("flex flex-col gap-2 p-2", className),
      ...props
    }
  );
}
function SidebarFooter({ className, ...props }) {
  return /* @__PURE__ */ jsx(
    "div",
    {
      "data-slot": "sidebar-footer",
      "data-sidebar": "footer",
      className: cn("flex flex-col gap-2 p-2", className),
      ...props
    }
  );
}
function SidebarContent({ className, ...props }) {
  return /* @__PURE__ */ jsx(
    "div",
    {
      "data-slot": "sidebar-content",
      "data-sidebar": "content",
      className: cn(
        "flex min-h-0 flex-1 flex-col gap-2 overflow-auto group-data-[collapsible=icon]:overflow-hidden",
        className
      ),
      ...props
    }
  );
}
function SidebarGroup({ className, ...props }) {
  return /* @__PURE__ */ jsx(
    "div",
    {
      "data-slot": "sidebar-group",
      "data-sidebar": "group",
      className: cn("relative flex w-full min-w-0 flex-col p-2", className),
      ...props
    }
  );
}
function SidebarGroupLabel({
  className,
  asChild = false,
  ...props
}) {
  const Comp = asChild ? Slot : "div";
  return /* @__PURE__ */ jsx(
    Comp,
    {
      "data-slot": "sidebar-group-label",
      "data-sidebar": "group-label",
      className: cn(
        "text-muted-foreground ring-sidebar-ring flex h-8 shrink-0 items-center rounded-md px-2 text-xs font-medium outline-hidden transition-[margin,opacity] duration-200 ease-linear focus-visible:ring-2 [&>svg]:size-4 [&>svg]:shrink-0",
        "group-data-[collapsible=icon]:-mt-8 group-data-[collapsible=icon]:opacity-0",
        className
      ),
      ...props
    }
  );
}
function SidebarGroupContent({
  className,
  ...props
}) {
  return /* @__PURE__ */ jsx(
    "div",
    {
      "data-slot": "sidebar-group-content",
      "data-sidebar": "group-content",
      className: cn("w-full text-sm", className),
      ...props
    }
  );
}
function SidebarMenu({ className, ...props }) {
  return /* @__PURE__ */ jsx(
    "ul",
    {
      "data-slot": "sidebar-menu",
      "data-sidebar": "menu",
      className: cn("flex w-full min-w-0 flex-col gap-1", className),
      ...props
    }
  );
}
function SidebarMenuItem({ className, ...props }) {
  return /* @__PURE__ */ jsx(
    "li",
    {
      "data-slot": "sidebar-menu-item",
      "data-sidebar": "menu-item",
      className: cn("group/menu-item relative", className),
      ...props
    }
  );
}
const sidebarMenuButtonVariants = cva(
  "peer/menu-button flex w-full items-center gap-2 overflow-hidden rounded-md p-2 text-left text-sm outline-hidden ring-sidebar-ring transition-[width,height,padding] hover:bg-sidebar-accent hover:text-sidebar-accent-foreground focus-visible:ring-2 active:bg-sidebar-accent active:text-sidebar-accent-foreground disabled:pointer-events-none disabled:opacity-50 group-has-data-[sidebar=menu-action]/menu-item:pr-8 aria-disabled:pointer-events-none aria-disabled:opacity-50 data-[active=true]:font-medium data-[active=true]:text-primary data-[state=open]:hover:bg-sidebar-accent data-[state=open]:hover:text-sidebar-accent-foreground group-data-[collapsible=icon]:size-8! group-data-[collapsible=icon]:p-2! [&>span:last-child]:truncate [&>svg]:size-4 [&>svg]:shrink-0",
  {
    variants: {
      variant: {
        default: "hover:bg-sidebar-accent hover:text-sidebar-accent-foreground",
        outline: "bg-background shadow-[0_0_0_1px_hsl(var(--sidebar-border))] hover:bg-sidebar-accent hover:text-sidebar-accent-foreground hover:shadow-[0_0_0_1px_hsl(var(--sidebar-accent))]"
      },
      size: {
        default: "h-8 text-sm",
        sm: "h-7 text-xs",
        lg: "h-12 text-sm group-data-[collapsible=icon]:p-0!"
      }
    },
    defaultVariants: {
      variant: "default",
      size: "default"
    }
  }
);
function SidebarMenuButton({
  asChild = false,
  isActive = false,
  variant = "default",
  size = "default",
  tooltip,
  className,
  ...props
}) {
  const Comp = asChild ? Slot : "button";
  const { isMobile, state } = useSidebar();
  const button = /* @__PURE__ */ jsx(
    Comp,
    {
      "data-slot": "sidebar-menu-button",
      "data-sidebar": "menu-button",
      "data-size": size,
      "data-active": isActive,
      className: cn(sidebarMenuButtonVariants({ variant, size }), className),
      ...props
    }
  );
  if (!tooltip) {
    return button;
  }
  if (typeof tooltip === "string") {
    tooltip = {
      children: tooltip
    };
  }
  return /* @__PURE__ */ jsxs(Tooltip, { children: [
    /* @__PURE__ */ jsx(TooltipTrigger, { asChild: true, children: button }),
    /* @__PURE__ */ jsx(
      TooltipContent,
      {
        side: "right",
        align: "center",
        hidden: state !== "collapsed" || isMobile,
        ...tooltip
      }
    )
  ] });
}
function DropdownMenu({
  ...props
}) {
  return /* @__PURE__ */ jsx(DropdownMenu$1.Root, { "data-slot": "dropdown-menu", ...props });
}
function DropdownMenuTrigger({
  ...props
}) {
  return /* @__PURE__ */ jsx(
    DropdownMenu$1.Trigger,
    {
      "data-slot": "dropdown-menu-trigger",
      ...props
    }
  );
}
function DropdownMenuContent({
  className,
  align = "start",
  sideOffset = 4,
  ...props
}) {
  return /* @__PURE__ */ jsx(DropdownMenu$1.Portal, { children: /* @__PURE__ */ jsx(
    DropdownMenu$1.Content,
    {
      "data-slot": "dropdown-menu-content",
      sideOffset,
      align,
      className: cn(
        "data-open:animate-in data-closed:animate-out data-closed:fade-out-0 data-open:fade-in-0 data-closed:zoom-out-95 data-open:zoom-in-95 data-[side=bottom]:slide-in-from-top-2 data-[side=left]:slide-in-from-right-2 data-[side=right]:slide-in-from-left-2 data-[side=top]:slide-in-from-bottom-2 ring-foreground/10 bg-popover text-popover-foreground min-w-32 rounded-md p-1 shadow-md ring-1 duration-100 z-50 max-h-(--radix-dropdown-menu-content-available-height) w-(--radix-dropdown-menu-trigger-width) origin-(--radix-dropdown-menu-content-transform-origin) overflow-x-hidden overflow-y-auto data-[state=closed]:overflow-hidden",
        className
      ),
      ...props
    }
  ) });
}
function DropdownMenuItem({
  className,
  inset,
  variant = "default",
  ...props
}) {
  return /* @__PURE__ */ jsx(
    DropdownMenu$1.Item,
    {
      "data-slot": "dropdown-menu-item",
      "data-inset": inset,
      "data-variant": variant,
      className: cn(
        "focus:bg-accent focus:text-accent-foreground data-[variant=destructive]:text-destructive data-[variant=destructive]:focus:bg-destructive/10 data-[variant=destructive]:data-[highlighted]:bg-destructive/10 dark:data-[variant=destructive]:focus:bg-destructive/20 dark:data-[variant=destructive]:data-[highlighted]:bg-destructive/20 data-[variant=destructive]:focus:text-destructive data-[variant=destructive]:data-[highlighted]:text-destructive data-[variant=destructive]:*:[svg]:text-destructive data-[variant=destructive]:data-[highlighted]:*:[svg]:!text-destructive data-[variant=destructive]:[&_svg]:!text-destructive not-data-[variant=destructive]:focus:**:text-accent-foreground not-data-[variant=destructive]:data-[highlighted]:**:text-accent-foreground gap-2 rounded-sm px-2 py-1.5 text-sm [&_svg:not([class*='size-'])]:size-4 group/dropdown-menu-item relative flex cursor-default items-center outline-hidden select-none data-[disabled]:pointer-events-none data-[disabled]:opacity-50 data-[inset]:pl-8 [&_svg]:pointer-events-none [&_svg]:shrink-0",
        className
      ),
      ...props
    }
  );
}
function AppSidebar() {
  const router = useRouter();
  const { location } = useRouterState();
  const pathname = location.pathname;
  const { state, isMobile, setOpenMobile } = useSidebar();
  const { theme, setTheme } = useTheme();
  const prevPathname = React.useRef(pathname);
  React.useEffect(() => {
    if (isMobile && prevPathname.current !== pathname) {
      prevPathname.current = pathname;
      setOpenMobile(false);
    } else {
      prevPathname.current = pathname;
    }
  }, [pathname, isMobile, setOpenMobile]);
  const [usuario, setUsuario] = React.useState(null);
  React.useEffect(() => {
    try {
      const raw = sessionStorage.getItem("rpi:usuario");
      if (raw) {
        const parsed = JSON.parse(raw);
        setUsuario(parsed);
        return;
      }
    } catch {
    }
    setUsuario(null);
  }, []);
  const [indicatorStyle, setIndicatorStyle] = React.useState(null);
  React.useEffect(() => {
    const updateIndicator = () => {
      const activeElement = document.querySelector('[data-active-item="true"]');
      if (activeElement) {
        const contentContainer = document.querySelector('[data-sidebar="content"]');
        if (contentContainer) {
          let element = activeElement;
          let offsetTop = 0;
          while (element !== contentContainer) {
            offsetTop += element.offsetTop;
            element = element.offsetParent;
          }
          setIndicatorStyle({
            top: offsetTop + 8,
            height: activeElement.offsetHeight - 16
          });
        }
      } else {
        setIndicatorStyle(null);
      }
    };
    const timeoutId = setTimeout(updateIndicator, 100);
    const sidebar = document.querySelector('[data-sidebar="sidebar"]');
    if (sidebar) {
      const resizeObserver = new ResizeObserver(() => {
        setTimeout(updateIndicator, 100);
      });
      resizeObserver.observe(sidebar);
      return () => {
        clearTimeout(timeoutId);
        resizeObserver.disconnect();
      };
    }
    return () => clearTimeout(timeoutId);
  }, [pathname]);
  const handleLogout = () => {
    try {
      sessionStorage.removeItem("rpi:usuario");
    } catch {
    }
    router.navigate({ to: "/login" });
  };
  const rolNombreNormalizado = String(usuario?.rol_nombre || "").toLowerCase().normalize("NFD").replace(/[\u0300-\u036f]/g, "").trim();
  const rolId = usuario?.rol_id;
  const esAdmin = rolId === 2 || rolNombreNormalizado.includes("admin");
  const esComite = rolId === 3 || rolId === 4 || rolId === 5 || rolNombreNormalizado.includes("comite");
  const esMedico = !esAdmin && !esComite;
  const puedeVerRegistro = esAdmin || esMedico;
  const puedeVerProyectos = esAdmin || esMedico;
  const puedeVerRevision = esAdmin || esComite;
  const puedeVerDocumentacion = esAdmin;
  return /* @__PURE__ */ jsxs(Sidebar, { collapsible: "icon", className: "border-r-0", children: [
    /* @__PURE__ */ jsx(SidebarHeader, { className: "h-16 p-0 gap-0 flex items-center justify-center group-data-[collapsible=icon]:h-16 max-md:h-0 max-md:min-h-0 max-md:overflow-hidden max-md:py-0", children: /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3 px-4 group-data-[collapsible=icon]:px-2 max-md:hidden", children: [
      /* @__PURE__ */ jsx(
        "div",
        {
          className: "w-10 h-10 bg-black dark:bg-white group-data-[collapsible=icon]:w-8 group-data-[collapsible=icon]:h-8 max-md:hidden",
          style: {
            WebkitMaskImage: `url(${assetPath("/LogoHJM.svg")})`,
            WebkitMaskSize: "contain",
            WebkitMaskRepeat: "no-repeat",
            WebkitMaskPosition: "center",
            maskImage: `url(${assetPath("/LogoHJM.svg")})`,
            maskSize: "contain",
            maskRepeat: "no-repeat",
            maskPosition: "center"
          }
        }
      ),
      /* @__PURE__ */ jsx("h2", { className: "text-lg font-semibold group-data-[collapsible=icon]:hidden max-md:hidden", children: "INVESTIGACION" })
    ] }) }),
    /* @__PURE__ */ jsx("div", { className: "flex justify-center px-4 group-data-[collapsible=icon]:px-2 max-md:hidden", children: /* @__PURE__ */ jsx("div", { className: "w-1/2 h-px bg-border group-data-[collapsible=icon]:w-full" }) }),
    /* @__PURE__ */ jsxs(SidebarContent, { className: "relative sidebar-menu-stagger sidebar-menu-icon-hover max-md:pt-16", children: [
      indicatorStyle && /* @__PURE__ */ jsx(
        motion.div,
        {
          className: "absolute w-0.5 rounded-full z-50",
          style: { backgroundColor: "#651643" },
          initial: false,
          animate: {
            top: indicatorStyle.top,
            height: indicatorStyle.height,
            left: 8
          },
          transition: {
            type: "spring",
            stiffness: 400,
            damping: 28,
            mass: 0.5
          }
        }
      ),
      /* @__PURE__ */ jsxs(SidebarGroup, { children: [
        /* @__PURE__ */ jsx(SidebarGroupLabel, { children: "Principal" }),
        /* @__PURE__ */ jsx(SidebarGroupContent, { children: /* @__PURE__ */ jsxs(SidebarMenu, { children: [
          /* @__PURE__ */ jsx(SidebarMenuItem, { children: /* @__PURE__ */ jsx(SidebarMenuButton, { asChild: true, tooltip: "Inicio", isActive: pathname === "/inicio", children: /* @__PURE__ */ jsxs(Link, { to: "/inicio", "data-active-item": pathname === "/inicio", className: "flex items-center gap-2", onClick: () => isMobile && setOpenMobile(false), children: [
            /* @__PURE__ */ jsx(HugeiconsIcon, { icon: DashboardSquare01Icon, className: "size-5 shrink-0" }),
            /* @__PURE__ */ jsx("span", { children: "Inicio" })
          ] }) }) }),
          puedeVerRegistro && /* @__PURE__ */ jsx(SidebarMenuItem, { children: /* @__PURE__ */ jsx(SidebarMenuButton, { asChild: true, tooltip: "Registro de Proyecto", isActive: pathname.startsWith("/registro-proyecto"), children: /* @__PURE__ */ jsxs(Link, { to: "/registro-proyecto", search: { proyecto: void 0, paso: void 0 }, "data-active-item": pathname.startsWith("/registro-proyecto"), className: "flex items-center gap-2", onClick: () => isMobile && setOpenMobile(false), children: [
            /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileEditIcon, className: "size-5 shrink-0" }),
            /* @__PURE__ */ jsx("span", { children: "Registro de Proyecto" })
          ] }) }) })
        ] }) })
      ] }),
      puedeVerProyectos && /* @__PURE__ */ jsxs(SidebarGroup, { children: [
        /* @__PURE__ */ jsx(SidebarGroupLabel, { children: "Búsqueda" }),
        /* @__PURE__ */ jsx(SidebarGroupContent, { children: /* @__PURE__ */ jsx(SidebarMenu, { children: /* @__PURE__ */ jsx(SidebarMenuItem, { children: /* @__PURE__ */ jsx(SidebarMenuButton, { asChild: true, tooltip: "Proyectos", isActive: pathname.startsWith("/proyectos"), children: /* @__PURE__ */ jsxs(Link, { to: "/proyectos", "data-active-item": pathname.startsWith("/proyectos"), className: "flex items-center gap-2", onClick: () => isMobile && setOpenMobile(false), children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: File02Icon, className: "size-5 shrink-0" }),
          /* @__PURE__ */ jsx("span", { children: "Proyectos" })
        ] }) }) }) }) })
      ] }),
      (puedeVerRevision || puedeVerDocumentacion) && /* @__PURE__ */ jsxs(SidebarGroup, { children: [
        /* @__PURE__ */ jsx(SidebarGroupLabel, { children: "Gestión" }),
        /* @__PURE__ */ jsx(SidebarGroupContent, { children: /* @__PURE__ */ jsxs(SidebarMenu, { children: [
          puedeVerRevision && /* @__PURE__ */ jsx(SidebarMenuItem, { children: /* @__PURE__ */ jsx(SidebarMenuButton, { asChild: true, tooltip: "Revisión", isActive: pathname.startsWith("/revision"), children: /* @__PURE__ */ jsxs(Link, { to: "/revision", search: { proyecto: void 0, comite: void 0 }, "data-active-item": pathname.startsWith("/revision"), className: "flex items-center gap-2", onClick: () => isMobile && setOpenMobile(false), children: [
            /* @__PURE__ */ jsx(HugeiconsIcon, { icon: FileVerifiedIcon, className: "size-5 shrink-0" }),
            /* @__PURE__ */ jsx("span", { children: "Revisión" })
          ] }) }) }),
          puedeVerDocumentacion && /* @__PURE__ */ jsx(SidebarMenuItem, { children: /* @__PURE__ */ jsx(SidebarMenuButton, { asChild: true, tooltip: "Documentación", isActive: pathname.startsWith("/documentacion"), children: /* @__PURE__ */ jsxs(Link, { to: "/documentacion", "data-active-item": pathname.startsWith("/documentacion"), className: "flex items-center gap-2", onClick: () => isMobile && setOpenMobile(false), children: [
            /* @__PURE__ */ jsx(HugeiconsIcon, { icon: BookOpen01Icon, className: "size-5 shrink-0" }),
            /* @__PURE__ */ jsx("span", { children: "Documentación" })
          ] }) }) })
        ] }) })
      ] }),
      esAdmin && /* @__PURE__ */ jsxs(SidebarGroup, { children: [
        /* @__PURE__ */ jsx(SidebarGroupLabel, { children: "Admin" }),
        /* @__PURE__ */ jsx(SidebarGroupContent, { children: /* @__PURE__ */ jsx(SidebarMenu, { children: /* @__PURE__ */ jsx(SidebarMenuItem, { children: /* @__PURE__ */ jsx(SidebarMenuButton, { asChild: true, tooltip: "Usuarios", isActive: pathname.startsWith("/admin/usuarios"), children: /* @__PURE__ */ jsxs(Link, { to: "/admin/usuarios", "data-active-item": pathname.startsWith("/admin/usuarios"), className: "flex items-center gap-2", onClick: () => isMobile && setOpenMobile(false), children: [
          /* @__PURE__ */ jsx(HugeiconsIcon, { icon: UserGroupIcon, className: "size-5 shrink-0" }),
          /* @__PURE__ */ jsx("span", { children: "Usuarios" })
        ] }) }) }) }) })
      ] })
    ] }),
    /* @__PURE__ */ jsxs(SidebarFooter, { className: "h-[72px] p-0 gap-0 flex flex-col justify-center group-data-[collapsible=icon]:h-auto", children: [
      /* @__PURE__ */ jsx("div", { className: "flex justify-center px-4 mb-2 group-data-[collapsible=icon]:px-2 group-data-[collapsible=icon]:mb-0", children: /* @__PURE__ */ jsx("div", { className: "w-1/2 h-px bg-border group-data-[collapsible=icon]:w-full" }) }),
      /* @__PURE__ */ jsx("div", { className: "px-4 group-data-[collapsible=icon]:px-0 group-data-[collapsible=icon]:py-2 group-data-[collapsible=icon]:flex group-data-[collapsible=icon]:justify-center", children: /* @__PURE__ */ jsx(SidebarMenu, { className: "group-data-[collapsible=icon]:w-auto", children: /* @__PURE__ */ jsx(SidebarMenuItem, { className: "group-data-[collapsible=icon]:w-auto", children: /* @__PURE__ */ jsxs(DropdownMenu, { children: [
        /* @__PURE__ */ jsx(DropdownMenuTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(
          SidebarMenuButton,
          {
            size: "lg",
            className: "data-[state=open]:bg-sidebar-accent data-[state=open]:text-sidebar-accent-foreground group-data-[collapsible=icon]:w-10 group-data-[collapsible=icon]:h-10 group-data-[collapsible=icon]:p-0 group-data-[collapsible=icon]:justify-center",
            children: [
              /* @__PURE__ */ jsx(HugeiconsIcon, { icon: UserIcon, className: "group-data-[collapsible=icon]:size-5 size-5" }),
              /* @__PURE__ */ jsxs("div", { className: "grid flex-1 text-left text-sm leading-tight group-data-[collapsible=icon]:hidden", children: [
                /* @__PURE__ */ jsx("span", { className: "truncate font-semibold", children: [usuario?.nombre, usuario?.apellidos].filter(Boolean).join(" ") || "Usuario" }),
                /* @__PURE__ */ jsx("span", { className: "truncate text-xs", children: usuario?.correo || "—" })
              ] }),
              /* @__PURE__ */ jsx(HugeiconsIcon, { icon: ArrowUpDownIcon, className: "ml-auto size-4 group-data-[collapsible=icon]:hidden" })
            ]
          }
        ) }),
        /* @__PURE__ */ jsxs(
          DropdownMenuContent,
          {
            className: cn(
              "w-[--radix-dropdown-menu-trigger-width] min-w-56 max-w-[calc(100vw-2rem)] rounded-lg",
              isMobile && "z-[60]"
            ),
            side: state === "collapsed" && !isMobile ? "right" : "top",
            align: isMobile ? "center" : state === "collapsed" ? "center" : "end",
            sideOffset: 4,
            alignOffset: 0,
            children: [
              isMobile && /* @__PURE__ */ jsx(DropdownMenuItem, { onClick: () => setTheme(theme === "light" ? "dark" : "light"), children: theme === "light" ? /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Moon02Icon, className: "size-5 shrink-0" }),
                "Tema oscuro"
              ] }) : /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Sun01Icon, className: "size-5 shrink-0" }),
                "Tema claro"
              ] }) }),
              /* @__PURE__ */ jsxs(DropdownMenuItem, { onClick: handleLogout, variant: "destructive", children: [
                /* @__PURE__ */ jsx(HugeiconsIcon, { icon: Logout01Icon, className: "size-5 shrink-0" }),
                "Cerrar sesión"
              ] })
            ]
          }
        )
      ] }) }) }) })
    ] }),
    /* @__PURE__ */ jsx(SidebarRail, {})
  ] });
}
function SidebarProviderWrapper({
  children
}) {
  const [open, setOpen] = React.useState(false);
  const [isInitialized, setIsInitialized] = React.useState(false);
  React.useEffect(() => {
    const saved = localStorage.getItem("sidebar:state");
    setOpen(saved !== null ? saved === "true" : false);
    setIsInitialized(true);
  }, []);
  const handleOpenChange = (newOpen) => {
    setOpen(newOpen);
    localStorage.setItem("sidebar:state", String(newOpen));
  };
  if (!isInitialized) {
    return null;
  }
  return /* @__PURE__ */ jsx(SidebarProvider, { open, onOpenChange: handleOpenChange, children });
}
function tieneAccesoARuta(pathname) {
  const usuario = getUsuarioSesion();
  if (!usuario) return false;
  const rolNombreNormalizado = String(usuario.rol_nombre || "").toLowerCase().normalize("NFD").replace(/[\u0300-\u036f]/g, "").trim();
  const rolId = usuario.rol_id;
  const esAdmin = rolId === 2 || rolNombreNormalizado.includes("admin");
  const esComite = rolId === 3 || rolId === 4 || rolId === 5 || rolNombreNormalizado.includes("comite");
  const esMedico = !esAdmin && !esComite;
  if (pathname.startsWith("/inicio")) return true;
  if (esAdmin) return true;
  if (esComite) return pathname.startsWith("/revision");
  if (esMedico) return pathname.startsWith("/registro-proyecto") || pathname.startsWith("/proyectos");
  return false;
}
function MainContent() {
  const {
    openMobile,
    isMobile,
    setOpenMobile
  } = useSidebar();
  const {
    location
  } = useRouterState();
  const navigate = useNavigate();
  const pushed = isMobile && openMobile;
  useEffect(() => {
    if (typeof window === "undefined") return;
    if (!tieneAccesoARuta(location.pathname)) {
      navigate({
        to: "/inicio",
        replace: true
      });
    }
  }, [location.pathname, navigate]);
  return /* @__PURE__ */ jsxs(SidebarInset, { className: "!m-0 bg-muted flex flex-col min-h-0", children: [
    /* @__PURE__ */ jsxs("header", { className: "sticky top-0 z-10 max-md:z-[60] bg-muted header-entrance shrink-0", children: [
      /* @__PURE__ */ jsxs("div", { className: "flex h-16 items-center px-6 justify-between", children: [
        /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3 max-md:hidden", children: [
          /* @__PURE__ */ jsx(SidebarTrigger, {}),
          /* @__PURE__ */ jsx("div", { className: "h-8 w-px bg-border rounded-full" })
        ] }),
        /* @__PURE__ */ jsx("div", { className: "flex items-center gap-3 md:hidden", children: /* @__PURE__ */ jsx("div", { className: "w-8 h-8 bg-black dark:bg-white shrink-0", style: {
          WebkitMaskImage: `url(${assetPath("/LogoHJM.svg")})`,
          WebkitMaskSize: "contain",
          WebkitMaskRepeat: "no-repeat",
          WebkitMaskPosition: "center",
          maskImage: `url(${assetPath("/LogoHJM.svg")})`,
          maskSize: "contain",
          maskRepeat: "no-repeat",
          maskPosition: "center"
        } }) }),
        /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3 max-md:ml-auto", children: [
          /* @__PURE__ */ jsx("div", { className: "h-8 w-px bg-border rounded-full max-md:hidden" }),
          /* @__PURE__ */ jsx("div", { className: "max-md:hidden", children: /* @__PURE__ */ jsx(ThemeToggle, {}) }),
          /* @__PURE__ */ jsx(SidebarTrigger, { className: "md:hidden" })
        ] })
      ] }),
      /* @__PURE__ */ jsx("div", { className: "h-px bg-border max-md:hidden" })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: "flex-1 min-h-0 relative max-md:overflow-hidden", style: isMobile ? {
      "--content-push": pushed ? "85vw" : "0"
    } : void 0, children: [
      /* @__PURE__ */ jsx("div", { className: "h-full w-full", style: isMobile ? {
        transform: "translateX(var(--content-push, 0))",
        filter: pushed ? "blur(4px)" : "blur(0px)",
        transition: "transform 0.3s cubic-bezier(0.4, 0, 0.2, 1)"
      } : void 0, onClick: pushed ? () => setOpenMobile(false) : void 0, role: pushed ? "button" : void 0, "aria-label": pushed ? "Cerrar menú" : void 0, children: /* @__PURE__ */ jsx("div", { className: "h-full overflow-y-auto content-entrance", children: /* @__PURE__ */ jsx(Outlet, {}) }, location.pathname) }),
      pushed && /* @__PURE__ */ jsx("div", { className: "absolute inset-0 pointer-events-none bg-gradient-to-r from-transparent via-transparent to-muted max-md:block hidden", "aria-hidden": true })
    ] })
  ] });
}
function LayoutWithSidebar() {
  const listo = useRequireAuth();
  if (!listo) {
    return /* @__PURE__ */ jsx("div", { className: "min-h-screen flex items-center justify-center bg-muted", children: /* @__PURE__ */ jsx(Spinner, { className: "size-8 text-muted-foreground" }) });
  }
  return /* @__PURE__ */ jsxs(SidebarProviderWrapper, { children: [
    /* @__PURE__ */ jsx(AppSidebar, {}),
    /* @__PURE__ */ jsx(MainContent, {})
  ] });
}
export {
  LayoutWithSidebar as component
};
